/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import com.intellij.lang.LighterASTNode;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PathAwarePropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.util.TraverseDirection;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JT\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0016\u0010\f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u001cR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "()V", "canBeValOccurrenceRanges", "", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "analyze", "", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwarePropertyInitializationInfo;", "properties", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "capturedWrites", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "canBeVal", "", "symbol", "value", "getDestructuringChildrenCount", "", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Ljava/lang/Integer;", "UninitializedPropertyReporter", "checkers"})
public final class CanBeValChecker
extends AbstractFirPropertyInitializationChecker {
    @NotNull
    public static final CanBeValChecker INSTANCE = new CanBeValChecker();
    @NotNull
    private static final Set<EventOccurrencesRange> canBeValOccurrenceRanges;

    private CanBeValChecker() {
    }

    @Override
    public void analyze(@NotNull ControlFlowGraph graph2, @NotNull DiagnosticReporter reporter, @NotNull Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data, @NotNull Set<? extends FirPropertySymbol> properties2, @NotNull Set<? extends FirVariableAssignment> capturedWrites, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter(graph2, "graph");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(properties2, "properties");
        Intrinsics.checkNotNullParameter(capturedWrites, "capturedWrites");
        Intrinsics.checkNotNullParameter(context, "context");
        Set unprocessedProperties = new LinkedHashSet();
        Map propertiesCharacteristics = new LinkedHashMap();
        UninitializedPropertyReporter reporterVisitor = new UninitializedPropertyReporter(data, properties2, unprocessedProperties, propertiesCharacteristics);
        CfgTraverserKt.traverse(graph2, TraverseDirection.Forward, reporterVisitor);
        for (FirPropertySymbol property2 : unprocessedProperties) {
            KtSourceElement source;
            KtSourceElement ktSourceElement = source = property2.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) continue;
            KtSourceElement ktSourceElement2 = source;
            if (Intrinsics.areEqual(ktSourceElement2 != null ? ktSourceElement2.getElementType() : null, KtNodeTypes.DESTRUCTURING_DECLARATION)) continue;
            propertiesCharacteristics.put(property2, EventOccurrencesRange.ZERO);
        }
        KtSourceElement lastDestructuringSource = null;
        boolean destructuringCanBeVal = false;
        int lastDestructuredVariables = 0;
        for (Map.Entry entry : propertiesCharacteristics.entrySet()) {
            KtSourceElement source;
            FirPropertySymbol symbol2 = (FirPropertySymbol)entry.getKey();
            EventOccurrencesRange value2 = (EventOccurrencesRange)((Object)entry.getValue());
            KtSourceElement ktSourceElement = source = symbol2.getSource();
            if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getElementType() : null, KtNodeTypes.DESTRUCTURING_DECLARATION)) {
                lastDestructuringSource = source;
                Integer n = this.getDestructuringChildrenCount(symbol2);
                if (n == null) {
                    continue;
                }
                lastDestructuredVariables = n;
                destructuringCanBeVal = true;
                continue;
            }
            if (lastDestructuringSource != null) {
                if (lastDestructuredVariables == 1 && destructuringCanBeVal && this.canBeVal(symbol2, value2)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)lastDestructuringSource, FirErrors.INSTANCE.getCAN_BE_VAL(), (DiagnosticContext)context, null, 8, null);
                    lastDestructuringSource = null;
                } else if (!this.canBeVal(symbol2, value2)) {
                    destructuringCanBeVal = false;
                }
                --lastDestructuredVariables;
                continue;
            }
            if (!this.canBeVal(symbol2, value2) || symbol2.getHasDelegate()) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCAN_BE_VAL(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final boolean canBeVal(FirPropertySymbol symbol2, EventOccurrencesRange value2) {
        return canBeValOccurrenceRanges.contains((Object)value2) && symbol2.isVar();
    }

    private final Integer getDestructuringChildrenCount(FirPropertySymbol $this$getDestructuringChildrenCount) {
        int n;
        KtSourceElement ktSourceElement = $this$getDestructuringChildrenCount.getSource();
        if (ktSourceElement == null) {
            return null;
        }
        KtSourceElement source = ktSourceElement;
        Iterable $this$count$iv = SourceHelpersKt.getChildren(source.getLighterASTNode(), source.getTreeStructure());
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                LighterASTNode it = (LighterASTNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    static {
        EventOccurrencesRange[] eventOccurrencesRangeArray = new EventOccurrencesRange[]{EventOccurrencesRange.EXACTLY_ONCE, EventOccurrencesRange.AT_MOST_ONCE, EventOccurrencesRange.ZERO};
        canBeValOccurrenceRanges = SetsKt.setOf(eventOccurrencesRangeArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BM\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001bH\u0016R!\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker$UninitializedPropertyReporter;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwarePropertyInitializationInfo;", "localProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "unprocessedProperties", "", "propertiesCharacteristics", "", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "(Ljava/util/Map;Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;)V", "getData", "()Ljava/util/Map;", "getLocalProperties", "()Ljava/util/Set;", "getPropertiesCharacteristics", "getUnprocessedProperties", "visitNode", "", "node", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "checkers"})
    private static final class UninitializedPropertyReporter
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data;
        @NotNull
        private final Set<FirPropertySymbol> localProperties;
        @NotNull
        private final Set<FirPropertySymbol> unprocessedProperties;
        @NotNull
        private final Map<FirPropertySymbol, EventOccurrencesRange> propertiesCharacteristics;

        public UninitializedPropertyReporter(@NotNull Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data, @NotNull Set<? extends FirPropertySymbol> localProperties, @NotNull Set<FirPropertySymbol> unprocessedProperties, @NotNull Map<FirPropertySymbol, EventOccurrencesRange> propertiesCharacteristics) {
            Intrinsics.checkNotNullParameter(data, "data");
            Intrinsics.checkNotNullParameter(localProperties, "localProperties");
            Intrinsics.checkNotNullParameter(unprocessedProperties, "unprocessedProperties");
            Intrinsics.checkNotNullParameter(propertiesCharacteristics, "propertiesCharacteristics");
            this.data = data;
            this.localProperties = localProperties;
            this.unprocessedProperties = unprocessedProperties;
            this.propertiesCharacteristics = propertiesCharacteristics;
        }

        @NotNull
        public final Map<CFGNode<?>, PathAwarePropertyInitializationInfo> getData() {
            return this.data;
        }

        @NotNull
        public final Set<FirPropertySymbol> getLocalProperties() {
            return this.localProperties;
        }

        @NotNull
        public final Set<FirPropertySymbol> getUnprocessedProperties() {
            return this.unprocessedProperties;
        }

        @NotNull
        public final Map<FirPropertySymbol, EventOccurrencesRange> getPropertiesCharacteristics() {
            return this.propertiesCharacteristics;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, "node");
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            Intrinsics.checkNotNullParameter(node, "node");
            FirBasedSymbol<?> firBasedSymbol = UtilsKt.getResolvedSymbol(node.getFir().getCalleeReference());
            FirPropertySymbol firPropertySymbol = firBasedSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firBasedSymbol : null;
            if (firPropertySymbol == null) {
                return;
            }
            FirPropertySymbol symbol2 = firPropertySymbol;
            if (!this.localProperties.contains(symbol2)) {
                return;
            }
            this.unprocessedProperties.remove(symbol2);
            EventOccurrencesRange currentCharacteristic = this.propertiesCharacteristics.getOrDefault(symbol2, EventOccurrencesRange.ZERO);
            PathAwarePropertyInitializationInfo info = MapsKt.getValue(this.data, node);
            Map<FirPropertySymbol, EventOccurrencesRange> map = this.propertiesCharacteristics;
            EventOccurrencesRange eventOccurrencesRange = (EventOccurrencesRange)((Object)((PropertyInitializationInfo)info.getInfoAtNormalPath$checkers()).get(symbol2));
            if (eventOccurrencesRange == null) {
                eventOccurrencesRange = EventOccurrencesRange.ZERO;
            }
            EventOccurrencesRange eventOccurrencesRange2 = currentCharacteristic.or(eventOccurrencesRange);
            map.put(symbol2, eventOccurrencesRange2);
        }

        @Override
        public void visitVariableDeclarationNode(@NotNull VariableDeclarationNode node) {
            Intrinsics.checkNotNullParameter(node, "node");
            FirPropertySymbol symbol2 = node.getFir().getSymbol();
            if (node.getFir().getInitializer() == null && node.getFir().getDelegate() == null) {
                this.unprocessedProperties.add(symbol2);
            } else {
                this.propertiesCharacteristics.put(symbol2, EventOccurrencesRange.AT_MOST_ONCE);
            }
        }
    }
}

