/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.lang.management.ThreadMXBean;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.TotalProfiler;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0096\bJ!\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0096\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/daemon/common/WallAndThreadTotalProfiler;", "Lorg/jetbrains/kotlin/daemon/common/TotalProfiler;", "()V", "beginMeasure", "", "", "obj", "", "endMeasure", "", "startState", "daemon-common"})
public final class WallAndThreadTotalProfiler
extends TotalProfiler {
    @Override
    @NotNull
    public List<Long> beginMeasure(@Nullable Object obj) {
        boolean $i$f$beginMeasure = false;
        ThreadMXBean threadMXBean = this.getThreadMXBean();
        Intrinsics.checkNotNullExpressionValue((Object)threadMXBean, (String)"threadMXBean");
        ThreadMXBean threadMXBean$iv = threadMXBean;
        boolean $i$f$beginMeasureWallAndThreadTimes = false;
        long startTime$iv = System.nanoTime();
        ThreadMXBean $this$threadCpuTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadCpuTime = false;
        long startThreadTime$iv = $this$threadCpuTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv$iv.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean $this$threadUserTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadUserTime = false;
        long startThreadUserTime$iv = $this$threadUserTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv$iv.getCurrentThreadUserTime() : 0L;
        Object[] objectArray = new Long[]{startTime$iv, startThreadTime$iv, startThreadUserTime$iv};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void endMeasure(@Nullable Object obj, @NotNull List<Long> startState) {
        void perfCounters$iv;
        Intrinsics.checkNotNullParameter(startState, (String)"startState");
        boolean $i$f$endMeasure = false;
        PerfCounters perfCounters = this.getTotal();
        ThreadMXBean threadMXBean = this.getThreadMXBean();
        Intrinsics.checkNotNullExpressionValue((Object)threadMXBean, (String)"threadMXBean");
        ThreadMXBean threadMXBean$iv = threadMXBean;
        boolean $i$f$endMeasureWallAndThreadTimes = false;
        long startTime$iv = ((Number)startState.get(0)).longValue();
        long startThreadTime$iv = ((Number)startState.get(1)).longValue();
        long startThreadUserTime$iv = ((Number)startState.get(2)).longValue();
        ThreadMXBean $this$threadCpuTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadCpuTime = false;
        ThreadMXBean $this$threadUserTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadUserTime = false;
        PerfCounters.DefaultImpls.addMeasurement$default((PerfCounters)perfCounters$iv, System.nanoTime() - startTime$iv, ($this$threadCpuTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv$iv.getCurrentThreadCpuTime() : 0L) - startThreadTime$iv, ($this$threadUserTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv$iv.getCurrentThreadUserTime() : 0L) - startThreadUserTime$iv, 0L, 8, null);
    }
}

