/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.stack;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArrayDeque;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.stack.DataStack;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fJ\b\u0010\u0013\u001a\u0004\u0018\u00010\tJ\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u00160\u0015J\u0006\u0010\u0017\u001a\u00020\u0011J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\fJ\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019J\u0006\u0010\u001b\u001a\u00020\tJ\u0006\u0010\u001c\u001a\u00020\u0019J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\tJ\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0019J\u0016\u0010\"\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u0019J\u0016\u0010$\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010%\u001a\u00020\rJ\u0018\u0010$\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/stack/SubFrame;", "", "owner", "Lorg/jetbrains/kotlin/ir/IrElement;", "(Lorg/jetbrains/kotlin/ir/IrElement;)V", "dataStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/DataStack;", "instructions", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "memory", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "getOwner", "()Lorg/jetbrains/kotlin/ir/IrElement;", "containsStateInMemory", "", "symbol", "dropInstructions", "getAll", "", "Lkotlin/Pair;", "isEmpty", "loadState", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "peekState", "popInstruction", "popState", "pushInstruction", "", "instruction", "pushState", "state", "rewriteState", "newState", "storeState", "variable", "ir.interpreter"})
final class SubFrame {
    @NotNull
    private final IrElement owner;
    @NotNull
    private final ArrayDeque<Instruction> instructions;
    @NotNull
    private final DataStack dataStack;
    @NotNull
    private final Map<IrSymbol, Variable> memory;

    public SubFrame(@NotNull IrElement owner) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        this.owner = owner;
        this.instructions = new ArrayDeque();
        this.dataStack = new DataStack();
        this.memory = new LinkedHashMap();
    }

    @NotNull
    public final IrElement getOwner() {
        return this.owner;
    }

    public final boolean isEmpty() {
        return this.instructions.isEmpty();
    }

    public final void pushInstruction(@NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter(instruction, "instruction");
        this.instructions.addFirst(instruction);
    }

    @NotNull
    public final Instruction popInstruction() {
        return this.instructions.removeFirst();
    }

    @Nullable
    public final Instruction dropInstructions() {
        Instruction instruction;
        Instruction instruction2 = this.instructions.lastOrNull();
        if (instruction2 == null) {
            instruction = null;
        } else {
            Instruction instruction3;
            Instruction $this$dropInstructions_u24lambda_u2d0 = instruction3 = instruction2;
            boolean bl = false;
            this.instructions.clear();
            instruction = instruction3;
        }
        return instruction;
    }

    public final void pushState(@NotNull State state) {
        Intrinsics.checkNotNullParameter(state, "state");
        this.dataStack.push(state);
    }

    @NotNull
    public final State popState() {
        return this.dataStack.pop();
    }

    @Nullable
    public final State peekState() {
        return this.dataStack.peek();
    }

    public final void storeState(@NotNull IrSymbol symbol2, @NotNull Variable variable2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        Intrinsics.checkNotNullParameter(variable2, "variable");
        Map<IrSymbol, Variable> map = this.memory;
        map.put(symbol2, variable2);
    }

    public final void storeState(@NotNull IrSymbol symbol2, @Nullable State state) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        Map<IrSymbol, Variable> map = this.memory;
        Variable variable2 = new Variable(state);
        map.put(symbol2, variable2);
    }

    public final boolean containsStateInMemory(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        return this.memory.get(symbol2) != null;
    }

    @Nullable
    public final State loadState(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        Variable variable2 = this.memory.get(symbol2);
        return variable2 == null ? null : variable2.getState();
    }

    public final void rewriteState(@NotNull IrSymbol symbol2, @NotNull State newState) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        Intrinsics.checkNotNullParameter(newState, "newState");
        Variable variable2 = this.memory.get(symbol2);
        if (variable2 != null) {
            variable2.setState(newState);
        }
    }

    @NotNull
    public final List<Pair<IrSymbol, Variable>> getAll() {
        return MapsKt.toList(this.memory);
    }
}

