/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.fir.FirFakeSourceElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirRealPsiSourceElement;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.types.FirDynamicTypeRef;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirDynamicTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirFunctionTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirImplicitTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirUserTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.FirFunctionTypeRefImpl;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRefKt;
import org.jetbrains.kotlin.fir.types.impl.FirResolvedTypeRefImpl;
import org.jetbrains.kotlin.fir.types.impl.FirUserTypeRefImpl;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a!\u0010\u0005\u001a\u0002H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u0007*\u0002H\u00062\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u001a\u0010\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\r\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0010\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u0015\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0016"}, d2={"packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getPackageFqName", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;)Lorg/jetbrains/kotlin/name/FqName;", "copyWithNewSourceKind", "R", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "newKind", "Lorg/jetbrains/kotlin/fir/FirFakeSourceElementKind;", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;Lorg/jetbrains/kotlin/fir/FirFakeSourceElementKind;)Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "dependenciesWithoutSelf", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "getWholeQualifierSourceIfPossible", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "stepsToWholeQualifier", "", "returnExpressions", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "tree"})
public final class UtilsKt {
    @NotNull
    public static final Sequence<ModuleInfo> dependenciesWithoutSelf(@NotNull ModuleInfo $this$dependenciesWithoutSelf) {
        Intrinsics.checkNotNullParameter($this$dependenciesWithoutSelf, "<this>");
        return SequencesKt.filter(CollectionsKt.asSequence((Iterable)$this$dependenciesWithoutSelf.dependencies()), (Function1)new Function1<ModuleInfo, Boolean>($this$dependenciesWithoutSelf){
            final /* synthetic */ ModuleInfo $this_dependenciesWithoutSelf;
            {
                this.$this_dependenciesWithoutSelf = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ModuleInfo it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !Intrinsics.areEqual(it, this.$this_dependenciesWithoutSelf);
            }
        });
    }

    @NotNull
    public static final List<FirExpression> returnExpressions(@NotNull FirBlock $this$returnExpressions) {
        Intrinsics.checkNotNullParameter($this$returnExpressions, "<this>");
        FirStatement firStatement = CollectionsKt.lastOrNull($this$returnExpressions.getStatements());
        return CollectionsKt.listOfNotNull(firStatement instanceof FirExpression ? (FirExpression)firStatement : null);
    }

    @NotNull
    public static final <R extends FirTypeRef> R copyWithNewSourceKind(@NotNull R $this$copyWithNewSourceKind, @NotNull FirFakeSourceElementKind newKind) {
        FirTypeRef firTypeRef;
        Intrinsics.checkNotNullParameter($this$copyWithNewSourceKind, "<this>");
        Intrinsics.checkNotNullParameter(newKind, "newKind");
        if ($this$copyWithNewSourceKind.getSource() == null) {
            return $this$copyWithNewSourceKind;
        }
        FirSourceElement firSourceElement = $this$copyWithNewSourceKind.getSource();
        if (Intrinsics.areEqual(firSourceElement == null ? null : firSourceElement.getKind(), newKind)) {
            return $this$copyWithNewSourceKind;
        }
        FirSourceElement firSourceElement2 = $this$copyWithNewSourceKind.getSource();
        FirSourceElement newSource = firSourceElement2 == null ? null : FirSourceElementKt.fakeElement(firSourceElement2, newKind);
        R typeRef = $this$copyWithNewSourceKind;
        if (typeRef instanceof FirResolvedTypeRefImpl) {
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
            FirResolvedTypeRef original$iv = (FirResolvedTypeRef)typeRef;
            boolean $i$f$buildResolvedTypeRefCopy = false;
            FirResolvedTypeRefBuilder copyBuilder$iv = new FirResolvedTypeRefBuilder();
            copyBuilder$iv.setSource(original$iv.getSource());
            copyBuilder$iv.getAnnotations().addAll((Collection<FirAnnotationCall>)original$iv.getAnnotations());
            copyBuilder$iv.setType(original$iv.getType());
            copyBuilder$iv.setDelegatedTypeRef(original$iv.getDelegatedTypeRef());
            FirResolvedTypeRefBuilder $this$copyWithNewSourceKind_u24lambda_u2d0 = firResolvedTypeRefBuilder = copyBuilder$iv;
            boolean bl = false;
            $this$copyWithNewSourceKind_u24lambda_u2d0.setSource(newSource);
            firTypeRef = firResolvedTypeRefBuilder.build();
        } else if (typeRef instanceof FirErrorTypeRef) {
            FirErrorTypeRefBuilder firErrorTypeRefBuilder;
            FirErrorTypeRef original$iv = (FirErrorTypeRef)typeRef;
            boolean $i$f$buildErrorTypeRefCopy = false;
            FirErrorTypeRefBuilder copyBuilder$iv = new FirErrorTypeRefBuilder();
            copyBuilder$iv.setSource(original$iv.getSource());
            copyBuilder$iv.setDelegatedTypeRef(original$iv.getDelegatedTypeRef());
            copyBuilder$iv.setDiagnostic(original$iv.getDiagnostic());
            FirErrorTypeRefBuilder $this$copyWithNewSourceKind_u24lambda_u2d1 = firErrorTypeRefBuilder = copyBuilder$iv;
            boolean bl = false;
            $this$copyWithNewSourceKind_u24lambda_u2d1.setSource(newSource);
            firTypeRef = firErrorTypeRefBuilder.build();
        } else if (typeRef instanceof FirUserTypeRefImpl) {
            FirUserTypeRefBuilder $i$f$buildErrorTypeRefCopy;
            boolean $i$f$buildUserTypeRef = false;
            FirUserTypeRefBuilder $this$copyWithNewSourceKind_u24lambda_u2d2 = $i$f$buildErrorTypeRefCopy = new FirUserTypeRefBuilder();
            boolean bl = false;
            $this$copyWithNewSourceKind_u24lambda_u2d2.setSource(newSource);
            $this$copyWithNewSourceKind_u24lambda_u2d2.setMarkedNullable(((FirUserTypeRefImpl)typeRef).isMarkedNullable());
            FirUserTypeRefBuilder $this$copyWithNewSourceKind_u24lambda_u2d1 = $this$copyWithNewSourceKind_u24lambda_u2d2;
            CollectionsKt.addAll((Collection)$this$copyWithNewSourceKind_u24lambda_u2d1.getQualifier(), (Iterable)((FirUserTypeRefImpl)typeRef).getQualifier());
            $this$copyWithNewSourceKind_u24lambda_u2d1 = $this$copyWithNewSourceKind_u24lambda_u2d2;
            CollectionsKt.addAll((Collection)$this$copyWithNewSourceKind_u24lambda_u2d1.getAnnotations(), (Iterable)((FirUserTypeRefImpl)typeRef).getAnnotations());
            firTypeRef = $i$f$buildErrorTypeRefCopy.build();
        } else if (typeRef instanceof FirImplicitTypeRef) {
            FirImplicitTypeRefBuilder bl;
            FirImplicitTypeRef original$iv = (FirImplicitTypeRef)typeRef;
            boolean $i$f$buildImplicitTypeRefCopy = false;
            FirImplicitTypeRefBuilder copyBuilder$iv = new FirImplicitTypeRefBuilder();
            copyBuilder$iv.setSource(original$iv.getSource());
            FirImplicitTypeRefBuilder $this$copyWithNewSourceKind_u24lambda_u2d3 = bl = copyBuilder$iv;
            boolean bl2 = false;
            $this$copyWithNewSourceKind_u24lambda_u2d3.setSource(newSource);
            firTypeRef = bl.build();
        } else if (typeRef instanceof FirFunctionTypeRefImpl) {
            FirFunctionTypeRefBuilder bl;
            FirFunctionTypeRef original$iv = (FirFunctionTypeRef)typeRef;
            boolean $i$f$buildFunctionTypeRefCopy = false;
            FirFunctionTypeRefBuilder copyBuilder$iv = new FirFunctionTypeRefBuilder();
            copyBuilder$iv.setSource(original$iv.getSource());
            copyBuilder$iv.getAnnotations().addAll((Collection<FirAnnotationCall>)original$iv.getAnnotations());
            copyBuilder$iv.setMarkedNullable(original$iv.isMarkedNullable());
            copyBuilder$iv.setReceiverTypeRef(original$iv.getReceiverTypeRef());
            copyBuilder$iv.getValueParameters().addAll((Collection<FirValueParameter>)original$iv.getValueParameters());
            copyBuilder$iv.setReturnTypeRef(original$iv.getReturnTypeRef());
            copyBuilder$iv.setSuspend(original$iv.isSuspend());
            FirFunctionTypeRefBuilder $this$copyWithNewSourceKind_u24lambda_u2d4 = bl = copyBuilder$iv;
            boolean bl3 = false;
            $this$copyWithNewSourceKind_u24lambda_u2d4.setSource(newSource);
            firTypeRef = bl.build();
        } else if (typeRef instanceof FirDynamicTypeRef) {
            FirDynamicTypeRefBuilder firDynamicTypeRefBuilder;
            boolean $i$f$buildDynamicTypeRef = false;
            FirDynamicTypeRefBuilder $this$copyWithNewSourceKind_u24lambda_u2d5 = firDynamicTypeRefBuilder = new FirDynamicTypeRefBuilder();
            boolean bl = false;
            $this$copyWithNewSourceKind_u24lambda_u2d5.setSource(newSource);
            $this$copyWithNewSourceKind_u24lambda_u2d5.setMarkedNullable(((FirDynamicTypeRef)typeRef).isMarkedNullable());
            FirDynamicTypeRefBuilder firDynamicTypeRefBuilder2 = $this$copyWithNewSourceKind_u24lambda_u2d5;
            CollectionsKt.addAll((Collection)firDynamicTypeRefBuilder2.getAnnotations(), (Iterable)typeRef.getAnnotations());
            firTypeRef = firDynamicTypeRefBuilder.build();
        } else if (typeRef instanceof FirImplicitBuiltinTypeRef) {
            firTypeRef = FirImplicitBuiltinTypeRefKt.withFakeSource((FirImplicitBuiltinTypeRef)typeRef, newKind);
        } else {
            throw new NotImplementedError(Intrinsics.stringPlus("An operation is not implemented: ", Intrinsics.stringPlus("Not implemented for ", Reflection.getOrCreateKotlinClass(typeRef.getClass()))));
        }
        return (R)firTypeRef;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirSourceElement getWholeQualifierSourceIfPossible(@NotNull FirSourceElement $this$getWholeQualifierSourceIfPossible, int stepsToWholeQualifier) {
        FirSourceElement firSourceElement;
        Intrinsics.checkNotNullParameter($this$getWholeQualifierSourceIfPossible, "<this>");
        if (stepsToWholeQualifier == 0) {
            return $this$getWholeQualifierSourceIfPossible;
        }
        FirSourceElement firSourceElement2 = $this$getWholeQualifierSourceIfPossible;
        if (firSourceElement2 instanceof FirRealPsiSourceElement) {
            FirPsiSourceElement firPsiSourceElement;
            PsiElement wholeQualifier;
            Sequence<PsiElement> qualifiersChain2 = SequencesKt.generateSequence(((FirRealPsiSourceElement)$this$getWholeQualifierSourceIfPossible).getPsi(), (Function1)getWholeQualifierSourceIfPossible.qualifiersChain.1.INSTANCE);
            PsiElement $this$toFirPsiSourceElement_u24default$iv = wholeQualifier = SequencesKt.elementAt(qualifiersChain2, stepsToWholeQualifier);
            FirSourceElementKind kind$iv = FirRealSourceElementKind.INSTANCE;
            boolean $i$f$toFirPsiSourceElement = false;
            FirSourceElementKind firSourceElementKind = kind$iv;
            if (firSourceElementKind instanceof FirRealSourceElementKind) {
                firPsiSourceElement = new FirRealPsiSourceElement($this$toFirPsiSourceElement_u24default$iv);
            } else if (firSourceElementKind instanceof FirFakeSourceElementKind) {
                firPsiSourceElement = new FirFakeSourceElement($this$toFirPsiSourceElement_u24default$iv, (FirFakeSourceElementKind)kind$iv);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            firSourceElement = (FirRealPsiSourceElement)firPsiSourceElement;
        } else if (firSourceElement2 instanceof FirLightSourceElement) {
            void tree$iv;
            void endOffset$iv;
            void startOffset$iv;
            void $this$toFirLightSourceElement_u24default$iv;
            LighterASTNode wholeQualifier;
            Sequence<LighterASTNode> qualifiersChain3 = SequencesKt.generateSequence($this$getWholeQualifierSourceIfPossible.getLighterASTNode(), (Function1)new Function1<LighterASTNode, LighterASTNode>($this$getWholeQualifierSourceIfPossible){
                final /* synthetic */ FirSourceElement $this_getWholeQualifierSourceIfPossible;
                {
                    this.$this_getWholeQualifierSourceIfPossible = $receiver;
                    super(1);
                }

                @Nullable
                public final LighterASTNode invoke(@NotNull LighterASTNode it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$this_getWholeQualifierSourceIfPossible.getTreeStructure().getParent(it);
                }
            });
            LighterASTNode $this$toFirPsiSourceElement_u24default$iv = wholeQualifier = SequencesKt.elementAt(qualifiersChain3, stepsToWholeQualifier);
            FlyweightCapableTreeStructure<LighterASTNode> kind$iv = $this$getWholeQualifierSourceIfPossible.getTreeStructure();
            int n = $this$getWholeQualifierSourceIfPossible.getStartOffset();
            int n2 = wholeQualifier.getEndOffset() + ($this$getWholeQualifierSourceIfPossible.getEndOffset() - $this$getWholeQualifierSourceIfPossible.getLighterASTNode().getEndOffset());
            FirSourceElementKind kind$iv2 = FirRealSourceElementKind.INSTANCE;
            boolean $i$f$toFirLightSourceElement = false;
            firSourceElement = new FirLightSourceElement((LighterASTNode)$this$toFirLightSourceElement_u24default$iv, (int)startOffset$iv, (int)endOffset$iv, (FlyweightCapableTreeStructure<LighterASTNode>)tree$iv, kind$iv2);
        } else if (firSourceElement2 instanceof FirFakeSourceElement) {
            firSourceElement = $this$getWholeQualifierSourceIfPossible;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return firSourceElement;
    }

    @NotNull
    public static final FqName getPackageFqName(@NotNull FirFile $this$packageFqName) {
        Intrinsics.checkNotNullParameter($this$packageFqName, "<this>");
        return $this$packageFqName.getPackageDirective().getPackageFqName();
    }
}

