/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.UnwrappedType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\tH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/NewSchemeOfIntegerOperatorResolutionChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "literalOperatorsFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isIntOperator", "", "frontend"})
public final class NewSchemeOfIntegerOperatorResolutionChecker
implements CallChecker {
    @NotNull
    public static final NewSchemeOfIntegerOperatorResolutionChecker INSTANCE;
    @NotNull
    private static final Set<FqName> literalOperatorsFqNames;

    private NewSchemeOfIntegerOperatorResolutionChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ApproximateIntegerLiteralTypesInReceiverPosition)) {
            return;
        }
        Object object = context2.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue(object, "context.trace.bindingContext");
        BindingContext bindingContext = object;
        Object object2 = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(object2, "resolvedCall.valueArguments");
        boolean bl = false;
        object = object2.entrySet().iterator();
        while (object.hasNext()) {
            KotlinType kotlinType;
            Object object3 = object2 = (Map.Entry)object.next();
            boolean bl2 = false;
            ValueParameterDescriptor valueParameter2 = (ValueParameterDescriptor)object3.getKey();
            Object object4 = object2;
            boolean bl3 = false;
            ResolvedValueArgument arguments2 = (ResolvedValueArgument)object4.getValue();
            Intrinsics.checkNotNullExpressionValue(valueParameter2, "valueParameter");
            if (ArgumentsUtilsKt.isVararg(valueParameter2)) {
                KotlinType kotlinType2 = valueParameter2.getVarargElementType();
                if (kotlinType2 == null) continue;
                kotlinType = kotlinType2;
            } else {
                kotlinType = valueParameter2.getType();
            }
            UnwrappedType expectedType2 = kotlinType.unwrap();
            for (ValueArgument argument2 : arguments2.getArguments()) {
                IntegerLiteralTypeConstructor valueTypeConstructor;
                KotlinType approximatedType;
                TypeConstructor typeConstructor2;
                IntegerLiteralTypeConstructor integerLiteralTypeConstructor;
                IElementType token;
                Object callForArgument;
                IntegerValueTypeConstant integerValueTypeConstant;
                KtExpression ktExpression = argument2.getArgumentExpression();
                if (ktExpression == null) continue;
                KtExpression expression2 = ktExpression;
                Object object5 = bindingContext.get(BindingContext.COMPILE_TIME_VALUE, expression2);
                IntegerValueTypeConstant integerValueTypeConstant2 = integerValueTypeConstant = object5 instanceof IntegerValueTypeConstant ? (IntegerValueTypeConstant)object5 : null;
                if (integerValueTypeConstant == null) continue;
                IntegerValueTypeConstant compileTimeValue = integerValueTypeConstant;
                object5 = CallUtilKt.getResolvedCall(expression2, bindingContext);
                if (object5 == null || !this.isIntOperator((ResolvedCall<?>)(callForArgument = object5))) continue;
                KtElement ktElement = callForArgument.getCall().getCallElement();
                Intrinsics.checkNotNullExpressionValue(ktElement, "callForArgument.call.callElement");
                KtElement callElement = ktElement;
                if (callElement instanceof KtConstantExpression || callElement instanceof KtUnaryExpression && (Intrinsics.areEqual(token = ((KtUnaryExpression)callElement).getOperationToken(), KtTokens.PLUS) || Intrinsics.areEqual(token, KtTokens.MINUS)) || (integerLiteralTypeConstructor = (typeConstructor2 = compileTimeValue.getUnknownIntegerType().getConstructor()) instanceof IntegerLiteralTypeConstructor ? (IntegerLiteralTypeConstructor)typeConstructor2 : null) == null || Intrinsics.areEqual(approximatedType = (valueTypeConstructor = integerLiteralTypeConstructor).getApproximatedType(), expectedType2)) continue;
                context2.getTrace().report(Errors.INTEGER_OPERATOR_RESOLVE_WILL_CHANGE.on((KtExpression)((PsiElement)expression2), approximatedType));
            }
        }
    }

    private final boolean isIntOperator(ResolvedCall<?> $this$isIntOperator) {
        SimpleFunctionDescriptor simpleFunctionDescriptor;
        Object obj = $this$isIntOperator.getResultingDescriptor();
        SimpleFunctionDescriptor simpleFunctionDescriptor2 = simpleFunctionDescriptor = obj instanceof SimpleFunctionDescriptor ? (SimpleFunctionDescriptor)obj : null;
        if (simpleFunctionDescriptor == null) {
            return false;
        }
        SimpleFunctionDescriptor descriptor2 = simpleFunctionDescriptor;
        return literalOperatorsFqNames.contains(DescriptorUtilsKt.getFqNameSafe(descriptor2));
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_2;
        void $this$mapTo$iv;
        INSTANCE = new NewSchemeOfIntegerOperatorResolutionChecker();
        Object object = new String[]{"plus", "minus", "times", "div", "rem", "plus", "minus", "times", "div", "rem", "shl", "shr", "ushr", "and", "or", "xor", "unaryPlus", "unaryMinus", "inv"};
        object = CollectionsKt.listOf(object);
        boolean bl = false;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string2 = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            String[] stringArray = new String[]{"kotlin", "Int", it};
            FqName fqName2 = FqName.fromSegments(CollectionsKt.listOf(stringArray));
            collection.add(fqName2);
        }
        literalOperatorsFqNames = (Set)var1_2;
    }
}

