/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.serialization.JvmIdSignatureDescriptor;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.collectors.FirDiagnosticsCollector;
import org.jetbrains.kotlin.fir.analysis.collectors.SimpleDiagnosticsCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.backend.Fir2IrConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrResult;
import org.jetbrains.kotlin.fir.backend.jvm.Fir2IrJvmSpecialAnnotationSymbolProvider;
import org.jetbrains.kotlin.fir.backend.jvm.FirJvmKotlinMangler;
import org.jetbrains.kotlin.fir.backend.jvm.FirJvmVisibilityConverter;
import org.jetbrains.kotlin.fir.builder.RawFirBuilder;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.lightTree.LightTree2Fir;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTotalResolveProcessor;
import org.jetbrains.kotlin.ir.backend.jvm.serialization.JvmManglerDesc;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorExtensions;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\"\u001a\u00020#H\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u001c\u0010(\u001a\u0018\u0012\u0004\u0012\u00020\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00130\u0011J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00120\u0013R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u001b\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/FirAnalyzerFacade;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "originalFiles", "Ljava/io/File;", "useLightTree", "", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Ljava/util/Collection;Ljava/util/Collection;Z)V", "_scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "collectedDiagnostics", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnostic;", "firFiles", "getKtFiles", "()Ljava/util/Collection;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getOriginalFiles", "scopeSession", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getUseLightTree", "()Z", "buildRawFir", "", "convertToIr", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrResult;", "extensions", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorExtensions;", "runCheckers", "runResolution", "entrypoint"})
public final class FirAnalyzerFacade {
    @NotNull
    private final FirSession session;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final Collection<KtFile> ktFiles;
    @NotNull
    private final Collection<File> originalFiles;
    private final boolean useLightTree;
    @Nullable
    private List<? extends FirFile> firFiles;
    @Nullable
    private ScopeSession _scopeSession;
    @Nullable
    private Map<FirFile, ? extends List<? extends FirDiagnostic<?>>> collectedDiagnostics;

    public FirAnalyzerFacade(@NotNull FirSession session2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Collection<? extends KtFile> ktFiles, @NotNull Collection<? extends File> originalFiles, boolean useLightTree) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(ktFiles, "ktFiles");
        Intrinsics.checkNotNullParameter(originalFiles, "originalFiles");
        this.session = session2;
        this.languageVersionSettings = languageVersionSettings;
        this.ktFiles = ktFiles;
        this.originalFiles = originalFiles;
        this.useLightTree = useLightTree;
    }

    public /* synthetic */ FirAnalyzerFacade(FirSession firSession, LanguageVersionSettings languageVersionSettings, Collection collection, Collection collection2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            collection = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            collection2 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(firSession, languageVersionSettings, collection, collection2, bl);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final Collection<KtFile> getKtFiles() {
        return this.ktFiles;
    }

    @NotNull
    public final Collection<File> getOriginalFiles() {
        return this.originalFiles;
    }

    public final boolean getUseLightTree() {
        return this.useLightTree;
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        ScopeSession scopeSession = this._scopeSession;
        Intrinsics.checkNotNull(scopeSession);
        return scopeSession;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildRawFir() {
        List list2;
        FirAnalyzerFacade firAnalyzerFacade;
        if (this.firFiles != null) {
            return;
        }
        FirProviderImpl firProvider = (FirProviderImpl)MainSessionComponentsKt.getFirProvider(this.session);
        FirAnalyzerFacade firAnalyzerFacade2 = this;
        if (this.useLightTree) {
            Collection<FirFile> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            LightTree2Fir builder2 = new LightTree2Fir(this.session, firProvider.getKotlinScopeProvider(), false, 4, null);
            Iterable iterable = this.originalFiles;
            FirAnalyzerFacade firAnalyzerFacade3 = firAnalyzerFacade2;
            boolean $i$f$map = false;
            void var5_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                FirFile firFile = builder2.buildFirFile((File)it);
                boolean bl2 = false;
                boolean bl3 = false;
                FirFile firFile2 = firFile;
                boolean bl4 = false;
                firProvider.recordFile(firFile2);
                FirFile firFile3 = firFile;
                collection.add(firFile3);
            }
            collection = (List)destination$iv$iv;
            firAnalyzerFacade = firAnalyzerFacade3;
            list2 = collection;
        } else {
            Collection<FirFile> collection;
            RawFirBuilder builder3 = new RawFirBuilder(this.session, firProvider.getKotlinScopeProvider(), null, 4, null);
            Iterable $this$map$iv = this.ktFiles;
            FirAnalyzerFacade firAnalyzerFacade4 = firAnalyzerFacade2;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                KtFile it = (KtFile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                FirFile firFile = builder3.buildFirFile(it);
                boolean bl5 = false;
                boolean bl6 = false;
                FirFile firFile4 = firFile;
                boolean bl7 = false;
                firProvider.recordFile(firFile4);
                FirFile firFile5 = firFile;
                collection.add(firFile5);
            }
            collection = (List)destination$iv$iv;
            firAnalyzerFacade = firAnalyzerFacade4;
            list2 = collection;
        }
        firAnalyzerFacade.firFiles = list2;
    }

    @NotNull
    public final List<FirFile> runResolution() {
        if (this.firFiles == null) {
            this.buildRawFir();
        }
        if (this._scopeSession != null) {
            List<FirFile> list2 = this.firFiles;
            Intrinsics.checkNotNull(list2);
            return list2;
        }
        FirTotalResolveProcessor resolveProcessor = new FirTotalResolveProcessor(this.session);
        List<FirFile> list3 = this.firFiles;
        Intrinsics.checkNotNull(list3);
        resolveProcessor.process(list3);
        this._scopeSession = resolveProcessor.getScopeSession();
        list3 = this.firFiles;
        Intrinsics.checkNotNull(list3);
        return list3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<FirFile, List<FirDiagnostic<?>>> runCheckers() {
        if (this._scopeSession == null) {
            this.runResolution();
        }
        if (this.collectedDiagnostics != null) {
            Map<FirFile, List<FirDiagnostic<?>>> map = this.collectedDiagnostics;
            Intrinsics.checkNotNull(map);
            return map;
        }
        SimpleDiagnosticsCollector collector2 = FirDiagnosticsCollector.INSTANCE.create(this.session, this.getScopeSession());
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        Map map = MapsKt.createMapBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        Map map2 = map;
        FirAnalyzerFacade firAnalyzerFacade = this;
        boolean bl5 = false;
        List<? extends FirFile> list2 = this.firFiles;
        Intrinsics.checkNotNull(list2);
        for (FirFile firFile : list2) {
            void $this$runCheckers_u24lambda_u2d4;
            $this$runCheckers_u24lambda_u2d4.put(firFile, collector2.collectDiagnostics(firFile));
        }
        Unit unit = Unit.INSTANCE;
        firAnalyzerFacade.collectedDiagnostics = MapsKt.build(map);
        Map<FirFile, List<FirDiagnostic<?>>> map3 = this.collectedDiagnostics;
        Intrinsics.checkNotNull(map3);
        return map3;
    }

    @NotNull
    public final Fir2IrResult convertToIr(@NotNull GeneratorExtensions extensions) {
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        if (this._scopeSession == null) {
            this.runResolution();
        }
        JvmIdSignatureDescriptor signaturer = new JvmIdSignatureDescriptor(new JvmManglerDesc(null, 1, null));
        Object object = this._scopeSession;
        Intrinsics.checkNotNull(object);
        ScopeSession scopeSession = object;
        object = this.firFiles;
        Intrinsics.checkNotNull(object);
        return Fir2IrConverter.Companion.createModuleFragment(this.session, scopeSession, (List<? extends FirFile>)object, this.languageVersionSettings, signaturer, extensions, new FirJvmKotlinMangler(this.session), IrFactoryImpl.INSTANCE, FirJvmVisibilityConverter.INSTANCE, new Fir2IrJvmSpecialAnnotationSymbolProvider());
    }
}

