/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ZipEntryMap
extends AbstractMap<String, ArchiveHandler.EntryInfo> {
    private ArchiveHandler.EntryInfo[] entries;
    private int size = 0;
    private EntrySet entrySet;

    ZipEntryMap(int expectedSize) {
        this.entries = new ArchiveHandler.EntryInfo[Math.max(10, expectedSize * 2)];
    }

    @Override
    public ArchiveHandler.EntryInfo get(@NotNull Object key) {
        ArchiveHandler.EntryInfo entry;
        int index2;
        if (key == null) {
            ZipEntryMap.$$$reportNull$$$0(0);
        }
        String relativePath = (String)key;
        int i = index2 = ZipEntryMap.index(relativePath, this.entries);
        while ((entry = this.entries[i]) != null && !ZipEntryMap.isTheOne(entry, relativePath)) {
            if (++i == this.entries.length) {
                i = 0;
            }
            if (i != index2) continue;
            entry = null;
            break;
        }
        return entry;
    }

    private static int index(@NotNull String relativePath, ArchiveHandler.EntryInfo @NotNull [] entries) {
        if (relativePath == null) {
            ZipEntryMap.$$$reportNull$$$0(1);
        }
        if (entries == null) {
            ZipEntryMap.$$$reportNull$$$0(2);
        }
        return (relativePath.hashCode() & Integer.MAX_VALUE) % entries.length;
    }

    @Override
    public ArchiveHandler.EntryInfo put(String relativePath, ArchiveHandler.EntryInfo value2) {
        ArchiveHandler.EntryInfo old;
        if (this.size >= 5 * this.entries.length / 8) {
            this.rehash();
        }
        if ((old = ZipEntryMap.put(relativePath, value2, this.entries)) == null) {
            ++this.size;
        }
        return old;
    }

    @Nullable
    private static ArchiveHandler.EntryInfo put(@NotNull String relativePath, @NotNull ArchiveHandler.EntryInfo value2, ArchiveHandler.EntryInfo @NotNull [] entries) {
        ArchiveHandler.EntryInfo entry;
        int index2;
        if (relativePath == null) {
            ZipEntryMap.$$$reportNull$$$0(3);
        }
        if (value2 == null) {
            ZipEntryMap.$$$reportNull$$$0(4);
        }
        if (entries == null) {
            ZipEntryMap.$$$reportNull$$$0(5);
        }
        int i = index2 = ZipEntryMap.index(relativePath, entries);
        while (true) {
            if ((entry = entries[i]) == null || ZipEntryMap.isTheOne(entry, relativePath)) break;
            if (++i != entries.length) continue;
            i = 0;
        }
        entries[i] = value2;
        return entry;
    }

    private static boolean isTheOne(@NotNull ArchiveHandler.EntryInfo entry, @NotNull CharSequence relativePath) {
        if (entry == null) {
            ZipEntryMap.$$$reportNull$$$0(6);
        }
        if (relativePath == null) {
            ZipEntryMap.$$$reportNull$$$0(7);
        }
        int endIndex = relativePath.length();
        ArchiveHandler.EntryInfo e = entry;
        while (e != null) {
            CharSequence shortName = e.shortName;
            if (!CharArrayUtil.regionMatches(relativePath, endIndex - shortName.length(), relativePath.length(), shortName)) {
                return false;
            }
            if (e.parent != null && e.parent.shortName.length() != 0 && (endIndex -= shortName.length()) != 0) {
                if (relativePath.charAt(endIndex - 1) == '/') {
                    --endIndex;
                } else {
                    return false;
                }
            }
            e = e.parent;
        }
        return endIndex == 0;
    }

    private void rehash() {
        ArchiveHandler.EntryInfo[] newEntries = new ArchiveHandler.EntryInfo[this.entries.length < 1000 ? this.entries.length * 2 : this.entries.length * 3 / 2];
        for (ArchiveHandler.EntryInfo entry : this.entries) {
            if (entry == null) continue;
            ZipEntryMap.put(ZipEntryMap.getRelativePath(entry), entry, newEntries);
        }
        this.entries = newEntries;
    }

    @NotNull
    private static String getRelativePath(@NotNull ArchiveHandler.EntryInfo entry) {
        if (entry == null) {
            ZipEntryMap.$$$reportNull$$$0(8);
        }
        StringBuilder result2 = new StringBuilder(entry.shortName.length() + 10);
        ArchiveHandler.EntryInfo e = entry;
        while (e != null) {
            if (result2.length() != 0 && e.shortName.length() != 0) {
                result2.append('/');
            }
            ZipEntryMap.appendReversed(result2, e.shortName);
            e = e.parent;
        }
        String string2 = result2.reverse().toString();
        if (string2 == null) {
            ZipEntryMap.$$$reportNull$$$0(9);
        }
        return string2;
    }

    private static void appendReversed(@NotNull StringBuilder builder2, @NotNull CharSequence sequence2) {
        if (builder2 == null) {
            ZipEntryMap.$$$reportNull$$$0(10);
        }
        if (sequence2 == null) {
            ZipEntryMap.$$$reportNull$$$0(11);
        }
        for (int i = sequence2.length() - 1; i >= 0; --i) {
            builder2.append(sequence2.charAt(i));
        }
    }

    @Override
    public ArchiveHandler.EntryInfo remove(@NotNull Object key) {
        if (key == null) {
            ZipEntryMap.$$$reportNull$$$0(12);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.entries = new ArchiveHandler.EntryInfo[10];
    }

    @NotNull
    public EntrySet entrySet() {
        EntrySet es = this.entrySet;
        EntrySet entrySet = es == null ? (this.entrySet = new EntrySet()) : es;
        if (entrySet == null) {
            ZipEntryMap.$$$reportNull$$$0(13);
        }
        return entrySet;
    }

    @Override
    @NotNull
    public Collection<ArchiveHandler.EntryInfo> values() {
        List<ArchiveHandler.EntryInfo> list2 = ContainerUtil.filter(this.entries, Conditions.notNull());
        if (list2 == null) {
            ZipEntryMap.$$$reportNull$$$0(14);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/ZipEntryMap";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/ZipEntryMap";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "index";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isTheOne";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendReversed";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<String, ArchiveHandler.EntryInfo>> {
        private EntrySet() {
        }

        @Override
        public final int size() {
            return ZipEntryMap.this.size();
        }

        @Override
        public final void clear() {
            ZipEntryMap.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<String, ArchiveHandler.EntryInfo>> iterator() {
            return ContainerUtil.mapIterator(ContainerUtil.iterate(ZipEntryMap.this.entries, Conditions.notNull()).iterator(), entry -> new AbstractMap.SimpleEntry<String, ArchiveHandler.EntryInfo>(ZipEntryMap.getRelativePath(entry), (ArchiveHandler.EntryInfo)entry));
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            String key = (String)e.getKey();
            ArchiveHandler.EntryInfo value2 = (ArchiveHandler.EntryInfo)e.getValue();
            return value2.equals(ZipEntryMap.this.get(key));
        }

        @Override
        public final boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

