/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.analyze;

import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.FunctionInterfaceFactoryKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.context.ModuleContext;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.frontend.js.di.InjectionKt;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.ErrorTolerancePolicy;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.resolve.BindingContextSlicesJsKt;
import org.jetbrains.kotlin.js.resolve.JsPlatformAnalyzerServices;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.js.JsPlatforms;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JV\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u000eJ<\u0010\u0013\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\rJ$\u0010\u001a\u001a\u00020\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ(\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H$\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/js/analyze/AbstractTopDownAnalyzerFacadeForJS;", "", "()V", "analyzeFiles", "Lorg/jetbrains/kotlin/js/analyzer/JsAnalysisResult;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "moduleDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "friendModuleDescriptors", "thisIsBuiltInsModule", "", "customBuiltInsModule", "analyzeFilesWithGivenTrace", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "moduleContext", "Lorg/jetbrains/kotlin/context/ModuleContext;", "additionalPackages", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "checkForErrors", "allFiles", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "errorPolicy", "Lorg/jetbrains/kotlin/js/config/ErrorTolerancePolicy;", "loadIncrementalCacheMetadata", "incrementalData", "Lorg/jetbrains/kotlin/incremental/js/IncrementalDataProvider;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "js.frontend"})
public abstract class AbstractTopDownAnalyzerFacadeForJS {
    @NotNull
    public final JsAnalysisResult analyzeFiles(@NotNull Collection<? extends KtFile> files2, @NotNull Project project, @NotNull CompilerConfiguration configuration, @NotNull List<ModuleDescriptorImpl> moduleDescriptors, @NotNull List<ModuleDescriptorImpl> friendModuleDescriptors, boolean thisIsBuiltInsModule, @Nullable ModuleDescriptorImpl customBuiltInsModule) {
        Object object;
        String string2;
        Intrinsics.checkNotNullParameter(files2, "files");
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Intrinsics.checkNotNullParameter(moduleDescriptors, "moduleDescriptors");
        Intrinsics.checkNotNullParameter(friendModuleDescriptors, "friendModuleDescriptors");
        boolean bl = !thisIsBuiltInsModule || customBuiltInsModule == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string3 = "Can't simultaneously use custom built-ins module and set current module as built-ins";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        KotlinBuiltIns builtIns = thisIsBuiltInsModule ? (KotlinBuiltIns)new DefaultBuiltIns(false) : (customBuiltInsModule != null ? customBuiltInsModule.getBuiltIns() : JsPlatformAnalyzerServices.INSTANCE.getBuiltIns());
        Object bl4 = configuration.get(CommonConfigurationKeys.MODULE_NAME);
        Intrinsics.checkNotNull(bl4);
        String moduleName = string2 = bl4;
        ProjectContext projectContext = ContextKt.ProjectContext(project, "TopDownAnalyzer for JS");
        bl4 = Name.special('<' + moduleName + '>');
        Intrinsics.checkNotNullExpressionValue(bl4, "special(\"<$moduleName>\")");
        MutableModuleContext context2 = ContextKt.ContextForNewModule(projectContext, (Name)bl4, builtIns, JsPlatforms.INSTANCE.getDefaultJsPlatform());
        boolean bl5 = false;
        List additionalPackages = new ArrayList();
        if (thisIsBuiltInsModule) {
            builtIns.setBuiltInsModule(context2.getModule());
            Collection collection = additionalPackages;
            object = FunctionInterfaceFactoryKt.functionInterfacePackageFragmentProvider(context2.getStorageManager(), context2.getModule());
            boolean bl6 = false;
            collection.add(object);
        }
        object = new ModuleDescriptorImpl[]{context2.getModule()};
        Set<ModuleDescriptorImpl> set = SetsKt.plus(SetsKt.mutableSetOf(object), (Iterable)moduleDescriptors);
        object = builtIns.getBuiltInsModule();
        Intrinsics.checkNotNullExpressionValue(object, "builtIns.builtInsModule");
        Set<ModuleDescriptorImpl[]> dependencies2 = SetsKt.plus(set, object);
        context2.getModule().setDependencies(CollectionsKt.toList((Iterable)dependencies2), CollectionsKt.toSet((Iterable)friendModuleDescriptors));
        ModuleKind moduleKind = configuration.get(JSConfigurationKeys.MODULE_KIND, ModuleKind.PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)moduleKind, "configuration.get(JSConfigurationKeys.MODULE_KIND, ModuleKind.PLAIN)");
        ModuleKind moduleKind2 = moduleKind;
        BindingTraceContext trace = new BindingTraceContext();
        trace.record(BindingContextSlicesJsKt.MODULE_KIND, context2.getModule(), moduleKind2);
        return this.analyzeFilesWithGivenTrace(files2, trace, context2, configuration, additionalPackages);
    }

    public static /* synthetic */ JsAnalysisResult analyzeFiles$default(AbstractTopDownAnalyzerFacadeForJS abstractTopDownAnalyzerFacadeForJS, Collection collection, Project project, CompilerConfiguration compilerConfiguration, List list2, List list3, boolean bl, ModuleDescriptorImpl moduleDescriptorImpl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: analyzeFiles");
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            moduleDescriptorImpl = null;
        }
        return abstractTopDownAnalyzerFacadeForJS.analyzeFiles(collection, project, compilerConfiguration, list2, list3, bl, moduleDescriptorImpl);
    }

    @NotNull
    protected abstract PackageFragmentProvider loadIncrementalCacheMetadata(@NotNull IncrementalDataProvider var1, @NotNull ModuleContext var2, @NotNull LookupTracker var3, @NotNull LanguageVersionSettings var4);

    @NotNull
    public final JsAnalysisResult analyzeFilesWithGivenTrace(@NotNull Collection<? extends KtFile> files2, @NotNull BindingTrace trace, @NotNull ModuleContext moduleContext, @NotNull CompilerConfiguration configuration, @NotNull List<? extends PackageFragmentProvider> additionalPackages) {
        PackageFragmentProvider packageFragmentProvider;
        Intrinsics.checkNotNullParameter(files2, "files");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(moduleContext, "moduleContext");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Intrinsics.checkNotNullParameter(additionalPackages, "additionalPackages");
        Object object = configuration.get(CommonConfigurationKeys.LOOKUP_TRACKER);
        LookupTracker lookupTracker = object == null ? (LookupTracker)LookupTracker.DO_NOTHING.INSTANCE : object;
        Intrinsics.checkNotNullExpressionValue(lookupTracker, "configuration.get(CommonConfigurationKeys.LOOKUP_TRACKER) ?: LookupTracker.DO_NOTHING");
        LookupTracker lookupTracker2 = lookupTracker;
        ExpectActualTracker expectActualTracker = configuration.get(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER);
        object = expectActualTracker == null ? (ExpectActualTracker)ExpectActualTracker.DoNothing.INSTANCE : expectActualTracker;
        Intrinsics.checkNotNullExpressionValue(object, "configuration.get(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER) ?: ExpectActualTracker.DoNothing");
        Object expectActualTracker2 = object;
        LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(configuration);
        IncrementalDataProvider incrementalDataProvider = configuration.get(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER);
        if (incrementalDataProvider == null) {
            packageFragmentProvider = null;
        } else {
            IncrementalDataProvider incrementalDataProvider2 = incrementalDataProvider;
            boolean bl = false;
            boolean bl2 = false;
            IncrementalDataProvider it = incrementalDataProvider2;
            boolean bl3 = false;
            packageFragmentProvider = this.loadIncrementalCacheMetadata(it, moduleContext, lookupTracker2, languageVersionSettings);
        }
        PackageFragmentProvider packageFragment = packageFragmentProvider;
        LazyTopDownAnalyzer analyzerForJs = InjectionKt.createTopDownAnalyzerForJs(moduleContext, trace, new FileBasedDeclarationProviderFactory(moduleContext.getStorageManager(), files2), languageVersionSettings, lookupTracker2, (ExpectActualTracker)expectActualTracker2, CollectionsKt.plus((Collection)additionalPackages, (Iterable)CollectionsKt.listOfNotNull(packageFragment)));
        LazyTopDownAnalyzer.analyzeDeclarations$default(analyzerForJs, TopDownAnalysisMode.TopLevelDeclarations, files2, null, 4, null);
        return JsAnalysisResult.Companion.success(trace, moduleContext.getModule());
    }

    public static /* synthetic */ JsAnalysisResult analyzeFilesWithGivenTrace$default(AbstractTopDownAnalyzerFacadeForJS abstractTopDownAnalyzerFacadeForJS, Collection collection, BindingTrace bindingTrace, ModuleContext moduleContext, CompilerConfiguration compilerConfiguration, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: analyzeFilesWithGivenTrace");
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return abstractTopDownAnalyzerFacadeForJS.analyzeFilesWithGivenTrace(collection, bindingTrace, moduleContext, compilerConfiguration, list2);
    }

    public final boolean checkForErrors(@NotNull Collection<? extends KtFile> allFiles, @NotNull BindingContext bindingContext, @NotNull ErrorTolerancePolicy errorPolicy) {
        Intrinsics.checkNotNullParameter(allFiles, "allFiles");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Intrinsics.checkNotNullParameter((Object)errorPolicy, "errorPolicy");
        boolean hasErrors = false;
        try {
            AnalyzingUtils.INSTANCE.throwExceptionOnErrors(bindingContext);
        }
        catch (Exception ex) {
            if (!errorPolicy.getAllowSemanticErrors()) {
                throw ex;
            }
            hasErrors = true;
        }
        try {
            for (KtFile ktFile : allFiles) {
                AnalyzingUtils.checkForSyntacticErrors(ktFile);
            }
        }
        catch (Exception ex) {
            if (!errorPolicy.getAllowSyntaxErrors()) {
                throw ex;
            }
            hasErrors = true;
        }
        return hasErrors;
    }
}

