/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.load.kotlin.JvmType;
import org.jetbrains.kotlin.load.kotlin.JvmTypeFactory;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/JvmTypeFactoryImpl;", "Lorg/jetbrains/kotlin/load/kotlin/JvmTypeFactory;", "Lorg/jetbrains/kotlin/load/kotlin/JvmType;", "()V", "javaLangClassType", "getJavaLangClassType", "()Lorg/jetbrains/kotlin/load/kotlin/JvmType;", "boxType", "possiblyPrimitiveType", "createFromString", "representation", "", "createObjectType", "Lorg/jetbrains/kotlin/load/kotlin/JvmType$Object;", "internalName", "toString", "type", "descriptors.jvm"})
final class JvmTypeFactoryImpl
implements JvmTypeFactory<JvmType> {
    public static final JvmTypeFactoryImpl INSTANCE;

    @Override
    @NotNull
    public JvmType boxType(@NotNull JvmType possiblyPrimitiveType) {
        JvmType jvmType;
        Intrinsics.checkParameterIsNotNull(possiblyPrimitiveType, "possiblyPrimitiveType");
        if (possiblyPrimitiveType instanceof JvmType.Primitive && ((JvmType.Primitive)possiblyPrimitiveType).getJvmPrimitiveType() != null) {
            JvmClassName jvmClassName = JvmClassName.byFqNameWithoutInnerClasses(((JvmType.Primitive)possiblyPrimitiveType).getJvmPrimitiveType().getWrapperFqName());
            Intrinsics.checkExpressionValueIsNotNull(jvmClassName, "JvmClassName.byFqNameWit\u2026mitiveType.wrapperFqName)");
            String string2 = jvmClassName.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string2, "JvmClassName.byFqNameWit\u2026apperFqName).internalName");
            jvmType = this.createObjectType(string2);
        } else {
            jvmType = possiblyPrimitiveType;
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType createFromString(@NotNull String representation) {
        JvmType jvmType;
        int n;
        String string2;
        Object object;
        int n2;
        char firstChar;
        block8: {
            Intrinsics.checkParameterIsNotNull(representation, "representation");
            CharSequence charSequence = representation;
            boolean bl = false;
            boolean bl2 = charSequence.length() > 0;
            bl = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-JvmTypeFactoryImpl$createFromString$22 = false;
                String $i$a$-assert-JvmTypeFactoryImpl$createFromString$22 = "empty string as JvmType";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-JvmTypeFactoryImpl$createFromString$22));
            }
            firstChar = representation.charAt(0);
            JvmPrimitiveType[] $this$firstOrNull$iv = JvmPrimitiveType.values();
            boolean $i$f$firstOrNull = false;
            JvmPrimitiveType[] jvmPrimitiveTypeArray = $this$firstOrNull$iv;
            n2 = jvmPrimitiveTypeArray.length;
            for (int i = 0; i < n2; ++i) {
                JvmPrimitiveType element$iv;
                JvmPrimitiveType it = element$iv = jvmPrimitiveTypeArray[i];
                boolean bl3 = false;
                if (!(it.getDesc().charAt(0) == firstChar)) continue;
                object = element$iv;
                break block8;
            }
            object = null;
        }
        if (object != null) {
            string2 = object;
            n = 0;
            boolean bl = false;
            String it = string2;
            boolean bl4 = false;
            return new JvmType.Primitive((JvmPrimitiveType)((Object)it));
        }
        switch (firstChar) {
            case 'V': {
                jvmType = new JvmType.Primitive(null);
                break;
            }
            case '[': {
                string2 = representation;
                n = 1;
                JvmTypeFactoryImpl jvmTypeFactoryImpl = this;
                boolean bl = false;
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).substring(startIndex)");
                String string4 = string3;
                JvmType jvmType2 = jvmTypeFactoryImpl.createFromString(string4);
                jvmType = new JvmType.Array(jvmType2);
                break;
            }
            default: {
                String string5;
                boolean bl = firstChar == 'L' && StringsKt.endsWith$default((CharSequence)representation, ';', false, 2, null);
                n = 0;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl5 = false;
                    String string6 = "Type that is not primitive nor array should be Object, but '" + representation + "' was found";
                    throw (Throwable)((Object)new AssertionError((Object)string6));
                }
                String string7 = representation;
                n = 1;
                int n3 = representation.length() - 1;
                n2 = 0;
                String string8 = string7.substring(n, n3);
                Intrinsics.checkExpressionValueIsNotNull(string8, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string9 = string5 = string8;
                jvmType = new JvmType.Object(string9);
            }
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType.Object createObjectType(@NotNull String internalName) {
        Intrinsics.checkParameterIsNotNull(internalName, "internalName");
        return new JvmType.Object(internalName);
    }

    @Override
    @NotNull
    public String toString(@NotNull JvmType type2) {
        Object object;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        JvmType jvmType = type2;
        if (jvmType instanceof JvmType.Array) {
            object = "[" + this.toString(((JvmType.Array)type2).getElementType());
        } else if (jvmType instanceof JvmType.Primitive) {
            object = ((JvmType.Primitive)type2).getJvmPrimitiveType();
            if (object == null || (object = object.getDesc()) == null) {
                object = "V";
            }
        } else if (jvmType instanceof JvmType.Object) {
            object = "L" + ((JvmType.Object)type2).getInternalName() + ";";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Override
    @NotNull
    public JvmType getJavaLangClassType() {
        return this.createObjectType("java/lang/Class");
    }

    private JvmTypeFactoryImpl() {
    }

    static {
        JvmTypeFactoryImpl jvmTypeFactoryImpl;
        INSTANCE = jvmTypeFactoryImpl = new JvmTypeFactoryImpl();
    }
}

