/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.RangeKind;
import org.jetbrains.kotlin.js.backend.ast.metadata.RangeType;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoKt;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslatorKt$WhenMappings;
import org.jetbrains.kotlin.js.translate.callTranslator.ExplicitReceivers;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCasesKt;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.RangeCheckTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.InlineUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005\u001a \u0010\f\u001a\u00020\r2\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a(\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a8\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\t2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0014\u001a\u00020\u0015*\n\u0012\u0006\b\u0001\u0012\u00020\u00130\tH\u0002\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\n\u0012\u0006\b\u0001\u0012\u00020\u00130\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"intRangeToFqName", "Lorg/jetbrains/kotlin/name/FqName;", "longRangeToFqName", "untilFqName", "computeExplicitReceiversForInvoke", "Lorg/jetbrains/kotlin/js/translate/callTranslator/ExplicitReceivers;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "explicitReceivers", "mayBeMarkByRangeMetadata", "", "callExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "translateCall", "translateFunctionCall", "inlineResolvedCall", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "expectedReceivers", "", "getReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "js.translator"})
public final class CallTranslatorKt {
    private static final FqName intRangeToFqName = new FqName("kotlin.Int.rangeTo");
    private static final FqName longRangeToFqName = new FqName("kotlin.Long.rangeTo");
    private static final FqName untilFqName = new FqName("kotlin.ranges.until");

    private static final boolean expectedReceivers(@NotNull ResolvedCall<? extends CallableDescriptor> $this$expectedReceivers) {
        return $this$expectedReceivers.getExplicitReceiverKind() != ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
    }

    private static final JsExpression translateCall(TranslationContext context2, ResolvedCall<? extends FunctionDescriptor> resolvedCall2, ExplicitReceivers explicitReceivers) {
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            ExplicitReceivers explicitReceivers2;
            ResolvedCall<CallableDescriptor> inlineCall2;
            boolean bl = explicitReceivers.getExtensionReceiver() == null;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-CallTranslatorKt$translateCall$22 = false;
                String $i$a$-assert-CallTranslatorKt$translateCall$22 = "VariableAsFunctionResolvedCall must have one receiver";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-CallTranslatorKt$translateCall$22));
            }
            ResolvedCall<VariableDescriptor> variableCall = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall();
            VariableDescriptor variableDescriptor = variableCall.getResultingDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(variableDescriptor, "variableCall.resultingDescriptor");
            KotlinType $i$a$-assert-CallTranslatorKt$translateCall$22 = variableDescriptor.getType();
            boolean bl3 = false;
            boolean bl4 = false;
            KotlinType $this$run = $i$a$-assert-CallTranslatorKt$translateCall$22;
            boolean bl5 = false;
            boolean isFunctionType = FunctionTypesKt.isFunctionTypeOrSubtype($this$run) || FunctionTypesKt.isSuspendFunctionTypeOrSubtype($this$run);
            ResolvedCall<CallableDescriptor> resolvedCall3 = inlineCall2 = isFunctionType ? variableCall : resolvedCall2;
            if (CallTranslatorKt.expectedReceivers(variableCall)) {
                JsExpression newReceiver = CallTranslator.INSTANCE.translateGet(context2, variableCall, explicitReceivers.getExtensionOrDispatchReceiver());
                explicitReceivers2 = new ExplicitReceivers(newReceiver, null, 2, null);
            } else {
                JsExpression dispatchReceiver = CallTranslator.INSTANCE.translateGet(context2, variableCall, null);
                explicitReceivers2 = explicitReceivers.getExtensionOrDispatchReceiver() == null ? new ExplicitReceivers(dispatchReceiver, null, 2, null) : new ExplicitReceivers(dispatchReceiver, explicitReceivers.getExtensionOrDispatchReceiver());
            }
            ExplicitReceivers newExplicitReceivers = explicitReceivers2;
            return CallTranslatorKt.translateFunctionCall(context2, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall(), inlineCall2, newExplicitReceivers);
        }
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call2, "resolvedCall.call");
        Call call3 = call2;
        if (call3.getCallType() == Call.CallType.INVOKE && !CallResolverUtilKt.isInvokeCallOnVariable(call3)) {
            ExplicitReceivers explicitReceiversForInvoke = CallTranslatorKt.computeExplicitReceiversForInvoke(context2, resolvedCall2, explicitReceivers);
            return CallTranslatorKt.translateFunctionCall(context2, resolvedCall2, resolvedCall2, explicitReceiversForInvoke);
        }
        return CallTranslatorKt.translateFunctionCall(context2, resolvedCall2, resolvedCall2, explicitReceivers);
    }

    private static final JsExpression translateFunctionCall(TranslationContext context2, ResolvedCall<? extends FunctionDescriptor> resolvedCall2, ResolvedCall<? extends CallableDescriptor> inlineResolvedCall, ExplicitReceivers explicitReceivers) {
        JsExpression rangeCheck = new RangeCheckTranslator(context2).translateAsRangeCheck(resolvedCall2, explicitReceivers);
        if (rangeCheck != null) {
            return rangeCheck;
        }
        FunctionCallInfo callInfo2 = CallInfoKt.getCallInfo(context2, resolvedCall2, explicitReceivers);
        JsExpression callExpression = FunctionCallCasesKt.translateFunctionCall(callInfo2);
        if (CallExpressionTranslator.shouldBeInlined(inlineResolvedCall.getResultingDescriptor(), context2)) {
            Call call2 = resolvedCall2.getCall();
            Intrinsics.checkExpressionValueIsNotNull(call2, "resolvedCall.call");
            KtElement ktElement = call2.getCallElement();
            Intrinsics.checkExpressionValueIsNotNull(ktElement, "resolvedCall.call.callElement");
            InlineUtils.setInlineCallMetadata(callExpression, ktElement, inlineResolvedCall.getResultingDescriptor(), context2);
        }
        if (resolvedCall2.getResultingDescriptor().isSuspend()) {
            Object object = callExpression;
            FunctionCallInfo functionCallInfo = callInfo2;
            boolean bl = false;
            boolean bl2 = false;
            JsExpression $this$apply = object;
            boolean bl3 = false;
            MetadataProperties.setSuspend($this$apply, true);
            Call call3 = resolvedCall2.getCall();
            Intrinsics.checkExpressionValueIsNotNull(call3, "resolvedCall.call");
            $this$apply.setSource(call3.getCallElement());
            JsExpression jsExpression = object;
            JsStatement jsStatement = JsAstUtils.asSyntheticStatement(jsExpression);
            Intrinsics.checkExpressionValueIsNotNull(jsStatement, "JsAstUtils.asSyntheticSt\u2026ll.callElement\n        })");
            JsStatement statement2 = functionCallInfo.constructSuspendSafeCallIfNeeded(jsStatement);
            JsBlock jsBlock = context2.getCurrentBlock();
            Intrinsics.checkExpressionValueIsNotNull(jsBlock, "context.currentBlock");
            object = jsBlock.getStatements();
            bl = false;
            object.add(statement2);
            return UtilsKt.createCoroutineResult(context2, resolvedCall2);
        }
        callExpression = callInfo2.constructSafeCallIfNeeded(callExpression);
        KotlinType kotlinType = CallTranslatorKt.getReturnType(resolvedCall2);
        JsExpression jsExpression = callExpression;
        boolean bl = false;
        boolean bl4 = false;
        KotlinType it = kotlinType;
        boolean bl5 = false;
        Call call4 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call4, "resolvedCall.call");
        KotlinType kotlinType2 = CallUtilKt.isSafeCall(call4) ? TypeUtilsKt.makeNullable(it) : it;
        MetadataProperties.setType(jsExpression, kotlinType2);
        CallTranslatorKt.mayBeMarkByRangeMetadata(resolvedCall2, callExpression);
        return callExpression;
    }

    private static final void mayBeMarkByRangeMetadata(ResolvedCall<? extends FunctionDescriptor> resolvedCall2, JsExpression callExpression) {
        block1: {
            FqNameUnsafe fqNameUnsafe;
            block3: {
                FqName fqName2;
                block2: {
                    block0: {
                        fqName2 = DescriptorUtilsKt.getFqNameSafe(resolvedCall2.getResultingDescriptor());
                        if (!Intrinsics.areEqual(fqName2, intRangeToFqName)) break block0;
                        MetadataProperties.setRange(callExpression, new Pair<RangeType, RangeKind>(RangeType.INT, RangeKind.RANGE_TO));
                        break block1;
                    }
                    if (!Intrinsics.areEqual(fqName2, longRangeToFqName)) break block2;
                    MetadataProperties.setRange(callExpression, new Pair<RangeType, RangeKind>(RangeType.LONG, RangeKind.RANGE_TO));
                    break block1;
                }
                if (!Intrinsics.areEqual(fqName2, untilFqName)) break block1;
                Object object = resolvedCall2.getResultingDescriptor().getReturnType();
                FqNameUnsafe fqNameUnsafe2 = object != null && (object = ((KotlinType)object).getConstructor()) != null && (object = object.getDeclarationDescriptor()) != null ? DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)object) : (fqNameUnsafe = null);
                if (!Intrinsics.areEqual(fqNameUnsafe, KotlinBuiltIns.FQ_NAMES.intRange)) break block3;
                MetadataProperties.setRange(callExpression, new Pair<RangeType, RangeKind>(RangeType.INT, RangeKind.UNTIL));
                break block1;
            }
            if (!Intrinsics.areEqual(fqNameUnsafe, KotlinBuiltIns.FQ_NAMES.longRange)) break block1;
            MetadataProperties.setRange(callExpression, new Pair<RangeType, RangeKind>(RangeType.LONG, RangeKind.UNTIL));
        }
    }

    @NotNull
    public static final KotlinType getReturnType(@NotNull ResolvedCall<? extends CallableDescriptor> $this$getReturnType) {
        Intrinsics.checkParameterIsNotNull($this$getReturnType, "$this$getReturnType");
        KotlinType kotlinType = TranslationUtils.getReturnTypeForCoercion($this$getReturnType.getResultingDescriptor());
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TranslationUtils.getRetu\u2026cion(resultingDescriptor)");
        return kotlinType;
    }

    @NotNull
    public static final ExplicitReceivers computeExplicitReceiversForInvoke(@NotNull TranslationContext context2, @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall2, @NotNull ExplicitReceivers explicitReceivers) {
        ExplicitReceivers explicitReceivers2;
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(explicitReceivers, "explicitReceivers");
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call2, "resolvedCall.call");
        KtElement ktElement = call2.getCallElement();
        Intrinsics.checkExpressionValueIsNotNull(ktElement, "resolvedCall.call.callElement");
        KtElement callElement = ktElement;
        boolean bl = explicitReceivers.getExtensionReceiver() == null;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CallTranslatorKt$computeExplicitReceiversForInvoke$22 = false;
            String $i$a$-assert-CallTranslatorKt$computeExplicitReceiversForInvoke$22 = "'Invoke' call must have one receiver: " + callElement;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-CallTranslatorKt$computeExplicitReceiversForInvoke$22));
        }
        Function1<ReceiverValue, JsExpression> $fun$translateReceiverAsExpression$2 = new Function1<ReceiverValue, JsExpression>(context2){
            final /* synthetic */ TranslationContext $context;

            @Nullable
            public final JsExpression invoke(@Nullable ReceiverValue receiver) {
                JsExpression jsExpression;
                ReceiverValue receiverValue = receiver;
                if (!(receiverValue instanceof ExpressionReceiver)) {
                    receiverValue = null;
                }
                ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
                if (expressionReceiver != null) {
                    ExpressionReceiver expressionReceiver2 = expressionReceiver;
                    boolean bl = false;
                    boolean bl2 = false;
                    ExpressionReceiver it = expressionReceiver2;
                    boolean bl3 = false;
                    jsExpression = Translation.translateAsExpression(it.getExpression(), this.$context);
                } else {
                    jsExpression = null;
                }
                return jsExpression;
            }
            {
                this.$context = translationContext;
                super(1);
            }
        };
        ReceiverValue dispatchReceiver = resolvedCall2.getDispatchReceiver();
        ReceiverValue extensionReceiver = resolvedCall2.getExtensionReceiver();
        if (dispatchReceiver != null && extensionReceiver != null && resolvedCall2.getExplicitReceiverKind() == ExplicitReceiverKind.BOTH_RECEIVERS) {
            boolean bl3 = explicitReceivers.getExtensionOrDispatchReceiver() != null;
            boolean bl4 = false;
            if (_Assertions.ENABLED && !bl3) {
                boolean $i$a$-assert-CallTranslatorKt$computeExplicitReceiversForInvoke$52 = false;
                String $i$a$-assert-CallTranslatorKt$computeExplicitReceiversForInvoke$52 = "No explicit receiver for 'invoke' resolved call with both receivers: " + callElement + ", text: " + callElement.getText() + "Dispatch receiver: " + dispatchReceiver + " Extension receiver: " + extensionReceiver;
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-CallTranslatorKt$computeExplicitReceiversForInvoke$52));
            }
        } else {
            boolean bl5 = explicitReceivers.getExtensionOrDispatchReceiver() == null;
            boolean bl6 = false;
            if (_Assertions.ENABLED && !bl5) {
                boolean bl7 = false;
                String string2 = "Non trivial explicit receiver " + explicitReceivers.getExtensionOrDispatchReceiver() + '\n' + "for 'invoke' resolved call: " + callElement + ", text: " + callElement.getText() + '\n' + "Dispatch receiver: " + dispatchReceiver + " Extension receiver: " + extensionReceiver;
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
        }
        switch (CallTranslatorKt$WhenMappings.$EnumSwitchMapping$0[resolvedCall2.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                explicitReceivers2 = new ExplicitReceivers(null, null, 2, null);
                break;
            }
            case 2: {
                explicitReceivers2 = new ExplicitReceivers($fun$translateReceiverAsExpression$2.invoke(dispatchReceiver), null, 2, null);
                break;
            }
            case 3: {
                explicitReceivers2 = new ExplicitReceivers($fun$translateReceiverAsExpression$2.invoke(extensionReceiver), null, 2, null);
                break;
            }
            case 4: {
                explicitReceivers2 = new ExplicitReceivers($fun$translateReceiverAsExpression$2.invoke(dispatchReceiver), $fun$translateReceiverAsExpression$2.invoke(extensionReceiver));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return explicitReceivers2;
    }

    public static final /* synthetic */ JsExpression access$translateCall(TranslationContext context2, ResolvedCall resolvedCall2, ExplicitReceivers explicitReceivers) {
        return CallTranslatorKt.translateCall(context2, resolvedCall2, explicitReceivers);
    }
}

