/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.converter;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirPropertyImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirTypeParameterImpl;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirBlockImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirCallWithArgumentList;
import org.jetbrains.kotlin.fir.expressions.impl.FirComponentCallImpl;
import org.jetbrains.kotlin.fir.lightTree.fir.DestructuringDeclaration;
import org.jetbrains.kotlin.fir.lightTree.fir.TypeConstraint;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.psi.stubs.elements.KtConstantExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStringTemplateExpressionElementType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000p\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a,\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0019\u0010\u0015\u001a\u0015\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0016\u00a2\u0006\u0002\b\u0017H\u0086\b\u001a/\u0010\u0018\u001a\u0002H\u0019\"\b\b\u0000\u0010\u0019*\u00020\u001a*\u0002H\u00192\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\u0006\u0010\u001b\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u001c\u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020\u0014\u001a\n\u0010\u001f\u001a\u00020\u0002*\u00020\u001e\u001a\n\u0010 \u001a\u00020\u0011*\u00020\u0014\u001a\u0018\u0010!\u001a\u00020\"*\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0001\u001a\u0016\u0010&\u001a\u00020'*\u0004\u0018\u00010\u001e2\b\b\u0002\u0010(\u001a\u00020\u001e\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006)"}, d2={"expressionSet", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "qualifiedAccessTokens", "Lcom/intellij/psi/tree/TokenSet;", "getQualifiedAccessTokens", "()Lcom/intellij/psi/tree/TokenSet;", "generateDestructuringBlock", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "multiDeclaration", "Lorg/jetbrains/kotlin/fir/lightTree/fir/DestructuringDeclaration;", "container", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "tmpVariable", "", "isClassLocal", "classNode", "Lcom/intellij/lang/LighterASTNode;", "getParent", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "extractArgumentsFrom", "T", "Lorg/jetbrains/kotlin/fir/expressions/impl/FirCallWithArgumentList;", "stubMode", "(Lorg/jetbrains/kotlin/fir/expressions/impl/FirCallWithArgumentList;Ljava/util/List;Z)Lorg/jetbrains/kotlin/fir/expressions/impl/FirCallWithArgumentList;", "getAsStringWithoutBacktick", "", "getOperationSymbol", "isExpression", "joinTypeParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParametersOwner;", "typeConstraints", "Lorg/jetbrains/kotlin/fir/lightTree/fir/TypeConstraint;", "nameAsSafeName", "Lorg/jetbrains/kotlin/name/Name;", "defaultName", "lightTree"})
public final class ConverterUtilKt {
    private static final List<IElementType> expressionSet = CollectionsKt.listOf(KtNodeTypes.REFERENCE_EXPRESSION, KtNodeTypes.DOT_QUALIFIED_EXPRESSION, KtNodeTypes.LAMBDA_EXPRESSION, KtNodeTypes.FUN);
    @NotNull
    private static final TokenSet qualifiedAccessTokens;

    @NotNull
    public static final TokenSet getQualifiedAccessTokens() {
        return qualifiedAccessTokens;
    }

    @NotNull
    public static final Name nameAsSafeName(@Nullable String $this$nameAsSafeName, @NotNull String defaultName) {
        Name name;
        Intrinsics.checkParameterIsNotNull(defaultName, "defaultName");
        if ($this$nameAsSafeName != null) {
            Name name2 = Name.identifier(StringsKt.replace$default($this$nameAsSafeName, "`", "", false, 4, null));
            name = name2;
            Intrinsics.checkExpressionValueIsNotNull(name2, "Name.identifier(this.replace(\"`\", \"\"))");
        } else {
            CharSequence charSequence = defaultName;
            boolean bl = false;
            if (charSequence.length() > 0) {
                Name name3 = Name.identifier(defaultName);
                name = name3;
                Intrinsics.checkExpressionValueIsNotNull(name3, "Name.identifier(defaultName)");
            } else {
                Name name4 = SpecialNames.NO_NAME_PROVIDED;
                name = name4;
                Intrinsics.checkExpressionValueIsNotNull(name4, "SpecialNames.NO_NAME_PROVIDED");
            }
        }
        return name;
    }

    public static /* synthetic */ Name nameAsSafeName$default(String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string3 = "";
        }
        return ConverterUtilKt.nameAsSafeName(string2, string3);
    }

    @NotNull
    public static final IElementType getOperationSymbol(@NotNull String $this$getOperationSymbol) {
        Intrinsics.checkParameterIsNotNull($this$getOperationSymbol, "$this$getOperationSymbol");
        TokenSet tokenSet = KotlinExpressionParsing.ALL_OPERATIONS;
        Intrinsics.checkExpressionValueIsNotNull(tokenSet, "KotlinExpressionParsing.ALL_OPERATIONS");
        IElementType[] iElementTypeArray = tokenSet.getTypes();
        Intrinsics.checkExpressionValueIsNotNull(iElementTypeArray, "KotlinExpressionParsing.ALL_OPERATIONS.types");
        IElementType[] $this$forEach$iv = iElementTypeArray;
        boolean $i$f$forEach = false;
        IElementType[] iElementTypeArray2 = $this$forEach$iv;
        int n = iElementTypeArray2.length;
        for (int i = 0; i < n; ++i) {
            IElementType element$iv;
            IElementType it = element$iv = iElementTypeArray2[i];
            boolean bl = false;
            if (!(it instanceof KtSingleValueToken) || !Intrinsics.areEqual(((KtSingleValueToken)it).getValue(), $this$getOperationSymbol)) continue;
            return it;
        }
        if (Intrinsics.areEqual($this$getOperationSymbol, "as?")) {
            KtToken ktToken = KtTokens.AS_SAFE;
            Intrinsics.checkExpressionValueIsNotNull(ktToken, "KtTokens.AS_SAFE");
            return ktToken;
        }
        KtToken ktToken = KtTokens.IDENTIFIER;
        Intrinsics.checkExpressionValueIsNotNull(ktToken, "KtTokens.IDENTIFIER");
        return ktToken;
    }

    @NotNull
    public static final String getAsStringWithoutBacktick(@NotNull LighterASTNode $this$getAsStringWithoutBacktick) {
        Intrinsics.checkParameterIsNotNull($this$getAsStringWithoutBacktick, "$this$getAsStringWithoutBacktick");
        return StringsKt.replace$default($this$getAsStringWithoutBacktick.toString(), "`", "", false, 4, null);
    }

    public static final boolean isExpression(@NotNull LighterASTNode $this$isExpression) {
        Intrinsics.checkParameterIsNotNull($this$isExpression, "$this$isExpression");
        IElementType iElementType = $this$isExpression.getTokenType();
        return iElementType instanceof KtNodeType || iElementType instanceof KtConstantExpressionElementType || iElementType instanceof KtStringTemplateExpressionElementType || expressionSet.contains(iElementType);
    }

    public static final void joinTypeParameters(@NotNull FirTypeParametersOwner $this$joinTypeParameters, @NotNull List<TypeConstraint> typeConstraints) {
        Intrinsics.checkParameterIsNotNull($this$joinTypeParameters, "$this$joinTypeParameters");
        Intrinsics.checkParameterIsNotNull(typeConstraints, "typeConstraints");
        Iterable $this$forEach$iv = typeConstraints;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TypeConstraint typeConstraint = (TypeConstraint)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = $this$joinTypeParameters.getTypeParameters();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                FirTypeParameter typeParameter = (FirTypeParameter)element$iv2;
                boolean bl2 = false;
                if (Intrinsics.areEqual(typeConstraint.getIdentifier(), typeParameter.getName().getIdentifier())) {
                    FirTypeParameter firTypeParameter = typeParameter;
                    if (firTypeParameter == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.impl.FirTypeParameterImpl");
                    }
                    Collection collection = ((FirTypeParameterImpl)firTypeParameter).getBounds();
                    Object object = typeConstraint.getFirTypeRef();
                    boolean bl3 = false;
                    collection.add(object);
                    collection = ((FirTypeParameterImpl)typeParameter).getAnnotations();
                    object = typeConstraint.getAnnotations();
                    bl3 = false;
                    CollectionsKt.addAll(collection, object);
                }
                FirTypeParameter firTypeParameter = typeParameter;
                if (firTypeParameter == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.impl.FirTypeParameterImpl");
                }
                FirDeclarationUtilKt.addDefaultBoundIfNecessary((FirTypeParameterImpl)firTypeParameter);
            }
        }
    }

    @NotNull
    public static final <T extends FirCallWithArgumentList> T extractArgumentsFrom(@NotNull T $this$extractArgumentsFrom, @NotNull List<? extends FirExpression> container, boolean stubMode) {
        Intrinsics.checkParameterIsNotNull($this$extractArgumentsFrom, "$this$extractArgumentsFrom");
        Intrinsics.checkParameterIsNotNull(container, "container");
        if (!stubMode || $this$extractArgumentsFrom instanceof FirAnnotationCall) {
            Collection collection = $this$extractArgumentsFrom.getArguments();
            boolean bl = false;
            CollectionsKt.addAll(collection, (Iterable)container);
        }
        return $this$extractArgumentsFrom;
    }

    public static final boolean isClassLocal(@NotNull LighterASTNode classNode, @NotNull Function1<? super LighterASTNode, ? extends LighterASTNode> getParent) {
        int $i$f$isClassLocal = 0;
        Intrinsics.checkParameterIsNotNull(classNode, "classNode");
        Intrinsics.checkParameterIsNotNull(getParent, "getParent");
        LighterASTNode currentNode = classNode;
        while (currentNode != null) {
            IElementType tokenType = currentNode.getTokenType();
            LighterASTNode parent2 = getParent.invoke(currentNode);
            if (Intrinsics.areEqual(tokenType, KtNodeTypes.PROPERTY) || Intrinsics.areEqual(tokenType, KtNodeTypes.FUN)) {
                LighterASTNode lighterASTNode = parent2;
                LighterASTNode grandParent = lighterASTNode != null ? getParent.invoke(lighterASTNode) : null;
                LighterASTNode lighterASTNode2 = parent2;
                if (Intrinsics.areEqual(lighterASTNode2 != null ? lighterASTNode2.getTokenType() : null, KtNodeTypes.KT_FILE)) {
                    return true;
                }
                LighterASTNode lighterASTNode3 = parent2;
                if (Intrinsics.areEqual(lighterASTNode3 != null ? lighterASTNode3.getTokenType() : null, KtNodeTypes.CLASS_BODY)) {
                    LighterASTNode lighterASTNode4;
                    LighterASTNode lighterASTNode5 = grandParent;
                    if (!Intrinsics.areEqual(lighterASTNode5 != null ? lighterASTNode5.getTokenType() : null, KtNodeTypes.OBJECT_DECLARATION) || !Intrinsics.areEqual((lighterASTNode4 = grandParent) != null && (lighterASTNode4 = getParent.invoke(lighterASTNode4)) != null ? lighterASTNode4.getTokenType() : null, KtNodeTypes.OBJECT_LITERAL)) {
                        return true;
                    }
                }
                LighterASTNode lighterASTNode6 = parent2;
                if (Intrinsics.areEqual(lighterASTNode6 != null ? lighterASTNode6.getTokenType() : null, KtNodeTypes.BLOCK)) {
                    LighterASTNode lighterASTNode7 = grandParent;
                    if (Intrinsics.areEqual(lighterASTNode7 != null ? lighterASTNode7.getTokenType() : null, KtNodeTypes.SCRIPT)) {
                        return true;
                    }
                }
            }
            if (Intrinsics.areEqual(tokenType, KtNodeTypes.BLOCK)) {
                return true;
            }
            currentNode = parent2;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirExpression generateDestructuringBlock(@NotNull FirSession session, @NotNull DestructuringDeclaration multiDeclaration, @NotNull FirVariable<?> container, boolean tmpVariable) {
        Intrinsics.checkParameterIsNotNull(session, "session");
        Intrinsics.checkParameterIsNotNull(multiDeclaration, "multiDeclaration");
        Intrinsics.checkParameterIsNotNull(container, "container");
        FirBlockImpl firBlockImpl = new FirBlockImpl(null);
        boolean bl = false;
        boolean bl2 = false;
        FirBlockImpl $this$apply = firBlockImpl;
        boolean bl3 = false;
        if (tmpVariable) {
            Collection collection = $this$apply.getStatements();
            FirVariable<?> firVariable = container;
            boolean bl4 = false;
            collection.add(firVariable);
        }
        boolean isVar = multiDeclaration.isVar();
        boolean bl5 = false;
        for (FirVariable entry : (Iterable)multiDeclaration.getEntries()) {
            void index2;
            Collection collection = $this$apply.getStatements();
            FirTypeRef firTypeRef = entry.getReturnTypeRef();
            Name name = entry.getName();
            FirExpression firExpression2 = new FirComponentCallImpl(null, ConversionUtilsKt.generateResolvedAccessExpression(null, container), (int)(index2 + true));
            FirPropertySymbol firPropertySymbol = new FirPropertySymbol(new CallableId(entry.getName()), false, null, 6, null);
            Visibility visibility = Visibilities.LOCAL;
            Intrinsics.checkExpressionValueIsNotNull(visibility, "Visibilities.LOCAL");
            FirPropertyImpl firPropertyImpl = new FirPropertyImpl(null, session, firTypeRef, null, name, firExpression2, null, isVar, firPropertySymbol, true, new FirDeclarationStatusImpl(visibility, Modality.FINAL));
            boolean bl6 = false;
            boolean bl7 = false;
            FirPropertyImpl $this$apply2 = firPropertyImpl;
            boolean bl8 = false;
            Collection collection2 = $this$apply2.getAnnotations();
            Iterable iterable = entry.getAnnotations();
            boolean bl9 = false;
            CollectionsKt.addAll(collection2, iterable);
            $this$apply2.getSymbol().bind((FirSymbolOwner)$this$apply2);
            bl6 = false;
            collection.add(firPropertyImpl);
            ++index2;
        }
        return firBlockImpl;
    }

    static {
        TokenSet tokenSet = TokenSet.create(KtNodeTypes.DOT_QUALIFIED_EXPRESSION, KtNodeTypes.SAFE_ACCESS_EXPRESSION);
        Intrinsics.checkExpressionValueIsNotNull(tokenSet, "TokenSet.create(DOT_QUAL\u2026, SAFE_ACCESS_EXPRESSION)");
        qualifiedAccessTokens = tokenSet;
    }
}

