/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.Configuration;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.ModuleDescriptor;

public final class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static String[] replaceWildcards(String[] confs, ModuleDescriptor md) {
        if (confs == null) {
            return md.getConfigurationsNames();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        LinkedHashSet<String> excluded = new LinkedHashSet<String>();
        for (String conf : confs) {
            if ("*".equals(conf)) {
                result.addAll(Arrays.asList(md.getConfigurationsNames()));
                continue;
            }
            if ("*(public)".equals(conf)) {
                for (Configuration cf : md.getConfigurations()) {
                    if (!Configuration.Visibility.PUBLIC.equals(cf.getVisibility())) continue;
                    result.add(cf.getName());
                }
                continue;
            }
            if ("*(private)".equals(conf)) {
                for (Configuration cf : md.getConfigurations()) {
                    if (!Configuration.Visibility.PRIVATE.equals(cf.getVisibility())) continue;
                    result.add(cf.getName());
                }
                continue;
            }
            if (conf.startsWith("!")) {
                excluded.add(conf.substring(1));
                continue;
            }
            result.add(conf);
        }
        for (String ex : excluded) {
            result.remove(ex);
        }
        return result.toArray(new String[result.size()]);
    }
}

