/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.QualifiedExpressionWithCallSelectorAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.reference.VariableAccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

public final class QualifiedExpressionTranslator {
    private QualifiedExpressionTranslator() {
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull KtQualifiedExpression expression2, @NotNull TranslationContext context, boolean forceOrderOfEvaluation) {
        KtExpression selector;
        if (expression2 == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$1(0);
        }
        if (context == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$1(1);
        }
        if (expression2 == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$0(1);
        }
        JsExpression receiver2 = QualifiedExpressionTranslator.translateReceiver(expression2, context);
        if (forceOrderOfEvaluation && receiver2 != null) {
            receiver2 = context.defineTemporary(receiver2);
        }
        if ((selector = PsiUtils.getSelector(expression2)) instanceof KtSimpleNameExpression) {
            VariableAccessTranslator variableAccessTranslator = VariableAccessTranslator.newInstance(context, (KtSimpleNameExpression)selector, receiver2);
            if (variableAccessTranslator == null) {
                QualifiedExpressionTranslator.$$$reportNull$$$0(2);
            }
            if (variableAccessTranslator == null) {
                QualifiedExpressionTranslator.$$$reportNull$$$1(2);
            }
            return variableAccessTranslator;
        }
        if (selector instanceof KtCallExpression) {
            QualifiedExpressionWithCallSelectorAccessTranslator qualifiedExpressionWithCallSelectorAccessTranslator = new QualifiedExpressionWithCallSelectorAccessTranslator((KtCallExpression)selector, receiver2, context);
            if (qualifiedExpressionWithCallSelectorAccessTranslator == null) {
                QualifiedExpressionTranslator.$$$reportNull$$$0(3);
            }
            if (qualifiedExpressionWithCallSelectorAccessTranslator == null) {
                QualifiedExpressionTranslator.$$$reportNull$$$1(3);
            }
            return qualifiedExpressionWithCallSelectorAccessTranslator;
        }
        throw new AssertionError((Object)("Unexpected qualified expression: " + expression2.getText()));
    }

    @NotNull
    public static JsNode translateQualifiedExpression(@NotNull KtQualifiedExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$1(4);
        }
        if (context == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$1(5);
        }
        if (expression2 == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$0(4);
        }
        if (context == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$0(5);
        }
        ResolvedCall<? extends CallableDescriptor> call2 = CallUtilKt.getResolvedCall(expression2, context.bindingContext());
        JsExpression receiver2 = null;
        if (call2 != null) {
            receiver2 = QualifiedExpressionTranslator.translateReceiver(expression2, context);
        }
        KtExpression selector = PsiUtils.getSelector(expression2);
        JsNode jsNode = QualifiedExpressionTranslator.dispatchToCorrectTranslator(receiver2, selector, context);
        if (jsNode == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$0(6);
        }
        if (jsNode == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$1(6);
        }
        return jsNode;
    }

    @NotNull
    private static JsNode dispatchToCorrectTranslator(@Nullable JsExpression receiver2, @NotNull KtExpression selector, @NotNull TranslationContext context) {
        if (selector == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$1(7);
        }
        if (context == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$1(8);
        }
        if (selector == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$0(7);
        }
        if (context == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$0(8);
        }
        if (ReferenceTranslator.canBePropertyAccess(selector, context)) {
            assert (selector instanceof KtSimpleNameExpression) : "Selectors for properties must be simple names.";
            JsExpression jsExpression = VariableAccessTranslator.newInstance(context, (KtSimpleNameExpression)selector, receiver2).translateAsGet();
            if (jsExpression == null) {
                QualifiedExpressionTranslator.$$$reportNull$$$0(9);
            }
            if (jsExpression == null) {
                QualifiedExpressionTranslator.$$$reportNull$$$1(9);
            }
            return jsExpression;
        }
        if (selector instanceof KtCallExpression) {
            JsNode jsNode = QualifiedExpressionTranslator.invokeCallExpressionTranslator(receiver2, (KtCallExpression)selector, context);
            if (jsNode == null) {
                QualifiedExpressionTranslator.$$$reportNull$$$0(10);
            }
            if (jsNode == null) {
                QualifiedExpressionTranslator.$$$reportNull$$$1(10);
            }
            return jsNode;
        }
        if (selector instanceof KtSimpleNameExpression) {
            JsExpression jsExpression = ReferenceTranslator.translateSimpleName((KtSimpleNameExpression)selector, context);
            if (jsExpression == null) {
                QualifiedExpressionTranslator.$$$reportNull$$$0(11);
            }
            if (jsExpression == null) {
                QualifiedExpressionTranslator.$$$reportNull$$$1(11);
            }
            return jsExpression;
        }
        throw new AssertionError((Object)("Unexpected qualified expression: " + selector.getText()));
    }

    @NotNull
    static JsNode invokeCallExpressionTranslator(@Nullable JsExpression receiver2, @NotNull KtCallExpression selector, @NotNull TranslationContext context) {
        JsNode jsNode;
        if (selector == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$1(12);
        }
        if (context == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$1(13);
        }
        if (selector == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$0(12);
        }
        if (context == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$0(13);
        }
        try {
            jsNode = CallExpressionTranslator.translate(selector, receiver2, context);
        }
        catch (RuntimeException e) {
            throw ErrorReportingUtils.reportErrorWithLocation(selector, e);
        }
        if (jsNode == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$0(14);
        }
        if (jsNode == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$1(14);
        }
        return jsNode;
    }

    @Nullable
    private static JsExpression translateReceiver(@NotNull KtQualifiedExpression expression2, @NotNull TranslationContext context) {
        KtExpression receiverExpression;
        if (expression2 == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$1(15);
        }
        if (context == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$1(16);
        }
        if (expression2 == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$0(15);
        }
        if (context == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$0(16);
        }
        if (QualifiedExpressionTranslator.isFullQualifierForExpression(receiverExpression = expression2.getReceiverExpression(), context)) {
            return null;
        }
        return Translation.translateAsExpression(receiverExpression, context);
    }

    private static boolean isFullQualifierForExpression(@Nullable KtExpression receiverExpression, @NotNull TranslationContext context) {
        DeclarationDescriptor descriptorForReferenceExpression;
        if (context == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$1(17);
        }
        if (context == null) {
            QualifiedExpressionTranslator.$$$reportNull$$$0(17);
        }
        if (receiverExpression == null) {
            return false;
        }
        if (receiverExpression instanceof KtReferenceExpression && (descriptorForReferenceExpression = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), (KtReferenceExpression)receiverExpression)) instanceof PackageViewDescriptor) {
            return true;
        }
        if (receiverExpression instanceof KtQualifiedExpression) {
            return QualifiedExpressionTranslator.isFullQualifierForExpression(((KtQualifiedExpression)receiverExpression).getSelectorExpression(), context);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessTranslator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "translateQualifiedExpression";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "dispatchToCorrectTranslator";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeCallExpressionTranslator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAccessTranslator";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "translateQualifiedExpression";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dispatchToCorrectTranslator";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invokeCallExpressionTranslator";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "translateReceiver";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isFullQualifierForExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessTranslator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "translateQualifiedExpression";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "dispatchToCorrectTranslator";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeCallExpressionTranslator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAccessTranslator";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "translateQualifiedExpression";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dispatchToCorrectTranslator";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invokeCallExpressionTranslator";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "translateReceiver";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isFullQualifierForExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

