/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import gnu.trove.TObjectIntHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassUtil {
    private ClassUtil() {
    }

    public static String extractPackageName(String className2) {
        if (className2 != null) {
            int i = className2.lastIndexOf(46);
            return i == -1 ? "" : className2.substring(0, i);
        }
        return null;
    }

    @NotNull
    public static String extractClassName(@NotNull String fqName2) {
        int i;
        if (fqName2 == null) {
            ClassUtil.$$$reportNull$$$0(0);
        }
        String string = (i = fqName2.lastIndexOf(46)) == -1 ? fqName2 : fqName2.substring(i + 1);
        if (string == null) {
            ClassUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static String createNewClassQualifiedName(String qualifiedName, String className2) {
        if (className2 == null) {
            return null;
        }
        if (qualifiedName == null || qualifiedName.isEmpty()) {
            return className2;
        }
        return qualifiedName + "." + ClassUtil.extractClassName(className2);
    }

    public static PsiDirectory sourceRoot(PsiDirectory containingDirectory) {
        while (containingDirectory != null) {
            if (JavaDirectoryService.getInstance().isSourceRoot(containingDirectory)) {
                return containingDirectory;
            }
            containingDirectory = containingDirectory.getParentDirectory();
        }
        return null;
    }

    public static void formatClassName(@NotNull PsiClass aClass2, @NotNull StringBuilder buf) {
        String qName;
        if (aClass2 == null) {
            ClassUtil.$$$reportNull$$$0(2);
        }
        if (buf == null) {
            ClassUtil.$$$reportNull$$$0(3);
        }
        if ((qName = aClass2.getQualifiedName()) != null) {
            buf.append(qName);
        } else {
            PsiClass parentClass = PsiTreeUtil.getContextOfType((PsiElement)aClass2, PsiClass.class, true);
            if (parentClass != null) {
                ClassUtil.formatClassName(parentClass, buf);
                buf.append("$");
                buf.append(ClassUtil.getNonQualifiedClassIdx(aClass2, parentClass));
                String name = aClass2.getName();
                if (name != null) {
                    buf.append(name);
                }
            }
        }
    }

    private static int getNonQualifiedClassIdx(@NotNull PsiClass psiClass, @NotNull PsiClass containingClass) {
        if (psiClass == null) {
            ClassUtil.$$$reportNull$$$0(4);
        }
        if (containingClass == null) {
            ClassUtil.$$$reportNull$$$0(5);
        }
        TObjectIntHashMap indices = (TObjectIntHashMap)CachedValuesManager.getCachedValue(containingClass, () -> {
            if (containingClass == null) {
                ClassUtil.$$$reportNull$$$0(25);
            }
            TObjectIntHashMap<PsiClass> map2 = new TObjectIntHashMap<PsiClass>();
            int index2 = 0;
            for (PsiClass aClass2 : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot(containingClass)).postOrderDfsTraversal().filter(PsiClass.class)) {
                if (aClass2.getQualifiedName() != null) continue;
                map2.put(aClass2, ++index2);
            }
            return CachedValueProvider.Result.create(map2, containingClass);
        });
        return indices.get(psiClass);
    }

    public static PsiClass findNonQualifiedClassByIndex(@NotNull String indexName, @NotNull PsiClass containingClass) {
        if (indexName == null) {
            ClassUtil.$$$reportNull$$$0(6);
        }
        if (containingClass == null) {
            ClassUtil.$$$reportNull$$$0(7);
        }
        return ClassUtil.findNonQualifiedClassByIndex(indexName, containingClass, false);
    }

    public static PsiClass findNonQualifiedClassByIndex(@NotNull String indexName, final @NotNull PsiClass containingClass, final boolean jvmCompatible) {
        String prefix;
        if (indexName == null) {
            ClassUtil.$$$reportNull$$$0(8);
        }
        if (containingClass == null) {
            ClassUtil.$$$reportNull$$$0(9);
        }
        final int idx = !(prefix = ClassUtil.getDigitPrefix(indexName)).isEmpty() ? Integer.parseInt(prefix) : -1;
        final String name = prefix.length() < indexName.length() ? indexName.substring(prefix.length()) : null;
        final PsiClass[] result2 = new PsiClass[1];
        containingClass.accept(new JavaRecursiveElementVisitor(){
            private int myCurrentIdx;

            @Override
            public void visitElement(PsiElement element) {
                if (result2[0] == null) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitClass(PsiClass aClass2) {
                if (!jvmCompatible) {
                    super.visitClass(aClass2);
                    if (aClass2.getQualifiedName() == null) {
                        ++this.myCurrentIdx;
                        if (this.myCurrentIdx == idx && Comparing.strEqual(name, aClass2.getName())) {
                            result2[0] = aClass2;
                        }
                    }
                    return;
                }
                if (aClass2 == containingClass) {
                    super.visitClass(aClass2);
                    return;
                }
                if (Comparing.strEqual(name, aClass2.getName())) {
                    ++this.myCurrentIdx;
                    if (this.myCurrentIdx == idx || idx == -1) {
                        result2[0] = aClass2;
                    }
                }
            }

            @Override
            public void visitTypeParameter(PsiTypeParameter classParameter) {
                if (!jvmCompatible) {
                    super.visitTypeParameter(classParameter);
                } else {
                    this.visitElement(classParameter);
                }
            }
        });
        return result2[0];
    }

    @NotNull
    private static String getDigitPrefix(@NotNull String indexName) {
        char c;
        int i;
        if (indexName == null) {
            ClassUtil.$$$reportNull$$$0(10);
        }
        for (i = 0; i < indexName.length() && Character.isDigit(c = indexName.charAt(i)); ++i) {
        }
        String string = i == 0 ? "" : indexName.substring(0, i);
        if (string == null) {
            ClassUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name) {
        if (manager == null) {
            ClassUtil.$$$reportNull$$$0(12);
        }
        if (name == null) {
            ClassUtil.$$$reportNull$$$0(13);
        }
        return ClassUtil.findPsiClass(manager, name, null, false);
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name, @Nullable PsiClass parent2, boolean jvmCompatible) {
        if (manager == null) {
            ClassUtil.$$$reportNull$$$0(14);
        }
        if (name == null) {
            ClassUtil.$$$reportNull$$$0(15);
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope(manager.getProject());
        return ClassUtil.findPsiClass(manager, name, parent2, jvmCompatible, scope);
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name, @Nullable PsiClass parent2, boolean jvmCompatible, @NotNull GlobalSearchScope scope) {
        if (manager == null) {
            ClassUtil.$$$reportNull$$$0(16);
        }
        if (name == null) {
            ClassUtil.$$$reportNull$$$0(17);
        }
        if (scope == null) {
            ClassUtil.$$$reportNull$$$0(18);
        }
        if (parent2 != null) {
            return ClassUtil.findSubClass(name, parent2, jvmCompatible);
        }
        PsiClass result2 = JavaPsiFacade.getInstance(manager.getProject()).findClass(name, scope);
        if (result2 != null) {
            return result2;
        }
        int p = 0;
        while ((p = name.indexOf(36, p + 1)) > 0 && p < name.length() - 1) {
            String suffix;
            String prefix = name.substring(0, p);
            parent2 = JavaPsiFacade.getInstance(manager.getProject()).findClass(prefix, scope);
            if (parent2 == null || (result2 = ClassUtil.findSubClass(suffix = name.substring(p + 1), parent2, jvmCompatible)) == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    private static PsiClass findSubClass(@NotNull String name, @NotNull PsiClass parent2, boolean jvmCompatible) {
        PsiClass result2;
        if (name == null) {
            ClassUtil.$$$reportNull$$$0(19);
        }
        if (parent2 == null) {
            ClassUtil.$$$reportNull$$$0(20);
        }
        PsiClass psiClass = result2 = ClassUtil.isIndexed(name) ? ClassUtil.findNonQualifiedClassByIndex(name, parent2, jvmCompatible) : parent2.findInnerClassByName(name, false);
        if (result2 != null) {
            return result2;
        }
        int p = 0;
        while ((p = name.indexOf(36, p + 1)) > 0 && p < name.length() - 1) {
            String suffix;
            String prefix = name.substring(0, p);
            PsiClass subClass = ClassUtil.isIndexed(prefix) ? ClassUtil.findNonQualifiedClassByIndex(prefix, parent2, jvmCompatible) : parent2.findInnerClassByName(prefix, false);
            if (subClass == null || (result2 = ClassUtil.findSubClass(suffix = name.substring(p + 1), subClass, jvmCompatible)) == null) continue;
            return result2;
        }
        return null;
    }

    private static boolean isIndexed(String name) {
        return Character.isDigit(name.charAt(0));
    }

    @Nullable
    public static String getJVMClassName(@NotNull PsiClass aClass2) {
        PsiClass containingClass;
        if (aClass2 == null) {
            ClassUtil.$$$reportNull$$$0(21);
        }
        if ((containingClass = aClass2.getContainingClass()) != null) {
            String parentName = ClassUtil.getJVMClassName(containingClass);
            if (parentName == null) {
                return null;
            }
            return parentName + "$" + aClass2.getName();
        }
        return aClass2.getQualifiedName();
    }

    @Nullable
    public static PsiClass findPsiClassByJVMName(@NotNull PsiManager manager, @NotNull String jvmClassName) {
        if (manager == null) {
            ClassUtil.$$$reportNull$$$0(22);
        }
        if (jvmClassName == null) {
            ClassUtil.$$$reportNull$$$0(23);
        }
        return ClassUtil.findPsiClass(manager, jvmClassName.replace('/', '.'), null, true);
    }

    public static boolean isTopLevelClass(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            ClassUtil.$$$reportNull$$$0(24);
        }
        if (aClass2.getContainingClass() != null) {
            return false;
        }
        if (aClass2 instanceof PsiAnonymousClass) {
            return false;
        }
        PsiElement parent2 = aClass2.getParent();
        if (parent2 instanceof PsiDeclarationStatement && parent2.getParent() instanceof PsiCodeBlock) {
            return false;
        }
        PsiFile parentFile = aClass2.getContainingFile();
        return parentFile != null && parentFile.getLanguage() == JavaLanguage.INSTANCE;
    }

    public static String getVMParametersMethodSignature(PsiMethod method) {
        return StringUtil.join(method.getParameterList().getParameters(), param -> {
            PsiType type2 = TypeConversionUtil.erasure(param.getType());
            return type2 != null ? type2.accept(ClassUtil.createSignatureVisitor()) : "";
        }, ",");
    }

    private static PsiTypeVisitor<String> createSignatureVisitor() {
        return new PsiTypeVisitor<String>(){

            @Override
            public String visitPrimitiveType(PsiPrimitiveType primitiveType) {
                return primitiveType.getCanonicalText();
            }

            @Override
            public String visitClassType(PsiClassType classType) {
                PsiClass aClass2 = classType.resolve();
                if (aClass2 == null) {
                    return "";
                }
                return ClassUtil.getJVMClassName(aClass2);
            }

            @Override
            public String visitArrayType(PsiArrayType arrayType) {
                PsiType componentType = arrayType.getComponentType();
                String typePresentation = componentType.accept(this);
                if (componentType instanceof PsiClassType) {
                    typePresentation = "L" + typePresentation + ";";
                }
                return "[" + typePresentation;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/ClassUtil";
                break;
            }
            case 2: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/ClassUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractClassName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDigitPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractClassName";
                break;
            }
            case 1: 
            case 11: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "formatClassName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNonQualifiedClassIdx";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findNonQualifiedClassByIndex";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDigitPrefix";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findPsiClass";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findSubClass";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getJVMClassName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findPsiClassByJVMName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelClass";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getNonQualifiedClassIdx$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

