/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.serialization;

import com.intellij.openapi.util.Pair;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.FakeDescriptorsForReferencesKt;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.serialization.JvmCodegenStringTable;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.load.java.lazy.types.RawTypeImpl;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ClassMapperLite;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.protobuf.GeneratedMessageLite;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.AnnotationSerializer;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.SerializerExtension;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class JvmSerializerExtension
extends SerializerExtension {
    private final JvmSerializationBindings bindings;
    private final BindingContext codegenBinding;
    private final KotlinTypeMapper typeMapper;
    private final JvmCodegenStringTable stringTable;
    private final AnnotationSerializer annotationSerializer;
    private final boolean useTypeTable;
    private final String moduleName;
    private final ClassBuilderMode classBuilderMode;
    private final boolean isReleaseCoroutines;

    public JvmSerializerExtension(@NotNull JvmSerializationBindings bindings, @NotNull GenerationState state2) {
        this.bindings = bindings;
        this.codegenBinding = state2.getBindingContext();
        this.typeMapper = state2.getTypeMapper();
        this.stringTable = new JvmCodegenStringTable(this.typeMapper);
        this.annotationSerializer = new AnnotationSerializer(this.stringTable);
        this.useTypeTable = state2.getUseTypeTableInSerializer();
        this.moduleName = state2.getModuleName();
        this.classBuilderMode = state2.getClassBuilderMode();
        this.isReleaseCoroutines = state2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ReleaseCoroutines);
    }

    @Override
    @NotNull
    public JvmCodegenStringTable getStringTable() {
        return this.stringTable;
    }

    @Override
    public boolean shouldUseTypeTable() {
        return this.useTypeTable;
    }

    @Override
    public void serializeClass(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.Class.Builder proto) {
        if (!this.moduleName.equals("main")) {
            proto.setExtension(JvmProtoBuf.classModuleName, this.stringTable.getStringIndex(this.moduleName));
        }
        Type containerAsmType = DescriptorUtils.isInterface(descriptor2) ? this.typeMapper.mapDefaultImpls(descriptor2) : this.typeMapper.mapClass(descriptor2);
        this.writeLocalProperties(proto, containerAsmType, JvmProtoBuf.classLocalVariable);
    }

    @Override
    public void serializePackage(@NotNull FqName packageFqName, @NotNull ProtoBuf.Package.Builder proto) {
        if (!this.moduleName.equals("main")) {
            proto.setExtension(JvmProtoBuf.packageModuleName, this.stringTable.getStringIndex(this.moduleName));
        }
    }

    public void serializeJvmPackage(@NotNull ProtoBuf.Package.Builder proto, @NotNull Type partAsmType) {
        this.writeLocalProperties(proto, partAsmType, JvmProtoBuf.packageLocalVariable);
    }

    private <MessageType extends GeneratedMessageLite.ExtendableMessage<MessageType>, BuilderType extends GeneratedMessageLite.ExtendableBuilder<MessageType, BuilderType>> void writeLocalProperties(@NotNull BuilderType proto, @NotNull Type classAsmType, @NotNull GeneratedMessageLite.GeneratedExtension<MessageType, List<ProtoBuf.Property>> extension) {
        List<LocalVariableDescriptor> localVariables = CodegenBinding.getLocalDelegatedProperties(this.codegenBinding, classAsmType);
        if (localVariables == null) {
            return;
        }
        for (LocalVariableDescriptor localVariable : localVariables) {
            PropertyDescriptor propertyDescriptor = FakeDescriptorsForReferencesKt.createFreeFakeLocalPropertyDescriptor(localVariable);
            DescriptorSerializer serializer = DescriptorSerializer.createForLambda(this);
            proto.addExtension(extension, (ProtoBuf.Property)serializer.propertyProto(propertyDescriptor).build());
        }
    }

    @Override
    public void serializeFlexibleType(@NotNull FlexibleType flexibleType, @NotNull ProtoBuf.Type.Builder lowerProto, @NotNull ProtoBuf.Type.Builder upperProto) {
        lowerProto.setFlexibleTypeCapabilitiesId(this.getStringTable().getStringIndex("kotlin.jvm.PlatformType"));
        if (flexibleType instanceof RawTypeImpl) {
            lowerProto.setExtension(JvmProtoBuf.isRaw, true);
            upperProto.setExtension(JvmProtoBuf.isRaw, true);
        }
    }

    @Override
    public void serializeType(@NotNull KotlinType type2, @NotNull ProtoBuf.Type.Builder proto) {
        for (AnnotationDescriptor annotation2 : DescriptorUtilsKt.getNonSourceAnnotations(type2)) {
            proto.addExtension(JvmProtoBuf.typeAnnotation, this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeTypeParameter(@NotNull TypeParameterDescriptor typeParameter, @NotNull ProtoBuf.TypeParameter.Builder proto) {
        for (AnnotationDescriptor annotation2 : DescriptorUtilsKt.getNonSourceAnnotations(typeParameter)) {
            proto.addExtension(JvmProtoBuf.typeParameterAnnotation, this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeConstructor(@NotNull ConstructorDescriptor descriptor2, @NotNull ProtoBuf.Constructor.Builder proto) {
        JvmProtoBuf.JvmMethodSignature signature;
        Method method = this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, descriptor2);
        if (method != null && (signature = new SignatureSerializer().methodSignature(descriptor2, method)) != null) {
            proto.setExtension(JvmProtoBuf.constructorSignature, signature);
        }
    }

    @Override
    public void serializeFunction(@NotNull FunctionDescriptor descriptor2, @NotNull ProtoBuf.Function.Builder proto) {
        JvmProtoBuf.JvmMethodSignature signature;
        Method method = this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, descriptor2);
        if (method != null && (signature = new SignatureSerializer().methodSignature(descriptor2, method)) != null) {
            proto.setExtension(JvmProtoBuf.methodSignature, signature);
        }
    }

    @Override
    public void serializeProperty(@NotNull PropertyDescriptor descriptor2, @NotNull ProtoBuf.Property.Builder proto) {
        SignatureSerializer signatureSerializer = new SignatureSerializer();
        PropertyGetterDescriptor getter2 = descriptor2.getGetter();
        PropertySetterDescriptor setter2 = descriptor2.getSetter();
        Method getterMethod = getter2 == null ? null : this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, getter2);
        Method setterMethod = setter2 == null ? null : this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, setter2);
        Pair<Type, String> field = this.bindings.get(JvmSerializationBindings.FIELD_FOR_PROPERTY, descriptor2);
        Method syntheticMethod = this.bindings.get(JvmSerializationBindings.SYNTHETIC_METHOD_FOR_PROPERTY, descriptor2);
        JvmProtoBuf.JvmPropertySignature signature = signatureSerializer.propertySignature(descriptor2, field != null ? (String)field.second : null, field != null ? ((Type)field.first).getDescriptor() : null, syntheticMethod != null ? signatureSerializer.methodSignature(null, syntheticMethod) : null, getterMethod != null ? signatureSerializer.methodSignature(null, getterMethod) : null, setterMethod != null ? signatureSerializer.methodSignature(null, setterMethod) : null);
        proto.setExtension(JvmProtoBuf.propertySignature, signature);
    }

    @Override
    public void serializeErrorType(@NotNull KotlinType type2, @NotNull ProtoBuf.Type.Builder builder) {
        if (this.classBuilderMode == ClassBuilderMode.KAPT3) {
            builder.setClassName(this.stringTable.getStringIndex("error/NonExistentClass"));
            return;
        }
        super.serializeErrorType(type2, builder);
    }

    @Override
    public boolean releaseCoroutines() {
        return this.isReleaseCoroutines;
    }

    private class SignatureSerializer {
        private SignatureSerializer() {
        }

        @Nullable
        public JvmProtoBuf.JvmMethodSignature methodSignature(@Nullable FunctionDescriptor descriptor2, @NotNull Method method) {
            JvmProtoBuf.JvmMethodSignature.Builder builder = JvmProtoBuf.JvmMethodSignature.newBuilder();
            if (descriptor2 == null || !descriptor2.getName().asString().equals(method.getName())) {
                builder.setName(JvmSerializerExtension.this.stringTable.getStringIndex(method.getName()));
            }
            if (descriptor2 == null || this.requiresSignature(descriptor2, method.getDescriptor())) {
                builder.setDesc(JvmSerializerExtension.this.stringTable.getStringIndex(method.getDescriptor()));
            }
            return builder.hasName() || builder.hasDesc() ? builder.build() : null;
        }

        private boolean requiresSignature(@NotNull FunctionDescriptor descriptor2, @NotNull String desc) {
            String returnTypeDesc;
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
            if (receiverParameter != null) {
                String receiverDesc = this.mapTypeDefault(receiverParameter.getValue().getType());
                if (receiverDesc == null) {
                    return true;
                }
                sb.append(receiverDesc);
            }
            for (ValueParameterDescriptor valueParameter : descriptor2.getValueParameters()) {
                String paramDesc = this.mapTypeDefault(valueParameter.getType());
                if (paramDesc == null) {
                    return true;
                }
                sb.append(paramDesc);
            }
            sb.append(")");
            KotlinType returnType = descriptor2.getReturnType();
            String string = returnTypeDesc = returnType == null ? "V" : this.mapTypeDefault(returnType);
            if (returnTypeDesc == null) {
                return true;
            }
            sb.append(returnTypeDesc);
            return !sb.toString().equals(desc);
        }

        private boolean requiresSignature(@NotNull PropertyDescriptor descriptor2, @NotNull String desc) {
            return !desc.equals(this.mapTypeDefault(descriptor2.getType()));
        }

        @Nullable
        private String mapTypeDefault(@NotNull KotlinType type2) {
            ClassifierDescriptor classifier2 = type2.getConstructor().getDeclarationDescriptor();
            if (!(classifier2 instanceof ClassDescriptor)) {
                return null;
            }
            ClassId classId = DescriptorUtilsKt.getClassId((ClassDescriptor)classifier2);
            return classId == null ? null : ClassMapperLite.mapClass(classId.asString());
        }

        @NotNull
        public JvmProtoBuf.JvmPropertySignature propertySignature(@NotNull PropertyDescriptor descriptor2, @Nullable String fieldName, @Nullable String fieldDesc, @Nullable JvmProtoBuf.JvmMethodSignature syntheticMethod, @Nullable JvmProtoBuf.JvmMethodSignature getter2, @Nullable JvmProtoBuf.JvmMethodSignature setter2) {
            JvmProtoBuf.JvmPropertySignature.Builder signature = JvmProtoBuf.JvmPropertySignature.newBuilder();
            if (fieldDesc != null) {
                assert (fieldName != null) : "Field name shouldn't be null when there's a field type: " + fieldDesc;
                signature.setField(this.fieldSignature(descriptor2, fieldName, fieldDesc));
            }
            if (syntheticMethod != null) {
                signature.setSyntheticMethod(syntheticMethod);
            }
            if (getter2 != null) {
                signature.setGetter(getter2);
            }
            if (setter2 != null) {
                signature.setSetter(setter2);
            }
            return signature.build();
        }

        @NotNull
        public JvmProtoBuf.JvmFieldSignature fieldSignature(@NotNull PropertyDescriptor descriptor2, @NotNull String name, @NotNull String desc) {
            JvmProtoBuf.JvmFieldSignature.Builder builder = JvmProtoBuf.JvmFieldSignature.newBuilder();
            if (!descriptor2.getName().asString().equals(name)) {
                builder.setName(JvmSerializerExtension.this.stringTable.getStringIndex(name));
            }
            if (this.requiresSignature(descriptor2, desc)) {
                builder.setDesc(JvmSerializerExtension.this.stringTable.getStringIndex(desc));
            }
            return builder.build();
        }
    }
}

