/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.java.stubs.JavaClassElementType;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.BitUtil;
import org.jetbrains.annotations.Nullable;

public class PsiClassStubImpl<T extends PsiClass>
extends StubBase<T>
implements PsiClassStub<T> {
    private final String myQualifiedName;
    private final String myName;
    private final String myBaseRefText;
    private final short myFlags;
    private String mySourceFileName;

    public PsiClassStubImpl(JavaClassElementType type2, StubElement parent2, @Nullable String qualifiedName, @Nullable String name, @Nullable String baseRefText, short flags) {
        super(parent2, type2);
        this.myQualifiedName = qualifiedName;
        this.myName = name;
        this.myBaseRefText = baseRefText;
        this.myFlags = flags;
        if (StubBasedPsiElementBase.ourTraceStubAstBinding) {
            String creationTrace = "Stub creation thread: " + Thread.currentThread() + "\n" + DebugUtil.currentStackTrace();
            this.putUserData(StubBasedPsiElementBase.CREATION_TRACE, creationTrace);
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String getQualifiedName() {
        return this.myQualifiedName;
    }

    @Override
    public String getBaseClassReferenceText() {
        return this.myBaseRefText;
    }

    @Override
    public boolean isDeprecated() {
        return BitUtil.isSet(this.myFlags, 1);
    }

    @Override
    public boolean hasDeprecatedAnnotation() {
        return BitUtil.isSet(this.myFlags, 128);
    }

    @Override
    public boolean isInterface() {
        return BitUtil.isSet(this.myFlags, 2);
    }

    @Override
    public boolean isEnum() {
        return BitUtil.isSet(this.myFlags, 4);
    }

    @Override
    public boolean isEnumConstantInitializer() {
        return PsiClassStubImpl.isEnumConstInitializer(this.myFlags);
    }

    public static boolean isEnumConstInitializer(short flags) {
        return BitUtil.isSet(flags, 8);
    }

    @Override
    public boolean isAnonymous() {
        return PsiClassStubImpl.isAnonymous(this.myFlags);
    }

    public static boolean isAnonymous(short flags) {
        return BitUtil.isSet(flags, 16);
    }

    @Override
    public boolean isAnnotationType() {
        return BitUtil.isSet(this.myFlags, 32);
    }

    @Override
    public LanguageLevel getLanguageLevel() {
        LanguageLevel level;
        StubElement parent2 = this.getParentStub();
        if (parent2 instanceof PsiJavaFileStub && (level = ((PsiJavaFileStub)parent2).getLanguageLevel()) != null) {
            return level;
        }
        return LanguageLevel.HIGHEST;
    }

    @Override
    public String getSourceFileName() {
        return this.mySourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.mySourceFileName = sourceFileName;
    }

    @Override
    public boolean isAnonymousInQualifiedNew() {
        return BitUtil.isSet(this.myFlags, 64);
    }

    public short getFlags() {
        return this.myFlags;
    }

    public static short packFlags(boolean isDeprecated, boolean isInterface, boolean isEnum, boolean isEnumConstantInitializer, boolean isAnonymous, boolean isAnnotationType, boolean isInQualifiedNew, boolean hasDeprecatedAnnotation, boolean anonymousInner, boolean localClassInner) {
        short flags = 0;
        if (isDeprecated) {
            flags = (short)(flags | 1);
        }
        if (isInterface) {
            flags = (short)(flags | 2);
        }
        if (isEnum) {
            flags = (short)(flags | 4);
        }
        if (isEnumConstantInitializer) {
            flags = (short)(flags | 8);
        }
        if (isAnonymous) {
            flags = (short)(flags | 0x10);
        }
        if (isAnnotationType) {
            flags = (short)(flags | 0x20);
        }
        if (isInQualifiedNew) {
            flags = (short)(flags | 0x40);
        }
        if (hasDeprecatedAnnotation) {
            flags = (short)(flags | 0x80);
        }
        if (anonymousInner) {
            flags = (short)(flags | 0x100);
        }
        if (localClassInner) {
            flags = (short)(flags | 0x200);
        }
        return flags;
    }

    public boolean isAnonymousInner() {
        return BitUtil.isSet(this.myFlags, 256);
    }

    public boolean isLocalClassInner() {
        return BitUtil.isSet(this.myFlags, 512);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiClassStub[");
        if (this.isInterface()) {
            builder.append("interface ");
        }
        if (this.isAnonymous()) {
            builder.append("anonymous ");
        }
        if (this.isEnum()) {
            builder.append("enum ");
        }
        if (this.isAnnotationType()) {
            builder.append("annotation ");
        }
        if (this.isEnumConstantInitializer()) {
            builder.append("enumInit ");
        }
        if (this.isDeprecated()) {
            builder.append("deprecated ");
        }
        if (this.hasDeprecatedAnnotation()) {
            builder.append("deprecatedA ");
        }
        builder.append("name=").append(this.getName()).append(" fqn=").append(this.getQualifiedName());
        if (this.getBaseClassReferenceText() != null) {
            builder.append(" baseref=").append(this.getBaseClassReferenceText());
        }
        if (this.isAnonymousInQualifiedNew()) {
            builder.append(" inqualifnew");
        }
        if (this.isAnonymousInner()) {
            builder.append(" jvmAnonymousInner");
        }
        if (this.isLocalClassInner()) {
            builder.append(" jvmLocalClassInner");
        }
        builder.append("]");
        return builder.toString();
    }
}

