/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureBase;
import com.intellij.psi.util.MethodSignatureHandMade;
import com.intellij.psi.util.TypeConversionUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodSignatureUtil {
    public static final TObjectHashingStrategy<MethodSignatureBackedByPsiMethod> METHOD_BASED_HASHING_STRATEGY = new TObjectHashingStrategy<MethodSignatureBackedByPsiMethod>(){

        @Override
        public int computeHashCode(MethodSignatureBackedByPsiMethod signature) {
            return signature.getMethod().hashCode();
        }

        @Override
        public boolean equals(MethodSignatureBackedByPsiMethod s1, MethodSignatureBackedByPsiMethod s2) {
            return s1.getMethod().equals(s2.getMethod());
        }
    };
    public static final TObjectHashingStrategy<MethodSignature> METHOD_PARAMETERS_ERASURE_EQUALITY = new TObjectHashingStrategy<MethodSignature>(){

        @Override
        public int computeHashCode(MethodSignature signature) {
            return signature.hashCode();
        }

        @Override
        public boolean equals(MethodSignature method1, MethodSignature method2) {
            return MethodSignatureUtil.areSignaturesEqualLightweight(method1, method2) && MethodSignatureUtil.areErasedParametersEqual(method1, method2);
        }
    };

    private MethodSignatureUtil() {
    }

    public static boolean areOverrideEquivalent(PsiMethod method1, PsiMethod method2) {
        int typeParamsLength2;
        int typeParamsLength1 = method1.getTypeParameters().length;
        return (typeParamsLength1 == (typeParamsLength2 = method2.getTypeParameters().length) || typeParamsLength1 == 0 || typeParamsLength2 == 0) && MethodSignatureUtil.areErasedParametersEqual(method1.getSignature(PsiSubstitutor.EMPTY), method2.getSignature(PsiSubstitutor.EMPTY));
    }

    public static boolean areErasedParametersEqual(@NotNull MethodSignature method1, @NotNull MethodSignature method2) {
        if (method1 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(0);
        }
        if (method2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(1);
        }
        Object[] erased1 = method1 instanceof MethodSignatureBase ? ((MethodSignatureBase)method1).getErasedParameterTypes() : MethodSignatureUtil.calcErasedParameterTypes(method1);
        Object[] erased2 = method2 instanceof MethodSignatureBase ? ((MethodSignatureBase)method2).getErasedParameterTypes() : MethodSignatureUtil.calcErasedParameterTypes(method2);
        return Arrays.equals(erased1, erased2);
    }

    @NotNull
    public static PsiType[] calcErasedParameterTypes(@NotNull MethodSignature signature) {
        PsiType[] parameterTypes;
        if (signature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(2);
        }
        if ((parameterTypes = signature.getParameterTypes()).length == 0) {
            if (PsiType.EMPTY_ARRAY == null) {
                MethodSignatureUtil.$$$reportNull$$$0(3);
            }
            return PsiType.EMPTY_ARRAY;
        }
        PsiSubstitutor substitutor2 = signature.getSubstitutor();
        PsiType[] erasedTypes = PsiType.createArray(parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            erasedTypes[i] = TypeConversionUtil.erasure(parameterTypes[i], substitutor2);
        }
        if (erasedTypes == null) {
            MethodSignatureUtil.$$$reportNull$$$0(4);
        }
        return erasedTypes;
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @Nullable PsiParameterList parameterTypes, @Nullable PsiTypeParameterList typeParameterList, @NotNull PsiSubstitutor substitutor2) {
        if (name == null) {
            MethodSignatureUtil.$$$reportNull$$$0(5);
        }
        if (substitutor2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(6);
        }
        MethodSignature methodSignature = MethodSignatureUtil.createMethodSignature(name, parameterTypes, typeParameterList, substitutor2, false);
        if (methodSignature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(7);
        }
        return methodSignature;
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @Nullable PsiParameterList parameterTypes, @Nullable PsiTypeParameterList typeParameterList, @NotNull PsiSubstitutor substitutor2, boolean isConstructor) {
        if (name == null) {
            MethodSignatureUtil.$$$reportNull$$$0(8);
        }
        if (substitutor2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(9);
        }
        MethodSignatureHandMade methodSignatureHandMade = new MethodSignatureHandMade(name, parameterTypes, typeParameterList, substitutor2, isConstructor);
        if (methodSignatureHandMade == null) {
            MethodSignatureUtil.$$$reportNull$$$0(10);
        }
        return methodSignatureHandMade;
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @NotNull PsiType[] parameterTypes, @NotNull PsiTypeParameter[] typeParameterList, @NotNull PsiSubstitutor substitutor2) {
        if (name == null) {
            MethodSignatureUtil.$$$reportNull$$$0(11);
        }
        if (parameterTypes == null) {
            MethodSignatureUtil.$$$reportNull$$$0(12);
        }
        if (typeParameterList == null) {
            MethodSignatureUtil.$$$reportNull$$$0(13);
        }
        if (substitutor2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(14);
        }
        MethodSignature methodSignature = MethodSignatureUtil.createMethodSignature(name, parameterTypes, typeParameterList, substitutor2, false);
        if (methodSignature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(15);
        }
        return methodSignature;
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @NotNull PsiType[] parameterTypes, @NotNull PsiTypeParameter[] typeParameterList, @NotNull PsiSubstitutor substitutor2, boolean isConstructor) {
        if (name == null) {
            MethodSignatureUtil.$$$reportNull$$$0(16);
        }
        if (parameterTypes == null) {
            MethodSignatureUtil.$$$reportNull$$$0(17);
        }
        if (typeParameterList == null) {
            MethodSignatureUtil.$$$reportNull$$$0(18);
        }
        if (substitutor2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(19);
        }
        MethodSignatureHandMade methodSignatureHandMade = new MethodSignatureHandMade(name, parameterTypes, typeParameterList, substitutor2, isConstructor);
        if (methodSignatureHandMade == null) {
            MethodSignatureUtil.$$$reportNull$$$0(20);
        }
        return methodSignatureHandMade;
    }

    public static boolean areSignaturesEqual(@NotNull PsiMethod method1, @NotNull PsiMethod method2) {
        if (method1 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(21);
        }
        if (method2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(22);
        }
        return MethodSignatureUtil.areSignaturesEqual(method1.getSignature(PsiSubstitutor.EMPTY), method2.getSignature(PsiSubstitutor.EMPTY));
    }

    public static boolean areSignaturesEqual(@NotNull MethodSignature method1, @NotNull MethodSignature method2) {
        if (method1 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(23);
        }
        if (method2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(24);
        }
        if (method2 == method1) {
            return true;
        }
        if (!MethodSignatureUtil.areSignaturesEqualLightweight(method1, method2)) {
            return false;
        }
        return MethodSignatureUtil.checkSignaturesEqualInner(method1, method2, MethodSignatureUtil.getSuperMethodSignatureSubstitutor(method1, method2)) || MethodSignatureUtil.checkSignaturesEqualInner(method2, method1, MethodSignatureUtil.getSuperMethodSignatureSubstitutor(method2, method1));
    }

    private static boolean checkSignaturesEqualInner(@NotNull MethodSignature subSignature, @NotNull MethodSignature superSignature, PsiSubstitutor unifyingSubstitutor) {
        if (subSignature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(25);
        }
        if (superSignature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(26);
        }
        if (unifyingSubstitutor == null) {
            return false;
        }
        if (!MethodSignatureUtil.areErasedParametersEqual(subSignature, superSignature)) {
            return false;
        }
        PsiType[] subParameterTypes = subSignature.getParameterTypes();
        PsiType[] superParameterTypes = superSignature.getParameterTypes();
        for (int i = 0; i < subParameterTypes.length; ++i) {
            PsiType type2;
            PsiType type1 = unifyingSubstitutor.substitute(subParameterTypes[i]);
            if (Comparing.equal(type1, type2 = unifyingSubstitutor.substitute(superParameterTypes[i]))) continue;
            return false;
        }
        return true;
    }

    public static boolean areSignaturesEqualLightweight(@NotNull MethodSignature sig1, @NotNull MethodSignature sig2) {
        PsiType[] parameterTypes2;
        String name2;
        String name1;
        boolean isConstructor2;
        boolean isConstructor1;
        if (sig1 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(27);
        }
        if (sig2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(28);
        }
        if ((isConstructor1 = sig1.isConstructor()) != (isConstructor2 = sig2.isConstructor())) {
            return false;
        }
        if (!(isConstructor1 && (sig1 instanceof HierarchicalMethodSignature || sig2 instanceof HierarchicalMethodSignature) || (name1 = sig1.getName()).equals(name2 = sig2.getName()))) {
            return false;
        }
        PsiType[] parameterTypes1 = sig1.getParameterTypes();
        if (parameterTypes1.length != (parameterTypes2 = sig2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < parameterTypes1.length; ++i) {
            PsiType type1 = parameterTypes1[i];
            PsiType type2 = parameterTypes2[i];
            if (type1 instanceof PsiPrimitiveType != type2 instanceof PsiPrimitiveType) {
                return false;
            }
            if (!(type1 instanceof PsiPrimitiveType) || type1.equals(type2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSuperMethod(@NotNull PsiMethod superMethodCandidate, @NotNull PsiMethod derivedMethod) {
        if (superMethodCandidate == null) {
            MethodSignatureUtil.$$$reportNull$$$0(29);
        }
        if (derivedMethod == null) {
            MethodSignatureUtil.$$$reportNull$$$0(30);
        }
        PsiClass superClassCandidate = superMethodCandidate.getContainingClass();
        PsiClass derivedClass = derivedMethod.getContainingClass();
        if (derivedClass == null || superClassCandidate == null || derivedClass == superClassCandidate) {
            return false;
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(superClassCandidate, derivedClass, PsiSubstitutor.EMPTY, null);
        if (superSubstitutor == null) {
            return false;
        }
        MethodSignature superSignature = superMethodCandidate.getSignature(superSubstitutor);
        MethodSignature derivedSignature = derivedMethod.getSignature(PsiSubstitutor.EMPTY);
        return MethodSignatureUtil.isSubsignature(superSignature, derivedSignature);
    }

    @Nullable
    public static PsiMethod findMethodInSuperClassBySignatureInDerived(@NotNull PsiClass aClass2, @NotNull PsiClass superClass, @NotNull MethodSignature signature, boolean checkDeep) {
        if (aClass2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(31);
        }
        if (superClass == null) {
            MethodSignatureUtil.$$$reportNull$$$0(32);
        }
        if (signature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(33);
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass2, PsiSubstitutor.EMPTY);
        return MethodSignatureUtil.doFindMethodInSuperClassBySignatureInDerived(superClass, superSubstitutor, signature, checkDeep);
    }

    @Nullable
    private static PsiMethod doFindMethodInSuperClassBySignatureInDerived(@NotNull PsiClass superClass, @NotNull PsiSubstitutor superSubstitutor, @NotNull MethodSignature signature, boolean checkDeep) {
        PsiClass clazz;
        PsiMethod[] methods2;
        if (superClass == null) {
            MethodSignatureUtil.$$$reportNull$$$0(34);
        }
        if (superSubstitutor == null) {
            MethodSignatureUtil.$$$reportNull$$$0(35);
        }
        if (signature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(36);
        }
        String name = signature.getName();
        for (PsiMethod method : methods2 = superClass.findMethodsByName(name, false)) {
            if (!MethodSignatureUtil.isSubsignature(method.getSignature(superSubstitutor), signature)) continue;
            return method;
        }
        if (checkDeep && (clazz = superClass.getSuperClass()) != null && clazz != superClass) {
            PsiSubstitutor substitutor1 = TypeConversionUtil.getSuperClassSubstitutor(clazz, superClass, superSubstitutor);
            return MethodSignatureUtil.doFindMethodInSuperClassBySignatureInDerived(clazz, substitutor1, signature, true);
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass aClass2, @NotNull PsiMethod pattenMethod, boolean checkBases) {
        if (aClass2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(37);
        }
        if (pattenMethod == null) {
            MethodSignatureUtil.$$$reportNull$$$0(38);
        }
        return MethodSignatureUtil.findMethodBySignature(aClass2, pattenMethod.getSignature(PsiSubstitutor.EMPTY), checkBases);
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass aClass2, @NotNull MethodSignature methodSignature, boolean checkBases) {
        if (aClass2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(39);
        }
        if (methodSignature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(40);
        }
        String name = methodSignature.isConstructor() ? aClass2.getName() : methodSignature.getName();
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass2.findMethodsAndTheirSubstitutorsByName(name, checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            PsiMethod method = (PsiMethod)pair.first;
            PsiSubstitutor substitutor2 = (PsiSubstitutor)pair.second;
            MethodSignature foundMethodSignature = method.getSignature(substitutor2);
            if (!methodSignature.equals(foundMethodSignature)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySuperSignature(@NotNull PsiClass aClass2, @NotNull MethodSignature methodSignature, boolean checkBases) {
        if (aClass2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(41);
        }
        if (methodSignature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(42);
        }
        String name = methodSignature.isConstructor() ? aClass2.getName() : methodSignature.getName();
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass2.findMethodsAndTheirSubstitutorsByName(name, checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            PsiMethod method = (PsiMethod)pair.first;
            PsiSubstitutor substitutor2 = (PsiSubstitutor)pair.second;
            MethodSignature foundMethodSignature = method.getSignature(substitutor2);
            if (!MethodSignatureUtil.isSubsignature(methodSignature, foundMethodSignature)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySuperMethod(@NotNull PsiClass aClass2, @NotNull PsiMethod method, boolean checkBases) {
        if (aClass2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(43);
        }
        if (method == null) {
            MethodSignatureUtil.$$$reportNull$$$0(44);
        }
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass2.findMethodsAndTheirSubstitutorsByName(method.getName(), checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            MethodSignature superSignature;
            PsiSubstitutor superSubstitutor;
            PsiMethod candidate2 = (PsiMethod)pair.first;
            PsiSubstitutor substitutor2 = (PsiSubstitutor)pair.second;
            MethodSignature candidateSignature = candidate2.getSignature(substitutor2);
            PsiClass methodClass = method.getContainingClass();
            PsiClass candidateClass = candidate2.getContainingClass();
            if (methodClass == null || candidateClass == null || (superSubstitutor = TypeConversionUtil.getClassSubstitutor(methodClass, candidateClass, substitutor2)) == null || !MethodSignatureUtil.isSubsignature(superSignature = method.getSignature(superSubstitutor), candidateSignature)) continue;
            return candidate2;
        }
        return null;
    }

    public static boolean hasOverloads(@NotNull PsiMethod method) {
        if (method == null) {
            MethodSignatureUtil.$$$reportNull$$$0(45);
        }
        return MethodSignatureUtil.getOverloads(method).length > 1;
    }

    @NotNull
    public static PsiMethod[] getOverloads(@NotNull PsiMethod method) {
        PsiClass aClass2;
        if (method == null) {
            MethodSignatureUtil.$$$reportNull$$$0(46);
        }
        if ((aClass2 = method.getContainingClass()) == null) {
            PsiMethod[] psiMethodArray = new PsiMethod[]{method};
            if (psiMethodArray == null) {
                MethodSignatureUtil.$$$reportNull$$$0(47);
            }
            return psiMethodArray;
        }
        PsiMethod[] psiMethodArray = aClass2.findMethodsByName(method.getName(), false);
        if (psiMethodArray == null) {
            MethodSignatureUtil.$$$reportNull$$$0(48);
        }
        return psiMethodArray;
    }

    public static boolean areParametersErasureEqual(@NotNull PsiMethod method1, @NotNull PsiMethod method2) {
        if (method1 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(49);
        }
        if (method2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(50);
        }
        if (method1.getParameterList().getParametersCount() != method2.getParameterList().getParametersCount()) {
            return false;
        }
        return MethodSignatureUtil.areSignaturesErasureEqual(method1.getSignature(PsiSubstitutor.EMPTY), method2.getSignature(PsiSubstitutor.EMPTY));
    }

    public static boolean areSignaturesErasureEqual(@NotNull MethodSignature signature1, @NotNull MethodSignature signature2) {
        if (signature1 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(51);
        }
        if (signature2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(52);
        }
        return METHOD_PARAMETERS_ERASURE_EQUALITY.equals(signature1, signature2);
    }

    @Nullable
    public static PsiSubstitutor getSuperMethodSignatureSubstitutor(@NotNull MethodSignature methodSignature, @NotNull MethodSignature superMethodSignature) {
        PsiTypeParameter[] superTypeParameters;
        PsiTypeParameter[] methodTypeParameters;
        if (methodSignature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(53);
        }
        if (superMethodSignature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(54);
        }
        if ((methodTypeParameters = methodSignature.getTypeParameters()).length != (superTypeParameters = superMethodSignature.getTypeParameters()).length) {
            return null;
        }
        PsiSubstitutor result2 = superMethodSignature.getSubstitutor();
        for (int i = 0; i < methodTypeParameters.length; ++i) {
            PsiTypeParameter methodTypeParameter = methodTypeParameters[i];
            PsiElementFactory factory2 = JavaPsiFacade.getInstance(methodTypeParameter.getProject()).getElementFactory();
            result2 = result2.put(superTypeParameters[i], factory2.createType(methodTypeParameter));
        }
        PsiSubstitutor methodSubstitutor = methodSignature.getSubstitutor();
        for (int i = 0; i < methodTypeParameters.length; ++i) {
            PsiTypeParameter methodTypeParameter = methodTypeParameters[i];
            PsiTypeParameter superTypeParameter = superTypeParameters[i];
            HashSet<PsiType> methodSupers = new HashSet<PsiType>();
            for (PsiClassType methodSuper : methodTypeParameter.getSuperTypes()) {
                methodSupers.add(methodSubstitutor.substitute(methodSuper));
            }
            HashSet<PsiType> superSupers = new HashSet<PsiType>();
            for (PsiClassType superSuper : superTypeParameter.getSuperTypes()) {
                superSupers.add(methodSubstitutor.substitute(result2.substitute(superSuper)));
            }
            methodSupers.remove(PsiType.getJavaLangObject(methodTypeParameter.getManager(), methodTypeParameter.getResolveScope()));
            superSupers.remove(PsiType.getJavaLangObject(superTypeParameter.getManager(), superTypeParameter.getResolveScope()));
            if (methodSupers.equals(superSupers)) continue;
            return null;
        }
        return result2;
    }

    @NotNull
    public static PsiSubstitutor combineSubstitutors(@NotNull PsiSubstitutor substitutor1, @NotNull PsiSubstitutor substitutor2) {
        PsiTypeParameter[] typeParameters2;
        if (substitutor1 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(55);
        }
        if (substitutor2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(56);
        }
        if (substitutor1 == PsiSubstitutor.EMPTY) {
            PsiSubstitutor psiSubstitutor = substitutor2;
            if (psiSubstitutor == null) {
                MethodSignatureUtil.$$$reportNull$$$0(57);
            }
            return psiSubstitutor;
        }
        Set<PsiTypeParameter> parameters1 = substitutor1.getSubstitutionMap().keySet();
        for (PsiTypeParameter typeParameter : typeParameters2 = parameters1.toArray(PsiTypeParameter.EMPTY_ARRAY)) {
            PsiClass resolved;
            PsiType type2 = substitutor1.substitute(typeParameter);
            PsiType otherSubstituted = type2 instanceof PsiClassType ? ((resolved = ((PsiClassType)type2).resolve()) instanceof PsiTypeParameter ? substitutor2.substitute((PsiTypeParameter)resolved) : substitutor2.substitute(type2)) : substitutor2.substitute(type2);
            substitutor1 = substitutor1.put(typeParameter, otherSubstituted);
        }
        PsiSubstitutor psiSubstitutor = substitutor1;
        if (psiSubstitutor == null) {
            MethodSignatureUtil.$$$reportNull$$$0(58);
        }
        return psiSubstitutor;
    }

    @NotNull
    public static PsiMethod[] convertMethodSignaturesToMethods(@NotNull List<? extends MethodSignatureBackedByPsiMethod> sameNameMethodList) {
        if (sameNameMethodList == null) {
            MethodSignatureUtil.$$$reportNull$$$0(59);
        }
        PsiMethod[] methods2 = new PsiMethod[sameNameMethodList.size()];
        for (int i = 0; i < sameNameMethodList.size(); ++i) {
            methods2[i] = sameNameMethodList.get(i).getMethod();
        }
        if (methods2 == null) {
            MethodSignatureUtil.$$$reportNull$$$0(60);
        }
        return methods2;
    }

    public static boolean isSubsignature(@NotNull MethodSignature superSignature, @NotNull MethodSignature subSignature) {
        if (superSignature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(61);
        }
        if (subSignature == null) {
            MethodSignatureUtil.$$$reportNull$$$0(62);
        }
        if (subSignature == superSignature) {
            return true;
        }
        if (!MethodSignatureUtil.areSignaturesEqualLightweight(superSignature, subSignature)) {
            return false;
        }
        PsiSubstitutor unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(subSignature, superSignature);
        if (MethodSignatureUtil.checkSignaturesEqualInner(superSignature, subSignature, unifyingSubstitutor)) {
            return true;
        }
        if (subSignature.getTypeParameters().length > 0) {
            return false;
        }
        PsiType[] subParameterTypes = subSignature.getParameterTypes();
        PsiType[] superParameterTypes = superSignature.getParameterTypes();
        for (int i = 0; i < subParameterTypes.length; ++i) {
            PsiType type1 = subParameterTypes[i];
            PsiType type2 = TypeConversionUtil.erasure(superParameterTypes[i], superSignature.getSubstitutor());
            if (Comparing.equal(type1, type2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isReturnTypeSubstitutable(MethodSignature d1, MethodSignature d2, PsiType r1, PsiType r2) {
        if (PsiType.VOID.equals(r1)) {
            return PsiType.VOID.equals(r2);
        }
        if (r1 instanceof PsiPrimitiveType) {
            return r1.equals(r2);
        }
        if (r1 instanceof PsiClassType && r2 != null) {
            PsiSubstitutor adaptingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(d2, d1);
            if (adaptingSubstitutor != null && r2.isAssignableFrom(adaptingSubstitutor.substitute(r1))) {
                return true;
            }
            if (!MethodSignatureUtil.areSignaturesEqual(d1, d2)) {
                return r1.equals(TypeConversionUtil.erasure(r2));
            }
        }
        return Comparing.equal(r1, r2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 15: 
            case 20: 
            case 47: 
            case 48: 
            case 57: 
            case 58: 
            case 60: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 15: 
            case 20: 
            case 47: 
            case 48: 
            case 57: 
            case 58: 
            case 60: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method1";
                break;
            }
            case 1: 
            case 22: 
            case 24: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method2";
                break;
            }
            case 2: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 15: 
            case 20: 
            case 47: 
            case 48: 
            case 57: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/MethodSignatureUtil";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 9: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterList";
                break;
            }
            case 25: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subSignature";
                break;
            }
            case 26: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superSignature";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sig1";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sig2";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethodCandidate";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedMethod";
                break;
            }
            case 31: 
            case 37: 
            case 39: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superSubstitutor";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattenMethod";
                break;
            }
            case 40: 
            case 42: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSignature";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature1";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature2";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethodSignature";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor1";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor2";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sameNameMethodList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/MethodSignatureUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcErasedParameterTypes";
                break;
            }
            case 7: 
            case 10: 
            case 15: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodSignature";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverloads";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "combineSubstitutors";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMethodSignaturesToMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areErasedParametersEqual";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcErasedParameterTypes";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 15: 
            case 20: 
            case 47: 
            case 48: 
            case 57: 
            case 58: 
            case 60: {
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createMethodSignature";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "areSignaturesEqual";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkSignaturesEqualInner";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "areSignaturesEqualLightweight";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isSuperMethod";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findMethodInSuperClassBySignatureInDerived";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "doFindMethodInSuperClassBySignatureInDerived";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findMethodBySignature";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findMethodBySuperSignature";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findMethodBySuperMethod";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "hasOverloads";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getOverloads";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "areParametersErasureEqual";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "areSignaturesErasureEqual";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getSuperMethodSignatureSubstitutor";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "combineSubstitutors";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "convertMethodSignaturesToMethods";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isSubsignature";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 15: 
            case 20: 
            case 47: 
            case 48: 
            case 57: 
            case 58: 
            case 60: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

