/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/types/checker/StrictEqualityTypeChecker;", "", "()V", "strictEqualTypes", "", "a", "Lorg/jetbrains/kotlin/types/SimpleType;", "b", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "descriptors"})
public final class StrictEqualityTypeChecker {
    public static final StrictEqualityTypeChecker INSTANCE;

    public final boolean strictEqualTypes(@NotNull UnwrappedType a, @NotNull UnwrappedType b) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        if (a == b) {
            return true;
        }
        if (a instanceof SimpleType && b instanceof SimpleType) {
            return this.strictEqualTypes((SimpleType)a, (SimpleType)b);
        }
        if (a instanceof FlexibleType && b instanceof FlexibleType) {
            return this.strictEqualTypes(((FlexibleType)a).getLowerBound(), ((FlexibleType)b).getLowerBound()) && this.strictEqualTypes(((FlexibleType)a).getUpperBound(), ((FlexibleType)b).getUpperBound());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean strictEqualTypes(@NotNull SimpleType a, @NotNull SimpleType b) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        if (a.isMarkedNullable() != b.isMarkedNullable() || SpecialTypesKt.isDefinitelyNotNullType(a) != SpecialTypesKt.isDefinitelyNotNullType(b) || Intrinsics.areEqual(a.getConstructor(), b.getConstructor()) ^ true || a.getArguments().size() != b.getArguments().size()) {
            return false;
        }
        if (a.getArguments() == b.getArguments()) {
            return true;
        }
        int n = 0;
        int n2 = ((Collection)a.getArguments()).size();
        while (n < n2) {
            void i;
            TypeProjection aArg = a.getArguments().get((int)i);
            TypeProjection bArg = b.getArguments().get((int)i);
            if (aArg.isStarProjection() != bArg.isStarProjection()) {
                return false;
            }
            if (!aArg.isStarProjection()) {
                if (aArg.getProjectionKind() != bArg.getProjectionKind()) {
                    return false;
                }
                if (!this.strictEqualTypes(aArg.getType().unwrap(), bArg.getType().unwrap())) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private StrictEqualityTypeChecker() {
    }

    static {
        StrictEqualityTypeChecker strictEqualityTypeChecker;
        INSTANCE = strictEqualityTypeChecker = new StrictEqualityTypeChecker();
    }
}

