/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FakeOverrideTypeCalculator;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "()V", "fakeOverrideTypeCalculator", "Lorg/jetbrains/kotlin/fir/scopes/FakeOverrideTypeCalculator;", "getFakeOverrideTypeCalculator", "()Lorg/jetbrains/kotlin/fir/scopes/FakeOverrideTypeCalculator;", "tryCalculateReturnTypeOrNull", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "providers"})
@SourceDebugExtension(value={"SMAP\nReturnTypeCalculatorForFullBodyResolve.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReturnTypeCalculatorForFullBodyResolve.kt\norg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve\n+ 2 FirErrorTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirErrorTypeRefBuilderKt\n*L\n1#1,35:1\n57#2,4:36\n*S KotlinDebug\n*F\n+ 1 ReturnTypeCalculatorForFullBodyResolve.kt\norg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve\n*L\n27#1:36,4\n*E\n"})
public final class ReturnTypeCalculatorForFullBodyResolve
extends ReturnTypeCalculator {
    @NotNull
    public static final ReturnTypeCalculatorForFullBodyResolve INSTANCE = new ReturnTypeCalculatorForFullBodyResolve();

    private ReturnTypeCalculatorForFullBodyResolve() {
    }

    @Override
    @NotNull
    public FakeOverrideTypeCalculator getFakeOverrideTypeCalculator() {
        return FakeOverrideTypeCalculator.Forced.INSTANCE;
    }

    @Override
    @Nullable
    public FirResolvedTypeRef tryCalculateReturnTypeOrNull(@NotNull FirCallableDeclaration declaration) {
        FirErrorTypeRefBuilder firErrorTypeRefBuilder;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirTypeRef returnTypeRef = declaration.getReturnTypeRef();
        if (returnTypeRef instanceof FirResolvedTypeRef) {
            return (FirResolvedTypeRef)returnTypeRef;
        }
        if (declaration.getOrigin().getFromSupertypes()) {
            return FakeOverrideTypeCalculator.Forced.INSTANCE.computeReturnType(declaration);
        }
        boolean $i$f$buildErrorTypeRef = false;
        FirErrorTypeRefBuilder $this$tryCalculateReturnTypeOrNull_u24lambda_u240 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
        boolean bl = false;
        $this$tryCalculateReturnTypeOrNull_u24lambda_u240.setDiagnostic(new ConeSimpleDiagnostic("Cannot calculate return type during full-body resolution (local class/object?): " + UtilsKt.render(declaration), DiagnosticKind.InferenceError));
        return firErrorTypeRefBuilder.build();
    }
}

