/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\t\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001!B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J!\u0010\n\u001a\u000e\u0018\u00010\u0007R\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u000b\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\fJ.\u0010\n\u001a\f0\u0007R\b\u0012\u0004\u0012\u00028\u00000\u00002\u0010\u0010\u000b\u001a\f0\u0007R\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0002J'\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u00002\u0010\u0010\u0012\u001a\f0\u0007R\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0002\u00a2\u0006\u0002\u0010\u0013J6\u0010\u0014\u001a\f0\u0007R\b\u0012\u0004\u0012\u00028\u00000\u00002\u0010\u0010\u0015\u001a\f0\u0007R\b\u0012\u0004\u0012\u00028\u00000\u00002\u0010\u0010\u0016\u001a\f0\u0007R\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0002J\u0014\u0010\u0017\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019J\u0006\u0010\u001a\u001a\u00020\u0010J\u0016\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001dJ\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\u0006\u0010\u001c\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00190\u0019R$\u0010\u0005\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u000e\u0012\f0\u0007R\b\u0012\u0004\u0012\u00028\u00000\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions;", "T", "", "<init>", "()V", "leafParents", "", "Lorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions$Node;", "dirty", "", "findRoot", "node", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions$Node;", "pathWeight", "", "addToRoot", "", "leaf", "root", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions$Node;)V", "mergeRoots", "root1", "root2", "addUnion", "elements", "", "compress", "contains", "element", "(Ljava/lang/Object;)Z", "get", "(Ljava/lang/Object;)Ljava/util/List;", "allUnions", "Node", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nDisjointUnions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisjointUnions.kt\norg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1#2:109\n1863#3,2:110\n1557#3:112\n1628#3,3:113\n*S KotlinDebug\n*F\n+ 1 DisjointUnions.kt\norg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions\n*L\n88#1:110,2\n106#1:112\n106#1:113,3\n*E\n"})
public final class DisjointUnions<T> {
    @NotNull
    private final Map<T, Node> leafParents = new LinkedHashMap();
    private boolean dirty;

    private final Node findRoot(T node) {
        Node node2;
        Node node3 = this.leafParents.get(node);
        if (node3 != null) {
            Node it = node3;
            boolean bl = false;
            node2 = DisjointUnions.findRoot$default(this, it, 0, 2, null);
        } else {
            node2 = null;
        }
        return node2;
    }

    private final Node findRoot(Node node, int pathWeight) {
        Node node2 = node.getParent();
        if (node2 == null) {
            return node;
        }
        Node strictParent = node2;
        int currentWeight = pathWeight + node.getLeafs().size();
        Node foundRoot = this.findRoot(strictParent, currentWeight);
        if (!Intrinsics.areEqual((Object)foundRoot, (Object)node)) {
            List leafs = node.getLeafs();
            node.setRank(node.getRank() - currentWeight);
            if (!(node.getRank() >= 0)) {
                throw new IllegalStateException("Check failed.");
            }
            foundRoot.getLeafs().addAll(leafs);
            leafs.clear();
            node.setParent(foundRoot);
        }
        return foundRoot;
    }

    static /* synthetic */ Node findRoot$default(DisjointUnions disjointUnions, Node node, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return disjointUnions.findRoot(node, n);
    }

    private final void addToRoot(T leaf, Node root) {
        this.leafParents.put(leaf, root);
        int n = root.getRank();
        root.setRank(n + 1);
        root.getLeafs().add(leaf);
    }

    private final Node mergeRoots(Node root1, Node root2) {
        if (Intrinsics.areEqual((Object)root1, (Object)root2)) {
            return root1;
        }
        if (!(root1.getParent() == null && root2.getParent() == null)) {
            boolean $i$a$-require-DisjointUnions$mergeRoots$22 = false;
            String $i$a$-require-DisjointUnions$mergeRoots$22 = "Merge is possible only for root nodes";
            throw new IllegalArgumentException($i$a$-require-DisjointUnions$mergeRoots$22.toString());
        }
        if (Intrinsics.areEqual((Object)root2.getParent(), (Object)root1)) {
            return root1;
        }
        if (Intrinsics.areEqual((Object)root1.getParent(), (Object)root2)) {
            return root2;
        }
        Node rootToMove = null;
        Node newParentRoot = null;
        if (root1.getRank() > root2.getRank()) {
            rootToMove = root2;
            newParentRoot = root1;
        } else {
            rootToMove = root1;
            newParentRoot = root2;
        }
        rootToMove.setParent(newParentRoot);
        List leafs = rootToMove.getLeafs();
        newParentRoot.setRank(newParentRoot.getRank() + leafs.size());
        rootToMove.setRank(rootToMove.getRank() - leafs.size());
        if (!(rootToMove.getRank() >= 0)) {
            throw new IllegalStateException("Check failed.");
        }
        newParentRoot.getLeafs().addAll(leafs);
        leafs.clear();
        return newParentRoot;
    }

    public final void addUnion(@NotNull List<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Node currentRoot = null;
        this.dirty = true;
        for (T leaf : elements) {
            Node strictRoot;
            block3: {
                Node node;
                block5: {
                    block4: {
                        strictRoot = this.leafParents.get(leaf);
                        if (strictRoot != null) break block3;
                        node = currentRoot;
                        if (node == null) break block4;
                        Node p0 = node;
                        boolean bl = false;
                        Node node2 = DisjointUnions.findRoot$default(this, p0, 0, 2, null);
                        node = node2;
                        if (node2 != null) break block5;
                    }
                    node = new Node(this, 0, null, 3, null);
                }
                currentRoot = node;
                this.addToRoot(leaf, currentRoot);
                continue;
            }
            Node leafRoot = DisjointUnions.findRoot$default(this, strictRoot, 0, 2, null);
            Node node = currentRoot;
            currentRoot = node != null ? this.mergeRoots(node, leafRoot) : leafRoot;
        }
    }

    public final void compress() {
        if (this.dirty) {
            Iterable $this$forEach$iv = this.leafParents.keySet();
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object p0 = element$iv = iterator2.next();
                boolean bl = false;
                this.findRoot(p0);
            }
            this.dirty = false;
        }
    }

    public final boolean contains(T element) {
        return this.leafParents.containsKey(element);
    }

    @NotNull
    public final List<T> get(T element) {
        if (!(!this.dirty)) {
            boolean bl = false;
            String string2 = "Call compress before getting union";
            throw new IllegalArgumentException(string2.toString());
        }
        Node root = this.findRoot(element);
        if (!(root != null)) {
            boolean $i$a$-require-DisjointUnions$get$32 = false;
            String $i$a$-require-DisjointUnions$get$32 = "Element not contains in any union";
            throw new IllegalArgumentException($i$a$-require-DisjointUnions$get$32.toString());
        }
        if (!(root.getRank() == root.getLeafs().size())) {
            boolean bl = false;
            String string3 = "Invalid tree state after compress";
            throw new IllegalStateException(string3.toString());
        }
        return root.getLeafs();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<T>> allUnions() {
        void $this$mapTo$iv$iv;
        if (!(!this.dirty)) {
            boolean $i$a$-require-DisjointUnions$allUnions$22 = false;
            String $i$a$-require-DisjointUnions$allUnions$22 = "Call compress before getting union";
            throw new IllegalArgumentException($i$a$-require-DisjointUnions$allUnions$22.toString());
        }
        Iterable $this$map$iv = this.leafParents.keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.get(it));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR&\u0010\u000e\u001a\u000e\u0018\u00010\u0000R\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions$Node;", "", "rank", "", "leafs", "", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions;ILjava/util/List;)V", "getRank", "()I", "setRank", "(I)V", "getLeafs", "()Ljava/util/List;", "parent", "Lorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions;", "getParent", "()Lorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions$Node;", "setParent", "(Lorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions$Node;)V", "toString", "", "backend.wasm"})
    private final class Node {
        private int rank;
        @NotNull
        private final List<T> leafs;
        @Nullable
        private Node parent;
        final /* synthetic */ DisjointUnions<T> this$0;

        public Node(DisjointUnions this$0, @NotNull int rank, List<T> leafs) {
            Intrinsics.checkNotNullParameter(leafs, (String)"leafs");
            this.this$0 = this$0;
            this.rank = rank;
            this.leafs = leafs;
        }

        public /* synthetic */ Node(DisjointUnions disjointUnions, int n, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            if ((n2 & 2) != 0) {
                list = new ArrayList();
            }
            this(disjointUnions, n, list);
        }

        public final int getRank() {
            return this.rank;
        }

        public final void setRank(int n) {
            this.rank = n;
        }

        @NotNull
        public final List<T> getLeafs() {
            return this.leafs;
        }

        @Nullable
        public final Node getParent() {
            return this.parent;
        }

        public final void setParent(@Nullable Node node) {
            this.parent = node;
        }

        @NotNull
        public String toString() {
            return (this.parent == null ? "ROOT " : "") + "Node with " + this.leafs.size() + " leafs and " + this.rank + " rank";
        }
    }
}

