/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.ki.shell.plugins;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.ki.shell.BaseCommand;
import org.jetbrains.kotlinx.ki.shell.Command;
import org.jetbrains.kotlinx.ki.shell.Plugin;
import org.jetbrains.kotlinx.ki.shell.Shell;
import org.jetbrains.kotlinx.ki.shell.UtilKt;
import org.jetbrains.kotlinx.ki.shell.configuration.ReplConfiguration;
import org.jetbrains.kotlinx.ki.shell.plugins.PromptPlugin;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u0000 &2\u00020\u0001:\u0003&'(B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\nH\u0002J\b\u0010\u001e\u001a\u00020\nH\u0002J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0004H\u0016J\b\u0010!\u001a\u00020\nH\u0002J\b\u0010\"\u001a\u00020\nH\u0002J\u000e\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001aJ\b\u0010%\u001a\u00020\nH\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlinx/ki/shell/plugins/PromptPlugin;", "Lorg/jetbrains/kotlinx/ki/shell/Plugin;", "()V", "conf", "Lorg/jetbrains/kotlinx/ki/shell/configuration/ReplConfiguration;", "getConf", "()Lorg/jetbrains/kotlinx/ki/shell/configuration/ReplConfiguration;", "setConf", "(Lorg/jetbrains/kotlinx/ki/shell/configuration/ReplConfiguration;)V", "incomplete", "", "getIncomplete", "()Ljava/lang/String;", "setIncomplete", "(Ljava/lang/String;)V", "pattern", "getPattern", "setPattern", "repl", "Lorg/jetbrains/kotlinx/ki/shell/Shell;", "getRepl", "()Lorg/jetbrains/kotlinx/ki/shell/Shell;", "setRepl", "(Lorg/jetbrains/kotlinx/ki/shell/Shell;)V", "types", "", "Lorg/jetbrains/kotlinx/ki/shell/plugins/PromptPlugin$PromptType;", "cleanUp", "", "evalTime", "formattedTime", "init", "config", "maxMemory", "promptFunc", "registerCustomType", "promptType", "totalMemory", "Companion", "Prompt", "PromptType", "ki-shell"})
public final class PromptPlugin
implements Plugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public Shell repl;
    public ReplConfiguration conf;
    public String pattern;
    public String incomplete;
    @NotNull
    private final Map<String, PromptType> types;

    public PromptPlugin() {
        Pair[] pairArray = new Pair[]{TuplesKt.to("l", new PromptType("l", new Function0<String>(this){
            final /* synthetic */ PromptPlugin this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return String.valueOf(this.this$0.getRepl().getCurrentSnippetNo().get());
            }
        }, "line number")), TuplesKt.to("u", new PromptType("u", types.2.INSTANCE, "user name")), TuplesKt.to("h", new PromptType("h", types.3.INSTANCE, "host name")), TuplesKt.to("d", new PromptType("d", new Function0<String>(this){
            final /* synthetic */ PromptPlugin this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return PromptPlugin.access$formattedTime(this.this$0);
            }
        }, "current time")), TuplesKt.to("t", new PromptType("t", new Function0<String>(this){
            final /* synthetic */ PromptPlugin this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return PromptPlugin.access$totalMemory(this.this$0);
            }
        }, "total memory")), TuplesKt.to("m", new PromptType("m", new Function0<String>(this){
            final /* synthetic */ PromptPlugin this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return PromptPlugin.access$maxMemory(this.this$0);
            }
        }, "maximum memory")), TuplesKt.to("e", new PromptType("e", new Function0<String>(this){
            final /* synthetic */ PromptPlugin this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return PromptPlugin.access$evalTime(this.this$0);
            }
        }, "evaluation time"))};
        this.types = MapsKt.mutableMapOf(pairArray);
    }

    @NotNull
    public final Shell getRepl() {
        Shell shell = this.repl;
        if (shell != null) {
            return shell;
        }
        Intrinsics.throwUninitializedPropertyAccessException("repl");
        return null;
    }

    public final void setRepl(@NotNull Shell shell) {
        Intrinsics.checkNotNullParameter(shell, "<set-?>");
        this.repl = shell;
    }

    @NotNull
    public final ReplConfiguration getConf() {
        ReplConfiguration replConfiguration = this.conf;
        if (replConfiguration != null) {
            return replConfiguration;
        }
        Intrinsics.throwUninitializedPropertyAccessException("conf");
        return null;
    }

    public final void setConf(@NotNull ReplConfiguration replConfiguration) {
        Intrinsics.checkNotNullParameter(replConfiguration, "<set-?>");
        this.conf = replConfiguration;
    }

    @NotNull
    public final String getPattern() {
        String string2 = this.pattern;
        if (string2 != null) {
            return string2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("pattern");
        return null;
    }

    public final void setPattern(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.pattern = string2;
    }

    @NotNull
    public final String getIncomplete() {
        String string2 = this.incomplete;
        if (string2 != null) {
            return string2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("incomplete");
        return null;
    }

    public final void setIncomplete(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.incomplete = string2;
    }

    @Override
    public void init(@NotNull Shell repl2, @NotNull ReplConfiguration config) {
        Intrinsics.checkNotNullParameter(repl2, "repl");
        Intrinsics.checkNotNullParameter(config, "config");
        this.setRepl(repl2);
        this.setConf(config);
        repl2.setPrompt(new Function0<String>((Object)this){

            @NotNull
            public final String invoke() {
                return PromptPlugin.access$promptFunc((PromptPlugin)this.receiver);
            }
        });
        repl2.registerCommand(new Prompt(config));
    }

    private final String formattedTime() {
        String string2 = LocalTime.now().toString();
        Intrinsics.checkNotNullExpressionValue(string2, "now().toString()");
        return string2;
    }

    private final String totalMemory() {
        return UtilKt.calcHumanReadableSize$default(Runtime.getRuntime().totalMemory(), false, 2, null);
    }

    private final String maxMemory() {
        return UtilKt.calcHumanReadableSize$default(Runtime.getRuntime().maxMemory(), false, 2, null);
    }

    private final String evalTime() {
        String string2 = "%.2fs";
        Object[] objectArray = new Object[]{(double)this.getRepl().getEvaluationTimeMillis() / 1000.0};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private final String promptFunc() {
        String string2;
        if (!((Collection)this.getRepl().getIncompleteLines()).isEmpty()) {
            string2 = this.getIncomplete();
        } else {
            Map map2;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Map<String, PromptType> map3 = this.types;
            String string3 = Intrinsics.stringPlus(this.getPattern(), " ");
            Companion companion = Companion;
            boolean $i$f$mapValues = false;
            void var3_5 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map4 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                map2 = map4;
                boolean bl2 = false;
                Function0<String> function0 = ((PromptType)it.getValue()).getDisplay();
                map2.put(k, function0);
            }
            map2 = destination$iv$iv;
            string2 = companion.format$ki_shell(string3, map2);
        }
        return string2;
    }

    public final void registerCustomType(@NotNull PromptType promptType) {
        Intrinsics.checkNotNullParameter(promptType, "promptType");
        Map<String, PromptType> map2 = this.types;
        String string2 = promptType.getType();
        map2.put(string2, promptType);
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void sayHello() {
        Plugin.DefaultImpls.sayHello(this);
    }

    public static final /* synthetic */ String access$promptFunc(PromptPlugin $this) {
        return $this.promptFunc();
    }

    public static final /* synthetic */ String access$formattedTime(PromptPlugin $this) {
        return $this.formattedTime();
    }

    public static final /* synthetic */ String access$totalMemory(PromptPlugin $this) {
        return $this.totalMemory();
    }

    public static final /* synthetic */ String access$maxMemory(PromptPlugin $this) {
        return $this.maxMemory();
    }

    public static final /* synthetic */ String access$evalTime(PromptPlugin $this) {
        return $this.evalTime();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\b\u0010\u001c\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\n\u0010\bR\u001b\u0010\r\u001a\u00020\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u0010\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u001b\u0010\u0012\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\f\u001a\u0004\b\u0013\u0010\bR\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0016\u0010\b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlinx/ki/shell/plugins/PromptPlugin$Prompt;", "Lorg/jetbrains/kotlinx/ki/shell/BaseCommand;", "conf", "Lorg/jetbrains/kotlinx/ki/shell/configuration/ReplConfiguration;", "(Lorg/jetbrains/kotlinx/ki/shell/plugins/PromptPlugin;Lorg/jetbrains/kotlinx/ki/shell/configuration/ReplConfiguration;)V", "description", "", "getDescription", "()Ljava/lang/String;", "incomplete", "getIncomplete", "incomplete$delegate", "Lorg/jetbrains/kotlinx/ki/shell/configuration/ReplConfiguration$DelegateProvider;", "name", "getName", "name$delegate", "params", "getParams", "pattern", "getPattern", "pattern$delegate", "short", "getShort", "short$delegate", "Lorg/jetbrains/kotlinx/ki/shell/configuration/ReplConfiguration$DelegateProviderForNullables;", "execute", "Lorg/jetbrains/kotlinx/ki/shell/Command$Result;", "line", "help", "ki-shell"})
    public final class Prompt
    extends BaseCommand {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReplConfiguration.DelegateProvider name$delegate;
        @NotNull
        private final ReplConfiguration.DelegateProviderForNullables short$delegate;
        @NotNull
        private final String description;
        @NotNull
        private final String params;
        @NotNull
        private final ReplConfiguration.DelegateProvider pattern$delegate;
        @NotNull
        private final ReplConfiguration.DelegateProvider incomplete$delegate;

        public Prompt(ReplConfiguration conf) {
            Intrinsics.checkNotNullParameter(PromptPlugin.this, "this$0");
            Intrinsics.checkNotNullParameter(conf, "conf");
            this.name$delegate = conf.get("prompt");
            this.short$delegate = conf.getNullable();
            this.description = "customize prompt";
            this.params = "[pattern]";
            this.pattern$delegate = conf.get("[%l]");
            this.incomplete$delegate = conf.get("...");
            PromptPlugin.this.setPattern(this.getPattern());
            PromptPlugin.this.setIncomplete(this.getIncomplete());
        }

        @Override
        @NotNull
        public String getName() {
            return (String)this.name$delegate.getValue(this, $$delegatedProperties[0]);
        }

        @Override
        @Nullable
        public String getShort() {
            return (String)this.short$delegate.getValue(this, $$delegatedProperties[1]);
        }

        @Override
        @NotNull
        public String getDescription() {
            return this.description;
        }

        @Override
        @NotNull
        public String getParams() {
            return this.params;
        }

        private final String getPattern() {
            return (String)this.pattern$delegate.getValue(this, $$delegatedProperties[2]);
        }

        private final String getIncomplete() {
            return (String)this.incomplete$delegate.getValue(this, $$delegatedProperties[3]);
        }

        @Override
        @NotNull
        public Command.Result execute(@NotNull String line) {
            Intrinsics.checkNotNullParameter(line, "line");
            int p = StringsKt.indexOf$default((CharSequence)line, ' ', 0, false, 6, null);
            if (p > 0) {
                String string2 = line.substring(p + 1);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
                PromptPlugin.this.setPattern(((Object)StringsKt.trim((CharSequence)string2)).toString());
            } else {
                System.out.println((Object)PromptPlugin.this.getPattern());
            }
            return new Command.Result.Success(null, 1, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String help() {
            void $this$mapTo$iv$iv;
            Map $this$map$iv = MapsKt.toSortedMap(PromptPlugin.this.types);
            boolean $i$f$map = false;
            Map map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PromptType type2 = (PromptType)it.getValue();
                collection.add('%' + type2.getType() + '\t' + type2.getHelp());
            }
            String help2 = CollectionsKt.joinToString$default((List)destination$iv$iv, "\n|", null, null, 0, null, null, 62, null);
            return StringsKt.trimMargin$default("\n                |:prompt [format]\n                |\n                |The command customizes prompt.\n                |Format can contain following specials:\n                |" + help2 + "\n                ", null, 1, null);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Prompt.class, "name", "getName()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(Prompt.class, "short", "getShort()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(Prompt.class, "pattern", "getPattern()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(Prompt.class, "incomplete", "getIncomplete()Ljava/lang/String;", 0))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J-\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/ki/shell/plugins/PromptPlugin$PromptType;", "", "type", "", "display", "Lkotlin/Function0;", "help", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;Ljava/lang/String;)V", "getDisplay", "()Lkotlin/jvm/functions/Function0;", "getHelp", "()Ljava/lang/String;", "getType", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "ki-shell"})
    public static final class PromptType {
        @NotNull
        private final String type;
        @NotNull
        private final Function0<String> display;
        @NotNull
        private final String help;

        public PromptType(@NotNull String type2, @NotNull Function0<String> display, @NotNull String help2) {
            Intrinsics.checkNotNullParameter(type2, "type");
            Intrinsics.checkNotNullParameter(display, "display");
            Intrinsics.checkNotNullParameter(help2, "help");
            this.type = type2;
            this.display = display;
            this.help = help2;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final Function0<String> getDisplay() {
            return this.display;
        }

        @NotNull
        public final String getHelp() {
            return this.help;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @NotNull
        public final Function0<String> component2() {
            return this.display;
        }

        @NotNull
        public final String component3() {
            return this.help;
        }

        @NotNull
        public final PromptType copy(@NotNull String type2, @NotNull Function0<String> display, @NotNull String help2) {
            Intrinsics.checkNotNullParameter(type2, "type");
            Intrinsics.checkNotNullParameter(display, "display");
            Intrinsics.checkNotNullParameter(help2, "help");
            return new PromptType(type2, display, help2);
        }

        public static /* synthetic */ PromptType copy$default(PromptType promptType, String string2, Function0 function0, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = promptType.type;
            }
            if ((n & 2) != 0) {
                function0 = promptType.display;
            }
            if ((n & 4) != 0) {
                string3 = promptType.help;
            }
            return promptType.copy(string2, function0, string3);
        }

        @NotNull
        public String toString() {
            return "PromptType(type=" + this.type + ", display=" + this.display + ", help=" + this.help + ')';
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + this.display.hashCode();
            result2 = result2 * 31 + this.help.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PromptType)) {
                return false;
            }
            PromptType promptType = (PromptType)other;
            if (!Intrinsics.areEqual(this.type, promptType.type)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.display, promptType.display)) {
                return false;
            }
            return Intrinsics.areEqual(this.help, promptType.help);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\b0\u0007H\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlinx/ki/shell/plugins/PromptPlugin$Companion;", "", "()V", "format", "", "p", "types", "", "Lkotlin/Function0;", "format$ki_shell", "ki-shell"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String format$ki_shell(@NotNull String p, @NotNull Map<String, ? extends Function0<String>> types2) {
            Intrinsics.checkNotNullParameter(p, "p");
            Intrinsics.checkNotNullParameter(types2, "types");
            int state = 0;
            StringBuilder sb = new StringBuilder();
            StringBuilder tb = new StringBuilder();
            int n = p.length();
            block4: for (int i = 0; i < n; ++i) {
                char ch = p.charAt(i);
                char c = ch;
                if (c == '%') {
                    state = 1;
                    continue;
                }
                if (c == '{') {
                    if (state == 1) {
                        state = 2;
                        continue;
                    }
                    sb.append(ch);
                    continue;
                }
                if (c == '}') {
                    if (state == 2) {
                        String string2 = tb.toString();
                        Intrinsics.checkNotNullExpressionValue(string2, "tb.toString()");
                        String t = string2;
                        sb.append((String)((Function0)types2.getOrDefault(t, new Function0<String>(t){
                            final /* synthetic */ String $t;
                            {
                                this.$t = $t;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return "%{" + this.$t + '}';
                            }
                        })).invoke());
                        tb.setLength(0);
                        state = 0;
                        continue;
                    }
                    sb.append(ch);
                    continue;
                }
                switch (state) {
                    case 1: {
                        sb.append((String)((Function0)types2.getOrDefault(String.valueOf(ch), new Function0<String>(ch){
                            final /* synthetic */ char $ch;
                            {
                                this.$ch = $ch;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return Intrinsics.stringPlus("%", Character.valueOf(this.$ch));
                            }
                        })).invoke());
                        state = 0;
                        continue block4;
                    }
                    case 2: {
                        tb.append(ch);
                        continue block4;
                    }
                }
                sb.append(ch);
            }
            String string3 = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string3, "sb.toString()");
            return string3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

