/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.ki.shell.plugins;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.ki.shell.BaseCommand;
import org.jetbrains.kotlinx.ki.shell.Command;
import org.jetbrains.kotlinx.ki.shell.Plugin;
import org.jetbrains.kotlinx.ki.shell.Shell;
import org.jetbrains.kotlinx.ki.shell.configuration.ReplConfiguration;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/ki/shell/plugins/PastePlugin;", "Lorg/jetbrains/kotlinx/ki/shell/Plugin;", "()V", "console", "Lorg/jline/reader/LineReader;", "getConsole", "()Lorg/jline/reader/LineReader;", "setConsole", "(Lorg/jline/reader/LineReader;)V", "pasteConsole", "getPasteConsole", "setPasteConsole", "repl", "Lorg/jetbrains/kotlinx/ki/shell/Shell;", "getRepl", "()Lorg/jetbrains/kotlinx/ki/shell/Shell;", "setRepl", "(Lorg/jetbrains/kotlinx/ki/shell/Shell;)V", "cleanUp", "", "init", "config", "Lorg/jetbrains/kotlinx/ki/shell/configuration/ReplConfiguration;", "Paste", "ki-shell"})
public final class PastePlugin
implements Plugin {
    public Shell repl;
    public LineReader console;
    public LineReader pasteConsole;

    @NotNull
    public final Shell getRepl() {
        Shell shell = this.repl;
        if (shell != null) {
            return shell;
        }
        Intrinsics.throwUninitializedPropertyAccessException("repl");
        return null;
    }

    public final void setRepl(@NotNull Shell shell) {
        Intrinsics.checkNotNullParameter(shell, "<set-?>");
        this.repl = shell;
    }

    @NotNull
    public final LineReader getConsole() {
        LineReader lineReader = this.console;
        if (lineReader != null) {
            return lineReader;
        }
        Intrinsics.throwUninitializedPropertyAccessException("console");
        return null;
    }

    public final void setConsole(@NotNull LineReader lineReader) {
        Intrinsics.checkNotNullParameter(lineReader, "<set-?>");
        this.console = lineReader;
    }

    @NotNull
    public final LineReader getPasteConsole() {
        LineReader lineReader = this.pasteConsole;
        if (lineReader != null) {
            return lineReader;
        }
        Intrinsics.throwUninitializedPropertyAccessException("pasteConsole");
        return null;
    }

    public final void setPasteConsole(@NotNull LineReader lineReader) {
        Intrinsics.checkNotNullParameter(lineReader, "<set-?>");
        this.pasteConsole = lineReader;
    }

    @Override
    public void init(@NotNull Shell repl2, @NotNull ReplConfiguration config) {
        Intrinsics.checkNotNullParameter(repl2, "repl");
        Intrinsics.checkNotNullParameter(config, "config");
        this.setRepl(repl2);
        this.setConsole(repl2.getReader());
        LineReader lineReader = repl2.getReaderBuilder().highlighter(this.getConsole().getHighlighter()).build();
        Intrinsics.checkNotNullExpressionValue(lineReader, "repl.readerBuilder.highl\u2026sole.highlighter).build()");
        this.setPasteConsole(lineReader);
        this.getPasteConsole().option(LineReader.Option.DISABLE_HIGHLIGHTER, this.getConsole().isSet(LineReader.Option.DISABLE_HIGHLIGHTER));
        this.getPasteConsole().option(LineReader.Option.DISABLE_EVENT_EXPANSION, true);
        this.getPasteConsole().setVariable("secondary-prompt-pattern", "");
        repl2.registerCommand(new Paste(config));
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void sayHello() {
        Plugin.DefaultImpls.sayHello(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\n\u0010\bR\u001b\u0010\r\u001a\u00020\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlinx/ki/shell/plugins/PastePlugin$Paste;", "Lorg/jetbrains/kotlinx/ki/shell/BaseCommand;", "conf", "Lorg/jetbrains/kotlinx/ki/shell/configuration/ReplConfiguration;", "(Lorg/jetbrains/kotlinx/ki/shell/plugins/PastePlugin;Lorg/jetbrains/kotlinx/ki/shell/configuration/ReplConfiguration;)V", "description", "", "getDescription", "()Ljava/lang/String;", "name", "getName", "name$delegate", "Lorg/jetbrains/kotlinx/ki/shell/configuration/ReplConfiguration$DelegateProvider;", "short", "getShort", "short$delegate", "execute", "Lorg/jetbrains/kotlinx/ki/shell/Command$Result;", "line", "ki-shell"})
    public final class Paste
    extends BaseCommand {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReplConfiguration.DelegateProvider name$delegate;
        @NotNull
        private final ReplConfiguration.DelegateProvider short$delegate;
        @NotNull
        private final String description;

        public Paste(ReplConfiguration conf) {
            Intrinsics.checkNotNullParameter(PastePlugin.this, "this$0");
            Intrinsics.checkNotNullParameter(conf, "conf");
            this.name$delegate = conf.get("paste");
            this.short$delegate = conf.get("p");
            this.description = "enter paste mode";
        }

        @Override
        @NotNull
        public String getName() {
            return (String)this.name$delegate.getValue(this, $$delegatedProperties[0]);
        }

        @Override
        @NotNull
        public String getShort() {
            return (String)this.short$delegate.getValue(this, $$delegatedProperties[1]);
        }

        @Override
        @NotNull
        public String getDescription() {
            return this.description;
        }

        @Override
        @NotNull
        public Command.Result execute(@NotNull String line) {
            Intrinsics.checkNotNullParameter(line, "line");
            String string2 = "// Entering paste mode (ctrl-D to finish)";
            System.out.println((Object)string2);
            StringBuilder buf = new StringBuilder();
            int lineCount = 0;
            try {
                while (true) {
                    String s = PastePlugin.this.getPasteConsole().readLine("");
                    StringBuilder stringBuilder2 = buf.append(s);
                    Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(value)");
                    StringBuilder stringBuilder3 = stringBuilder2.append('\n');
                    Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append('\\n')");
                    int n = lineCount;
                    lineCount = n + 1;
                }
            }
            catch (EndOfFileException s) {
                String string3 = buf.toString();
                Intrinsics.checkNotNullExpressionValue(string3, "buf.toString()");
                String code = string3;
                string3 = "// Exiting paste mode, now interpreting.";
                System.out.println((Object)string3);
                return new Command.Result.RunSnippets((Iterable<String>)CollectionsKt.listOf(code));
            }
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Paste.class, "name", "getName()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(Paste.class, "short", "getShort()Ljava/lang/String;", 0))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

