/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.extapi.psi.ASTDelegatePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclarationStub;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmSimpleNameBacktickChecker;", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "()V", "DANGEROUS_CHARS", "", "", "INVALID_CHARS", "getINVALID_CHARS", "()Ljava/util/Set;", "checkDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkIdentifier", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "checkNamed", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "reportIfNeeded", "name", "", "reportOn", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "frontend.java"})
public final class JvmSimpleNameBacktickChecker
implements IdentifierChecker {
    @NotNull
    public static final JvmSimpleNameBacktickChecker INSTANCE = new JvmSimpleNameBacktickChecker();
    @NotNull
    private static final Set<Character> INVALID_CHARS;
    @NotNull
    private static final Set<Character> DANGEROUS_CHARS;

    private JvmSimpleNameBacktickChecker() {
    }

    @NotNull
    public final Set<Character> getINVALID_CHARS() {
        return INVALID_CHARS;
    }

    @Override
    public void checkIdentifier(@NotNull KtSimpleNameExpression simpleNameExpression, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkNotNullParameter(simpleNameExpression, "simpleNameExpression");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        this.reportIfNeeded(simpleNameExpression.getReferencedName(), (Function0<? extends PsiElement>)new Function0<PsiElement>(simpleNameExpression){
            final /* synthetic */ KtSimpleNameExpression $simpleNameExpression;
            {
                this.$simpleNameExpression = $simpleNameExpression;
                super(0);
            }

            @Nullable
            public final PsiElement invoke() {
                return this.$simpleNameExpression.getIdentifier();
            }
        }, diagnosticHolder);
    }

    @Override
    public void checkDeclaration(@NotNull KtDeclaration declaration2, @NotNull DiagnosticSink diagnosticHolder) {
        ASTDelegatePsiElement it;
        boolean $i$f$forEach;
        Iterable<KtNamedDeclarationStub> $this$forEach$iv;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        if (declaration2 instanceof KtDestructuringDeclaration) {
            List<KtDestructuringDeclarationEntry> list2 = ((KtDestructuringDeclaration)declaration2).getEntries();
            Intrinsics.checkNotNullExpressionValue(list2, "declaration.entries");
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (KtNamedDeclarationStub element$iv : $this$forEach$iv) {
                it = (KtDestructuringDeclarationEntry)((Object)element$iv);
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)it), diagnosticHolder);
            }
        }
        if (declaration2 instanceof KtCallableDeclaration) {
            $this$forEach$iv = ((KtCallableDeclaration)declaration2).getValueParameters();
            Intrinsics.checkNotNullExpressionValue($this$forEach$iv, "declaration.valueParameters");
            $this$forEach$iv = $this$forEach$iv;
            $i$f$forEach = false;
            for (KtNamedDeclarationStub element$iv : $this$forEach$iv) {
                it = (KtParameter)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)it), diagnosticHolder);
            }
        }
        if (declaration2 instanceof KtTypeParameterListOwner) {
            $this$forEach$iv = ((KtTypeParameterListOwner)declaration2).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue($this$forEach$iv, "declaration.typeParameters");
            $this$forEach$iv = $this$forEach$iv;
            $i$f$forEach = false;
            for (KtNamedDeclarationStub element$iv : $this$forEach$iv) {
                it = (KtTypeParameter)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)it), diagnosticHolder);
            }
        }
        if (declaration2 instanceof KtNamedDeclaration) {
            this.checkNamed((KtNamedDeclaration)declaration2, diagnosticHolder);
        }
    }

    private final void checkNamed(KtNamedDeclaration declaration2, DiagnosticSink diagnosticHolder) {
        String string2;
        String string3 = declaration2.getName();
        if (string3 == null) {
            return;
        }
        String name2 = string2 = string3;
        this.reportIfNeeded(name2, (Function0<? extends PsiElement>)new Function0<PsiElement>(declaration2){
            final /* synthetic */ KtNamedDeclaration $declaration;
            {
                this.$declaration = $declaration;
                super(0);
            }

            @Nullable
            public final PsiElement invoke() {
                PsiElement psiElement = this.$declaration.getNameIdentifier();
                return psiElement == null ? (PsiElement)this.$declaration : psiElement;
            }
        }, diagnosticHolder);
    }

    private final void reportIfNeeded(String name2, Function0<? extends PsiElement> reportOn, DiagnosticSink diagnosticHolder) {
        Object object = KtPsiUtil.unquoteIdentifier(name2);
        Intrinsics.checkNotNullExpressionValue(object, "unquoteIdentifier(name)");
        String text2 = object;
        if (((CharSequence)text2).length() == 0) {
            object = reportOn.invoke();
            if (object == null) {
                return;
            }
            diagnosticHolder.report(Errors.INVALID_CHARACTERS.on((PsiElement)object, "should not be empty"));
        } else {
            boolean bl;
            char it;
            char element$iv;
            int n;
            Object object2;
            boolean $i$f$any;
            Object $this$any$iv;
            block10: {
                $this$any$iv = text2;
                $i$f$any = false;
                object2 = $this$any$iv;
                for (n = 0; n < object2.length(); ++n) {
                    element$iv = object2.charAt(n);
                    it = element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.getINVALID_CHARS().contains(Character.valueOf(it))) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
            if (bl) {
                $this$any$iv = reportOn.invoke();
                if ($this$any$iv == null) {
                    return;
                }
                diagnosticHolder.report(Errors.INVALID_CHARACTERS.on((PsiElement)$this$any$iv, Intrinsics.stringPlus("contains illegal characters: ", CollectionsKt.joinToString$default(CollectionsKt.intersect((Iterable)INVALID_CHARS, (Iterable)StringsKt.toSet(text2)), "", null, null, 0, null, null, 62, null))));
            } else {
                boolean bl3;
                block11: {
                    $this$any$iv = text2;
                    $i$f$any = false;
                    object2 = $this$any$iv;
                    for (n = 0; n < object2.length(); ++n) {
                        element$iv = object2.charAt(n);
                        it = element$iv;
                        boolean bl4 = false;
                        if (!DANGEROUS_CHARS.contains(Character.valueOf(it))) continue;
                        bl3 = true;
                        break block11;
                    }
                    bl3 = false;
                }
                if (bl3) {
                    object = reportOn.invoke();
                    if (object == null) {
                        return;
                    }
                    diagnosticHolder.report(ErrorsJvm.DANGEROUS_CHARACTERS.on((PsiElement)object, CollectionsKt.joinToString$default(CollectionsKt.intersect((Iterable)DANGEROUS_CHARS, (Iterable)StringsKt.toSet(text2)), "", null, null, 0, null, null, 62, null)));
                }
            }
        }
    }

    static {
        Character[] characterArray = new Character[]{Character.valueOf('.'), Character.valueOf(';'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('/'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('\\')};
        INVALID_CHARS = SetsKt.setOf(characterArray);
        characterArray = new Character[]{Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('\"'), Character.valueOf('|'), Character.valueOf('%')};
        DANGEROUS_CHARS = SetsKt.setOf(characterArray);
    }
}

