/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a,\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u0017\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u001a\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u0004\u001a\n\u0010\u001b\u001a\u00020\u0019*\u00020\u001c\u001a\u0014\u0010\u001d\u001a\u00020\u0019*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0017H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"ALLOWED_SCOPE_KINDS", "", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeKind;", "COROUTINE_CONTEXT_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getCOROUTINE_CONTEXT_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "checkCoroutinesFeature", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "checkRestrictsSuspension", "enclosingSuspendCallableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "findEnclosingSuspendFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isBuiltInCoroutineContext", "", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isRestrictsSuspensionReceiver", "Lorg/jetbrains/kotlin/types/KotlinType;", "isScopeForDefaultParameterValuesOf", "Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;", "enclosingSuspendFunction", "frontend"})
public final class CoroutineCallCheckerKt {
    @NotNull
    private static final FqName COROUTINE_CONTEXT_FQ_NAME;
    @NotNull
    private static final Set<LexicalScopeKind> ALLOWED_SCOPE_KINDS;

    @NotNull
    public static final FqName getCOROUTINE_CONTEXT_FQ_NAME() {
        return COROUTINE_CONTEXT_FQ_NAME;
    }

    public static final boolean isBuiltInCoroutineContext(@NotNull FqName $this$isBuiltInCoroutineContext) {
        Intrinsics.checkNotNullParameter($this$isBuiltInCoroutineContext, "<this>");
        return Intrinsics.areEqual($this$isBuiltInCoroutineContext, StandardNames.COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier("coroutineContext")));
    }

    public static final boolean isBuiltInCoroutineContext(@NotNull FunctionDescriptor $this$isBuiltInCoroutineContext) {
        boolean bl;
        PropertyGetterDescriptor propertyGetterDescriptor;
        Intrinsics.checkNotNullParameter($this$isBuiltInCoroutineContext, "<this>");
        PropertyGetterDescriptor propertyGetterDescriptor2 = propertyGetterDescriptor = $this$isBuiltInCoroutineContext instanceof PropertyGetterDescriptor ? (PropertyGetterDescriptor)$this$isBuiltInCoroutineContext : null;
        if (propertyGetterDescriptor == null) {
            bl = false;
        } else {
            PropertyDescriptor propertyDescriptor = propertyGetterDescriptor.getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "correspondingProperty");
            FqName fqName2 = DescriptorUtilsKt.getFqNameSafe(propertyDescriptor);
            bl = CoroutineCallCheckerKt.isBuiltInCoroutineContext(fqName2);
        }
        return bl;
    }

    public static final boolean isBuiltInCoroutineContext(@NotNull PropertyDescriptor $this$isBuiltInCoroutineContext) {
        Intrinsics.checkNotNullParameter($this$isBuiltInCoroutineContext, "<this>");
        return CoroutineCallCheckerKt.isBuiltInCoroutineContext(DescriptorUtilsKt.getFqNameSafe($this$isBuiltInCoroutineContext));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final FunctionDescriptor findEnclosingSuspendFunction(@NotNull CallCheckerContext context) {
        block7: {
            Intrinsics.checkNotNullParameter(context, "context");
            $this$firstOrNull$iv = ScopeUtilsKt.getParentsWithSelf(context.getScope());
            $i$f$firstOrNull = false;
            var4_4 = $this$firstOrNull$iv.iterator();
            while (var4_4.hasNext()) {
                it = element$iv = var4_4.next();
                $i$a$-firstOrNull-CoroutineCallCheckerKt$findEnclosingSuspendFunction$1 = false;
                if (!(it instanceof LexicalScope) || !CoroutineCallCheckerKt.ALLOWED_SCOPE_KINDS.contains((Object)((LexicalScope)it).getKind())) ** GOTO lbl-1000
                $this$safeAs$iv = ((LexicalScope)it).getOwnerDescriptor();
                $i$f$safeAs = false;
                v0 = $this$safeAs$iv;
                if (!(v0 instanceof FunctionDescriptor)) {
                    v0 = null;
                }
                if ((var10_13 = (FunctionDescriptor)v0) == null ? false : var10_13.isSuspend() == true) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                v2 = element$iv;
                break block7;
            }
            v2 = null;
        }
        var1_14 = v2;
        if (var1_14 == null) {
            v3 = null;
        } else {
            $this$cast$iv = var1_14;
            $i$f$cast = false;
            var2_1 = (LexicalScope)$this$cast$iv;
            $this$cast$iv = var3_3 = var2_1.getOwnerDescriptor();
            $i$f$cast = false;
            v4 = $this$cast$iv;
            if (v4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            }
            v3 = (FunctionDescriptor)v4;
        }
        return v3;
    }

    private static final boolean isScopeForDefaultParameterValuesOf(HierarchicalScope $this$isScopeForDefaultParameterValuesOf, FunctionDescriptor enclosingSuspendFunction) {
        return $this$isScopeForDefaultParameterValuesOf instanceof LexicalScope && ((LexicalScope)$this$isScopeForDefaultParameterValuesOf).getKind() == LexicalScopeKind.DEFAULT_VALUE && Intrinsics.areEqual(((LexicalScope)$this$isScopeForDefaultParameterValuesOf).getOwnerDescriptor(), enclosingSuspendFunction);
    }

    public static final void checkCoroutinesFeature(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull DiagnosticSink diagnosticHolder, @NotNull PsiElement reportOn) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        if (languageVersionSettings.supportsFeature(LanguageFeature.ReleaseCoroutines)) {
            if (languageVersionSettings.getApiVersion().compareTo(ApiVersion.KOTLIN_1_3) < 0) {
                diagnosticHolder.report(Errors.UNSUPPORTED.on(reportOn, "cannot use release coroutines with api version less than 1.3"));
            }
            return;
        }
        Pair<LanguageFeature, LanguageVersionSettings> diagnosticData = TuplesKt.to(LanguageFeature.Coroutines, languageVersionSettings);
        LanguageFeature.State state = languageVersionSettings.getFeatureSupport(LanguageFeature.Coroutines);
        int n = WhenMappings.$EnumSwitchMapping$0[state.ordinal()];
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                diagnosticHolder.report(Errors.EXPERIMENTAL_FEATURE_WARNING.on(reportOn, diagnosticData));
                break;
            }
            case 3: {
                diagnosticHolder.report(Errors.EXPERIMENTAL_FEATURE_ERROR.on(reportOn, diagnosticData));
                break;
            }
            case 4: {
                diagnosticHolder.report(Errors.UNSUPPORTED_FEATURE.on(reportOn, diagnosticData));
            }
        }
    }

    public static final boolean isRestrictsSuspensionReceiver(@NotNull KotlinType $this$isRestrictsSuspensionReceiver) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter($this$isRestrictsSuspensionReceiver, "<this>");
            Iterable $this$any$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf($this$isRestrictsSuspensionReceiver), (Iterable)TypeUtilsKt.supertypes($this$isRestrictsSuspensionReceiver));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl3 = false;
                    ClassifierDescriptor classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
                    if (classifierDescriptor == null) {
                        bl2 = false;
                    } else {
                        Annotations annotations2 = classifierDescriptor.getAnnotations();
                        FqName fqName2 = StandardNames.COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier("RestrictsSuspension"));
                        Intrinsics.checkNotNullExpressionValue(fqName2, "COROUTINES_PACKAGE_FQ_NA\u2026r(\"RestrictsSuspension\"))");
                        bl2 = annotations2.hasAnnotation(fqName2);
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final void checkRestrictsSuspension(CallableDescriptor enclosingSuspendCallableDescriptor, ResolvedCall<?> resolvedCall2, PsiElement reportOn, CallCheckerContext context2) {
        ReceiverParameterDescriptor receiverParameterDescriptor = enclosingSuspendCallableDescriptor.getExtensionReceiverParameter();
        ReceiverValue enclosingSuspendExtensionReceiverValue = receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getValue();
        ReceiverParameterDescriptor receiverParameterDescriptor2 = enclosingSuspendCallableDescriptor.getDispatchReceiverParameter();
        ReceiverValue enclosingSuspendDispatchReceiverValue = receiverParameterDescriptor2 == null ? null : receiverParameterDescriptor2.getValue();
        Object object = new ReceiverValue[]{resolvedCall2.getDispatchReceiver(), resolvedCall2.getExtensionReceiver()};
        List<ReceiverValue> receivers = CollectionsKt.listOfNotNull(object);
        for (ReceiverValue receiverValue : receivers) {
            ReceiverValue receiverValue2;
            Intrinsics.checkNotNullExpressionValue(receiverValue, "receiverValue");
            if (!CoroutineCallCheckerKt.checkRestrictsSuspension$isRestrictsSuspensionReceiver(receiverValue) || ((receiverValue2 = enclosingSuspendExtensionReceiverValue) == null ? false : CoroutineCallCheckerKt.checkRestrictsSuspension$sameInstance(receiverValue2, context2, receiverValue)) || ((receiverValue2 = enclosingSuspendDispatchReceiverValue) == null ? false : CoroutineCallCheckerKt.checkRestrictsSuspension$sameInstance(receiverValue2, context2, receiverValue))) continue;
            CoroutineCallCheckerKt.checkRestrictsSuspension$reportError(context2, reportOn);
            return;
        }
        object = enclosingSuspendExtensionReceiverValue;
        if (!(object == null ? false : CoroutineCallCheckerKt.checkRestrictsSuspension$isRestrictsSuspensionReceiver((ReceiverValue)object))) {
            return;
        }
        if (CoroutineCallCheckerKt.checkRestrictsSuspension$sameInstance(enclosingSuspendExtensionReceiverValue, context2, resolvedCall2.getDispatchReceiver())) {
            return;
        }
        if (CoroutineCallCheckerKt.checkRestrictsSuspension$sameInstance(enclosingSuspendExtensionReceiverValue, context2, resolvedCall2.getExtensionReceiver())) {
            ReceiverParameterDescriptor receiverParameterDescriptor3 = resolvedCall2.getCandidateDescriptor().getExtensionReceiverParameter();
            Intrinsics.checkNotNull(receiverParameterDescriptor3);
            object = receiverParameterDescriptor3.getValue();
            Intrinsics.checkNotNullExpressionValue(object, "resolvedCall.candidateDe\u2026ReceiverParameter!!.value");
            if (CoroutineCallCheckerKt.checkRestrictsSuspension$isRestrictsSuspensionReceiver((ReceiverValue)object)) {
                return;
            }
        }
        CoroutineCallCheckerKt.checkRestrictsSuspension$reportError(context2, reportOn);
    }

    private static final boolean checkRestrictsSuspension$isRestrictsSuspensionReceiver(ReceiverValue $this$checkRestrictsSuspension_u24isRestrictsSuspensionReceiver) {
        KotlinType kotlinType = $this$checkRestrictsSuspension_u24isRestrictsSuspensionReceiver.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "type");
        return CoroutineCallCheckerKt.isRestrictsSuspensionReceiver(kotlinType);
    }

    private static final boolean checkRestrictsSuspension$sameInstance(ReceiverValue $this$checkRestrictsSuspension_u24sameInstance, CallCheckerContext $context, ReceiverValue other) {
        ReceiverParameterDescriptor receiverParameterDescriptor;
        DeclarationDescriptor declarationDescriptor;
        if (other == null) {
            return false;
        }
        if ($this$checkRestrictsSuspension_u24sameInstance.getOriginal() == other.getOriginal()) {
            return true;
        }
        Object object = other instanceof ExpressionReceiver ? (ExpressionReceiver)other : null;
        KtExpression ktExpression = object == null ? null : object.getExpression();
        KtThisExpression ktThisExpression = ktExpression instanceof KtThisExpression ? (KtThisExpression)ktExpression : null;
        KtReferenceExpression referenceExpression = ktThisExpression == null ? null : ktThisExpression.getInstanceReference();
        if ((ktExpression = referenceExpression) == null) {
            declarationDescriptor = null;
        } else {
            Object it = object = ktExpression;
            boolean bl = false;
            declarationDescriptor = (DeclarationDescriptor)$context.getTrace().get(BindingContext.REFERENCE_TARGET, referenceExpression);
        }
        DeclarationDescriptor referenceTarget = declarationDescriptor;
        object = referenceTarget;
        ReceiverValue referenceReceiverValue = object instanceof CallableDescriptor ? ((receiverParameterDescriptor = ((CallableDescriptor)referenceTarget).getExtensionReceiverParameter()) == null ? null : receiverParameterDescriptor.getValue()) : (object instanceof ClassDescriptor ? ((ClassDescriptor)referenceTarget).getThisAsReceiverParameter().getValue() : null);
        return $this$checkRestrictsSuspension_u24sameInstance == referenceReceiverValue;
    }

    private static final void checkRestrictsSuspension$reportError(CallCheckerContext $context, PsiElement $reportOn) {
        $context.getTrace().report(Errors.ILLEGAL_RESTRICTED_SUSPENDING_FUNCTION_CALL.on($reportOn));
    }

    public static final /* synthetic */ void access$checkRestrictsSuspension(CallableDescriptor enclosingSuspendCallableDescriptor, ResolvedCall resolvedCall2, PsiElement reportOn, CallCheckerContext context2) {
        CoroutineCallCheckerKt.checkRestrictsSuspension(enclosingSuspendCallableDescriptor, resolvedCall2, reportOn, context2);
    }

    public static final /* synthetic */ boolean access$isScopeForDefaultParameterValuesOf(HierarchicalScope $receiver, FunctionDescriptor enclosingSuspendFunction) {
        return CoroutineCallCheckerKt.isScopeForDefaultParameterValuesOf($receiver, enclosingSuspendFunction);
    }

    static {
        LexicalScopeKind[] lexicalScopeKindArray = StandardNames.COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier("coroutineContext"));
        Intrinsics.checkNotNullExpressionValue(lexicalScopeKindArray, "COROUTINES_PACKAGE_FQ_NA\u2026fier(\"coroutineContext\"))");
        COROUTINE_CONTEXT_FQ_NAME = lexicalScopeKindArray;
        lexicalScopeKindArray = new LexicalScopeKind[]{LexicalScopeKind.FUNCTION_INNER_SCOPE, LexicalScopeKind.FUNCTION_HEADER_FOR_DESTRUCTURING};
        ALLOWED_SCOPE_KINDS = SetsKt.setOf(lexicalScopeKindArray);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LanguageFeature.State.values().length];
            nArray[LanguageFeature.State.ENABLED.ordinal()] = 1;
            nArray[LanguageFeature.State.ENABLED_WITH_WARNING.ordinal()] = 2;
            nArray[LanguageFeature.State.ENABLED_WITH_ERROR.ordinal()] = 3;
            nArray[LanguageFeature.State.DISABLED.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

