/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrBreakImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrContinueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDoWhileLoopImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrWhileLoopImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.ArgumentsGenerationUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.CallGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.ErrorExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.Generator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilder;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilderKt;
import org.jetbrains.kotlin.psi2ir.intermediate.VariableLValue;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00062\u0006\u0010\"\u001a\u00020#H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020#H\u0002\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/LoopExpressionGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "findParentLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "ktExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "targetLabel", "", "ktWithLabel", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "generateBreak", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ktBreak", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "generateContinue", "ktContinue", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "generateDoWhileLoop", "ktDoWhile", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "generateDoWhileLoopBody", "ktLoopBody", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "generateForLoop", "ktFor", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "generateWhileLoop", "ktWhile", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "generateWhileLoopBody", "getLoop", "ktLoop", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "getLoopLabel", "ir.psi2ir"})
public final class LoopExpressionGenerator
extends StatementGeneratorExtension {
    public LoopExpressionGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkNotNullParameter(statementGenerator, "statementGenerator");
        super(statementGenerator);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrExpression generateWhileLoop(@NotNull KtWhileExpression ktWhile) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(ktWhile, "ktWhile");
        IrWhileLoopImpl irLoop2 = new IrWhileLoopImpl(PsiUtilsKt.getStartOffsetSkippingComments(ktWhile), PsiUtilsKt.getEndOffset(ktWhile), this.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.WHILE_LOOP.INSTANCE);
        KtExpression ktExpression = ktWhile.getCondition();
        Intrinsics.checkNotNull(ktExpression);
        KtExpression ktExpression2 = ktExpression;
        Intrinsics.checkNotNullExpressionValue(ktExpression2, "ktWhile.condition!!");
        irLoop2.setCondition(this.genExpr(ktExpression2));
        this.getStatementGenerator().getBodyGenerator().putLoop(ktWhile, irLoop2);
        irLoop2.setLabel(this.getLoopLabel(ktWhile));
        IrWhileLoopImpl irWhileLoopImpl = irLoop2;
        ktExpression2 = ktWhile.getBody();
        if (ktExpression2 == null) {
            irExpression = null;
        } else {
            void ktLoopBody;
            KtExpression ktExpression3;
            KtExpression ktExpression4 = ktExpression3 = ktExpression2;
            IrWhileLoopImpl irWhileLoopImpl2 = irWhileLoopImpl;
            boolean bl = false;
            IrExpression irExpression2 = ktLoopBody instanceof KtBlockExpression ? this.generateWhileLoopBody((KtBlockExpression)ktLoopBody) : this.genExpr((KtExpression)ktLoopBody);
            irWhileLoopImpl = irWhileLoopImpl2;
            irExpression = irExpression2;
        }
        irWhileLoopImpl.setBody(irExpression);
        return irLoop2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrExpression generateDoWhileLoop(@NotNull KtDoWhileExpression ktDoWhile) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(ktDoWhile, "ktDoWhile");
        IrDoWhileLoopImpl irLoop2 = new IrDoWhileLoopImpl(PsiUtilsKt.getStartOffsetSkippingComments(ktDoWhile), PsiUtilsKt.getEndOffset(ktDoWhile), this.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.DO_WHILE_LOOP.INSTANCE);
        this.getStatementGenerator().getBodyGenerator().putLoop(ktDoWhile, irLoop2);
        irLoop2.setLabel(this.getLoopLabel(ktDoWhile));
        IrDoWhileLoopImpl irDoWhileLoopImpl = irLoop2;
        Object object = ktDoWhile.getBody();
        if (object == null) {
            irExpression = null;
        } else {
            void ktLoopBody;
            KtExpression ktExpression;
            KtExpression ktExpression2 = ktExpression = object;
            IrDoWhileLoopImpl irDoWhileLoopImpl2 = irDoWhileLoopImpl;
            boolean bl = false;
            IrExpression irExpression2 = ktLoopBody instanceof KtBlockExpression ? this.generateDoWhileLoopBody((KtBlockExpression)ktLoopBody) : this.genExpr((KtExpression)ktLoopBody);
            irDoWhileLoopImpl = irDoWhileLoopImpl2;
            irExpression = irExpression2;
        }
        irDoWhileLoopImpl.setBody(irExpression);
        KtExpression ktExpression = ktDoWhile.getCondition();
        Intrinsics.checkNotNull(ktExpression);
        object = ktExpression;
        Intrinsics.checkNotNullExpressionValue(object, "ktDoWhile.condition!!");
        irLoop2.setCondition(this.genExpr((KtExpression)object));
        Object $this$generateDoWhileLoop_u24lambda_u2d2 = object = new IrBlockImpl(PsiUtilsKt.getStartOffsetSkippingComments(ktDoWhile), PsiUtilsKt.getEndOffset(ktDoWhile), this.getContext().getIrBuiltIns().getUnitType(), null, 8, null);
        boolean bl = false;
        ((IrContainerExpression)$this$generateDoWhileLoop_u24lambda_u2d2).getStatements().add(irLoop2);
        return (IrExpression)object;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateWhileLoopBody(KtBlockExpression ktLoopBody) {
        Collection<IrStatement> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        int n = PsiUtilsKt.getStartOffsetSkippingComments(ktLoopBody);
        int n2 = PsiUtilsKt.getEndOffset(ktLoopBody);
        IrType irType = this.getContext().getIrBuiltIns().getUnitType();
        Iterable<KtExpression> iterable = ktLoopBody.getStatements();
        Intrinsics.checkNotNullExpressionValue(iterable, "ktLoopBody.statements");
        iterable = iterable;
        IrStatementOrigin irStatementOrigin = null;
        IrType irType2 = irType;
        int n3 = n2;
        int n4 = n;
        boolean $i$f$map = false;
        void var4_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtExpression ktExpression = (KtExpression)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            IrStatement irStatement = this.genStmt((KtExpression)it);
            collection.add(irStatement);
        }
        Collection<IrStatement> collection2 = collection = (List)destination$iv$iv;
        IrStatementOrigin irStatementOrigin2 = irStatementOrigin;
        IrType irType3 = irType2;
        int n5 = n3;
        int n6 = n4;
        return new IrBlockImpl(n6, n5, irType3, irStatementOrigin2, (List<? extends IrStatement>)collection2);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateDoWhileLoopBody(KtBlockExpression ktLoopBody) {
        Collection<IrStatement> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        int n = PsiUtilsKt.getStartOffsetSkippingComments(ktLoopBody);
        int n2 = PsiUtilsKt.getEndOffset(ktLoopBody);
        IrType irType = this.getContext().getIrBuiltIns().getUnitType();
        Iterable<KtExpression> iterable = ktLoopBody.getStatements();
        Intrinsics.checkNotNullExpressionValue(iterable, "ktLoopBody.statements");
        iterable = iterable;
        IrStatementOrigin irStatementOrigin = null;
        IrType irType2 = irType;
        int n3 = n2;
        int n4 = n;
        boolean $i$f$map = false;
        void var4_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtExpression ktExpression = (KtExpression)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            IrStatement irStatement = this.genStmt((KtExpression)it);
            collection.add(irStatement);
        }
        Collection<IrStatement> collection2 = collection = (List)destination$iv$iv;
        IrStatementOrigin irStatementOrigin2 = irStatementOrigin;
        IrType irType3 = irType2;
        int n5 = n3;
        int n6 = n4;
        return new IrCompositeImpl(n6, n5, irType3, irStatementOrigin2, (List<? extends IrStatement>)collection2);
    }

    @NotNull
    public final IrExpression generateBreak(@NotNull KtBreakExpression ktBreak) {
        String string2;
        Intrinsics.checkNotNullParameter(ktBreak, "ktBreak");
        IrExpression irExpression = this.findParentLoop(ktBreak);
        if (irExpression == null) {
            return new ErrorExpressionGenerator(this.getStatementGenerator()).generateErrorExpression(ktBreak, new RuntimeException(Intrinsics.stringPlus("Loop not found for break expression: ", ktBreak.getText())));
        }
        IrLoop parentLoop = irExpression;
        IrExpression $this$generateBreak_u24lambda_u2d6 = irExpression = new IrBreakImpl(PsiUtilsKt.getStartOffsetSkippingComments(ktBreak), PsiUtilsKt.getEndOffset(ktBreak), this.getContext().getIrBuiltIns().getNothingType(), parentLoop);
        boolean bl = false;
        String string3 = string2 = parentLoop.getLabel();
        IrExpression irExpression2 = $this$generateBreak_u24lambda_u2d6;
        boolean bl2 = false;
        boolean bl3 = ktBreak.getLabelName() != null;
        ((IrBreakContinue)irExpression2).setLabel(bl3 ? string2 : null);
        return irExpression;
    }

    @NotNull
    public final IrExpression generateContinue(@NotNull KtContinueExpression ktContinue) {
        String string2;
        Intrinsics.checkNotNullParameter(ktContinue, "ktContinue");
        IrExpression irExpression = this.findParentLoop(ktContinue);
        if (irExpression == null) {
            return new ErrorExpressionGenerator(this.getStatementGenerator()).generateErrorExpression(ktContinue, new RuntimeException(Intrinsics.stringPlus("Loop not found for continue expression: ", ktContinue.getText())));
        }
        IrLoop parentLoop = irExpression;
        IrExpression $this$generateContinue_u24lambda_u2d8 = irExpression = new IrContinueImpl(PsiUtilsKt.getStartOffsetSkippingComments(ktContinue), PsiUtilsKt.getEndOffset(ktContinue), this.getContext().getIrBuiltIns().getNothingType(), parentLoop);
        boolean bl = false;
        String string3 = string2 = parentLoop.getLabel();
        IrExpression irExpression2 = $this$generateContinue_u24lambda_u2d8;
        boolean bl2 = false;
        boolean bl3 = ktContinue.getLabelName() != null;
        ((IrBreakContinue)irExpression2).setLabel(bl3 ? string2 : null);
        return irExpression;
    }

    private final String getLoopLabel(KtLoopExpression ktLoop) {
        PsiElement psiElement = ktLoop.getParent();
        KtLabeledExpression ktLabeledExpression = psiElement instanceof KtLabeledExpression ? (KtLabeledExpression)psiElement : null;
        return ktLabeledExpression == null ? null : ktLabeledExpression.getLabelName();
    }

    private final IrLoop findParentLoop(KtExpressionWithLabel ktWithLabel) {
        return this.findParentLoop(ktWithLabel, ktWithLabel.getLabelName());
    }

    private final IrLoop findParentLoop(KtExpression ktExpression, String targetLabel) {
        KtExpression finger = ktExpression;
        block0: while (finger != null) {
            IrLoop $this$getParentOfType$iv;
            PsiElement psiElement = finger;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            finger = PsiTreeUtil.getParentOfType((PsiElement)((Object)$this$getParentOfType$iv), KtLoopExpression.class, strict$iv);
            if (finger == null) break;
            if (targetLabel == null) {
                $this$getParentOfType$iv = this.getLoop((KtLoopExpression)finger);
                if ($this$getParentOfType$iv == null) continue;
                return $this$getParentOfType$iv;
            }
            PsiElement parent2 = ((KtLoopExpression)finger).getParent();
            while (parent2 instanceof KtLabeledExpression) {
                String label;
                Intrinsics.checkNotNull(((KtLabeledExpression)parent2).getLabelName());
                if (Intrinsics.areEqual(targetLabel, label)) {
                    IrLoop irLoop2 = this.getLoop((KtLoopExpression)finger);
                    if (irLoop2 == null) continue block0;
                    return irLoop2;
                }
                parent2 = ((KtLabeledExpression)parent2).getParent();
            }
        }
        return null;
    }

    private final IrLoop getLoop(KtLoopExpression ktLoop) {
        return this.getStatementGenerator().getBodyGenerator().getLoop(ktLoop);
    }

    @NotNull
    public final IrExpression generateForLoop(@NotNull KtForExpression ktFor) {
        IrVariable irVariable2;
        Intrinsics.checkNotNullParameter(ktFor, "ktFor");
        KtParameter ktLoopParameter = ktFor.getLoopParameter();
        KtDestructuringDeclaration ktLoopDestructuringDeclaration = ktFor.getDestructuringDeclaration();
        if (ktLoopParameter == null && ktLoopDestructuringDeclaration == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus("Either loopParameter or destructuringParameter should be present:\n", ktFor.getText()));
        }
        KtExpression ktExpression = ktFor.getLoopRange();
        Intrinsics.checkNotNull(ktExpression);
        KtExpression ktExpression2 = ktExpression;
        Intrinsics.checkNotNullExpressionValue(ktExpression2, "ktFor.loopRange!!");
        KtExpression ktLoopRange = ktExpression2;
        KtExpression ktForBody = ktFor.getBody();
        Generator generator2 = this;
        WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL;
        Intrinsics.checkNotNullExpressionValue(writableSlice, "LOOP_RANGE_ITERATOR_RESOLVED_CALL");
        ResolvedCall iteratorResolvedCall = (ResolvedCall)GeneratorKt.getOrFail(generator2, writableSlice, ktLoopRange);
        Generator generator3 = this;
        WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice2 = BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL;
        Intrinsics.checkNotNullExpressionValue(writableSlice2, "LOOP_RANGE_HAS_NEXT_RESOLVED_CALL");
        ResolvedCall hasNextResolvedCall = (ResolvedCall)GeneratorKt.getOrFail(generator3, writableSlice2, ktLoopRange);
        Generator generator4 = this;
        WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice3 = BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL;
        Intrinsics.checkNotNullExpressionValue(writableSlice3, "LOOP_RANGE_NEXT_RESOLVED_CALL");
        ResolvedCall nextResolvedCall = (ResolvedCall)GeneratorKt.getOrFail(generator4, writableSlice3, ktLoopRange);
        CallGenerator callGenerator = new CallGenerator(this.getStatementGenerator());
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments(ktFor);
        int endOffset = PsiUtilsKt.getEndOffset(ktFor);
        IrBlockImpl irForBlock = new IrBlockImpl(startOffset, endOffset, this.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.FOR_LOOP.INSTANCE);
        StatementGenerator statementGenerator = this.getStatementGenerator();
        Intrinsics.checkNotNullExpressionValue(iteratorResolvedCall, "iteratorResolvedCall");
        CallBuilder iteratorCall = ArgumentsGenerationUtilsKt.pregenerateCall(statementGenerator, iteratorResolvedCall);
        IrExpression irIteratorCall = CallGeneratorKt.generateCall(callGenerator, ktLoopRange, iteratorCall, (IrStatementOrigin)IrStatementOrigin.FOR_LOOP_ITERATOR.INSTANCE);
        IrVariable irIterator = Scope.createTemporaryVariable$default(this.getScope(), irIteratorCall, "iterator", false, IrDeclarationOrigin.FOR_LOOP_ITERATOR.INSTANCE, null, 20, null);
        VariableLValue iteratorValue = new VariableLValue(this.getContext(), irIterator, null, 4, null);
        irForBlock.getStatements().add(irIterator);
        IrWhileLoopImpl irInnerWhile = new IrWhileLoopImpl(startOffset, endOffset, this.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.FOR_LOOP_INNER_WHILE.INSTANCE);
        irInnerWhile.setLabel(this.getLoopLabel(ktFor));
        this.getStatementGenerator().getBodyGenerator().putLoop(ktFor, irInnerWhile);
        irForBlock.getStatements().add(irInnerWhile);
        StatementGenerator statementGenerator2 = this.getStatementGenerator();
        Intrinsics.checkNotNullExpressionValue(hasNextResolvedCall, "hasNextResolvedCall");
        CallBuilder hasNextCall = ArgumentsGenerationUtilsKt.pregenerateCall(statementGenerator2, hasNextResolvedCall);
        CallBuilderKt.setExplicitReceiverValue(hasNextCall, iteratorValue);
        IrExpression irHasNextCall = CallGeneratorKt.generateCall(callGenerator, ktLoopRange, hasNextCall, (IrStatementOrigin)IrStatementOrigin.FOR_LOOP_HAS_NEXT.INSTANCE);
        irInnerWhile.setCondition(irHasNextCall);
        IrBlockImpl irInnerBody = new IrBlockImpl(startOffset, endOffset, this.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.FOR_LOOP_INNER_WHILE.INSTANCE);
        irInnerWhile.setBody(irInnerBody);
        StatementGenerator statementGenerator3 = this.getStatementGenerator();
        Intrinsics.checkNotNullExpressionValue(nextResolvedCall, "nextResolvedCall");
        CallBuilder nextCall = ArgumentsGenerationUtilsKt.pregenerateCall(statementGenerator3, nextResolvedCall);
        CallBuilderKt.setExplicitReceiverValue(nextCall, iteratorValue);
        IrExpression irNextCall = CallGeneratorKt.generateCall(callGenerator, ktLoopRange, nextCall, (IrStatementOrigin)IrStatementOrigin.FOR_LOOP_NEXT.INSTANCE);
        if (ktLoopParameter != null && ktLoopDestructuringDeclaration == null) {
            Generator generator5 = this;
            Object object = BindingContext.VALUE_PARAMETER;
            Intrinsics.checkNotNullExpressionValue(object, "VALUE_PARAMETER");
            VariableDescriptor loopParameter = (VariableDescriptor)GeneratorKt.getOrFail(generator5, (ReadOnlySlice)object, ktLoopParameter);
            SymbolTable symbolTable = this.getContext().getSymbolTable();
            int n = PsiUtilsKt.getStartOffsetSkippingComments(ktLoopParameter);
            int n2 = PsiUtilsKt.getEndOffset(ktLoopParameter);
            IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.FOR_LOOP_VARIABLE.INSTANCE;
            Intrinsics.checkNotNullExpressionValue(loopParameter, "loopParameter");
            object = loopParameter.getType();
            Intrinsics.checkNotNullExpressionValue(object, "loopParameter.type");
            irVariable2 = symbolTable.declareVariable(n, n2, irDeclarationOrigin, loopParameter, this.toIrType((KotlinType)object), irNextCall);
        } else {
            irVariable2 = Scope.createTemporaryVariable$default(this.getScope(), irNextCall, "loop_parameter", false, null, null, 28, null);
        }
        IrVariable irLoopParameter = irVariable2;
        irInnerBody.getStatements().add(irLoopParameter);
        if (ktLoopDestructuringDeclaration != null) {
            this.getStatementGenerator().declareComponentVariablesInBlock(ktLoopDestructuringDeclaration, irInnerBody, new VariableLValue(this.getContext(), irLoopParameter, null, 4, null));
        }
        if (ktForBody != null) {
            irInnerBody.getStatements().add(this.genExpr(ktForBody));
        }
        return irForBlock;
    }
}

