/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.util.xml;

import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class Xpp3DomBuilder {
    public static Xpp3Dom build(XmlPullParser parser) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(parser, true);
    }

    public static Xpp3Dom build(XmlPullParser parser, boolean trim) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(parser, trim, null);
    }

    public static Xpp3Dom build(XmlPullParser parser, boolean trim, InputLocationBuilder locationBuilder) throws XmlPullParserException, IOException {
        ArrayList<Xpp3Dom> elements = new ArrayList<Xpp3Dom>();
        ArrayList<StringBuilder> values2 = new ArrayList<StringBuilder>();
        int eventType = parser.getEventType();
        boolean spacePreserve = false;
        while (eventType != 1) {
            if (eventType == 2) {
                int depth;
                spacePreserve = false;
                String rawName = parser.getName();
                Xpp3Dom childConfiguration = new Xpp3Dom(rawName);
                if (locationBuilder != null) {
                    childConfiguration.setInputLocation(locationBuilder.toInputLocation(parser));
                }
                if ((depth = elements.size()) > 0) {
                    Xpp3Dom parent2 = (Xpp3Dom)elements.get(depth - 1);
                    parent2.addChild(childConfiguration);
                }
                elements.add(childConfiguration);
                if (parser.isEmptyElementTag()) {
                    values2.add(null);
                } else {
                    values2.add(new StringBuilder());
                }
                int attributesSize = parser.getAttributeCount();
                for (int i = 0; i < attributesSize; ++i) {
                    String name2 = parser.getAttributeName(i);
                    String value2 = parser.getAttributeValue(i);
                    childConfiguration.setAttribute(name2, value2);
                    spacePreserve = spacePreserve || "xml:space".equals(name2) && "preserve".equals(value2);
                }
            } else if (eventType == 4) {
                int depth = values2.size() - 1;
                StringBuilder valueBuffer = (StringBuilder)values2.get(depth);
                String text2 = parser.getText();
                if (trim && !spacePreserve) {
                    text2 = text2.trim();
                }
                valueBuffer.append(text2);
            } else if (eventType == 3) {
                int depth = elements.size() - 1;
                Xpp3Dom finishedConfiguration = (Xpp3Dom)elements.remove(depth);
                Object accumulatedValue = values2.remove(depth);
                if (finishedConfiguration.getChildCount() == 0) {
                    if (accumulatedValue == null) {
                        finishedConfiguration.setValue(null);
                    } else {
                        finishedConfiguration.setValue(accumulatedValue.toString());
                    }
                }
                if (depth == 0) {
                    return finishedConfiguration;
                }
            }
            eventType = parser.next();
        }
        throw new IllegalStateException("End of document found before returning to 0 depth");
    }

    public static interface InputLocationBuilder {
        public Object toInputLocation(XmlPullParser var1);
    }
}

