/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.repository.internal;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.apache.maven.model.DistributionManagement;
import org.jetbrains.kotlin.org.apache.maven.model.Model;
import org.jetbrains.kotlin.org.apache.maven.model.Relocation;
import org.jetbrains.kotlin.org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.jetbrains.kotlin.org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.jetbrains.kotlin.org.apache.maven.model.building.FileModelSource;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelBuilder;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelBuildingException;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelProblem;
import org.jetbrains.kotlin.org.apache.maven.model.resolution.UnresolvableModelException;
import org.jetbrains.kotlin.org.apache.maven.repository.internal.ArtifactDescriptorReaderDelegate;
import org.jetbrains.kotlin.org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.jetbrains.kotlin.org.apache.maven.repository.internal.DefaultModelCache;
import org.jetbrains.kotlin.org.apache.maven.repository.internal.DefaultModelResolver;
import org.jetbrains.kotlin.org.apache.maven.repository.internal.MavenWorkspaceReader;
import org.jetbrains.kotlin.org.apache.maven.repository.internal.RelocatedArtifact;
import org.jetbrains.kotlin.org.eclipse.aether.RepositoryEvent;
import org.jetbrains.kotlin.org.eclipse.aether.RepositoryException;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.RequestTrace;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.jetbrains.kotlin.org.eclipse.aether.impl.ArtifactResolver;
import org.jetbrains.kotlin.org.eclipse.aether.impl.RemoteRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.jetbrains.kotlin.org.eclipse.aether.impl.VersionRangeResolver;
import org.jetbrains.kotlin.org.eclipse.aether.impl.VersionResolver;
import org.jetbrains.kotlin.org.eclipse.aether.repository.WorkspaceReader;
import org.jetbrains.kotlin.org.eclipse.aether.repository.WorkspaceRepository;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactDescriptorPolicyRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactResolutionException;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactResult;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.VersionRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.VersionResolutionException;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.VersionResult;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.Service;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.ServiceLocator;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.ArtifactNotFoundException;

@Named
@Singleton
public class DefaultArtifactDescriptorReader
implements ArtifactDescriptorReader,
Service {
    private RemoteRepositoryManager remoteRepositoryManager;
    private VersionResolver versionResolver;
    private VersionRangeResolver versionRangeResolver;
    private ArtifactResolver artifactResolver;
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private ModelBuilder modelBuilder;

    @Override
    public void initService(ServiceLocator locator) {
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
        this.setArtifactResolver(locator.getService(ArtifactResolver.class));
        this.modelBuilder = locator.getService(ModelBuilder.class);
        if (this.modelBuilder == null) {
            this.setModelBuilder(new DefaultModelBuilderFactory().newInstance());
        }
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
    }

    public DefaultArtifactDescriptorReader setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remoteRepositoryManager cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setVersionResolver(VersionResolver versionResolver) {
        this.versionResolver = Objects.requireNonNull(versionResolver, "versionResolver cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        this.versionRangeResolver = Objects.requireNonNull(versionRangeResolver, "versionRangeResolver cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = Objects.requireNonNull(artifactResolver, "artifactResolver cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repositoryEventDispatcher cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setModelBuilder(ModelBuilder modelBuilder) {
        this.modelBuilder = Objects.requireNonNull(modelBuilder, "modelBuilder cannot be null");
        return this;
    }

    @Override
    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session2, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        ArtifactDescriptorResult result2 = new ArtifactDescriptorResult(request);
        Model model = this.loadPom(session2, request, result2);
        if (model != null) {
            Map<String, Object> config = session2.getConfigProperties();
            ArtifactDescriptorReaderDelegate delegate2 = (ArtifactDescriptorReaderDelegate)config.get(ArtifactDescriptorReaderDelegate.class.getName());
            if (delegate2 == null) {
                delegate2 = new ArtifactDescriptorReaderDelegate();
            }
            delegate2.populateResult(session2, result2, model);
        }
        return result2;
    }

    private Model loadPom(RepositorySystemSession session2, ArtifactDescriptorRequest request, ArtifactDescriptorResult result2) throws ArtifactDescriptorException {
        Model model;
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        LinkedHashSet<String> visited2 = new LinkedHashSet<String>();
        Artifact a = request.getArtifact();
        while (true) {
            ArtifactResult resolveResult;
            Artifact pomArtifact = ArtifactDescriptorUtils.toPomArtifact(a);
            try {
                VersionRequest versionRequest = new VersionRequest(a, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                VersionResult versionResult = this.versionResolver.resolveVersion(session2, versionRequest);
                a = a.setVersion(versionResult.getVersion());
                versionRequest = new VersionRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                versionResult = this.versionResolver.resolveVersion(session2, versionRequest);
                pomArtifact = pomArtifact.setVersion(versionResult.getVersion());
            }
            catch (VersionResolutionException e) {
                result2.addException(e);
                throw new ArtifactDescriptorException(result2);
            }
            if (!visited2.add(a.getGroupId() + ':' + a.getArtifactId() + ':' + a.getBaseVersion())) {
                RepositoryException exception = new RepositoryException("Artifact relocations form a cycle: " + visited2);
                this.invalidDescriptor(session2, trace, a, exception);
                if ((this.getPolicy(session2, a, request) & 2) != 0) {
                    return null;
                }
                result2.addException(exception);
                throw new ArtifactDescriptorException(result2);
            }
            try {
                ArtifactRequest resolveRequest = new ArtifactRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                resolveRequest.setTrace(trace);
                resolveResult = this.artifactResolver.resolveArtifact(session2, resolveRequest);
                pomArtifact = resolveResult.getArtifact();
                result2.setRepository(resolveResult.getRepository());
            }
            catch (ArtifactResolutionException e) {
                if (e.getCause() instanceof ArtifactNotFoundException) {
                    this.missingDescriptor(session2, trace, a, (Exception)e.getCause());
                    if ((this.getPolicy(session2, a, request) & 1) != 0) {
                        return null;
                    }
                }
                result2.addException(e);
                throw new ArtifactDescriptorException(result2);
            }
            WorkspaceReader workspace = session2.getWorkspaceReader();
            if (workspace instanceof MavenWorkspaceReader && (model = ((MavenWorkspaceReader)workspace).findModel(pomArtifact)) != null) {
                return model;
            }
            try {
                DefaultModelBuildingRequest modelRequest = new DefaultModelBuildingRequest();
                modelRequest.setValidationLevel(0);
                modelRequest.setProcessPlugins(false);
                modelRequest.setTwoPhaseBuilding(false);
                modelRequest.setSystemProperties(this.toProperties(session2.getUserProperties(), session2.getSystemProperties()));
                modelRequest.setModelCache(DefaultModelCache.newInstance(session2));
                modelRequest.setModelResolver(new DefaultModelResolver(session2, trace.newChild(modelRequest), request.getRequestContext(), this.artifactResolver, this.versionRangeResolver, this.remoteRepositoryManager, request.getRepositories()));
                if (resolveResult.getRepository() instanceof WorkspaceRepository) {
                    modelRequest.setPomFile(pomArtifact.getFile());
                } else {
                    modelRequest.setModelSource(new FileModelSource(pomArtifact.getFile()));
                }
                model = this.modelBuilder.build(modelRequest).getEffectiveModel();
            }
            catch (ModelBuildingException e) {
                for (ModelProblem problem : e.getProblems()) {
                    if (!(problem.getException() instanceof UnresolvableModelException)) continue;
                    result2.addException(problem.getException());
                    throw new ArtifactDescriptorException(result2);
                }
                this.invalidDescriptor(session2, trace, a, e);
                if ((this.getPolicy(session2, a, request) & 2) != 0) {
                    return null;
                }
                result2.addException(e);
                throw new ArtifactDescriptorException(result2);
            }
            Relocation relocation = this.getRelocation(model);
            if (relocation == null) break;
            result2.addRelocation(a);
            a = new RelocatedArtifact(a, relocation.getGroupId(), relocation.getArtifactId(), relocation.getVersion());
            result2.setArtifact(a);
        }
        return model;
    }

    private Properties toProperties(Map<String, String> dominant, Map<String, String> recessive) {
        Properties props = new Properties();
        if (recessive != null) {
            props.putAll(recessive);
        }
        if (dominant != null) {
            props.putAll(dominant);
        }
        return props;
    }

    private Relocation getRelocation(Model model) {
        Relocation relocation = null;
        DistributionManagement distMgmt = model.getDistributionManagement();
        if (distMgmt != null) {
            relocation = distMgmt.getRelocation();
        }
        return relocation;
    }

    private void missingDescriptor(RepositorySystemSession session2, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_MISSING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void invalidDescriptor(RepositorySystemSession session2, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_INVALID);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private int getPolicy(RepositorySystemSession session2, Artifact a, ArtifactDescriptorRequest request) {
        ArtifactDescriptorPolicy policy = session2.getArtifactDescriptorPolicy();
        if (policy == null) {
            return 0;
        }
        return policy.getPolicy(session2, new ArtifactDescriptorPolicyRequest(a, request.getRequestContext()));
    }
}

