/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.jetbrains.kotlin.org.apache.commons.io.Charsets;
import org.jetbrains.kotlin.org.apache.commons.io.output.StringBuilderWriter;

public class IOUtils {
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final String LINE_SEPARATOR;

    public static String toString(InputStream input, Charset encoding) throws IOException {
        StringBuilderWriter sw = new StringBuilderWriter();
        Throwable throwable = null;
        try {
            IOUtils.copy(input, sw, encoding);
            String string2 = sw.toString();
            return string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (sw != null) {
                if (throwable != null) {
                    try {
                        sw.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    sw.close();
                }
            }
        }
    }

    public static String toString(InputStream input, String encoding) throws IOException {
        return IOUtils.toString(input, Charsets.toCharset(encoding));
    }

    public static void copy(InputStream input, Writer output, Charset inputEncoding) throws IOException {
        InputStreamReader in = new InputStreamReader(input, Charsets.toCharset(inputEncoding));
        IOUtils.copy(in, output);
    }

    public static int copy(Reader input, Writer output) throws IOException {
        long count2 = IOUtils.copyLarge(input, output);
        if (count2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count2;
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        return IOUtils.copyLarge(input, output, new char[4096]);
    }

    public static long copyLarge(Reader input, Writer output, char[] buffer) throws IOException {
        int n;
        long count2 = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count2 += (long)n;
        }
        return count2;
    }

    static {
        StringBuilderWriter buf = new StringBuilderWriter(4);
        Throwable throwable = null;
        try {
            PrintWriter out = new PrintWriter(buf);
            Throwable throwable2 = null;
            try {
                out.println();
                LINE_SEPARATOR = buf.toString();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (out != null) {
                    if (throwable2 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            if (buf != null) {
                if (throwable != null) {
                    try {
                        buf.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                } else {
                    buf.close();
                }
            }
        }
    }
}

