/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.kotlin.com.google.inject.Guice;
import org.jetbrains.kotlin.com.google.inject.internal.AbstractProcessor;
import org.jetbrains.kotlin.com.google.inject.internal.Errors;
import org.jetbrains.kotlin.com.google.inject.spi.Message;

final class MessageProcessor
extends AbstractProcessor {
    private static final Logger logger = Logger.getLogger(Guice.class.getName());

    MessageProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public Boolean visit(Message message2) {
        if (message2.getCause() != null) {
            String rootMessage = MessageProcessor.getRootMessage(message2.getCause());
            logger.log(Level.INFO, "An exception was caught and reported. Message: " + rootMessage, message2.getCause());
        }
        this.errors.addMessage(message2);
        return true;
    }

    public static String getRootMessage(Throwable t) {
        Throwable cause = t.getCause();
        return cause == null ? t.toString() : MessageProcessor.getRootMessage(cause);
    }
}

