/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.binder.AnnotatedConstantBindingBuilder;
import org.jetbrains.kotlin.com.google.inject.binder.ConstantBindingBuilder;
import org.jetbrains.kotlin.com.google.inject.internal.AbstractBindingBuilder;
import org.jetbrains.kotlin.com.google.inject.internal.BindingImpl;
import org.jetbrains.kotlin.com.google.inject.internal.InstanceBindingImpl;
import org.jetbrains.kotlin.com.google.inject.spi.Element;
import org.jetbrains.kotlin.com.google.inject.spi.InjectionPoint;

public final class ConstantBindingBuilderImpl<T>
extends AbstractBindingBuilder<T>
implements AnnotatedConstantBindingBuilder,
ConstantBindingBuilder {
    public ConstantBindingBuilderImpl(Binder binder, List<Element> elements, Object source) {
        super(binder, elements, source, NULL_KEY);
    }

    @Override
    public ConstantBindingBuilder annotatedWith(Class<? extends Annotation> annotationType) {
        this.annotatedWithInternal(annotationType);
        return this;
    }

    @Override
    public ConstantBindingBuilder annotatedWith(Annotation annotation2) {
        this.annotatedWithInternal(annotation2);
        return this;
    }

    @Override
    public void to(String value2) {
        this.toConstant(String.class, value2);
    }

    @Override
    public void to(int value2) {
        this.toConstant(Integer.class, value2);
    }

    @Override
    public void to(long value2) {
        this.toConstant(Long.class, value2);
    }

    @Override
    public void to(boolean value2) {
        this.toConstant(Boolean.class, value2);
    }

    @Override
    public void to(double value2) {
        this.toConstant(Double.class, value2);
    }

    @Override
    public void to(float value2) {
        this.toConstant(Float.class, Float.valueOf(value2));
    }

    @Override
    public void to(short value2) {
        this.toConstant(Short.class, value2);
    }

    @Override
    public void to(char value2) {
        this.toConstant(Character.class, Character.valueOf(value2));
    }

    @Override
    public void to(byte value2) {
        this.toConstant(Byte.class, value2);
    }

    @Override
    public void to(Class<?> value2) {
        this.toConstant(Class.class, value2);
    }

    @Override
    public <E extends Enum<E>> void to(E value2) {
        this.toConstant(value2.getDeclaringClass(), value2);
    }

    private void toConstant(Class<?> type2, Object instance) {
        Class<?> typeAsClassT = type2;
        Object instanceAsT = instance;
        if (this.keyTypeIsSet()) {
            this.binder.addError("Constant value is set more than once.", new Object[0]);
            return;
        }
        BindingImpl base2 = this.getBinding();
        Key<?> key = base2.getKey().getAnnotation() != null ? Key.get(typeAsClassT, base2.getKey().getAnnotation()) : (base2.getKey().getAnnotationType() != null ? Key.get(typeAsClassT, base2.getKey().getAnnotationType()) : Key.get(typeAsClassT));
        if (instanceAsT == null) {
            this.binder.addError("Binding to null instances is not allowed. Use toProvider(Providers.of(null)) if this is your intended behaviour.", new Object[0]);
        }
        this.setBinding(new InstanceBindingImpl<Object>(base2.getSource(), key, base2.getScoping(), ImmutableSet.<InjectionPoint>of(), instanceAsT));
    }

    public String toString() {
        return "ConstantBindingBuilder";
    }
}

