/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.SamType;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForPropertyBackingField;
import org.jetbrains.kotlin.codegen.AccessorKind;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.ArgumentGeneratorKt;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.AssertCodegenUtilKt;
import org.jetbrains.kotlin.codegen.BaseExpressionCodegen;
import org.jetbrains.kotlin.codegen.BaseExpressionCodegenKt;
import org.jetbrains.kotlin.codegen.BoxedToPrimitiveEquality;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.BuiltinSpecialBridgesKt;
import org.jetbrains.kotlin.codegen.CallBasedArgumentGenerator;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.CallReceiver;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.ClosureGenerationStrategy;
import org.jetbrains.kotlin.codegen.CodegenStatementVisitor;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CommonVariableAsmNameManglingUtils;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultCallArgs;
import org.jetbrains.kotlin.codegen.DescriptorAsmUtil;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FrameMapBase;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.FunctionReferenceGenerationStrategy;
import org.jetbrains.kotlin.codegen.Ieee754Equality;
import org.jetbrains.kotlin.codegen.Ieee754Kt;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.InlineClassesCodegenUtilKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.PrimitiveToBoxedEquality;
import org.jetbrains.kotlin.codegen.PrimitiveToObjectEquality;
import org.jetbrains.kotlin.codegen.PrimitiveToSafeCallEquality;
import org.jetbrains.kotlin.codegen.PropertyCodegen;
import org.jetbrains.kotlin.codegen.PropertyReferenceCodegen;
import org.jetbrains.kotlin.codegen.SafeCallToPrimitiveEquality;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.StackValueWithLeaveTask;
import org.jetbrains.kotlin.codegen.StringConcatGenerator;
import org.jetbrains.kotlin.codegen.SyntheticClassDescriptorForLambda;
import org.jetbrains.kotlin.codegen.TailRecursionCodegen;
import org.jetbrains.kotlin.codegen.TypeAndNullability;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.ClosureContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.ConstructorContext;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.InlineLambdaContext;
import org.jetbrains.kotlin.codegen.context.LocalLookup;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.ScriptContext;
import org.jetbrains.kotlin.codegen.context.ScriptLikeContext;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenForLambda;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.coroutines.ResolvedCallWithRealDescriptor;
import org.jetbrains.kotlin.codegen.coroutines.SuspensionPointKind;
import org.jetbrains.kotlin.codegen.extensions.ExpressionCodegenExtension;
import org.jetbrains.kotlin.codegen.inline.FictitiousArrayConstructor;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenForDefaultBody;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.inline.NameGenerator;
import org.jetbrains.kotlin.codegen.inline.PsiInlineCodegen;
import org.jetbrains.kotlin.codegen.inline.PsiSourceCompilerForInline;
import org.jetbrains.kotlin.codegen.inline.ReificationArgument;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeParametersUsages;
import org.jetbrains.kotlin.codegen.inline.TypeParameterMappings;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicPropertyGetter;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicWithSpecialReceiver;
import org.jetbrains.kotlin.codegen.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.codegen.intrinsics.KCallableNameProperty;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.kotlin.codegen.range.RangeValue;
import org.jetbrains.kotlin.codegen.range.RangeValuesKt;
import org.jetbrains.kotlin.codegen.range.forLoop.ForLoopGenerator;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.signature.JvmSignatureWriter;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.codegen.when.SwitchCodegen;
import org.jetbrains.kotlin.codegen.when.SwitchCodegenProvider;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.JVMAssertionsMode;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.DescriptorsJvmAbiUtil;
import org.jetbrains.kotlin.load.java.descriptors.JavaPropertyDescriptor;
import org.jetbrains.kotlin.load.kotlin.DescriptorBasedTypeSignatureMappingKt;
import org.jetbrains.kotlin.load.kotlin.MethodSignatureMappingKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.PropertyImportedFromObject;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForTypeAliasObject;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.checkers.PrimitiveNumericComparisonInfo;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.resolve.jvm.JvmConstantsKt;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.sam.SamConstructorDescriptor;
import org.jetbrains.kotlin.resolve.scopes.receivers.CastImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeApproximator;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSystemCommonBackendContext;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.ClassicTypeSystemContextImpl;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class ExpressionCodegen
extends KtVisitor<StackValue, StackValue>
implements BaseExpressionCodegen,
LocalLookup {
    private final GenerationState state;
    final KotlinTypeMapper typeMapper;
    private final BindingContext bindingContext;
    public final InstructionAdapter v;
    public final FrameMap myFrameMap;
    public final MethodContext context;
    private final Type returnType;
    private final CodegenStatementVisitor statementVisitor;
    private final MemberCodegen<?> parentCodegen;
    private final TailRecursionCodegen tailRecursionCodegen;
    public final CallGenerator defaultCallGenerator;
    private final SwitchCodegenProvider switchCodegenProvider;
    private final TypeSystemCommonBackendContext typeSystem;
    private final Stack<BlockStackElement> blockStackElements;
    public final Map<KtElement, StackValue> tempVariables;
    private int myLastLineNumber;
    private boolean shouldMarkLineNumbers;
    private int finallyDepth;

    public ExpressionCodegen(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull Type returnType2, @NotNull MethodContext context2, @NotNull GenerationState state, @NotNull MemberCodegen<?> parentCodegen) {
        if (mv == null) {
            ExpressionCodegen.$$$reportNull$$$0(0);
        }
        if (frameMap == null) {
            ExpressionCodegen.$$$reportNull$$$0(1);
        }
        if (returnType2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(3);
        }
        if (state == null) {
            ExpressionCodegen.$$$reportNull$$$0(4);
        }
        if (parentCodegen == null) {
            ExpressionCodegen.$$$reportNull$$$0(5);
        }
        this.statementVisitor = new CodegenStatementVisitor(this);
        this.defaultCallGenerator = new CallGenerator.DefaultCallGenerator(this);
        this.blockStackElements = new Stack();
        this.tempVariables = new HashMap<KtElement, StackValue>();
        this.myLastLineNumber = -1;
        this.shouldMarkLineNumbers = true;
        this.finallyDepth = 0;
        this.state = state;
        this.typeMapper = state.getTypeMapper();
        this.bindingContext = state.getBindingContext();
        this.v = new InstructionAdapter(mv);
        this.myFrameMap = frameMap;
        this.context = context2;
        this.returnType = returnType2;
        this.parentCodegen = parentCodegen;
        this.tailRecursionCodegen = new TailRecursionCodegen(context2, this, this.v, state);
        this.switchCodegenProvider = new SwitchCodegenProvider(this);
        this.typeSystem = new ClassicTypeSystemContextImpl(state.getModule().getBuiltIns());
    }

    @Nullable
    private static FunctionDescriptor getOriginalSuspendLambdaDescriptorFromContext(MethodContext context2) {
        if (context2.getParentContext() instanceof ClosureContext && context2.getParentContext().closure != null && context2.getParentContext().closure.isSuspend()) {
            return ((ClosureContext)context2.getParentContext()).getOriginalSuspendLambdaDescriptor();
        }
        return null;
    }

    @NotNull
    public GenerationState getState() {
        GenerationState generationState = this.state;
        if (generationState == null) {
            ExpressionCodegen.$$$reportNull$$$0(6);
        }
        return generationState;
    }

    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.bindingContext;
        if (bindingContext == null) {
            ExpressionCodegen.$$$reportNull$$$0(7);
        }
        return bindingContext;
    }

    @NotNull
    public MemberCodegen<?> getParentCodegen() {
        MemberCodegen<?> memberCodegen = this.parentCodegen;
        if (memberCodegen == null) {
            ExpressionCodegen.$$$reportNull$$$0(8);
        }
        return memberCodegen;
    }

    @NotNull
    public KotlinTypeMapper getTypeMapper() {
        KotlinTypeMapper kotlinTypeMapper = this.typeMapper;
        if (kotlinTypeMapper == null) {
            ExpressionCodegen.$$$reportNull$$$0(9);
        }
        return kotlinTypeMapper;
    }

    @NotNull
    public ObjectLiteralResult generateObjectLiteral(@NotNull KtObjectLiteralExpression literal) {
        if (literal == null) {
            ExpressionCodegen.$$$reportNull$$$0(10);
        }
        KtObjectDeclaration objectDeclaration = literal.getObjectDeclaration();
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, objectDeclaration);
        assert (classDescriptor != null);
        Type asmType = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, objectDeclaration);
        ClassBuilder classBuilder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(objectDeclaration, classDescriptor), asmType, literal.getContainingFile());
        ClassContext objectContext = this.context.intoAnonymousClass(classDescriptor, this, OwnerKind.IMPLEMENTATION);
        ImplementationBodyCodegen literalCodegen = new ImplementationBodyCodegen(objectDeclaration, objectContext, classBuilder2, this.state, this.getParentCodegen(), true);
        literalCodegen.generate();
        ExpressionCodegen.addReifiedParametersFromSignature(literalCodegen, classDescriptor);
        this.propagateChildReifiedTypeParametersUsages(literalCodegen.getReifiedTypeParametersUsages());
        return new ObjectLiteralResult(literalCodegen.getReifiedTypeParametersUsages().wereUsedReifiedParameters(), classDescriptor);
    }

    private static void addReifiedParametersFromSignature(@NotNull MemberCodegen<?> member2, @NotNull ClassDescriptor descriptor2) {
        if (member2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(11);
        }
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(12);
        }
        for (KotlinType type2 : descriptor2.getTypeConstructor().getSupertypes()) {
            ExpressionCodegen.processTypeArguments(member2, type2);
        }
    }

    private static void processTypeArguments(@NotNull MemberCodegen<?> member2, KotlinType type2) {
        if (member2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(13);
        }
        for (TypeProjection supertypeArgument : type2.getArguments()) {
            if (supertypeArgument.isStarProjection()) continue;
            TypeParameterDescriptor parameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(supertypeArgument.getType());
            if (parameterDescriptor != null) {
                if (!parameterDescriptor.isReified()) continue;
                member2.getReifiedTypeParametersUsages().addUsedReifiedParameter(parameterDescriptor.getName().asString());
                continue;
            }
            ExpressionCodegen.processTypeArguments(member2, supertypeArgument.getType());
        }
    }

    @NotNull
    private StackValue castToRequiredTypeOfInterfaceIfNeeded(StackValue inner, @NotNull ClassDescriptor provided, @NotNull ClassDescriptor required) {
        if (provided == null) {
            ExpressionCodegen.$$$reportNull$$$0(14);
        }
        if (required == null) {
            ExpressionCodegen.$$$reportNull$$$0(15);
        }
        if (!JvmCodegenUtil.isJvmInterface(provided) && JvmCodegenUtil.isJvmInterface(required)) {
            SimpleType requiredDefaultType = required.getDefaultType();
            StackValue stackValue = StackValue.coercion(inner, this.asmType(requiredDefaultType), requiredDefaultType);
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(16);
            }
            return stackValue;
        }
        StackValue stackValue = inner;
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(17);
        }
        return stackValue;
    }

    public StackValue genQualified(StackValue receiver, KtElement selector) {
        return this.genQualified(receiver, selector, this);
    }

    private StackValue genQualified(StackValue receiver, KtElement selector, KtVisitor<StackValue, StackValue> visitor2) {
        if (this.tempVariables.containsKey(selector)) {
            throw new IllegalStateException("Inconsistent state: expression saved to a temporary variable is a selector");
        }
        if (!(selector instanceof KtBlockExpression)) {
            this.markStartLineNumber(selector);
        }
        try {
            KtExpression expression2;
            StackValue samValue;
            if (selector instanceof KtExpression && (samValue = this.genSamInterfaceValue((KtExpression)selector, visitor2)) != null) {
                return samValue;
            }
            StackValue stackValue = selector.accept(visitor2, receiver);
            stackValue = this.suspendFunctionTypeWrapperIfNeeded(selector, stackValue);
            stackValue = this.coerceAndBoxInlineClassIfNeeded(selector, stackValue);
            RuntimeAssertionInfo runtimeAssertionInfo = null;
            if (selector instanceof KtExpression && (runtimeAssertionInfo = this.bindingContext.get(JvmBindingContextSlices.RUNTIME_ASSERTION_INFO, expression2 = (KtExpression)selector)) == null && this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.StrictJavaNullabilityAssertions)) {
                runtimeAssertionInfo = this.bindingContext.get(JvmBindingContextSlices.BODY_RUNTIME_ASSERTION_INFO, expression2);
            }
            if (BuiltinSpecialBridgesKt.isValueArgumentForCallToMethodWithTypeCheckBarrier(selector, this.bindingContext)) {
                return stackValue;
            }
            return DescriptorAsmUtil.genNotNullAssertions(this.state, stackValue, runtimeAssertionInfo);
        }
        catch (CompilationException | ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CompilationException("Failed to generate expression: " + selector.getClass().getSimpleName(), e, selector);
        }
    }

    private StackValue suspendFunctionTypeWrapperIfNeeded(KtElement selector, StackValue stackValue) {
        Type functionTypeForWrapper;
        Type type2 = functionTypeForWrapper = selector instanceof KtExpression ? this.bindingContext.get(CodegenBinding.FUNCTION_TYPE_FOR_SUSPEND_WRAPPER, (KtExpression)selector) : null;
        if (functionTypeForWrapper == null) {
            return stackValue;
        }
        final StackValue stackValueToWrap = stackValue;
        stackValue = new StackValue(stackValue.type, stackValue.kotlinType){

            @Override
            public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (v == null) {
                    1.$$$reportNull$$$0(1);
                }
                stackValueToWrap.put(functionTypeForWrapper, null, v);
                ExpressionCodegen.invokeCoroutineMigrationMethod(v, "toExperimentalSuspendFunction", Type.getMethodDescriptor(functionTypeForWrapper, functionTypeForWrapper));
                1.coerce(functionTypeForWrapper, type2, v);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "v";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$1";
                objectArray[2] = "putSelector";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        return stackValue;
    }

    private StackValue coerceAndBoxInlineClassIfNeeded(KtElement selector, StackValue stackValue) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(selector, this.bindingContext);
        if (resolvedCall2 == null) {
            return stackValue;
        }
        CallableDescriptor descriptor2 = resolvedCall2.getResultingDescriptor();
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return stackValue;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor2;
        if (!functionDescriptor.isSuspend()) {
            return stackValue;
        }
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall && functionDescriptor.isOperator() && functionDescriptor.getName().getIdentifier().equals("invoke")) {
            return stackValue;
        }
        KotlinType unboxedInlineClass = CoroutineCodegenUtilKt.originalReturnTypeOfSuspendFunctionReturningUnboxedInlineClass(functionDescriptor, this.typeMapper);
        final StackValue stackValueToWrap = stackValue;
        final KotlinType originalKotlinType = unboxedInlineClass != null ? unboxedInlineClass : stackValueToWrap.kotlinType;
        final Type originalType = unboxedInlineClass != null ? this.typeMapper.mapType(unboxedInlineClass) : stackValueToWrap.type;
        stackValue = new StackValue(originalType, originalKotlinType){

            @Override
            public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
                if (type2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (v == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (originalKotlinType != null && InlineClassesUtilsKt.isInlineClassType(originalKotlinType) || kotlinType != null && InlineClassesUtilsKt.isInlineClassType(kotlinType)) {
                    stackValueToWrap.put(v);
                    StackValue.coerce(AsmTypes.OBJECT_TYPE, originalType, v);
                    StackValue.coerce(originalType, originalKotlinType, type2, kotlinType, v);
                } else {
                    stackValueToWrap.put(type2, kotlinType, v);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "v";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$2";
                objectArray[2] = "putSelector";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        return stackValue;
    }

    public StackValue gen(KtElement expr) {
        StackValue tempVar = this.tempVariables.get(expr);
        return tempVar != null ? tempVar : this.genQualified(StackValue.none(), expr);
    }

    public void gen(KtElement expr, Type type2) {
        this.gen(expr, type2, null);
    }

    public void gen(KtElement expr, Type type2, KotlinType kotlinType) {
        StackValue value2 = Type.VOID_TYPE.equals(type2) ? this.genStatement(expr) : this.gen(expr);
        this.putStackValue(expr, type2, kotlinType, value2);
    }

    private void putStackValue(@Nullable KtElement expr, @NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull StackValue value2) {
        FieldInfo resultFieldInfo;
        ScriptContext context2;
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(18);
        }
        if (value2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(19);
        }
        if (value2.type != Type.VOID_TYPE && (context2 = this.getScriptContext()) != null && expr == context2.getLastStatement() && (resultFieldInfo = context2.getResultFieldInfo()) != null) {
            StackValue.Field resultValue = StackValue.field(resultFieldInfo, (StackValue)StackValue.LOCAL_0);
            resultValue.store(value2, this.v);
            this.state.getScriptSpecific().setResultType(resultFieldInfo.getFieldKotlinType());
            this.state.getScriptSpecific().setResultFieldName(resultFieldInfo.getFieldName());
            return;
        }
        value2.put(type2, kotlinType, this.v);
    }

    @Nullable
    private ScriptContext getScriptContext() {
        CodegenContext context2;
        for (context2 = this.getContext(); context2 != null && !(context2 instanceof ScriptContext); context2 = ((CodegenContext)context2).getParentContext()) {
        }
        return (ScriptContext)context2;
    }

    private StackValue genLazy(KtElement expr, Type type2) {
        StackValue value2 = this.gen(expr);
        return StackValue.coercion(value2, type2, null);
    }

    private StackValue genLazy(KtElement expr, Type type2, KotlinType kotlinType) {
        StackValue value2 = this.gen(expr);
        return StackValue.coercion(value2, type2, kotlinType);
    }

    private StackValue genStatement(KtElement statement2) {
        return this.genQualified(StackValue.none(), statement2, this.statementVisitor);
    }

    @Override
    public StackValue visitClass(@NotNull KtClass klass, StackValue data2) {
        if (klass == null) {
            ExpressionCodegen.$$$reportNull$$$0(20);
        }
        return this.visitClassOrObject(klass);
    }

    @Override
    public StackValue visitTypeAlias(@NotNull KtTypeAlias typeAlias, StackValue data2) {
        if (typeAlias == null) {
            ExpressionCodegen.$$$reportNull$$$0(21);
        }
        return StackValue.none();
    }

    private StackValue visitClassOrObject(KtClassOrObject declaration2) {
        ClassDescriptor descriptor2 = this.bindingContext.get(BindingContext.CLASS, declaration2);
        assert (descriptor2 != null);
        Type asmType = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, declaration2);
        ClassBuilder classBuilder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(declaration2, descriptor2), asmType, declaration2.getContainingFile());
        ClassContext objectContext = this.context.intoAnonymousClass(descriptor2, this, OwnerKind.IMPLEMENTATION);
        new ImplementationBodyCodegen(declaration2, objectContext, classBuilder2, this.state, this.getParentCodegen(), true).generate();
        return StackValue.none();
    }

    @Override
    public StackValue visitObjectDeclaration(@NotNull KtObjectDeclaration declaration2, StackValue data2) {
        if (declaration2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(22);
        }
        return this.visitClassOrObject(declaration2);
    }

    @Override
    public StackValue visitExpression(@NotNull KtExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(23);
        }
        throw new UnsupportedOperationException("Codegen for " + expression2 + " is not yet implemented");
    }

    @Override
    public StackValue visitSuperExpression(@NotNull KtSuperExpression expression2, StackValue data2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(24);
        }
        return StackValue.thisOrOuter(this, ExpressionCodegen.getSuperCallLabelTarget(this.context, expression2), true, false);
    }

    @NotNull
    public static ClassDescriptor getSuperCallLabelTarget(@NotNull CodegenContext<?> context2, @NotNull KtSuperExpression expression2) {
        if (context2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(25);
        }
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(26);
        }
        KotlinType thisTypeForSuperCall = context2.getState().getBindingContext().get(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, expression2);
        assert (thisTypeForSuperCall != null) : "This type for superCall ''" + expression2.getText() + "'' should be not null!";
        ClassifierDescriptor descriptor2 = thisTypeForSuperCall.getConstructor().getDeclarationDescriptor();
        assert (descriptor2 instanceof ClassDescriptor) : "'This' reference target for ''" + expression2.getText() + "''should be class descriptor, but was " + descriptor2;
        ClassDescriptor classDescriptor = (ClassDescriptor)descriptor2;
        if (classDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(27);
        }
        return classDescriptor;
    }

    @NotNull
    public Type asmType(@NotNull KotlinType type2) {
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(28);
        }
        Type type3 = this.typeMapper.mapType(type2);
        if (type3 == null) {
            ExpressionCodegen.$$$reportNull$$$0(29);
        }
        return type3;
    }

    @NotNull
    public Type mapTypeAsDeclaration(@NotNull KotlinType type2) {
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(30);
        }
        Type type3 = this.typeMapper.mapTypeAsDeclaration(type2);
        if (type3 == null) {
            ExpressionCodegen.$$$reportNull$$$0(31);
        }
        return type3;
    }

    @NotNull
    public Type expressionType(@Nullable KtExpression expression2) {
        Type type2 = CodegenUtilKt.asmType(expression2, this.typeMapper, this.bindingContext);
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(32);
        }
        return type2;
    }

    @Nullable
    public KotlinType kotlinType(@Nullable KtExpression expression2) {
        return CodegenUtilKt.kotlinType(expression2, this.bindingContext);
    }

    @Override
    public StackValue visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(33);
        }
        return this.genQualified(receiver, expression2.getExpression());
    }

    @Override
    public StackValue visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(34);
        }
        return this.genQualified(receiver, expression2.getBaseExpression());
    }

    private static boolean isEmptyExpression(@Nullable KtElement expr) {
        KtBlockExpression blockExpression;
        List<KtExpression> statements2;
        if (expr == null) {
            return true;
        }
        return expr instanceof KtBlockExpression && ((statements2 = (blockExpression = (KtBlockExpression)expr).getStatements()).size() == 0 || statements2.size() == 1 && ExpressionCodegen.isEmptyExpression(statements2.get(0)));
    }

    @Override
    public StackValue visitIfExpression(@NotNull KtIfExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(35);
        }
        return this.generateIfExpression(expression2, false);
    }

    StackValue generateIfExpression(@NotNull KtIfExpression expression2, boolean isStatement) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(36);
        }
        Type asmType = isStatement ? Type.VOID_TYPE : this.expressionType(expression2);
        KotlinType kotlinType = isStatement ? null : this.kotlinType(expression2);
        StackValue condition = this.gen(expression2.getCondition());
        KtExpression thenExpression = expression2.getThen();
        KtExpression elseExpression = expression2.getElse();
        if (ExpressionCodegen.isEmptyExpression(thenExpression)) {
            if (ExpressionCodegen.isEmptyExpression(elseExpression)) {
                return StackValue.coercion(condition, asmType, kotlinType);
            }
            return this.generateSingleBranchIf(condition, expression2, elseExpression, false, isStatement);
        }
        if (ExpressionCodegen.isEmptyExpression(elseExpression)) {
            return this.generateSingleBranchIf(condition, expression2, thenExpression, true, isStatement);
        }
        return StackValue.operation(asmType, kotlinType, v -> {
            Label elseLabel = new Label();
            BranchedValue.Companion.condJump(condition, elseLabel, true, (InstructionAdapter)v);
            Label end = new Label();
            this.gen(thenExpression, asmType, kotlinType);
            v.goTo(end);
            v.mark(elseLabel);
            this.gen(elseExpression, asmType, kotlinType);
            this.markLineNumber(expression2, isStatement);
            v.mark(end);
            return Unit.INSTANCE;
        });
    }

    @Override
    public StackValue visitWhileExpression(@NotNull KtWhileExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(37);
        }
        return StackValue.operation(Type.VOID_TYPE, adapter -> {
            this.generateWhile(expression2);
            return Unit.INSTANCE;
        });
    }

    private void generateWhile(@NotNull KtWhileExpression expression2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(38);
        }
        Label condition = new Label();
        this.v.mark(condition);
        Label end = new Label();
        this.blockStackElements.push(new LoopBlockStackElement(end, condition, ExpressionCodegen.targetLabel(expression2)));
        StackValue conditionValue = this.gen(expression2.getCondition());
        BranchedValue.Companion.loopJump(conditionValue, end, true, this.v);
        this.generateLoopBody(expression2.getBody());
        this.markStartLineNumber(expression2);
        this.v.goTo(condition);
        this.v.mark(end);
        this.blockStackElements.pop();
    }

    @Override
    public StackValue visitDoWhileExpression(@NotNull KtDoWhileExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(39);
        }
        return StackValue.operation(Type.VOID_TYPE, adapter -> {
            this.generateDoWhile(expression2);
            return Unit.INSTANCE;
        });
    }

    private void generateDoWhile(@NotNull KtDoWhileExpression expression2) {
        StackValue conditionValue;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(40);
        }
        Label beginLoopLabel = new Label();
        this.v.mark(beginLoopLabel);
        Label breakLabel = new Label();
        Label continueLabel = new Label();
        this.blockStackElements.push(new LoopBlockStackElement(breakLabel, continueLabel, ExpressionCodegen.targetLabel(expression2)));
        PseudoInsnsKt.fakeAlwaysFalseIfeq(this.v, continueLabel);
        PseudoInsnsKt.fakeAlwaysFalseIfeq(this.v, breakLabel);
        KtExpression body2 = expression2.getBody();
        KtExpression condition = expression2.getCondition();
        StackValueWithLeaveTask leaveTask = null;
        if (body2 instanceof KtBlockExpression) {
            List<KtExpression> doWhileStatements = ((KtBlockExpression)body2).getStatements();
            ArrayList<KtExpression> statements2 = new ArrayList<KtExpression>(doWhileStatements.size() + 1);
            statements2.addAll(doWhileStatements);
            statements2.add(condition);
            leaveTask = this.generateBlock(statements2, false, continueLabel, null);
            conditionValue = leaveTask.getStackValue();
        } else {
            if (body2 != null) {
                this.gen(body2, Type.VOID_TYPE);
            }
            this.v.mark(continueLabel);
            conditionValue = this.gen(condition);
        }
        BranchedValue.Companion.loopJump(conditionValue, beginLoopLabel, false, this.v);
        if (leaveTask != null) {
            leaveTask.getLeaveTasks().invoke(conditionValue);
        }
        this.v.mark(breakLabel);
        this.blockStackElements.pop();
    }

    @Override
    public StackValue visitForExpression(@NotNull KtForExpression forExpression, StackValue receiver) {
        if (forExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(41);
        }
        return StackValue.operation(Type.VOID_TYPE, adapter -> {
            this.generateFor(forExpression);
            return Unit.INSTANCE;
        });
    }

    private void generateFor(@NotNull KtForExpression forExpression) {
        if (forExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(42);
        }
        KtExpression range = forExpression.getLoopRange();
        assert (range != null) : "No loop range in for expression";
        RangeValue rangeValue = RangeValuesKt.createRangeValueForExpression(this, range);
        this.generateForLoop(rangeValue.createForLoopGenerator(this, forExpression));
    }

    @NotNull
    public static KotlinType getExpectedReceiverType(@NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(43);
        }
        ReceiverParameterDescriptor extensionReceiver = resolvedCall2.getResultingDescriptor().getExtensionReceiverParameter();
        assert (extensionReceiver != null) : "Extension receiver should be non-null";
        KotlinType kotlinType = extensionReceiver.getType();
        if (kotlinType == null) {
            ExpressionCodegen.$$$reportNull$$$0(44);
        }
        return kotlinType;
    }

    @Nullable
    public static KtExpression getSingleArgumentExpression(@NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall2) {
        List<ResolvedValueArgument> resolvedValueArguments;
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(45);
        }
        if ((resolvedValueArguments = resolvedCall2.getValueArgumentsByIndex()) == null) {
            return null;
        }
        if (resolvedValueArguments.size() != 1) {
            return null;
        }
        List<ValueArgument> valueArguments = resolvedValueArguments.get(0).getArguments();
        if (valueArguments.size() != 1) {
            return null;
        }
        return valueArguments.get(0).getArgumentExpression();
    }

    private OwnerKind contextKind() {
        return this.context.getContextKind();
    }

    private void generateForLoop(ForLoopGenerator generator2) {
        Label loopExit = new Label();
        Label loopEntry = new Label();
        Label continueLabel = new Label();
        generator2.beforeLoop();
        generator2.checkEmptyLoop(loopExit);
        this.v.mark(loopEntry);
        this.resetLastLineNumber();
        this.markStartLineNumber(generator2.getForExpression());
        this.v.nop();
        generator2.checkPreCondition(loopExit);
        PseudoInsnsKt.fakeAlwaysFalseIfeq(this.v, continueLabel);
        this.markStartLineNumber(generator2.getForExpression());
        this.v.nop();
        generator2.beforeBody();
        this.blockStackElements.push(new LoopBlockStackElement(loopExit, continueLabel, ExpressionCodegen.targetLabel(generator2.getForExpression())));
        generator2.body();
        this.blockStackElements.pop();
        this.v.mark(continueLabel);
        generator2.afterBody(loopExit);
        this.v.goTo(loopEntry);
        this.v.mark(loopExit);
        generator2.afterLoop();
    }

    public void generateLoopBody(@Nullable KtExpression body2) {
        if (body2 != null) {
            this.gen(body2, Type.VOID_TYPE);
        }
    }

    @Override
    public StackValue visitBreakExpression(@NotNull KtBreakExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(46);
        }
        return this.generateBreakOrContinueExpression(expression2, true, new Label(), new ArrayList<TryBlockStackElement>());
    }

    @Override
    public StackValue visitContinueExpression(@NotNull KtContinueExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(47);
        }
        return this.generateBreakOrContinueExpression(expression2, false, new Label(), new ArrayList<TryBlockStackElement>());
    }

    @NotNull
    private StackValue generateBreakOrContinueExpression(@NotNull KtExpressionWithLabel expression2, boolean isBreak, @NotNull Label afterBreakContinueLabel, @NotNull List<TryBlockStackElement> nestedTryBlocksWithoutFinally) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(48);
        }
        if (afterBreakContinueLabel == null) {
            ExpressionCodegen.$$$reportNull$$$0(49);
        }
        if (nestedTryBlocksWithoutFinally == null) {
            ExpressionCodegen.$$$reportNull$$$0(50);
        }
        assert (expression2 instanceof KtContinueExpression || expression2 instanceof KtBreakExpression);
        if (this.blockStackElements.isEmpty()) {
            throw new UnsupportedOperationException("Target label for break/continue not found");
        }
        BlockStackElement stackElement2 = this.blockStackElements.peek();
        if (stackElement2 instanceof TryWithFinallyBlockStackElement) {
            TryWithFinallyBlockStackElement tryWithFinallyBlockStackElement = (TryWithFinallyBlockStackElement)stackElement2;
            this.genFinallyBlockOrGoto(tryWithFinallyBlockStackElement, null, afterBreakContinueLabel, nestedTryBlocksWithoutFinally);
            nestedTryBlocksWithoutFinally.clear();
        } else if (stackElement2 instanceof TryBlockStackElement) {
            nestedTryBlocksWithoutFinally.add((TryBlockStackElement)stackElement2);
        } else if (stackElement2 instanceof LoopBlockStackElement) {
            LoopBlockStackElement loopBlockStackElement = (LoopBlockStackElement)stackElement2;
            KtSimpleNameExpression labelElement = expression2.getTargetLabel();
            if (labelElement == null || loopBlockStackElement.targetLabel != null && labelElement.getReferencedName().equals(loopBlockStackElement.targetLabel.getReferencedName())) {
                Label label = isBreak ? loopBlockStackElement.breakLabel : loopBlockStackElement.continueLabel;
                StackValue stackValue = StackValue.operation(Type.VOID_TYPE, this.getNothingType(), adapter -> {
                    PseudoInsnsKt.fixStackAndJump(this.v, label);
                    this.v.mark(afterBreakContinueLabel);
                    return Unit.INSTANCE;
                });
                if (stackValue == null) {
                    ExpressionCodegen.$$$reportNull$$$0(51);
                }
                return stackValue;
            }
        } else {
            throw new UnsupportedOperationException("Wrong BlockStackElement in processing stack");
        }
        this.blockStackElements.pop();
        StackValue result2 = this.generateBreakOrContinueExpression(expression2, isBreak, afterBreakContinueLabel, nestedTryBlocksWithoutFinally);
        this.blockStackElements.push(stackElement2);
        StackValue stackValue = result2;
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(52);
        }
        return stackValue;
    }

    private StackValue generateSingleBranchIf(StackValue condition, KtIfExpression ifExpression, KtExpression expression2, boolean inverse, boolean isStatement) {
        Type targetType = isStatement ? Type.VOID_TYPE : this.expressionType(ifExpression);
        KotlinType targetKotlinType = isStatement ? null : this.kotlinType(ifExpression);
        return StackValue.operation(targetType, v -> {
            Label elseLabel = new Label();
            BranchedValue.Companion.condJump(condition, elseLabel, inverse, (InstructionAdapter)v);
            if (isStatement) {
                this.gen(expression2, Type.VOID_TYPE);
                v.mark(elseLabel);
            } else {
                this.gen(expression2, targetType, targetKotlinType);
                Label end = new Label();
                v.goTo(end);
                v.mark(elseLabel);
                StackValue.putUnitInstance(v);
                this.markStartLineNumber(ifExpression);
                v.mark(end);
            }
            return null;
        });
    }

    @Override
    public StackValue visitConstantExpression(@NotNull KtConstantExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(53);
        }
        ConstantValue<?> compileTimeValue = this.getPrimitiveOrStringCompileTimeConstant(expression2);
        assert (compileTimeValue != null);
        return StackValue.constant(compileTimeValue.getValue(), this.expressionType(expression2), this.kotlinType(expression2));
    }

    @Nullable
    public ConstantValue<?> getCompileTimeConstant(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(54);
        }
        return ExpressionCodegen.getCompileTimeConstant(expression2, this.bindingContext, this.state.getShouldInlineConstVals());
    }

    @Nullable
    public ConstantValue<?> getPrimitiveOrStringCompileTimeConstant(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(55);
        }
        return ExpressionCodegen.getPrimitiveOrStringCompileTimeConstant(expression2, this.bindingContext, this.state.getShouldInlineConstVals());
    }

    @Nullable
    public static ConstantValue<?> getPrimitiveOrStringCompileTimeConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext, boolean shouldInlineConstVals) {
        ConstantValue<?> constant;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(56);
        }
        if (bindingContext == null) {
            ExpressionCodegen.$$$reportNull$$$0(57);
        }
        if ((constant = ExpressionCodegen.getCompileTimeConstant(expression2, bindingContext, false, shouldInlineConstVals)) == null || ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(constant)) {
            return null;
        }
        return constant;
    }

    @Nullable
    public static ConstantValue<?> getCompileTimeConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext, boolean shouldInlineConstVals) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(58);
        }
        if (bindingContext == null) {
            ExpressionCodegen.$$$reportNull$$$0(59);
        }
        return ExpressionCodegen.getCompileTimeConstant(expression2, bindingContext, false, shouldInlineConstVals);
    }

    @Nullable
    public static ConstantValue<?> getCompileTimeConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext, boolean takeUpConstValsAsConst, boolean shouldInlineConstVals) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(60);
        }
        if (bindingContext == null) {
            ExpressionCodegen.$$$reportNull$$$0(61);
        }
        return JvmConstantsKt.getCompileTimeConstant(expression2, bindingContext, takeUpConstValsAsConst, shouldInlineConstVals);
    }

    @Override
    public StackValue visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(62);
        }
        List<StringTemplateEntry> entries2 = this.preprocessStringTemplate(expression2);
        Type type2 = this.expressionType(expression2);
        if (entries2.size() == 0) {
            return StackValue.constant("", type2);
        }
        if (entries2.size() == 1) {
            StringTemplateEntry entry = entries2.get(0);
            if (entry instanceof StringTemplateEntry.Expression) {
                KtExpression expr = ((StringTemplateEntry.Expression)entry).expression;
                return DescriptorAsmUtil.genToString(this.gen(expr), this.expressionType(expr), this.kotlinType(expr), this.typeMapper);
            }
            return StackValue.constant(((StringTemplateEntry.Constant)entry).value, type2);
        }
        return StackValue.operation(type2, v -> {
            StringConcatGenerator generator2 = StringConcatGenerator.Companion.create(this.state, (InstructionAdapter)v);
            generator2.genStringBuilderConstructorIfNeded();
            this.invokeAppendForEntries(generator2, entries2);
            generator2.genToString();
            return Unit.INSTANCE;
        });
    }

    private void invokeAppendForEntries(StringConcatGenerator generator2, List<StringTemplateEntry> entries2) {
        for (StringTemplateEntry entry : entries2) {
            if (entry instanceof StringTemplateEntry.Expression) {
                this.invokeAppend(generator2, ((StringTemplateEntry.Expression)entry).expression);
                continue;
            }
            String value2 = ((StringTemplateEntry.Constant)entry).value;
            if (value2.length() == 1) {
                generator2.putValueOrProcessConstant(StackValue.constant(Character.valueOf(value2.charAt(0)), Type.CHAR_TYPE, null));
                continue;
            }
            generator2.addStringConstant(value2);
        }
    }

    @NotNull
    private List<StringTemplateEntry> preprocessStringTemplate(@NotNull KtStringTemplateExpression expression2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(63);
        }
        KtStringTemplateEntry[] entries2 = expression2.getEntries();
        ArrayList<StringTemplateEntry> result2 = new ArrayList<StringTemplateEntry>(entries2.length);
        StringBuilder constantValue = new StringBuilder("");
        for (KtStringTemplateEntry entry : entries2) {
            if (entry instanceof KtLiteralStringTemplateEntry) {
                constantValue.append(entry.getText());
                continue;
            }
            if (entry instanceof KtEscapeStringTemplateEntry) {
                constantValue.append(((KtEscapeStringTemplateEntry)entry).getUnescapedValue());
                continue;
            }
            if (entry instanceof KtStringTemplateEntryWithExpression) {
                KtExpression entryExpression = entry.getExpression();
                if (entryExpression == null) {
                    throw new AssertionError((Object)("No expression in " + entry));
                }
                ConstantValue<?> compileTimeConstant = this.getPrimitiveOrStringCompileTimeConstant(entryExpression);
                if (compileTimeConstant != null && ExpressionCodegen.isConstantValueInlinableInStringTemplate(compileTimeConstant)) {
                    constantValue.append(String.valueOf(compileTimeConstant.getValue()));
                    continue;
                }
                String accumulatedConstantValue = constantValue.toString();
                if (accumulatedConstantValue.length() > 0) {
                    result2.add(new StringTemplateEntry.Constant(accumulatedConstantValue));
                }
                constantValue.setLength(0);
                result2.add(new StringTemplateEntry.Expression(entryExpression));
                continue;
            }
            throw new AssertionError((Object)("Unexpected string template entry: " + entry));
        }
        String leftoverConstantValue = constantValue.toString();
        if (leftoverConstantValue.length() > 0) {
            result2.add(new StringTemplateEntry.Constant(leftoverConstantValue));
        }
        ArrayList<StringTemplateEntry> arrayList = result2;
        if (arrayList == null) {
            ExpressionCodegen.$$$reportNull$$$0(64);
        }
        return arrayList;
    }

    private static boolean isConstantValueInlinableInStringTemplate(@NotNull ConstantValue<?> constant) {
        if (constant == null) {
            ExpressionCodegen.$$$reportNull$$$0(65);
        }
        return constant instanceof StringValue || constant instanceof BooleanValue || constant instanceof DoubleValue || constant instanceof FloatValue || constant instanceof IntegerValueConstant || constant instanceof NullValue;
    }

    @Override
    public StackValue visitBlockExpression(@NotNull KtBlockExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(66);
        }
        return this.generateBlock(expression2, false);
    }

    @Override
    public StackValue visitNamedFunction(@NotNull KtNamedFunction function2, StackValue data2) {
        if (function2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(67);
        }
        return this.visitNamedFunction(function2, data2, false);
    }

    public StackValue visitNamedFunction(@NotNull KtNamedFunction function2, StackValue data2, boolean isStatement) {
        if (function2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(68);
        }
        assert (data2 == StackValue.none());
        if (KtPsiUtil.isScriptDeclaration(function2)) {
            return StackValue.none();
        }
        StackValue closure = this.genClosure(function2, null);
        if (isStatement) {
            DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2);
            int index2 = this.lookupLocalIndex(descriptor2);
            closure.put(AsmTypes.OBJECT_TYPE, null, this.v);
            this.v.store(index2, AsmTypes.OBJECT_TYPE);
            return StackValue.none();
        }
        return closure;
    }

    @Override
    public StackValue visitLambdaExpression(@NotNull KtLambdaExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(69);
        }
        if (Boolean.TRUE.equals(this.bindingContext.get(BindingContext.BLOCK, expression2))) {
            return this.gen(expression2.getFunctionLiteral().getBodyExpression());
        }
        return this.genClosure(expression2.getFunctionLiteral(), null);
    }

    @NotNull
    private StackValue genClosure(KtDeclarationWithBody declaration2, @Nullable SamType samType) {
        FunctionDescriptor descriptor2 = this.bindingContext.get(BindingContext.FUNCTION, declaration2);
        assert (descriptor2 != null) : "Function is not resolved to descriptor: " + declaration2.getText();
        return this.genClosure(declaration2, descriptor2, new ClosureGenerationStrategy(this.state, declaration2), samType, null, null);
    }

    @NotNull
    private StackValue genClosure(@NotNull KtElement declaration2, @NotNull FunctionDescriptor descriptor2, @NotNull FunctionGenerationStrategy strategy, @Nullable SamType samType, @Nullable ResolvedCall<FunctionDescriptor> functionReferenceCall, @Nullable StackValue functionReferenceReceiver) {
        if (declaration2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(70);
        }
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(71);
        }
        if (strategy == null) {
            ExpressionCodegen.$$$reportNull$$$0(72);
        }
        ClassBuilder cv = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(declaration2, descriptor2), CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, descriptor2), declaration2.getContainingFile());
        ClosureCodegen coroutineCodegen = CoroutineCodegenForLambda.create(this, descriptor2, declaration2, cv);
        ClosureContext closureContext = descriptor2.isSuspend() ? this.context.intoCoroutineClosure(CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(descriptor2, this.state), descriptor2, this, this.state.getTypeMapper()) : this.context.intoClosure(descriptor2, this, this.typeMapper);
        ClosureCodegen closureCodegen = coroutineCodegen != null ? coroutineCodegen : new ClosureCodegen(this.state, declaration2, samType, closureContext, functionReferenceCall, strategy, this.parentCodegen, cv);
        closureCodegen.generate();
        return this.putClosureInstanceOnStack(closureCodegen, functionReferenceReceiver);
    }

    @NotNull
    private StackValue putClosureInstanceOnStack(@NotNull ClosureCodegen closureCodegen, @Nullable StackValue functionReferenceReceiver) {
        if (closureCodegen == null) {
            ExpressionCodegen.$$$reportNull$$$0(73);
        }
        if (closureCodegen.getReifiedTypeParametersUsages().wereUsedReifiedParameters()) {
            ReifiedTypeInliner.putNeedClassReificationMarker(this.v);
            this.propagateChildReifiedTypeParametersUsages(closureCodegen.getReifiedTypeParametersUsages());
        }
        StackValue stackValue = closureCodegen.putInstanceOnStack(this, functionReferenceReceiver);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(74);
        }
        return stackValue;
    }

    @Override
    public StackValue visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(75);
        }
        ObjectLiteralResult objectLiteralResult = this.generateObjectLiteral(expression2);
        ClassDescriptor classDescriptor = objectLiteralResult.classDescriptor;
        Type type2 = this.typeMapper.mapType(classDescriptor);
        return StackValue.operation(type2, v -> {
            if (objectLiteralResult.wereReifiedMarkers) {
                ReifiedTypeInliner.putNeedClassReificationMarker(v);
            }
            v.anew(type2);
            v.dup();
            this.pushClosureOnStack(classDescriptor, true, this.defaultCallGenerator, null);
            ClassConstructorDescriptor primaryConstructor2 = classDescriptor.getUnsubstitutedPrimaryConstructor();
            assert (primaryConstructor2 != null) : "There should be primary constructor for object literal";
            ResolvedCall<ConstructorDescriptor> superCall2 = BindingContextUtils.getDelegationConstructorCall(this.bindingContext, primaryConstructor2);
            if (superCall2 != null) {
                ConstructorDescriptor superConstructor = superCall2.getResultingDescriptor();
                ConstructorDescriptor constructorToCall = SamCodegenUtil.resolveSamAdapter(superConstructor);
                List<ValueParameterDescriptor> superValueParameters = superConstructor.getValueParameters();
                int params = superValueParameters.size();
                List<Type> superMappedTypes = this.typeMapper.mapToCallableMethod(constructorToCall, false).getValueParameterTypes();
                assert (superMappedTypes.size() >= params) : String.format("Incorrect number of mapped parameters vs arguments: %d < %d for %s", superMappedTypes.size(), params, classDescriptor);
                ArrayList<ResolvedValueArgument> valueArguments = new ArrayList<ResolvedValueArgument>(params);
                ArrayList<ValueParameterDescriptor> valueParameters2 = new ArrayList<ValueParameterDescriptor>(params);
                ArrayList<Type> mappedTypes = new ArrayList<Type>(params);
                for (ValueParameterDescriptor parameter : superCall2.getValueArguments().keySet()) {
                    ResolvedValueArgument argument2 = superCall2.getValueArguments().get(parameter);
                    if (argument2 instanceof DefaultValueArgument) continue;
                    valueArguments.add(argument2);
                    valueParameters2.add(parameter);
                    mappedTypes.add(superMappedTypes.get(parameter.getIndex()));
                }
                CallBasedArgumentGenerator argumentGenerator = new CallBasedArgumentGenerator(this, this.defaultCallGenerator, valueParameters2, mappedTypes);
                argumentGenerator.generate(valueArguments, valueArguments, null);
            }
            Collection<ClassConstructorDescriptor> constructors2 = classDescriptor.getConstructors();
            assert (constructors2.size() == 1) : "Unexpected number of constructors for class: " + classDescriptor + " " + constructors2;
            ConstructorDescriptor constructorDescriptor = CollectionsKt.single(constructors2);
            Method constructor2 = this.typeMapper.mapAsmMethod(SamCodegenUtil.resolveSamAdapter(constructorDescriptor));
            v.invokespecial(type2.getInternalName(), "<init>", constructor2.getDescriptor(), false);
            return Unit.INSTANCE;
        });
    }

    public void pushClosureOnStack(@NotNull ClassDescriptor classDescriptor, boolean putThis, @NotNull CallGenerator callGenerator, @Nullable StackValue functionReferenceReceiver) {
        KotlinType captureReceiver;
        ClassDescriptor captureThis;
        CalculatedClosure closure;
        if (classDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(76);
        }
        if (callGenerator == null) {
            ExpressionCodegen.$$$reportNull$$$0(77);
        }
        if ((closure = (CalculatedClosure)this.bindingContext.get(CodegenBinding.CLOSURE, classDescriptor)) == null) {
            return;
        }
        int paramIndex = 0;
        if (putThis && (captureThis = closure.getCapturedOuterClassDescriptor()) != null) {
            StackValue thisOrOuter = this.generateThisOrOuter(captureThis, false);
            assert (!AsmUtil.isPrimitive(thisOrOuter.type) || InlineClassesUtilsKt.isInlineClass(captureThis)) : "This or outer for " + captureThis + " should be non-primitive: " + thisOrOuter.type;
            callGenerator.putCapturedValueOnStack(thisOrOuter, thisOrOuter.type, paramIndex++);
        }
        if ((captureReceiver = closure.getCapturedReceiverFromOuterContext()) != null) {
            CallableDescriptor callableDescriptor;
            CallableDescriptor callableDescriptor2;
            Object capturedReceiver = functionReferenceReceiver;
            if (capturedReceiver == null && (callableDescriptor2 = ExpressionCodegen.unwrapOriginalReceiverOwnerForSuspendLambda(this.context)).getExtensionReceiverParameter() != null) {
                capturedReceiver = this.generateExtensionReceiver(callableDescriptor2);
            }
            if (capturedReceiver == null && (callableDescriptor = closure.getEnclosingCallableDescriptorWithReceiver()) != null) {
                capturedReceiver = this.generateExtensionReceiver(callableDescriptor);
            }
            assert (capturedReceiver != null) : "Captured receiver is null for closure " + closure;
            callGenerator.putCapturedValueOnStack((StackValue)capturedReceiver, ((StackValue)capturedReceiver).type, paramIndex++);
        }
        for (Map.Entry entry : closure.getCaptureVariables().entrySet()) {
            boolean asSharedVar;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)entry.getKey();
            EnclosedValueDescriptor valueDescriptor = (EnclosedValueDescriptor)entry.getValue();
            Type sharedVarType = this.typeMapper.getSharedVarType(declarationDescriptor);
            boolean bl = asSharedVar = sharedVarType != null;
            if (sharedVarType == null) {
                sharedVarType = this.typeMapper.mapType((VariableDescriptor)declarationDescriptor);
            }
            StackValue capturedVar = this.lookupOuterValue(valueDescriptor, asSharedVar);
            callGenerator.putCapturedValueOnStack(capturedVar, sharedVarType, paramIndex++);
        }
        ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassNotAny(classDescriptor);
        if (superClass != null) {
            this.pushClosureOnStack(superClass, putThis && closure.getCapturedOuterClassDescriptor() == null, callGenerator, null);
        }
        if (closure.isSuspend()) {
            if (closure.isSuspendLambda()) {
                boolean bl;
                boolean bl2 = bl = callGenerator instanceof PsiInlineCodegen && Objects.requireNonNull(((PsiInlineCodegen)callGenerator).getActiveLambda(), "no active lambda found").isCrossInline();
                if (!bl) {
                    this.v.aconst(null);
                }
            } else if (!(classDescriptor instanceof SyntheticClassDescriptorForLambda) || !((SyntheticClassDescriptorForLambda)classDescriptor).isCallableReference()) {
                assert (this.context.getFunctionDescriptor().isSuspend()) : "Coroutines closure must be created only inside suspend functions";
                ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.last(this.context.getFunctionDescriptor().getValueParameters());
                StackValue continuationValue = this.findLocalOrCapturedValue(valueParameterDescriptor);
                assert (continuationValue != null) : "Couldn't find a value for continuation parameter of " + this.context.getFunctionDescriptor();
                callGenerator.putCapturedValueOnStack(continuationValue, continuationValue.type, paramIndex);
            }
        }
    }

    @NotNull
    private static CallableDescriptor unwrapOriginalReceiverOwnerForSuspendLambda(@NotNull MethodContext context2) {
        FunctionDescriptor originalForInvokeSuspend;
        if (context2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(78);
        }
        if ((originalForInvokeSuspend = context2.getFunctionDescriptor().getUserData(CoroutineCodegenUtilKt.INITIAL_SUSPEND_DESCRIPTOR_FOR_INVOKE_SUSPEND)) != null) {
            FunctionDescriptor functionDescriptor = originalForInvokeSuspend;
            if (functionDescriptor == null) {
                ExpressionCodegen.$$$reportNull$$$0(79);
            }
            return functionDescriptor;
        }
        if (context2.getFunctionDescriptor().isSuspend()) {
            FunctionDescriptor functionDescriptor = CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(context2.getFunctionDescriptor());
            if (functionDescriptor == null) {
                ExpressionCodegen.$$$reportNull$$$0(80);
            }
            return functionDescriptor;
        }
        FunctionDescriptor functionDescriptor = context2.getFunctionDescriptor();
        if (functionDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(81);
        }
        return functionDescriptor;
    }

    StackValue generateBlock(@NotNull KtBlockExpression expression2, boolean isStatement) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(82);
        }
        if (expression2.getParent() instanceof KtNamedFunction) {
            return this.generateBlock(expression2.getStatements(), isStatement, null, this.context.getMethodEndLabel());
        }
        return this.generateBlock(expression2.getStatements(), isStatement, null, null);
    }

    @NotNull
    private StackValue lookupOuterValue(EnclosedValueDescriptor d, boolean asSharedVar) {
        DeclarationDescriptor descriptor2 = d.getDescriptor();
        for (LocalLookup.LocalLookupCase aCase : LocalLookup.LocalLookupCase.values()) {
            if (!aCase.isCase(descriptor2)) continue;
            StackValue outerValue = aCase.outerValue(d, this);
            if (asSharedVar && outerValue instanceof StackValue.FieldForSharedVar) {
                StackValue.FieldForSharedVar fieldForSharedVar = (StackValue.FieldForSharedVar)outerValue;
                StackValue stackValue = fieldForSharedVar.receiver;
                if (stackValue == null) {
                    ExpressionCodegen.$$$reportNull$$$0(83);
                }
                return stackValue;
            }
            StackValue stackValue = outerValue;
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(84);
            }
            return stackValue;
        }
        throw new IllegalStateException("Can't get outer value in " + this + " for " + d);
    }

    private StackValueWithLeaveTask generateBlock(@NotNull List<KtExpression> statements2, boolean isStatement, @Nullable Label labelBeforeLastExpression, @Nullable Label labelBlockEnd) {
        if (statements2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(85);
        }
        Label blockEnd = labelBlockEnd != null ? labelBlockEnd : new Label();
        ArrayList<Function<StackValue, Void>> leaveTasks = Lists.newArrayList();
        StackValue blockResult = null;
        Iterator<KtExpression> iterator2 = statements2.iterator();
        while (iterator2.hasNext()) {
            StackValue statementResult;
            boolean isExpression;
            KtNamedDeclaration declaration2;
            KtExpression possiblyLabeledStatement = iterator2.next();
            KtExpression statement2 = KtPsiUtil.safeDeparenthesize(possiblyLabeledStatement);
            if (statement2 instanceof KtNamedDeclaration && KtPsiUtil.isScriptDeclaration(declaration2 = (KtNamedDeclaration)statement2)) continue;
            this.putDescriptorIntoFrameMap(statement2);
            boolean bl = isExpression = !iterator2.hasNext() && !isStatement;
            if (isExpression && labelBeforeLastExpression != null) {
                this.v.mark(labelBeforeLastExpression);
            }
            StackValue stackValue = statementResult = isExpression ? this.gen(possiblyLabeledStatement) : this.genStatement(possiblyLabeledStatement);
            if (!iterator2.hasNext()) {
                blockResult = statementResult;
            } else {
                statementResult.put(Type.VOID_TYPE, null, this.v);
            }
            this.addLeaveTaskToRemoveDescriptorFromFrameMap(statement2, blockEnd, leaveTasks);
        }
        if (statements2.isEmpty()) {
            blockResult = StackValue.none();
        }
        assert (blockResult != null) : "Block result should be initialized in the loop or the condition above";
        return new StackValueWithLeaveTask(blockResult, value2 -> {
            if (labelBlockEnd == null) {
                this.v.mark(blockEnd);
            }
            for (Function task : Lists.reverse(leaveTasks)) {
                task.fun(value2);
            }
            return Unit.INSTANCE;
        });
    }

    @Nullable
    private StackValue getCoroutineInstanceValueForSuspensionPoint(@NotNull ResolvedCall<?> resolvedCall2) {
        FunctionDescriptor enclosingSuspendLambdaForSuspensionPoint;
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(86);
        }
        if ((enclosingSuspendLambdaForSuspensionPoint = this.bindingContext.get(BindingContext.ENCLOSING_SUSPEND_FUNCTION_FOR_SUSPEND_FUNCTION_CALL, resolvedCall2.getCall())) == null) {
            return null;
        }
        return this.genCoroutineInstanceForSuspendLambda(enclosingSuspendLambdaForSuspensionPoint);
    }

    @Nullable
    public StackValue genCoroutineInstanceForSuspendLambda(@NotNull FunctionDescriptor suspendFunction) {
        if (suspendFunction == null) {
            ExpressionCodegen.$$$reportNull$$$0(87);
        }
        if (!CoroutineCodegenUtilKt.isSuspendLambdaOrLocalFunction(suspendFunction)) {
            return null;
        }
        ClassDescriptor suspendLambdaClassDescriptor = this.bindingContext.get(CodegenBinding.CLASS_FOR_CALLABLE, suspendFunction);
        assert (suspendLambdaClassDescriptor != null) : "Coroutine class descriptor should not be null";
        return StackValue.thisOrOuter(this, suspendLambdaClassDescriptor, false, false);
    }

    @NotNull
    private Type getVariableType(@NotNull VariableDescriptor variableDescriptor) {
        Type sharedVarType;
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(88);
        }
        return (sharedVarType = this.typeMapper.getSharedVarType(variableDescriptor)) != null ? sharedVarType : this.getVariableTypeNoSharing(variableDescriptor);
    }

    @NotNull
    private Type getVariableTypeNoSharing(@NotNull VariableDescriptor variableDescriptor) {
        KotlinType varType;
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(89);
        }
        KotlinType kotlinType = varType = JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor) ? JvmCodegenUtil.getPropertyDelegateType((VariableDescriptorWithAccessors)variableDescriptor, this.bindingContext) : variableDescriptor.getType();
        if (variableDescriptor instanceof ValueParameterDescriptor && MethodSignatureMappingKt.forceSingleValueParameterBoxing((CallableDescriptor)variableDescriptor.getContainingDeclaration())) {
            Type type2 = this.asmType(TypeUtils.makeNullable(varType));
            if (type2 == null) {
                ExpressionCodegen.$$$reportNull$$$0(90);
            }
            return type2;
        }
        Type type3 = this.asmType(varType);
        if (type3 == null) {
            ExpressionCodegen.$$$reportNull$$$0(91);
        }
        return type3;
    }

    private void putDescriptorIntoFrameMap(@NotNull KtElement statement2) {
        if (statement2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(92);
        }
        if (statement2 instanceof KtDestructuringDeclaration) {
            KtDestructuringDeclaration multiDeclaration = (KtDestructuringDeclaration)statement2;
            for (KtDestructuringDeclarationEntry entry : multiDeclaration.getEntries()) {
                this.putLocalVariableIntoFrameMap(entry);
            }
        }
        if (statement2 instanceof KtVariableDeclaration) {
            this.putLocalVariableIntoFrameMap((KtVariableDeclaration)statement2);
        }
        if (statement2 instanceof KtNamedFunction) {
            DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, statement2);
            assert (descriptor2 instanceof FunctionDescriptor) : "Couldn't find function declaration in binding context " + statement2.getText();
            Type type2 = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)descriptor2);
            this.myFrameMap.enter(descriptor2, type2);
        }
    }

    private void putLocalVariableIntoFrameMap(@NotNull KtVariableDeclaration statement2) {
        VariableDescriptor variableDescriptor;
        if (statement2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(93);
        }
        if ((variableDescriptor = this.getVariableDescriptorNotNull(statement2)).getName().isSpecial()) {
            return;
        }
        Type type2 = this.getVariableType(variableDescriptor);
        int index2 = this.myFrameMap.enter(variableDescriptor, type2);
        if (JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor)) {
            this.myFrameMap.enter(CodegenBinding.getDelegatedLocalVariableMetadata(variableDescriptor, this.bindingContext), AsmTypes.K_PROPERTY0_TYPE);
        }
        if (AsmTypes.isSharedVarType(type2)) {
            this.markLineNumber(statement2, false);
            this.v.anew(type2);
            this.v.dup();
            this.v.invokespecial(type2.getInternalName(), "<init>", "()V", false);
            this.v.store(index2, AsmTypes.OBJECT_TYPE);
        }
    }

    private void addLeaveTaskToRemoveDescriptorFromFrameMap(@NotNull KtElement statement2, @NotNull Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        if (statement2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(94);
        }
        if (blockEnd == null) {
            ExpressionCodegen.$$$reportNull$$$0(95);
        }
        if (leaveTasks == null) {
            ExpressionCodegen.$$$reportNull$$$0(96);
        }
        if (statement2 instanceof KtDestructuringDeclaration) {
            KtDestructuringDeclaration multiDeclaration = (KtDestructuringDeclaration)statement2;
            for (KtDestructuringDeclarationEntry entry : multiDeclaration.getEntries()) {
                this.addLeaveTaskToRemoveLocalVariableFromFrameMap(entry, blockEnd, leaveTasks);
            }
        }
        if (statement2 instanceof KtVariableDeclaration) {
            this.addLeaveTaskToRemoveLocalVariableFromFrameMap((KtVariableDeclaration)statement2, blockEnd, leaveTasks);
        }
        if (statement2 instanceof KtNamedFunction) {
            this.addLeaveTaskToRemoveNamedFunctionFromFrameMap((KtNamedFunction)statement2, blockEnd, leaveTasks);
        }
    }

    private void addLeaveTaskToRemoveLocalVariableFromFrameMap(@NotNull KtVariableDeclaration statement2, Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        VariableDescriptor variableDescriptor;
        if (statement2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(97);
        }
        if (leaveTasks == null) {
            ExpressionCodegen.$$$reportNull$$$0(98);
        }
        if ((variableDescriptor = this.getVariableDescriptorNotNull(statement2)).getName().isSpecial()) {
            return;
        }
        Type type2 = this.getVariableType(variableDescriptor);
        Label scopeStart = new Label();
        this.v.mark(scopeStart);
        leaveTasks.add(answer -> {
            if (JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor)) {
                this.myFrameMap.leave(CodegenBinding.getDelegatedLocalVariableMetadata(variableDescriptor, this.bindingContext));
            }
            int index2 = this.myFrameMap.leave(variableDescriptor);
            this.v.visitLocalVariable(variableDescriptor.getName().asString(), type2.getDescriptor(), null, scopeStart, blockEnd, index2);
            return null;
        });
    }

    private void addLeaveTaskToRemoveNamedFunctionFromFrameMap(@NotNull KtNamedFunction localFunction, Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        if (localFunction == null) {
            ExpressionCodegen.$$$reportNull$$$0(99);
        }
        if (leaveTasks == null) {
            ExpressionCodegen.$$$reportNull$$$0(100);
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, localFunction);
        assert (functionDescriptor != null);
        Type type2 = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, functionDescriptor);
        Label scopeStart = new Label();
        this.v.mark(scopeStart);
        leaveTasks.add(answer -> {
            int index2 = this.myFrameMap.leave(functionDescriptor);
            String functionIndex = StringsKt.substringAfterLast(type2.getInternalName(), '$', "");
            assert (!functionIndex.isEmpty());
            String localVariableName = "$fun$" + CommonVariableAsmNameManglingUtils.mangleNameIfNeeded(functionDescriptor.getName().asString()) + "$" + functionIndex;
            this.v.visitLocalVariable(localVariableName, type2.getDescriptor(), null, scopeStart, blockEnd, index2);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runWithShouldMarkLineNumbers(boolean enable, Supplier<T> operation) {
        boolean originalStatus = this.shouldMarkLineNumbers;
        this.shouldMarkLineNumbers = enable;
        try {
            T t = operation.get();
            return t;
        }
        finally {
            this.shouldMarkLineNumbers = originalStatus;
        }
    }

    public void markStartLineNumber(@NotNull KtElement element) {
        if (element == null) {
            ExpressionCodegen.$$$reportNull$$$0(101);
        }
        this.markLineNumber(element, false);
    }

    public void markLineNumber(@NotNull PsiElement statement2, boolean markEndOffset) {
        if (statement2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(102);
        }
        if (!this.shouldMarkLineNumbers) {
            return;
        }
        Integer lineNumber = CodegenUtil.getLineNumberForElement(statement2, markEndOffset);
        if (lineNumber == null || lineNumber == this.myLastLineNumber) {
            return;
        }
        this.myLastLineNumber = lineNumber;
        Label label = new Label();
        this.v.visitLabel(label);
        this.v.visitLineNumber(lineNumber, label);
    }

    @Override
    public void markLineNumberAfterInlineIfNeeded(boolean registerLineNumberAfterwards) {
        if (!this.shouldMarkLineNumbers || registerLineNumberAfterwards) {
            if (this.myLastLineNumber > -1) {
                Label label = new Label();
                this.v.visitLabel(label);
                this.v.visitLineNumber(this.myLastLineNumber, label);
            }
        } else {
            this.resetLastLineNumber();
        }
    }

    private void resetLastLineNumber() {
        this.myLastLineNumber = -1;
    }

    @Override
    public int getLastLineNumber() {
        return this.myLastLineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFinallyOnReturn(@NotNull Label afterReturnLabel, @NotNull List<TryBlockStackElement> nestedTryBlocksWithoutFinally) {
        if (afterReturnLabel == null) {
            ExpressionCodegen.$$$reportNull$$$0(103);
        }
        if (nestedTryBlocksWithoutFinally == null) {
            ExpressionCodegen.$$$reportNull$$$0(104);
        }
        if (!this.blockStackElements.isEmpty()) {
            BlockStackElement stackElement2 = this.blockStackElements.peek();
            if (stackElement2 instanceof TryWithFinallyBlockStackElement) {
                TryWithFinallyBlockStackElement tryWithFinallyBlockStackElement = (TryWithFinallyBlockStackElement)stackElement2;
                this.genFinallyBlockOrGoto(tryWithFinallyBlockStackElement, null, afterReturnLabel, nestedTryBlocksWithoutFinally);
                nestedTryBlocksWithoutFinally.clear();
            } else if (stackElement2 instanceof TryBlockStackElement) {
                nestedTryBlocksWithoutFinally.add((TryBlockStackElement)stackElement2);
            } else if (!(stackElement2 instanceof LoopBlockStackElement)) {
                throw new UnsupportedOperationException("Wrong BlockStackElement in processing stack");
            }
            this.blockStackElements.pop();
            try {
                boolean bl = this.doFinallyOnReturn(afterReturnLabel, nestedTryBlocksWithoutFinally);
                return bl;
            }
            finally {
                this.blockStackElements.push(stackElement2);
            }
        }
        return false;
    }

    public boolean hasFinallyBlocks() {
        for (BlockStackElement element : this.blockStackElements) {
            if (!(element instanceof TryWithFinallyBlockStackElement)) continue;
            return true;
        }
        return false;
    }

    private void genFinallyBlockOrGoto(@Nullable TryWithFinallyBlockStackElement tryWithFinallyBlockStackElement, @Nullable Label tryCatchBlockEnd, @Nullable Label afterJumpLabel, @NotNull List<TryBlockStackElement> nestedTryBlocksWithoutFinally) {
        if (nestedTryBlocksWithoutFinally == null) {
            ExpressionCodegen.$$$reportNull$$$0(105);
        }
        if (tryWithFinallyBlockStackElement != null) {
            ++this.finallyDepth;
            assert (tryWithFinallyBlockStackElement.gaps.size() % 2 == 0) : "Finally block gaps are inconsistent";
            BlockStackElement topOfStack = this.blockStackElements.pop();
            assert (topOfStack == tryWithFinallyBlockStackElement) : "Top element of stack doesn't equals processing finally block";
            KtTryExpression jetTryExpression = tryWithFinallyBlockStackElement.expression;
            Label finallyStart = CodegenUtilKt.linkedLabel();
            this.v.mark(finallyStart);
            tryWithFinallyBlockStackElement.addGapLabel(finallyStart);
            ExpressionCodegen.addGapLabelsForNestedTryCatchWithoutFinally(this.state, nestedTryBlocksWithoutFinally, finallyStart);
            if (InlineCodegenUtilsKt.isFinallyMarkerRequired(this.context)) {
                InlineCodegenUtilsKt.generateFinallyMarker(this.v, this.finallyDepth, true);
            }
            this.gen(jetTryExpression.getFinallyBlock().getFinalExpression(), Type.VOID_TYPE);
            if (InlineCodegenUtilsKt.isFinallyMarkerRequired(this.context)) {
                InlineCodegenUtilsKt.generateFinallyMarker(this.v, this.finallyDepth, false);
            }
        }
        if (tryCatchBlockEnd != null) {
            if (tryWithFinallyBlockStackElement != null) {
                this.markLineNumber(tryWithFinallyBlockStackElement.expression, true);
            }
            this.v.goTo(tryCatchBlockEnd);
        }
        if (tryWithFinallyBlockStackElement != null) {
            Label finallyEnd;
            --this.finallyDepth;
            Label label = finallyEnd = afterJumpLabel != null ? afterJumpLabel : new Label();
            if (afterJumpLabel == null) {
                this.v.mark(finallyEnd);
            }
            tryWithFinallyBlockStackElement.addGapLabel(finallyEnd);
            ExpressionCodegen.addGapLabelsForNestedTryCatchWithoutFinally(this.state, nestedTryBlocksWithoutFinally, finallyEnd);
            this.blockStackElements.push(tryWithFinallyBlockStackElement);
        }
    }

    private static void addGapLabelsForNestedTryCatchWithoutFinally(@NotNull GenerationState state, @NotNull List<TryBlockStackElement> nestedTryBlocksWithoutFinally, @NotNull Label label) {
        if (state == null) {
            ExpressionCodegen.$$$reportNull$$$0(106);
        }
        if (nestedTryBlocksWithoutFinally == null) {
            ExpressionCodegen.$$$reportNull$$$0(107);
        }
        if (label == null) {
            ExpressionCodegen.$$$reportNull$$$0(108);
        }
        if (state.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperFinally)) {
            for (TryBlockStackElement tryBlock : nestedTryBlocksWithoutFinally) {
                tryBlock.addGapLabel(label);
            }
        }
    }

    private KotlinType getNothingType() {
        return this.state.getModule().getBuiltIns().getNothingType();
    }

    @Override
    public StackValue visitReturnExpression(@NotNull KtReturnExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(109);
        }
        return StackValue.operation(Type.VOID_TYPE, this.getNothingType(), adapter -> {
            KotlinType returnKotlinType;
            Type returnType2;
            boolean isNonLocalReturn;
            KtExpression returnedExpression = expression2.getReturnedExpression();
            CallableMemberDescriptor descriptor2 = (CallableMemberDescriptor)this.getContext().getContextDescriptor();
            NonLocalReturnInfo nonLocalReturn = this.getNonLocalReturnInfo(descriptor2, expression2);
            boolean bl = isNonLocalReturn = nonLocalReturn != null;
            if (isNonLocalReturn && this.state.isInlineDisabled()) {
                this.state.getDiagnostics().report(Errors.NON_LOCAL_RETURN_IN_DISABLED_INLINE.on(expression2));
                AsmUtil.genThrow(this.v, "java/lang/UnsupportedOperationException", "Non-local returns are not allowed with inlining disabled");
                return Unit.INSTANCE;
            }
            if (isNonLocalReturn) {
                FunctionDescriptor returnTarget;
                FunctionDescriptor functionDescriptor = returnTarget = nonLocalReturn.descriptor instanceof FunctionDescriptor ? (FunctionDescriptor)nonLocalReturn.descriptor : null;
                if (returnTarget == null || !returnTarget.isSuspend()) {
                    JvmKotlinType jvmKotlinType = nonLocalReturn.getJvmKotlinType(this.typeMapper);
                    returnType2 = jvmKotlinType.getType();
                    returnKotlinType = jvmKotlinType.getKotlinType();
                } else if (returnTarget instanceof AnonymousFunctionDescriptor) {
                    returnType2 = AsmTypes.OBJECT_TYPE;
                    returnKotlinType = this.state.getModule().getBuiltIns().getNullableAnyType();
                } else {
                    CodegenContext inlineSiteContext = this.context.getFirstCrossInlineOrNonInlineContext();
                    KotlinType originalInlineClass = null;
                    if (inlineSiteContext instanceof MethodContext) {
                        FunctionDescriptor view = CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(returnTarget, this.state);
                        originalInlineClass = CoroutineCodegenUtilKt.originalReturnTypeOfSuspendFunctionReturningUnboxedInlineClass(view, this.typeMapper);
                    }
                    if (originalInlineClass != null) {
                        returnType2 = this.typeMapper.mapType(originalInlineClass);
                        returnKotlinType = originalInlineClass;
                    } else {
                        JvmKotlinType jvmKotlinType = nonLocalReturn.getJvmKotlinType(this.typeMapper);
                        returnType2 = jvmKotlinType.getType();
                        returnKotlinType = jvmKotlinType.getKotlinType();
                    }
                }
            } else {
                KotlinType originalInlineClass = CoroutineCodegenUtilKt.originalReturnTypeOfSuspendFunctionReturningUnboxedInlineClass(this.context.getFunctionDescriptor(), this.typeMapper);
                if (originalInlineClass != null) {
                    returnType2 = this.typeMapper.mapType(originalInlineClass);
                    returnKotlinType = originalInlineClass;
                } else {
                    returnType2 = this.returnType;
                    returnKotlinType = this.context.getFunctionDescriptor().getReturnType();
                }
            }
            StackValue valueToReturn = returnedExpression != null ? this.gen(returnedExpression) : StackValue.none();
            this.putStackValue(returnedExpression, returnType2, returnKotlinType, valueToReturn);
            Label afterReturnLabel = new Label();
            this.generateFinallyBlocksIfNeeded(returnType2, returnKotlinType, afterReturnLabel);
            this.markLineNumber(expression2, false);
            if (isNonLocalReturn) {
                InlineCodegenUtilsKt.generateGlobalReturnFlag(this.v, nonLocalReturn.labelName);
                this.v.visitInsn(returnType2.getOpcode(172));
            } else {
                this.v.areturn(this.returnType);
            }
            this.v.mark(afterReturnLabel);
            return Unit.INSTANCE;
        });
    }

    public void generateFinallyBlocksIfNeeded(@NotNull Type returnType2, @Nullable KotlinType returnKotlinType, @NotNull Label afterReturnLabel) {
        if (returnType2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(110);
        }
        if (afterReturnLabel == null) {
            ExpressionCodegen.$$$reportNull$$$0(111);
        }
        if (this.hasFinallyBlocks()) {
            if (!Type.VOID_TYPE.equals(returnType2)) {
                int returnValIndex = this.myFrameMap.enterTemp(returnType2);
                StackValue.Local localForReturnValue = StackValue.local(returnValIndex, returnType2, returnKotlinType);
                localForReturnValue.store(StackValue.onStack(returnType2, returnKotlinType), this.v);
                this.doFinallyOnReturn(afterReturnLabel, new ArrayList<TryBlockStackElement>());
                localForReturnValue.put(returnType2, null, this.v);
                this.myFrameMap.leaveTemp(returnType2);
            } else {
                this.doFinallyOnReturn(afterReturnLabel, new ArrayList<TryBlockStackElement>());
            }
        }
    }

    @Nullable
    private NonLocalReturnInfo getNonLocalReturnInfo(@NotNull CallableMemberDescriptor descriptor2, @NotNull KtReturnExpression expression2) {
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(112);
        }
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(113);
        }
        if (ExpressionTypingUtils.isFunctionLiteral(descriptor2) || ExpressionTypingUtils.isFunctionExpression(descriptor2)) {
            if (expression2.getLabelName() == null) {
                if (ExpressionTypingUtils.isFunctionLiteral(descriptor2)) {
                    FunctionDescriptor containingFunction = BindingContextUtils.getContainingFunctionSkipFunctionLiterals(descriptor2, true).getFirst();
                    return new NonLocalReturnInfo(containingFunction, "$$$$$ROOT$$$$$");
                }
                return null;
            }
            PsiElement element = this.bindingContext.get(BindingContext.LABEL_TARGET, expression2.getTargetLabel());
            if (element != DescriptorToSourceUtils.getSourceFromDescriptor(this.context.getContextDescriptor())) {
                DeclarationDescriptor elementDescriptor = this.typeMapper.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
                assert (element != null) : "Expression should be not null " + expression2.getText();
                assert (elementDescriptor != null) : "Descriptor should be not null: " + element.getText();
                CallableDescriptor function2 = (CallableDescriptor)elementDescriptor;
                return new NonLocalReturnInfo(function2, expression2.getLabelName());
            }
        }
        return null;
    }

    public void returnExpression(@NotNull KtExpression expr) {
        Type typeForExpression;
        if (expr == null) {
            ExpressionCodegen.$$$reportNull$$$0(114);
        }
        boolean isBlockedNamedFunction = expr instanceof KtBlockExpression && expr.getParent() instanceof KtNamedFunction;
        FunctionDescriptor originalSuspendLambdaDescriptor = ExpressionCodegen.getOriginalSuspendLambdaDescriptorFromContext(this.context);
        boolean isVoidCoroutineLambda = originalSuspendLambdaDescriptor != null && DescriptorBasedTypeSignatureMappingKt.hasVoidReturnType(originalSuspendLambdaDescriptor);
        KotlinType originalReturnTypeOfSuspendFunctionReturningUnboxedInlineClass = CoroutineCodegenUtilKt.originalReturnTypeOfSuspendFunctionReturningUnboxedInlineClass(this.context.getFunctionDescriptor(), this.typeMapper);
        Type type2 = isBlockedNamedFunction || isVoidCoroutineLambda ? Type.VOID_TYPE : (typeForExpression = originalReturnTypeOfSuspendFunctionReturningUnboxedInlineClass != null ? this.typeMapper.mapType(originalReturnTypeOfSuspendFunctionReturningUnboxedInlineClass) : this.returnType);
        KotlinType kotlinTypeForExpression = isBlockedNamedFunction || isVoidCoroutineLambda ? null : (originalReturnTypeOfSuspendFunctionReturningUnboxedInlineClass != null ? originalReturnTypeOfSuspendFunctionReturningUnboxedInlineClass : this.context.getFunctionDescriptor().getReturnType());
        this.gen(expr, typeForExpression, kotlinTypeForExpression);
        if (!ExpressionCodegen.endsWithReturn(expr)) {
            if (ExpressionCodegen.isLambdaVoidBody(expr, typeForExpression)) {
                this.markLineNumber((KtFunctionLiteral)expr.getParent(), true);
            } else if (!ExpressionCodegen.isLambdaBody(expr)) {
                this.markLineNumber(expr, true);
            }
            if (typeForExpression.getSort() == 0) {
                StackValue.none().put(this.returnType, null, this.v);
            }
            this.v.areturn(this.returnType);
        }
    }

    private static boolean endsWithReturn(@NotNull KtElement bodyExpression) {
        if (bodyExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(115);
        }
        if (bodyExpression instanceof KtBlockExpression) {
            List<KtExpression> statements2 = ((KtBlockExpression)bodyExpression).getStatements();
            return statements2.size() > 0 && statements2.get(statements2.size() - 1) instanceof KtReturnExpression;
        }
        return bodyExpression instanceof KtReturnExpression;
    }

    private static boolean isLambdaVoidBody(@NotNull KtElement bodyExpression, @NotNull Type returnType2) {
        if (bodyExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(116);
        }
        if (returnType2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(117);
        }
        return ExpressionCodegen.isLambdaBody(bodyExpression) && Type.VOID_TYPE.equals(returnType2);
    }

    private static boolean isLambdaBody(@NotNull KtElement bodyExpression) {
        if (bodyExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(118);
        }
        if (bodyExpression instanceof KtBlockExpression) {
            PsiElement parent2 = bodyExpression.getParent();
            return parent2 instanceof KtFunctionLiteral;
        }
        return false;
    }

    @Override
    public StackValue visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @NotNull StackValue receiver) {
        StackValue intrinsicResult;
        DeclarationDescriptor descriptor2;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(119);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(120);
        }
        if ((resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.bindingContext)) == null) {
            descriptor2 = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        } else {
            StackValue intrinsicResult2;
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                VariableAsFunctionResolvedCall call2 = (VariableAsFunctionResolvedCall)((Object)resolvedCall2);
                resolvedCall2 = call2.getVariableCall();
            }
            if ((intrinsicResult2 = this.applyIntrinsic(descriptor2 = resolvedCall2.getResultingDescriptor(), KCallableNameProperty.class, resolvedCall2, receiver)) != null) {
                return intrinsicResult2;
            }
            receiver = StackValue.receiver(resolvedCall2, receiver, this, null);
            if (descriptor2 instanceof FakeCallableDescriptorForObject) {
                descriptor2 = ((FakeCallableDescriptorForObject)descriptor2).getReferencedDescriptor();
            }
        }
        assert (descriptor2 != null) : "Couldn't find descriptor for '" + expression2.getText() + "'";
        boolean isSyntheticField = (descriptor2 = descriptor2.getOriginal()) instanceof SyntheticFieldDescriptor;
        if (isSyntheticField) {
            descriptor2 = ((SyntheticFieldDescriptor)descriptor2).getPropertyDescriptor();
        }
        if ((intrinsicResult = this.applyIntrinsic(descriptor2, IntrinsicPropertyGetter.class, resolvedCall2, receiver)) != null) {
            return intrinsicResult;
        }
        return this.generateNonIntrinsicSimpleNameExpression(expression2, receiver, descriptor2, resolvedCall2, isSyntheticField);
    }

    public StackValue generateNonIntrinsicSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @NotNull StackValue receiver, @NotNull DeclarationDescriptor descriptor2, @Nullable ResolvedCall<?> resolvedCall2, boolean isSyntheticField) {
        ClassDescriptor classDescriptor;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(121);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(122);
        }
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(123);
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            ClassDescriptor superCallTarget;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
            if (InlineClassesUtilsKt.isUnderlyingPropertyOfInlineClass(propertyDescriptor)) {
                KotlinType propertyType = propertyDescriptor.getType();
                return StackValue.underlyingValueOfInlineClass(this.typeMapper.mapType(propertyType), propertyType, receiver);
            }
            List codegenExtensions = ExpressionCodegenExtension.Companion.getInstances(this.state.getProject());
            if (!codegenExtensions.isEmpty() && resolvedCall2 != null) {
                ExpressionCodegenExtension.Context context2 = new ExpressionCodegenExtension.Context(this, this.typeMapper, this.v);
                KotlinType returnType2 = propertyDescriptor.getReturnType();
                for (ExpressionCodegenExtension extension : codegenExtensions) {
                    StackValue value2;
                    if (returnType2 == null || (value2 = extension.applyProperty(receiver, resolvedCall2, context2)) == null) continue;
                    return value2;
                }
            }
            boolean directToField = isSyntheticField && this.contextKind() != OwnerKind.DEFAULT_IMPLS;
            ClassDescriptor classDescriptor2 = superCallTarget = resolvedCall2 == null ? null : this.getSuperCallTarget(resolvedCall2.getCall());
            if (directToField) {
                receiver = StackValue.receiverWithoutReceiverArgument(receiver);
            }
            return this.intermediateValueForProperty(propertyDescriptor, directToField, directToField, superCallTarget, false, receiver, resolvedCall2, false);
        }
        if (descriptor2 instanceof FakeCallableDescriptorForTypeAliasObject) {
            descriptor2 = ((FakeCallableDescriptorForTypeAliasObject)descriptor2).getTypeAliasDescriptor();
        }
        if (descriptor2 instanceof TypeAliasDescriptor) {
            classDescriptor = ((TypeAliasDescriptor)descriptor2).getClassDescriptor();
            assert (classDescriptor != null) : "Type alias " + descriptor2 + " static member reference should be rejected by type checker, since there is no class corresponding to this type alias.";
            descriptor2 = classDescriptor;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            classDescriptor = (ClassDescriptor)descriptor2;
            if (this.shouldGenerateSingletonAsThisOrOuterFromContext(classDescriptor)) {
                return this.generateThisOrOuterFromContext(classDescriptor, false, false);
            }
            if (DescriptorUtils.isCompanionObject(classDescriptor)) {
                return this.generateCompanionObjectInstance(classDescriptor);
            }
            if (DescriptorUtils.isObject(classDescriptor)) {
                return StackValue.singleton(classDescriptor, this.typeMapper);
            }
            if (DescriptorUtils.isEnumEntry(classDescriptor)) {
                return StackValue.enumEntry(classDescriptor, this.typeMapper);
            }
            ClassDescriptor companionObjectDescriptor2 = classDescriptor.getCompanionObjectDescriptor();
            if (companionObjectDescriptor2 != null) {
                return this.generateCompanionObjectInstance(companionObjectDescriptor2);
            }
            return StackValue.none();
        }
        StackValue localOrCaptured = this.findLocalOrCapturedValue(descriptor2);
        if (localOrCaptured != null) {
            KotlinType inlineClassType;
            if (descriptor2 instanceof ValueParameterDescriptor && InlineClassesCodegenUtilKt.isInlineClassWithUnderlyingTypeAnyOrAnyN(inlineClassType = ((ValueParameterDescriptor)descriptor2).getType()) && InlineClassesCodegenUtilKt.isGenericParameter((CallableDescriptor)descriptor2) && !(this.context instanceof InlineLambdaContext) && !CoroutineCodegenUtilKt.isInvokeSuspendOfLambda(this.context.getFunctionDescriptor())) {
                InlineClassRepresentation<SimpleType> representation;
                ClassDescriptor inlineClass = (ClassDescriptor)inlineClassType.getConstructor().getDeclarationDescriptor();
                InlineClassRepresentation<SimpleType> inlineClassRepresentation2 = representation = inlineClass != null ? inlineClass.getInlineClassRepresentation() : null;
                assert (representation != null) : "Not an inline class: " + inlineClassType;
                KotlinType underlyingType = representation.getUnderlyingType();
                return StackValue.underlyingValueOfInlineClass(this.typeMapper.mapType(underlyingType), underlyingType, localOrCaptured);
            }
            return localOrCaptured;
        }
        throw new UnsupportedOperationException("don't know how to generate reference " + descriptor2);
    }

    private StackValue generateCompanionObjectInstance(ClassDescriptor companionObjectDescriptor2) {
        assert (DescriptorUtils.isCompanionObject(companionObjectDescriptor2)) : "Companion object expected: " + companionObjectDescriptor2;
        CodegenContext accessorContext = this.getContextForCompanionObjectAccessorIfRequiredOrNull(companionObjectDescriptor2, this.context);
        if (accessorContext == null) {
            return StackValue.singleton(companionObjectDescriptor2, this.typeMapper);
        }
        Object accessorContextDescriptor = accessorContext.getContextDescriptor();
        assert (accessorContextDescriptor instanceof ClassDescriptor) : "Expected to put accessor for companion object " + companionObjectDescriptor2 + " into a class, but got " + accessorContextDescriptor;
        accessorContext.getOrCreateAccessorForCompanionObject(companionObjectDescriptor2);
        Type hostClassType = this.typeMapper.mapClass((ClassDescriptor)accessorContextDescriptor);
        Type companionObjectType = this.typeMapper.mapClass(companionObjectDescriptor2);
        return StackValue.operation(companionObjectType, companionObjectDescriptor2.getDefaultType(), v1 -> {
            v1.invokestatic(hostClassType.getInternalName(), JvmCodegenUtil.getCompanionObjectAccessorName(companionObjectDescriptor2), Type.getMethodDescriptor(companionObjectType, new Type[0]), false);
            return null;
        });
    }

    private boolean shouldGenerateSingletonAsThisOrOuterFromContext(ClassDescriptor classDescriptor) {
        if (!CodegenUtilKt.isPossiblyUninitializedSingleton(classDescriptor)) {
            return false;
        }
        if (!this.isInsideSingleton(classDescriptor)) {
            return false;
        }
        for (CodegenContext context2 = this.context; context2 != null; context2 = ((CodegenContext)context2).getParentContext()) {
            ClassDescriptor contextClass;
            if (context2 instanceof ConstructorContext) {
                ConstructorContext constructorContext = (ConstructorContext)context2;
                ClassDescriptor constructedClass = constructorContext.getConstructorDescriptor().getConstructedClass();
                if (constructedClass != classDescriptor) continue;
                return constructorContext.isThisInitialized();
            }
            if (!(context2 instanceof ClassContext) || !ExpressionCodegen.isInInnerClassesChainFor(contextClass = (ClassDescriptor)((ClassContext)context2).getContextDescriptor(), classDescriptor)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInInnerClassesChainFor(ClassDescriptor innerClass, ClassDescriptor outerClass2) {
        if (innerClass == outerClass2) {
            return true;
        }
        if (!innerClass.isInner()) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = innerClass.getContainingDeclaration();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            return false;
        }
        return ExpressionCodegen.isInInnerClassesChainFor((ClassDescriptor)containingDeclaration, outerClass2);
    }

    @Nullable
    private StackValue applyIntrinsic(DeclarationDescriptor descriptor2, Class<? extends IntrinsicPropertyGetter> intrinsicType, ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver) {
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(124);
        }
        if (descriptor2 instanceof CallableMemberDescriptor) {
            CallableMemberDescriptor memberDescriptor = DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)descriptor2);
            IntrinsicMethod intrinsic = this.state.getIntrinsics().getIntrinsic(memberDescriptor);
            if (intrinsicType.isInstance(intrinsic)) {
                Type returnType2 = this.typeMapper.mapType(memberDescriptor);
                return ((IntrinsicPropertyGetter)intrinsic).generate(resolvedCall2, this, returnType2, receiver);
            }
        }
        return null;
    }

    @Nullable
    public ClassDescriptor getSuperCallTarget(@NotNull Call call2) {
        KtSuperExpression superExpression;
        if (call2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(125);
        }
        return (superExpression = CallResolverUtilKt.getSuperCallExpression(call2)) == null ? null : ExpressionCodegen.getSuperCallLabelTarget(this.context, superExpression);
    }

    @Nullable
    public StackValue findLocalOrCapturedValue(@NotNull DeclarationDescriptor descriptor2) {
        int index2;
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(126);
        }
        if ((index2 = this.lookupLocalIndex(descriptor2)) >= 0) {
            return this.stackValueForLocal(descriptor2, index2);
        }
        return this.findCapturedValue(descriptor2);
    }

    @Nullable
    public StackValue findCapturedValue(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(127);
        }
        if (this.context instanceof ConstructorContext) {
            return this.lookupCapturedValueInConstructorParameters(descriptor2);
        }
        StackValue value2 = this.context.lookupInContext(descriptor2, StackValue.LOCAL_0, this.state, false);
        if (JvmCodegenUtil.isDelegatedLocalVariable(descriptor2) && value2 != null) {
            VariableDescriptor metadata2 = CodegenBinding.getDelegatedLocalVariableMetadata((VariableDescriptor)descriptor2, this.bindingContext);
            StackValue metadataValue = this.context.lookupInContext(metadata2, StackValue.LOCAL_0, this.state, false);
            assert (metadataValue != null) : "Metadata stack value should be non-null for local delegated property: " + descriptor2;
            return this.delegatedVariableValue(value2, metadataValue, (VariableDescriptorWithAccessors)descriptor2, this.typeMapper);
        }
        return value2;
    }

    @Nullable
    private StackValue lookupCapturedValueInConstructorParameters(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(128);
        }
        StackValue parentResult = this.context.lookupInContext(descriptor2, StackValue.LOCAL_0, this.state, false);
        if (this.context.closure == null || parentResult == null) {
            return parentResult;
        }
        int parameterOffsetInConstructor = this.context.closure.getCapturedParameterOffsetInConstructor(descriptor2);
        if (parameterOffsetInConstructor == -1) {
            return this.adjustVariableValue(parentResult, descriptor2);
        }
        assert (parentResult instanceof StackValue.Field || parentResult instanceof StackValue.FieldForSharedVar) : "Part of closure should be either Field or FieldForSharedVar";
        if (parentResult instanceof StackValue.FieldForSharedVar) {
            return StackValue.shared(parameterOffsetInConstructor, parentResult.type);
        }
        return this.adjustVariableValue(StackValue.local(parameterOffsetInConstructor, parentResult.type, parentResult.kotlinType), descriptor2);
    }

    private StackValue stackValueForLocal(DeclarationDescriptor descriptor2, int index2) {
        if (descriptor2 instanceof VariableDescriptor) {
            KotlinType delegateKotlinType;
            VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor2;
            Type sharedVarType = this.typeMapper.getSharedVarType(descriptor2);
            Type varType = this.getVariableTypeNoSharing(variableDescriptor);
            KotlinType kotlinType = delegateKotlinType = JvmCodegenUtil.isDelegatedLocalVariable(descriptor2) ? JvmCodegenUtil.getPropertyDelegateType((VariableDescriptorWithAccessors)descriptor2, this.bindingContext) : null;
            if (sharedVarType != null) {
                return StackValue.shared(index2, varType, variableDescriptor, delegateKotlinType);
            }
            return this.adjustVariableValue(StackValue.local(index2, varType, variableDescriptor, delegateKotlinType), variableDescriptor);
        }
        return StackValue.local(index2, AsmTypes.OBJECT_TYPE);
    }

    @Override
    public boolean isLocal(DeclarationDescriptor descriptor2) {
        LocalLookup outerLookup;
        if (this.lookupLocalIndex(descriptor2) != -1) {
            return true;
        }
        if (this.context.isContextWithUninitializedThis() && (outerLookup = this.context.getParentContext().getEnclosingLocalLookup()) != null) {
            return outerLookup.isLocal(descriptor2);
        }
        return false;
    }

    public int lookupLocalIndex(DeclarationDescriptor descriptor2) {
        int index2 = this.myFrameMap.getIndex(descriptor2);
        if (index2 != -1) {
            return index2;
        }
        if (!(descriptor2 instanceof ValueParameterDescriptor)) {
            return -1;
        }
        DeclarationDescriptor synonym = this.bindingContext.get(CodegenBinding.PARAMETER_SYNONYM, (ValueParameterDescriptor)descriptor2);
        if (synonym == null) {
            return -1;
        }
        return this.myFrameMap.getIndex(synonym);
    }

    @NotNull
    public StackValue.Property intermediateValueForProperty(@NotNull PropertyDescriptor propertyDescriptor, boolean forceField, @Nullable ClassDescriptor superCallTarget, @NotNull StackValue receiver) {
        if (propertyDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(129);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(130);
        }
        StackValue.Property property2 = this.intermediateValueForProperty(propertyDescriptor, forceField, false, superCallTarget, false, receiver, null, false);
        if (property2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(131);
        }
        return property2;
    }

    private CodegenContext getBackingFieldContext(@NotNull AccessorKind accessorKind, @NotNull DeclarationDescriptor containingDeclaration) {
        if (accessorKind == null) {
            ExpressionCodegen.$$$reportNull$$$0(132);
        }
        if (containingDeclaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(133);
        }
        switch (accessorKind) {
            case NORMAL: {
                CodegenContext parentWithDescriptor;
                if (containingDeclaration instanceof ClassDescriptor && (parentWithDescriptor = this.context.findParentContextWithDescriptor(containingDeclaration)) != null) {
                    return parentWithDescriptor;
                }
                return this.context.getParentContext();
            }
            case IN_CLASS_COMPANION: {
                return this.context.findParentContextWithDescriptor(containingDeclaration.getContainingDeclaration());
            }
            case FIELD_FROM_LOCAL: {
                return this.context.findParentContextWithDescriptor(containingDeclaration);
            }
            case LATEINIT_INTRINSIC: {
                return this.context.findParentContextWithDescriptor(containingDeclaration);
            }
        }
        throw new IllegalStateException("Unknown field accessor kind: " + (Object)((Object)accessorKind));
    }

    private static boolean isDefaultAccessor(@Nullable PropertyAccessorDescriptor accessor) {
        return accessor == null || accessor.isDefault();
    }

    public StackValue.Property intermediateValueForProperty(@NotNull PropertyDescriptor propertyDescriptor, boolean forceField, boolean syntheticBackingField, @Nullable ClassDescriptor superCallTarget, boolean skipAccessorsForPrivateFieldInOuterClass, @NotNull StackValue receiver, @Nullable ResolvedCall resolvedCall2, boolean skipLateinitAssertion) {
        String fieldName;
        DeclarationDescriptor ownerDescriptor;
        boolean skipPropertyAccessors;
        if (propertyDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(134);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(135);
        }
        if (propertyDescriptor instanceof SyntheticJavaPropertyDescriptor) {
            return this.intermediateValueForSyntheticExtensionProperty((SyntheticJavaPropertyDescriptor)propertyDescriptor, receiver);
        }
        if (propertyDescriptor instanceof PropertyImportedFromObject) {
            propertyDescriptor = (PropertyDescriptor)((PropertyImportedFromObject)propertyDescriptor).getCallableFromObject();
        }
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        boolean isBackingFieldMovedFromCompanion = DescriptorsJvmAbiUtil.isPropertyWithBackingFieldInOuterClass(propertyDescriptor);
        AccessorKind fieldAccessorKind = skipLateinitAssertion ? AccessorKind.LATEINIT_INTRINSIC : (isBackingFieldMovedFromCompanion && (forceField || DescriptorVisibilities.isPrivate(propertyDescriptor.getVisibility()) && ExpressionCodegen.isDefaultAccessor(propertyDescriptor.getGetter()) && ExpressionCodegen.isDefaultAccessor(propertyDescriptor.getSetter())) ? (JvmCodegenUtil.isDebuggerContext(this.context) ? AccessorKind.NORMAL : AccessorKind.IN_CLASS_COMPANION) : (syntheticBackingField && this.context.getFirstCrossInlineOrNonInlineContext().getParentContext().getContextDescriptor() != containingDeclaration ? AccessorKind.FIELD_FROM_LOCAL : AccessorKind.NORMAL));
        boolean isStaticBackingField = DescriptorUtils.isStaticDeclaration(propertyDescriptor) || DescriptorAsmUtil.isInstancePropertyWithStaticBackingField(propertyDescriptor);
        boolean isSuper = superCallTarget != null;
        boolean isExtensionProperty = propertyDescriptor.getExtensionReceiverParameter() != null;
        KotlinType delegateType = JvmCodegenUtil.getPropertyDelegateType(propertyDescriptor, this.bindingContext);
        boolean isDelegatedProperty = delegateType != null;
        CallableMethod callableGetter = null;
        CallableMethod callableSetter = null;
        CodegenContext backingFieldContext = this.getBackingFieldContext(fieldAccessorKind, containingDeclaration);
        boolean isPrivateProperty = fieldAccessorKind != AccessorKind.NORMAL && (DescriptorAsmUtil.getVisibilityForBackingField(propertyDescriptor, isDelegatedProperty) & 2) != 0;
        PropertyDescriptor originalPropertyDescriptor = DescriptorUtils.unwrapFakeOverride(propertyDescriptor);
        boolean directAccessToGetter = JvmCodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, true, isDelegatedProperty, this.context, this.state.getShouldInlineConstVals());
        boolean directAccessToSetter = JvmCodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, false, isDelegatedProperty, this.context, this.state.getShouldInlineConstVals());
        if (fieldAccessorKind == AccessorKind.LATEINIT_INTRINSIC) {
            boolean bl = skipPropertyAccessors = (!isPrivateProperty || this.context.getClassOrPackageParentContext() == backingFieldContext) && !isBackingFieldMovedFromCompanion;
            if (!skipPropertyAccessors) {
                if (isBackingFieldMovedFromCompanion && this.context.getContextDescriptor() instanceof AccessorForPropertyBackingField) {
                    CodegenContext parentContext = backingFieldContext.getParentContext();
                    propertyDescriptor = parentContext.getAccessor(propertyDescriptor, AccessorKind.IN_CLASS_COMPANION, delegateType, superCallTarget);
                } else {
                    propertyDescriptor = backingFieldContext.getAccessor(propertyDescriptor, fieldAccessorKind, delegateType, superCallTarget);
                }
            }
            ownerDescriptor = propertyDescriptor;
        } else if (fieldAccessorKind == AccessorKind.IN_CLASS_COMPANION || fieldAccessorKind == AccessorKind.FIELD_FROM_LOCAL) {
            boolean bl = skipPropertyAccessors = skipAccessorsForPrivateFieldInOuterClass || directAccessToGetter && (!propertyDescriptor.isVar() || directAccessToSetter);
            if (!skipPropertyAccessors) {
                propertyDescriptor = backingFieldContext.getAccessor(propertyDescriptor, fieldAccessorKind, delegateType, superCallTarget);
                assert (propertyDescriptor instanceof AccessorForPropertyBackingField) : "Unexpected accessor descriptor: " + propertyDescriptor;
                ownerDescriptor = propertyDescriptor;
            } else {
                ownerDescriptor = containingDeclaration;
            }
        } else {
            skipPropertyAccessors = forceField;
            if (JvmCodegenUtil.isDebuggerContext(this.context) && DescriptorVisibilities.isPrivate(propertyDescriptor.getVisibility()) && this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor) == Boolean.TRUE) {
                skipPropertyAccessors = true;
            }
            DeclarationDescriptor declarationDescriptor = ownerDescriptor = isBackingFieldMovedFromCompanion ? containingDeclaration : propertyDescriptor;
        }
        if (!(skipPropertyAccessors || directAccessToGetter && directAccessToSetter)) {
            propertyDescriptor = this.context.getAccessorForSuperCallIfNeeded(propertyDescriptor, superCallTarget, this.state);
            if (!JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(propertyDescriptor = this.context.accessibleDescriptor(propertyDescriptor, superCallTarget))) {
                PropertySetterDescriptor setter2;
                PropertyGetterDescriptor getter2;
                if (!directAccessToGetter && (getter2 = propertyDescriptor.getGetter()) != null) {
                    callableGetter = this.typeMapper.mapToCallableMethod(getter2, isSuper);
                }
                if (propertyDescriptor.isVar() && !directAccessToSetter && (setter2 = propertyDescriptor.getSetter()) != null) {
                    callableSetter = this.typeMapper.mapToCallableMethod(setter2, isSuper);
                }
            }
        }
        if (!isStaticBackingField) {
            propertyDescriptor = DescriptorUtils.unwrapFakeOverride(propertyDescriptor);
        }
        Type backingFieldOwner = this.typeMapper.mapOwner(ownerDescriptor);
        if (isExtensionProperty && !isDelegatedProperty) {
            fieldName = null;
        } else if (originalPropertyDescriptor.getContainingDeclaration() == backingFieldContext.getContextDescriptor()) {
            assert (backingFieldContext instanceof FieldOwnerContext) : "Actual context is " + backingFieldContext + " but should be instance of FieldOwnerContext";
            fieldName = ((FieldOwnerContext)backingFieldContext).getFieldName(propertyDescriptor, isDelegatedProperty);
        } else {
            fieldName = KotlinTypeMapper.mapDefaultFieldName(propertyDescriptor, isDelegatedProperty);
        }
        KotlinType propertyType = propertyDescriptor.getOriginal().getType();
        if (propertyDescriptor instanceof JavaPropertyDescriptor && InlineClassesUtilsKt.isInlineClassType(propertyType)) {
            propertyType = TypeUtils.makeNullable(propertyType);
        }
        return StackValue.property(propertyDescriptor, backingFieldOwner, this.typeMapper.mapType(isDelegatedProperty && forceField ? delegateType : propertyType), isStaticBackingField, fieldName, callableGetter, callableSetter, receiver, this, resolvedCall2, skipLateinitAssertion, isDelegatedProperty && forceField ? delegateType : null);
    }

    @NotNull
    private StackValue.Property intermediateValueForSyntheticExtensionProperty(@NotNull SyntheticJavaPropertyDescriptor propertyDescriptor, @NotNull StackValue receiver) {
        if (propertyDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(136);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(137);
        }
        Type type2 = this.typeMapper.mapType(propertyDescriptor.getOriginal().getType());
        CallableMethod callableGetter = this.typeMapper.mapToCallableMethod(this.context.accessibleDescriptor(propertyDescriptor.getGetMethod(), null), false);
        FunctionDescriptor setMethod = propertyDescriptor.getSetMethod();
        CallableMethod callableSetter = setMethod != null ? this.typeMapper.mapToCallableMethod(this.context.accessibleDescriptor(setMethod, null), false) : null;
        StackValue.Property property2 = StackValue.property(propertyDescriptor, null, type2, false, null, callableGetter, callableSetter, receiver, this, null, false, null);
        if (property2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(138);
        }
        return property2;
    }

    @Override
    public StackValue visitCallExpression(@NotNull KtCallExpression expression2, StackValue receiver) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        FunctionDescriptor descriptor2;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(139);
        }
        if ((descriptor2 = this.accessibleFunctionDescriptor(resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext))) instanceof ConstructorDescriptor) {
            return this.generateNewCall(expression2, resolvedCall2);
        }
        if (descriptor2.getOriginal() instanceof SamConstructorDescriptor) {
            KtExpression argumentExpression = this.bindingContext.get(CodegenBinding.SAM_CONSTRUCTOR_TO_ARGUMENT, expression2);
            assert (argumentExpression != null) : "Argument expression is not saved for a SAM constructor: " + descriptor2;
            return this.genSamInterfaceValue(argumentExpression, this);
        }
        return this.invokeFunction(resolvedCall2, receiver);
    }

    @Override
    public StackValue visitCollectionLiteralExpression(@NotNull KtCollectionLiteralExpression expression2, StackValue data2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(140);
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.bindingContext.get(BindingContext.COLLECTION_LITERAL_CALL, expression2);
        assert (resolvedCall2 != null) : "No resolved call for " + PsiUtilsKt.getTextWithLocation(expression2);
        return this.invokeFunction(resolvedCall2, data2);
    }

    @Nullable
    private StackValue genSamInterfaceValue(@NotNull KtExpression probablyParenthesizedExpression, @NotNull KtVisitor<StackValue, StackValue> visitor2) {
        if (probablyParenthesizedExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(141);
        }
        if (visitor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(142);
        }
        KtExpression expression2 = KtPsiUtil.deparenthesize(probablyParenthesizedExpression);
        SamType samType = this.bindingContext.get(CodegenBinding.SAM_VALUE, probablyParenthesizedExpression);
        if (samType == null || expression2 == null) {
            return null;
        }
        if (expression2 instanceof KtLambdaExpression) {
            return this.genClosure(((KtLambdaExpression)expression2).getFunctionLiteral(), samType);
        }
        if (expression2 instanceof KtNamedFunction) {
            return this.genClosure((KtNamedFunction)expression2, samType);
        }
        Type asmType = this.state.getSamWrapperClasses().getSamWrapperClass(samType, expression2.getContainingKtFile(), this, (CallableMemberDescriptor)this.context.getContextDescriptor());
        return StackValue.operation(asmType, v -> {
            Label afterAll = new Label();
            Type functionType = this.typeMapper.mapType(samType.getKotlinFunctionType());
            ((StackValue)expression2.accept(visitor2, StackValue.none())).put(functionType, null, (InstructionAdapter)v);
            v.dup();
            v.ifnull(afterAll);
            int tmp = this.myFrameMap.enterTemp(functionType);
            v.store(tmp, functionType);
            v.anew(asmType);
            v.dup();
            v.load(tmp, functionType);
            v.invokespecial(asmType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, functionType), false);
            this.myFrameMap.leaveTemp(functionType);
            v.mark(afterAll);
            return null;
        });
    }

    @NotNull
    protected FunctionDescriptor accessibleFunctionDescriptor(@NotNull ResolvedCall<?> resolvedCall2) {
        FunctionDescriptor originalIfSamAdapter;
        FunctionDescriptor descriptor2;
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(143);
        }
        if ((descriptor2 = (FunctionDescriptor)resolvedCall2.getResultingDescriptor()) instanceof TypeAliasConstructorDescriptor) {
            descriptor2 = ((TypeAliasConstructorDescriptor)descriptor2).getUnderlyingConstructorDescriptor();
        }
        if ((originalIfSamAdapter = SamCodegenUtil.getOriginalIfSamAdapter(descriptor2)) != null) {
            descriptor2 = originalIfSamAdapter;
        }
        descriptor2 = CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(descriptor2);
        if (CallUtilKt.usesDefaultArguments(resolvedCall2)) {
            FunctionDescriptor functionDescriptor = descriptor2;
            if (functionDescriptor == null) {
                ExpressionCodegen.$$$reportNull$$$0(144);
            }
            return functionDescriptor;
        }
        if (this.shouldForceAccessorForConstructor(descriptor2.getOriginal())) {
            return this.createAccessorForHiddenConstructor(resolvedCall2, descriptor2);
        }
        FunctionDescriptor functionDescriptor = this.context.accessibleDescriptor(descriptor2, this.getSuperCallTarget(resolvedCall2.getCall()));
        if (functionDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(145);
        }
        return functionDescriptor;
    }

    private boolean shouldForceAccessorForConstructor(FunctionDescriptor descriptor2) {
        if (!DescriptorAsmUtil.isHiddenConstructor(descriptor2)) {
            return false;
        }
        return descriptor2.getContainingDeclaration() != ((CallableMemberDescriptor)this.context.getContextDescriptor()).getContainingDeclaration();
    }

    @NotNull
    private AccessorForConstructorDescriptor createAccessorForHiddenConstructor(@NotNull ResolvedCall<?> resolvedCall2, FunctionDescriptor descriptor2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(146);
        }
        return new AccessorForConstructorDescriptor((ClassConstructorDescriptor)descriptor2.getOriginal(), descriptor2.getContainingDeclaration(), this.getSuperCallTarget(resolvedCall2.getCall()), AccessorKind.NORMAL);
    }

    @NotNull
    public StackValue invokeFunction(@NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(147);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(148);
        }
        StackValue stackValue = this.invokeFunction(resolvedCall2.getCall(), resolvedCall2, receiver);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(149);
        }
        return stackValue;
    }

    @NotNull
    public StackValue invokeFunction(@NotNull Call call2, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver) {
        ResolvedCallWithRealDescriptor callWithRealDescriptor;
        if (call2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(150);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(151);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(152);
        }
        if ((callWithRealDescriptor = CoroutineCodegenUtilKt.replaceSuspensionFunctionWithRealDescriptor(resolvedCall2, this.state)) != null) {
            this.prepareCoroutineArgumentForSuspendCall(resolvedCall2, callWithRealDescriptor.getFakeContinuationExpression());
            StackValue stackValue = this.invokeFunction(callWithRealDescriptor.getResolvedCall(), receiver);
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(153);
            }
            return stackValue;
        }
        FunctionDescriptor fd = this.accessibleFunctionDescriptor(resolvedCall2);
        ClassDescriptor superCallTarget = this.getSuperCallTarget(call2);
        fd = this.context.getAccessorForSuperCallIfNeeded(fd, superCallTarget, this.state);
        List codegenExtensions = ExpressionCodegenExtension.Companion.getInstances(this.state.getProject());
        if (!codegenExtensions.isEmpty()) {
            ExpressionCodegenExtension.Context context2 = new ExpressionCodegenExtension.Context(this, this.typeMapper, this.v);
            for (ExpressionCodegenExtension extension : codegenExtensions) {
                StackValue stackValue = extension.applyFunction(receiver, resolvedCall2, context2);
                if (stackValue == null) continue;
                StackValue stackValue2 = stackValue;
                if (stackValue2 == null) {
                    ExpressionCodegen.$$$reportNull$$$0(154);
                }
                return stackValue2;
            }
        }
        Callable callable = this.resolveToCallable(fd, superCallTarget != null, resolvedCall2);
        StackValue stackValue = callable.invokeMethodWithArguments(resolvedCall2, receiver, this);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(155);
        }
        return stackValue;
    }

    private void prepareCoroutineArgumentForSuspendCall(@NotNull ResolvedCall<?> resolvedCall2, @NotNull KtExpression continuationExpression) {
        StackValue coroutineInstanceValueForSuspensionPoint;
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(156);
        }
        if (continuationExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(157);
        }
        StackValue coroutineInstanceValue = (coroutineInstanceValueForSuspensionPoint = this.getCoroutineInstanceValueForSuspensionPoint(resolvedCall2)) != null ? coroutineInstanceValueForSuspensionPoint : this.getContinuationParameterFromEnclosingSuspendFunction(resolvedCall2);
        this.tempVariables.put(continuationExpression, coroutineInstanceValue);
    }

    private static void invokeCoroutineMigrationMethod(@NotNull InstructionAdapter v, String methodName, String descriptor2) {
        if (v == null) {
            ExpressionCodegen.$$$reportNull$$$0(158);
        }
        v.invokestatic("kotlin/coroutines/experimental/migration/CoroutinesMigrationKt", methodName, descriptor2, false);
    }

    private StackValue getContinuationParameterFromEnclosingSuspendFunction(@NotNull ResolvedCall<?> resolvedCall2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(159);
        }
        FunctionDescriptor enclosingSuspendFunction = this.bindingContext.get(BindingContext.ENCLOSING_SUSPEND_FUNCTION_FOR_SUSPEND_FUNCTION_CALL, resolvedCall2.getCall());
        assert (enclosingSuspendFunction != null) : "Suspend functions may be called either as suspension points or from another suspend function";
        FunctionDescriptor enclosingSuspendFunctionJvmView = this.bindingContext.get(CodegenBinding.SUSPEND_FUNCTION_TO_JVM_VIEW, enclosingSuspendFunction);
        assert (enclosingSuspendFunctionJvmView != null) : "No JVM view function found for " + enclosingSuspendFunction;
        return this.getContinuationParameterFromEnclosingSuspendFunctionDescriptor(enclosingSuspendFunctionJvmView);
    }

    @Nullable
    public StackValue getContinuationParameterFromEnclosingSuspendFunctionDescriptor(@NotNull FunctionDescriptor enclosingSuspendFunctionJvmView) {
        if (enclosingSuspendFunctionJvmView == null) {
            ExpressionCodegen.$$$reportNull$$$0(160);
        }
        ValueParameterDescriptor continuationParameter = enclosingSuspendFunctionJvmView.getValueParameters().get(enclosingSuspendFunctionJvmView.getValueParameters().size() - 1);
        return this.findLocalOrCapturedValue(continuationParameter);
    }

    @Nullable
    public static CodegenContext getParentContextSubclassOf(ClassDescriptor descriptor2, CodegenContext context2) {
        for (CodegenContext c = context2; c != null; c = c.getParentContext()) {
            if (!(c instanceof ClassContext) || !DescriptorUtils.isSubclass(c.getThisDescriptor(), descriptor2)) continue;
            return c;
        }
        return null;
    }

    @Nullable
    public static CodegenContext getCompanionObjectContextSubclassOf(ClassDescriptor descriptor2, CodegenContext context2) {
        for (CodegenContext current = context2; current != null; current = current.getParentContext()) {
            ClassContext classContext;
            ClassDescriptor companionObject;
            if (!(current instanceof ClassContext) || (companionObject = ((ClassDescriptor)(classContext = (ClassContext)current).getContextDescriptor()).getCompanionObjectDescriptor()) == null || !DescriptorUtils.isSubclass(companionObject, descriptor2)) continue;
            return classContext.getCompanionObjectContext();
        }
        return null;
    }

    @NotNull
    Callable resolveToCallable(@NotNull FunctionDescriptor fd, boolean superCall2, @NotNull ResolvedCall<?> resolvedCall2) {
        Boolean classFileContainsMethod2;
        CallableMethod method;
        IntrinsicMethod intrinsic;
        if (fd == null) {
            ExpressionCodegen.$$$reportNull$$$0(161);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(162);
        }
        if ((intrinsic = this.state.getIntrinsics().getIntrinsic(fd)) != null) {
            Callable callable = intrinsic.toCallable(fd, superCall2, resolvedCall2, this);
            if (callable == null) {
                ExpressionCodegen.$$$reportNull$$$0(163);
            }
            return callable;
        }
        fd = SamCodegenUtil.resolveSamAdapter(fd);
        List<ResolvedValueArgument> valueArguments = resolvedCall2.getValueArgumentsByIndex();
        if (valueArguments != null && valueArguments.stream().anyMatch(it -> it instanceof DefaultValueArgument)) {
            fd = ArgumentGeneratorKt.getFunctionWithDefaultArguments(fd);
        }
        if ((method = this.typeMapper.mapToCallableMethod(fd, superCall2, null, resolvedCall2)).getAsmMethod().getName().contains("-") && !this.state.getConfiguration().getBoolean(JVMConfigurationKeys.USE_OLD_INLINE_CLASSES_MANGLING_SCHEME) && (classFileContainsMethod2 = InlineClassesCodegenUtilKt.classFileContainsMethod(fd, this.state, method.getAsmMethod())) != null && !classFileContainsMethod2.booleanValue()) {
            this.typeMapper.setUseOldManglingRulesForFunctionAcceptingInlineClass(true);
            method = this.typeMapper.mapToCallableMethod(fd, superCall2, null, resolvedCall2);
            this.typeMapper.setUseOldManglingRulesForFunctionAcceptingInlineClass(false);
        }
        CallableMethod callableMethod = method;
        if (callableMethod == null) {
            ExpressionCodegen.$$$reportNull$$$0(164);
        }
        return callableMethod;
    }

    public void invokeMethodWithArguments(@NotNull Callable callableMethod, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver) {
        if (callableMethod == null) {
            ExpressionCodegen.$$$reportNull$$$0(165);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(166);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(167);
        }
        CallGenerator callGenerator = this.getOrCreateCallGenerator(resolvedCall2);
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        assert (callGenerator == this.defaultCallGenerator || !this.tailRecursionCodegen.isTailRecursion(resolvedCall2)) : "Tail recursive method can't be inlined: " + descriptor2;
        CallBasedArgumentGenerator argumentGenerator = new CallBasedArgumentGenerator(this, callGenerator, descriptor2.getValueParameters(), callableMethod.getValueParameterTypes());
        this.invokeMethodWithArguments(callableMethod, resolvedCall2, receiver, callGenerator, argumentGenerator);
    }

    public void invokeMethodWithArguments(@NotNull Callable callableMethod, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver, @NotNull CallGenerator callGenerator, @NotNull ArgumentGenerator argumentGenerator) {
        KotlinType returnType2;
        KotlinType unboxedInlineClass;
        if (callableMethod == null) {
            ExpressionCodegen.$$$reportNull$$$0(168);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(169);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(170);
        }
        if (callGenerator == null) {
            ExpressionCodegen.$$$reportNull$$$0(171);
        }
        if (argumentGenerator == null) {
            ExpressionCodegen.$$$reportNull$$$0(172);
        }
        if (AssertCodegenUtilKt.isAssertCall(resolvedCall2) && !this.state.getAssertionsMode().equals((Object)JVMAssertionsMode.LEGACY)) {
            AssertCodegenUtilKt.generateAssert(this.state.getAssertionsMode(), resolvedCall2, this, this.parentCodegen);
            return;
        }
        SuspensionPointKind suspensionPointKind = CoroutineCodegenUtilKt.isSuspensionPoint(resolvedCall2, this);
        boolean maybeSuspensionPoint = suspensionPointKind != SuspensionPointKind.NEVER && !this.insideCallableReference();
        boolean isConstructor = resolvedCall2.getResultingDescriptor() instanceof ConstructorDescriptor;
        if (!(callableMethod instanceof IntrinsicWithSpecialReceiver)) {
            this.putReceiverAndInlineMarkerIfNeeded(callableMethod, resolvedCall2, receiver, maybeSuspensionPoint, isConstructor);
        }
        callGenerator.processHiddenParameters();
        callGenerator.putHiddenParamsIntoLocals();
        List<ResolvedValueArgument> valueArguments = resolvedCall2.getValueArgumentsByIndex();
        assert (valueArguments != null) : "Failed to arrange value arguments by index: " + resolvedCall2.getResultingDescriptor();
        DefaultCallArgs defaultArgs = argumentGenerator.generate((List<? extends ResolvedValueArgument>)valueArguments, (List<? extends ResolvedValueArgument>)new ArrayList<ResolvedValueArgument>(resolvedCall2.getValueArguments().values()), (CallableDescriptor)resolvedCall2.getResultingDescriptor());
        if (this.tailRecursionCodegen.isTailRecursion(resolvedCall2)) {
            this.tailRecursionCodegen.generateTailRecursion(resolvedCall2);
            return;
        }
        boolean defaultMaskWasGenerated = defaultArgs.generateOnStackIfNeeded(callGenerator, isConstructor);
        if (callableMethod instanceof CallableMethod) {
            List<JvmMethodParameterSignature> callableParameters = ((CallableMethod)callableMethod).getValueParameters();
            for (JvmMethodParameterSignature parameter : callableParameters) {
                if (parameter.getKind() != JvmMethodParameterKind.CONSTRUCTOR_MARKER) continue;
                callGenerator.putValueIfNeeded(new JvmKotlinType(parameter.getAsmType(), null), StackValue.constant(null, parameter.getAsmType()));
            }
        }
        if (maybeSuspensionPoint) {
            InlineCodegenUtilsKt.addSuspendMarker(this.v, true, suspensionPointKind == SuspensionPointKind.NOT_INLINE);
        }
        callGenerator.genCall(callableMethod, resolvedCall2, defaultMaskWasGenerated, this);
        if (maybeSuspensionPoint) {
            InlineCodegenUtilsKt.addReturnsUnitMarkerIfNecessary(this.v, resolvedCall2);
            InlineCodegenUtilsKt.addSuspendMarker(this.v, false, suspensionPointKind == SuspensionPointKind.NOT_INLINE);
            InlineCodegenUtilsKt.addUnboxInlineClassMarkersIfNeeded(this.v, resolvedCall2.getResultingDescriptor(), this.typeMapper);
            InlineCodegenUtilsKt.addInlineMarker(this.v, false);
        }
        if (this.insideCallableReference() && resolvedCall2.getResultingDescriptor() instanceof FunctionDescriptor && (unboxedInlineClass = CoroutineCodegenUtilKt.originalReturnTypeOfSuspendFunctionReturningUnboxedInlineClass((FunctionDescriptor)resolvedCall2.getResultingDescriptor(), this.typeMapper)) != null) {
            CoroutineCodegenUtilKt.generateCoroutineSuspendedCheck(this.v);
        }
        if ((returnType2 = resolvedCall2.getResultingDescriptor().getReturnType()) != null && KotlinBuiltIns.isNothing(returnType2)) {
            if (this.state.getUseKotlinNothingValueException()) {
                this.v.anew(Type.getObjectType("kotlin/KotlinNothingValueException"));
                this.v.dup();
                this.v.invokespecial("kotlin/KotlinNothingValueException", "<init>", "()V", false);
            } else {
                this.v.aconst(null);
            }
            this.v.athrow();
        }
    }

    private boolean insideCallableReference() {
        return this.parentCodegen instanceof ClosureCodegen && ((ClosureCodegen)this.parentCodegen).isCallableReference();
    }

    private void putReceiverAndInlineMarkerIfNeeded(@NotNull Callable callableMethod, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver, boolean isSuspendCall, boolean isConstructor) {
        boolean isSafeCallOrOnStack;
        if (callableMethod == null) {
            ExpressionCodegen.$$$reportNull$$$0(173);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(174);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(175);
        }
        boolean bl = isSafeCallOrOnStack = receiver instanceof StackValue.SafeCall || receiver instanceof StackValue.OnStack;
        if (isSuspendCall && !isSafeCallOrOnStack && !this.tailRecursionCodegen.isTailRecursion(resolvedCall2)) {
            InlineCodegenUtilsKt.addInlineMarker(this.v, true);
        }
        if (!isConstructor) {
            receiver = StackValue.receiver(resolvedCall2, receiver, this, callableMethod);
            receiver.put(receiver.type, receiver.kotlinType, this.v);
            if (isSuspendCall && isSafeCallOrOnStack) {
                boolean bothReceivers = receiver instanceof CallReceiver && ((CallReceiver)receiver).getDispatchReceiver().type.getSort() != 0 && ((CallReceiver)receiver).getExtensionReceiver().type.getSort() != 0;
                Type firstReceiverType = bothReceivers ? ((CallReceiver)receiver).getDispatchReceiver().type : receiver.type;
                Type secondReceiverType = bothReceivers ? receiver.type : null;
                int tmpVarForFirstReceiver = this.myFrameMap.enterTemp(firstReceiverType);
                int tmpVarForSecondReceiver = -1;
                if (secondReceiverType != null) {
                    tmpVarForSecondReceiver = this.myFrameMap.enterTemp(secondReceiverType);
                    this.v.store(tmpVarForSecondReceiver, secondReceiverType);
                }
                this.v.store(tmpVarForFirstReceiver, firstReceiverType);
                InlineCodegenUtilsKt.addInlineMarker(this.v, true);
                this.v.load(tmpVarForFirstReceiver, firstReceiverType);
                if (secondReceiverType != null) {
                    this.v.load(tmpVarForSecondReceiver, secondReceiverType);
                    this.myFrameMap.leaveTemp(secondReceiverType);
                }
                this.myFrameMap.leaveTemp(firstReceiverType);
            }
            callableMethod.afterReceiverGeneration(this.v, this.myFrameMap, this.state);
        }
    }

    @NotNull
    private CallGenerator getOrCreateCallGenerator(@NotNull CallableDescriptor descriptor2, @Nullable KtElement callElement, @Nullable TypeParameterMappings<KotlinType> typeParameterMappings, boolean isDefaultCompilation) {
        Boolean classFileContainsMethod2;
        PsiSourceCompilerForInline sourceCompiler;
        boolean shouldInline;
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(176);
        }
        if (callElement == null) {
            CallGenerator callGenerator = this.defaultCallGenerator;
            if (callGenerator == null) {
                ExpressionCodegen.$$$reportNull$$$0(177);
            }
            return callGenerator;
        }
        boolean isIntrinsic = descriptor2 instanceof CallableMemberDescriptor && this.state.getIntrinsics().getIntrinsic((CallableMemberDescriptor)descriptor2) != null;
        boolean isInline = InlineUtil.isInline(descriptor2) && !isIntrinsic || InlineUtil.isArrayConstructorWithLambda(descriptor2);
        boolean bl = shouldInline = isInline && (!this.state.isInlineDisabled() || InlineUtil.containsReifiedTypeParameters(descriptor2));
        if (!shouldInline) {
            CallGenerator callGenerator = this.defaultCallGenerator;
            if (callGenerator == null) {
                ExpressionCodegen.$$$reportNull$$$0(178);
            }
            return callGenerator;
        }
        FunctionDescriptor original = CoroutineCodegenUtilKt.getOriginalSuspendFunctionView(CodegenUtilKt.unwrapInitialSignatureDescriptor(DescriptorUtils.unwrapFakeOverride((FunctionDescriptor)descriptor2.getOriginal())), this.bindingContext);
        FunctionDescriptor functionDescriptor = InlineUtil.isArrayConstructorWithLambda(original) ? FictitiousArrayConstructor.create((ConstructorDescriptor)original) : original.getOriginal();
        JvmMethodGenericSignature signature2 = this.typeMapper.mapSignatureWithGeneric(functionDescriptor, (sourceCompiler = new PsiSourceCompilerForInline(this, callElement, functionDescriptor)).getContext().getContextKind());
        if (signature2.getAsmMethod().getName().contains("-") && !this.state.getConfiguration().getBoolean(JVMConfigurationKeys.USE_OLD_INLINE_CLASSES_MANGLING_SCHEME) && (classFileContainsMethod2 = InlineClassesCodegenUtilKt.classFileContainsMethod(functionDescriptor, this.state, signature2.getAsmMethod())) != null && !classFileContainsMethod2.booleanValue()) {
            this.typeMapper.setUseOldManglingRulesForFunctionAcceptingInlineClass(true);
            signature2 = this.typeMapper.mapSignatureWithGeneric(functionDescriptor, sourceCompiler.getContext().getContextKind());
            this.typeMapper.setUseOldManglingRulesForFunctionAcceptingInlineClass(false);
        }
        if (isDefaultCompilation) {
            return new InlineCodegenForDefaultBody(functionDescriptor, this, this.state, signature2, sourceCompiler);
        }
        return new PsiInlineCodegen(this, this.state, functionDescriptor, signature2, typeParameterMappings, sourceCompiler, this.typeMapper.mapImplementationOwner(functionDescriptor), this.typeMapper.mapOwner(descriptor2), callElement);
    }

    @NotNull
    protected CallGenerator getOrCreateCallGeneratorForDefaultImplBody(@NotNull FunctionDescriptor descriptor2, @Nullable KtNamedFunction function2) {
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(179);
        }
        return this.getOrCreateCallGenerator(descriptor2, function2, null, true);
    }

    CallGenerator getOrCreateCallGenerator(@NotNull ResolvedCall<?> resolvedCall2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(180);
        }
        return this.getOrCreateCallGenerator(resolvedCall2, (CallableDescriptor)resolvedCall2.getResultingDescriptor());
    }

    @NotNull
    CallGenerator getOrCreateCallGenerator(@NotNull ResolvedCall<?> resolvedCall2, @NotNull CallableDescriptor descriptor2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(181);
        }
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(182);
        }
        Map<TypeParameterDescriptor, KotlinType> typeArguments2 = ExpressionCodegen.getTypeArgumentsForResolvedCall(resolvedCall2, descriptor2);
        TypeParameterMappings<KotlinType> mappings = new TypeParameterMappings<KotlinType>();
        for (Map.Entry<TypeParameterDescriptor, KotlinType> entry : typeArguments2.entrySet()) {
            TypeParameterDescriptor key = entry.getKey();
            KotlinType type2 = entry.getValue();
            boolean isReified = key.isReified() || InlineUtil.isArrayConstructorWithLambda(resolvedCall2.getResultingDescriptor());
            Pair<TypeParameterMarker, ReificationArgument> typeParameterAndReificationArgument = CodegenUtilKt.extractReificationArgument(this.typeSystem, type2);
            if (typeParameterAndReificationArgument == null) {
                KotlinType approximatedType = this.approximateCapturedType(type2);
                BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.TYPE);
                Type asmType = this.typeMapper.mapTypeArgument(approximatedType, signatureWriter);
                mappings.addParameterMappingToType(key.getName().getIdentifier(), approximatedType, asmType, ((JvmSignatureWriter)signatureWriter).toString(), isReified);
                continue;
            }
            mappings.addParameterMappingForFurtherReification(key.getName().getIdentifier(), type2, typeParameterAndReificationArgument.getSecond(), isReified);
        }
        return this.getOrCreateCallGenerator(descriptor2, resolvedCall2.getCall().getCallElement(), mappings, false);
    }

    @NotNull
    private KotlinType approximateCapturedType(@NotNull KotlinType type2) {
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(183);
        }
        if (this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference)) {
            TypeApproximator approximator2 = new TypeApproximator(this.state.getModule().getBuiltIns(), this.state.getLanguageVersionSettings());
            KotlinType approximatedType = TypeUtils.contains(type2, containedType -> CapturedTypeConstructorKt.isCaptured(containedType)) ? (KotlinType)approximator2.approximateToSuperType(type2, (TypeApproximatorConfiguration)TypeApproximatorConfiguration.InternalTypesApproximation.INSTANCE) : null;
            KotlinType kotlinType = approximatedType != null ? approximatedType : type2;
            if (kotlinType == null) {
                ExpressionCodegen.$$$reportNull$$$0(184);
            }
            return kotlinType;
        }
        KotlinType kotlinType = CapturedTypeApproximationKt.approximateCapturedTypes(type2).getUpper();
        if (kotlinType == null) {
            ExpressionCodegen.$$$reportNull$$$0(185);
        }
        return kotlinType;
    }

    @NotNull
    private static Map<TypeParameterDescriptor, KotlinType> getTypeArgumentsForResolvedCall(@NotNull ResolvedCall<?> resolvedCall2, @NotNull CallableDescriptor descriptor2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(186);
        }
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(187);
        }
        if (!(descriptor2 instanceof TypeAliasConstructorDescriptor)) {
            Map<TypeParameterDescriptor, KotlinType> map2 = resolvedCall2.getTypeArguments();
            if (map2 == null) {
                ExpressionCodegen.$$$reportNull$$$0(188);
            }
            return map2;
        }
        TypeAliasConstructorDescriptor typeAliasConstructorDescriptor = (TypeAliasConstructorDescriptor)descriptor2;
        ClassConstructorDescriptor underlyingConstructorDescriptor = typeAliasConstructorDescriptor.getUnderlyingConstructorDescriptor();
        KotlinType resultingType = typeAliasConstructorDescriptor.getReturnType();
        List<TypeProjection> typeArgumentsForReturnType = resultingType.getArguments();
        List<TypeParameterDescriptor> typeParameters2 = underlyingConstructorDescriptor.getTypeParameters();
        assert (typeParameters2.size() == typeArgumentsForReturnType.size()) : "Type parameters of the underlying constructor " + underlyingConstructorDescriptor + "should correspond to type arguments for the resulting type " + resultingType;
        HashMap<TypeParameterDescriptor, KotlinType> typeArgumentsMap = Maps.newHashMapWithExpectedSize(typeParameters2.size());
        for (TypeParameterDescriptor typeParameter : typeParameters2) {
            KotlinType typeArgument = typeArgumentsForReturnType.get(typeParameter.getIndex()).getType();
            typeArgumentsMap.put(typeParameter, typeArgument);
        }
        HashMap<TypeParameterDescriptor, KotlinType> hashMap = typeArgumentsMap;
        if (hashMap == null) {
            ExpressionCodegen.$$$reportNull$$$0(189);
        }
        return hashMap;
    }

    @NotNull
    public StackValue generateReceiverValue(@Nullable ReceiverValue receiverValue, boolean isSuper) {
        if (receiverValue instanceof ImplicitClassReceiver) {
            ClassDescriptor receiverDescriptor = ((ImplicitClassReceiver)receiverValue).getDeclarationDescriptor();
            StackValue stackValue = this.generateInstanceReceiver(receiverDescriptor, isSuper, receiverValue instanceof CastImplicitClassReceiver || DescriptorUtils.isEnumEntry(receiverDescriptor));
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(190);
            }
            return stackValue;
        }
        if (receiverValue instanceof ExtensionReceiver) {
            StackValue stackValue = this.generateExtensionReceiver(((ExtensionReceiver)receiverValue).getDeclarationDescriptor());
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(191);
            }
            return stackValue;
        }
        if (receiverValue instanceof ExpressionReceiver) {
            ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
            StackValue stackValue = this.gen(expressionReceiver.getExpression());
            if (!this.state.isReceiverAssertionsDisabled()) {
                RuntimeAssertionInfo runtimeAssertionInfo = this.bindingContext.get(JvmBindingContextSlices.RECEIVER_RUNTIME_ASSERTION_INFO, expressionReceiver);
                stackValue = DescriptorAsmUtil.genNotNullAssertions(this.state, stackValue, runtimeAssertionInfo);
            }
            StackValue stackValue2 = stackValue;
            if (stackValue2 == null) {
                ExpressionCodegen.$$$reportNull$$$0(192);
            }
            return stackValue2;
        }
        throw new UnsupportedOperationException("Unsupported receiver value: " + receiverValue);
    }

    private StackValue generateInstanceReceiver(@NotNull ClassDescriptor receiverDescriptor, boolean isSuper, boolean castReceiver) {
        if (receiverDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(193);
        }
        if (DescriptorUtils.isCompanionObject(receiverDescriptor)) {
            CallableMemberDescriptor contextDescriptor = (CallableMemberDescriptor)this.context.getContextDescriptor();
            if (contextDescriptor instanceof FunctionDescriptor && receiverDescriptor == contextDescriptor.getContainingDeclaration()) {
                return StackValue.LOCAL_0;
            }
            if (CodegenUtilKt.isPossiblyUninitializedSingleton(receiverDescriptor) && this.isInsideSingleton(receiverDescriptor)) {
                return this.generateThisOrOuterFromContext(receiverDescriptor, false, false);
            }
            return this.generateCompanionObjectInstance(receiverDescriptor);
        }
        if (receiverDescriptor instanceof ScriptDescriptor) {
            return this.generateScriptReceiver((ScriptDescriptor)receiverDescriptor);
        }
        return StackValue.thisOrOuter(this, receiverDescriptor, isSuper, castReceiver);
    }

    private CodegenContext getContextForCompanionObjectAccessorIfRequiredOrNull(@NotNull ClassDescriptor companionObjectDescriptor2, @NotNull CodegenContext contextBeforeInline) {
        if (companionObjectDescriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(194);
        }
        if (contextBeforeInline == null) {
            ExpressionCodegen.$$$reportNull$$$0(195);
        }
        if (JvmCodegenUtil.isDebuggerContext(contextBeforeInline)) {
            return null;
        }
        if (!this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperVisibilityForCompanionObjectInstanceField)) {
            return null;
        }
        int accessFlag = DescriptorAsmUtil.getVisibilityAccessFlag(companionObjectDescriptor2);
        CodegenContext context2 = contextBeforeInline.getFirstCrossInlineOrNonInlineContext();
        boolean isInlineMethodContext = context2.isInlineMethodContext();
        Object contextDescriptor = context2.getContextDescriptor();
        ClassDescriptor containingClassOfCompanionObject = DescriptorUtils.getContainingClass(companionObjectDescriptor2);
        if ((accessFlag & 2) != 0) {
            if (!isInlineMethodContext && contextDescriptor.getContainingDeclaration() == containingClassOfCompanionObject) {
                return null;
            }
            return context2.findParentContextWithDescriptor(containingClassOfCompanionObject);
        }
        if ((accessFlag & 4) != 0) {
            if (!isInlineMethodContext && ExpressionCodegen.canAccessProtectedMembers(contextDescriptor, containingClassOfCompanionObject)) {
                return null;
            }
            CodegenContext accessorContext = ExpressionCodegen.getParentContextSubclassOf(containingClassOfCompanionObject, context2);
            if (accessorContext == null) {
                accessorContext = ExpressionCodegen.getCompanionObjectContextSubclassOf(containingClassOfCompanionObject, context2);
            }
            assert (accessorContext != null) : "Class context for accessor to a protected companion object " + companionObjectDescriptor2 + " not found:\n" + JvmCodegenUtil.dumpContextHierarchy(context2);
            return accessorContext;
        }
        return null;
    }

    private static boolean canAccessProtectedMembers(DeclarationDescriptor contextDescriptor, ClassDescriptor classDescriptor) {
        DeclarationDescriptor containingDeclaration = contextDescriptor.getContainingDeclaration();
        return containingDeclaration == classDescriptor || JvmCodegenUtil.isInSamePackage(contextDescriptor, classDescriptor) || containingDeclaration instanceof ClassDescriptor && DescriptorUtils.isSubclass((ClassDescriptor)containingDeclaration, classDescriptor);
    }

    @NotNull
    public StackValue generateExtensionReceiver(@NotNull CallableDescriptor descriptor2) {
        ReceiverParameterDescriptor parameter;
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(196);
        }
        if (this.myFrameMap.getIndex(parameter = descriptor2.getExtensionReceiverParameter()) != -1) {
            KotlinType type2 = parameter.getReturnType();
            StackValue.Local local = StackValue.local(this.myFrameMap.getIndex(parameter), this.typeMapper.mapType(type2), type2);
            if (local == null) {
                ExpressionCodegen.$$$reportNull$$$0(197);
            }
            return local;
        }
        StackValue result2 = this.context.generateReceiver(descriptor2, this.state, false);
        if (result2 == null) {
            throw new NullPointerException("Extension receiver was null for callable " + descriptor2);
        }
        StackValue stackValue = result2;
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(198);
        }
        return stackValue;
    }

    @NotNull
    private StackValue generateScriptReceiver(@NotNull ScriptDescriptor receiver) {
        CodegenContext cur;
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(199);
        }
        StackValue result2 = StackValue.LOCAL_0;
        boolean inStartConstructorContext = cur instanceof ConstructorContext;
        for (cur = this.context; cur != null; cur = cur.getParentContext()) {
            if (!inStartConstructorContext) {
                cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
            }
            if (cur instanceof ScriptContext) {
                ScriptContext scriptContext = (ScriptContext)cur;
                if (scriptContext.getScriptDescriptor() == receiver) {
                    StackValue stackValue = result2;
                    if (stackValue == null) {
                        ExpressionCodegen.$$$reportNull$$$0(200);
                    }
                    return stackValue;
                }
                Type currentScriptType = this.typeMapper.mapType(scriptContext.getScriptDescriptor());
                SimpleType receiverKotlinType = receiver.getDefaultType();
                Type classType = this.typeMapper.mapType(receiverKotlinType);
                String fieldName = scriptContext.getScriptFieldName(receiver);
                StackValue.Field field2 = StackValue.field(classType, receiverKotlinType, currentScriptType, fieldName, false, result2, receiver);
                if (field2 == null) {
                    ExpressionCodegen.$$$reportNull$$$0(201);
                }
                return field2;
            }
            result2 = cur.getOuterExpression(result2, false);
            if (!inStartConstructorContext) continue;
            cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
            inStartConstructorContext = false;
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public StackValue generateThisOrOuter(@NotNull ClassDescriptor calleeContainingClass, boolean isSuper) {
        if (calleeContainingClass == null) {
            ExpressionCodegen.$$$reportNull$$$0(202);
        }
        StackValue stackValue = this.generateThisOrOuter(calleeContainingClass, isSuper, false);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(203);
        }
        return stackValue;
    }

    private boolean isInsideSingleton(@NotNull ClassDescriptor singletonClassDescriptor) {
        if (singletonClassDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(204);
        }
        assert (singletonClassDescriptor.getKind().isSingleton()) : "Singleton expected: " + singletonClassDescriptor;
        for (Object descriptor2 = this.context.getContextDescriptor(); descriptor2 != null; descriptor2 = descriptor2.getContainingDeclaration()) {
            if (descriptor2 == singletonClassDescriptor) {
                return true;
            }
            if (!(descriptor2 instanceof ClassDescriptor) || ((ClassDescriptor)descriptor2).isInner() || DescriptorUtils.isAnonymousObject(descriptor2)) continue;
            return false;
        }
        return false;
    }

    @NotNull
    public StackValue generateThisOrOuter(@NotNull ClassDescriptor thisOrOuterClass, boolean isSuper, boolean forceOuter) {
        if (thisOrOuterClass == null) {
            ExpressionCodegen.$$$reportNull$$$0(205);
        }
        if (!thisOrOuterClass.getKind().isSingleton()) {
            StackValue stackValue = this.generateThisOrOuterFromContext(thisOrOuterClass, isSuper, forceOuter);
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(206);
            }
            return stackValue;
        }
        if (thisOrOuterClass.equals(this.context.getThisDescriptor()) && !CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(this.context.getFunctionDescriptor())) {
            StackValue.Local local = StackValue.local(0, this.typeMapper.mapType(thisOrOuterClass));
            if (local == null) {
                ExpressionCodegen.$$$reportNull$$$0(207);
            }
            return local;
        }
        if (this.shouldGenerateSingletonAsThisOrOuterFromContext(thisOrOuterClass)) {
            StackValue stackValue = this.generateThisOrOuterFromContext(thisOrOuterClass, isSuper, forceOuter);
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(208);
            }
            return stackValue;
        }
        if (DescriptorUtils.isEnumEntry(thisOrOuterClass)) {
            StackValue.Field field2 = StackValue.enumEntry(thisOrOuterClass, this.typeMapper);
            if (field2 == null) {
                ExpressionCodegen.$$$reportNull$$$0(209);
            }
            return field2;
        }
        StackValue.Field field3 = StackValue.singleton(thisOrOuterClass, this.typeMapper);
        if (field3 == null) {
            ExpressionCodegen.$$$reportNull$$$0(210);
        }
        return field3;
    }

    private StackValue generateThisOrOuterFromContext(@NotNull ClassDescriptor thisOrOuterClass, boolean isSuper, boolean forceOuter) {
        if (thisOrOuterClass == null) {
            ExpressionCodegen.$$$reportNull$$$0(211);
        }
        CodegenContext cur = this.context;
        SimpleType contextType = cur.getThisDescriptor().getDefaultType();
        StackValue result2 = StackValue.local(0, this.asmType(contextType), contextType);
        boolean inStartConstructorContext = cur instanceof ConstructorContext;
        while (cur != null) {
            CodegenContext enclosingContext;
            ClassDescriptor thisDescriptor = cur.getThisDescriptor();
            if (!isSuper && thisDescriptor.getTypeConstructor().equals(thisOrOuterClass.getTypeConstructor())) {
                return result2;
            }
            if (!forceOuter && isSuper && DescriptorUtils.isSubclass(thisDescriptor, thisOrOuterClass)) {
                return this.castToRequiredTypeOfInterfaceIfNeeded(result2, thisDescriptor, thisOrOuterClass);
            }
            forceOuter = false;
            if (inStartConstructorContext) {
                result2 = cur.getOuterExpression(result2, false);
                cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
                enclosingContext = cur.getEnclosingClassContext();
                inStartConstructorContext = false;
            } else {
                cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
                enclosingContext = cur.getEnclosingClassContext();
                if (!(thisOrOuterClass instanceof ScriptDescriptor)) {
                    StackValue captured2;
                    MutableClosure closure;
                    if (cur instanceof ScriptLikeContext) {
                        return ((ScriptLikeContext)cur).getOuterReceiverExpression(result2, thisOrOuterClass);
                    }
                    if (enclosingContext instanceof ScriptLikeContext && (closure = cur.closure) != null && (captured2 = ((ScriptLikeContext)enclosingContext).captureVariable(closure, thisOrOuterClass)) != null) {
                        return captured2;
                    }
                }
                result2 = cur.getOuterExpression(result2, false);
            }
            cur = enclosingContext;
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    private static CodegenContext getNotNullParentContextForMethod(CodegenContext cur) {
        if (cur instanceof MethodContext) {
            cur = cur.getParentContext();
        }
        assert (cur != null);
        CodegenContext codegenContext = cur;
        if (codegenContext == null) {
            ExpressionCodegen.$$$reportNull$$$0(212);
        }
        return codegenContext;
    }

    private boolean canSkipArrayCopyForSpreadArgument(KtExpression spreadArgument) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(spreadArgument, this.bindingContext);
        if (resolvedCall2 == null) {
            return false;
        }
        CallableDescriptor calleeDescriptor = resolvedCall2.getResultingDescriptor();
        return calleeDescriptor instanceof ConstructorDescriptor || CompileTimeConstantUtils.isArrayFunctionCall(resolvedCall2) || DescriptorUtils.getFqName(calleeDescriptor).asString().equals("kotlin.arrayOfNulls");
    }

    @NotNull
    public StackValue genVarargs(@NotNull VarargValueArgument valueArgument, @NotNull KotlinType outType) {
        boolean hasSpreadOperator;
        if (valueArgument == null) {
            ExpressionCodegen.$$$reportNull$$$0(213);
        }
        if (outType == null) {
            ExpressionCodegen.$$$reportNull$$$0(214);
        }
        Type type2 = this.asmType(outType);
        assert (type2.getSort() == 9);
        Type elementType = AsmUtil.correctElementType(type2);
        List<ValueArgument> arguments2 = valueArgument.getArguments();
        int size = arguments2.size();
        boolean bl = hasSpreadOperator = this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowAssigningArrayElementsToVarargsInNamedFormForFunctions) ? arguments2.stream().anyMatch(argument2 -> argument2.getSpreadElement() != null || argument2.isNamed()) : arguments2.stream().anyMatch(argument2 -> argument2.getSpreadElement() != null);
        if (hasSpreadOperator) {
            String toArrayDescriptor;
            String addDescriptor;
            String owner;
            boolean arrayOfReferences = KotlinBuiltIns.isArray(outType);
            if (size == 1) {
                Type arrayType = AsmUtil.getArrayType(arrayOfReferences ? AsmTypes.OBJECT_TYPE : elementType);
                StackValue stackValue = StackValue.operation(type2, outType, adapter -> {
                    KtExpression spreadArgument = ((ValueArgument)arguments2.get(0)).getArgumentExpression();
                    this.gen(spreadArgument, type2, outType);
                    if (!this.canSkipArrayCopyForSpreadArgument(spreadArgument)) {
                        this.v.dup();
                        this.v.arraylength();
                        this.v.invokestatic("java/util/Arrays", "copyOf", Type.getMethodDescriptor(arrayType, arrayType, Type.INT_TYPE), false);
                    }
                    if (arrayOfReferences) {
                        this.v.checkcast(type2);
                    }
                    return Unit.INSTANCE;
                });
                if (stackValue == null) {
                    ExpressionCodegen.$$$reportNull$$$0(215);
                }
                return stackValue;
            }
            if (arrayOfReferences) {
                owner = "kotlin/jvm/internal/SpreadBuilder";
                addDescriptor = "(Ljava/lang/Object;)V";
                toArrayDescriptor = "([Ljava/lang/Object;)[Ljava/lang/Object;";
            } else {
                String spreadBuilderClassName = AsmUtil.asmPrimitiveTypeToLangPrimitiveType(elementType).getTypeName().getIdentifier() + "SpreadBuilder";
                owner = "kotlin/jvm/internal/" + spreadBuilderClassName;
                addDescriptor = "(" + elementType.getDescriptor() + ")V";
                toArrayDescriptor = "()" + type2.getDescriptor();
            }
            StackValue stackValue = StackValue.operation(type2, adapter -> {
                this.v.anew(Type.getObjectType(owner));
                this.v.dup();
                this.v.iconst(size);
                this.v.invokespecial(owner, "<init>", "(I)V", false);
                for (int i = 0; i != size; ++i) {
                    this.v.dup();
                    ValueArgument argument2 = (ValueArgument)arguments2.get(i);
                    KtExpression argumentExpression = argument2.getArgumentExpression();
                    KotlinType argumentKotlinType = this.kotlinType(argumentExpression);
                    if (argument2.getSpreadElement() != null) {
                        this.gen(argumentExpression, AsmTypes.OBJECT_TYPE, argumentKotlinType);
                        if (argumentKotlinType != null && InlineClassesUtilsKt.isInlineClassType(argumentKotlinType)) {
                            StackValue.coerce(AsmTypes.OBJECT_TYPE, argumentKotlinType, this.asmType(argumentKotlinType), argumentKotlinType, this.v);
                        }
                        this.v.invokevirtual(owner, "addSpread", "(Ljava/lang/Object;)V", false);
                        continue;
                    }
                    this.gen(argumentExpression, elementType, argumentKotlinType);
                    this.v.invokevirtual(owner, "add", addDescriptor, false);
                }
                if (arrayOfReferences) {
                    this.v.dup();
                    this.v.invokevirtual(owner, "size", "()I", false);
                    this.newArrayInstruction(outType);
                    this.v.invokevirtual(owner, "toArray", toArrayDescriptor, false);
                    this.v.checkcast(type2);
                } else {
                    this.v.invokevirtual(owner, "toArray", toArrayDescriptor, false);
                }
                return Unit.INSTANCE;
            });
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(216);
            }
            return stackValue;
        }
        StackValue stackValue = StackValue.operation(type2, outType, adapter -> {
            this.v.iconst(arguments2.size());
            this.newArrayInstruction(outType);
            KotlinType elementKotlinType = outType.getConstructor().getBuiltIns().getArrayElementType(outType);
            for (int i = 0; i != size; ++i) {
                this.v.dup();
                StackValue rightSide = this.gen(((ValueArgument)arguments2.get(i)).getArgumentExpression());
                StackValue.arrayElement(elementType, elementKotlinType, StackValue.onStack(type2, outType), StackValue.constant(i)).store(rightSide, this.v);
            }
            return Unit.INSTANCE;
        });
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(217);
        }
        return stackValue;
    }

    public int indexOfLocalNotDelegated(KtReferenceExpression lhs) {
        DeclarationDescriptor declarationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, lhs);
        if (BindingContextUtils.isBoxedLocalCapturedInClosure(this.bindingContext, declarationDescriptor)) {
            return -1;
        }
        if (declarationDescriptor instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)declarationDescriptor).isDelegated()) {
            return -1;
        }
        return this.lookupLocalIndex(declarationDescriptor);
    }

    @Override
    public StackValue visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2, StackValue data2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(218);
        }
        KtExpression receiverExpression = expression2.getReceiverExpression();
        assert (receiverExpression != null) : "Class literal expression should have a left-hand side";
        DoubleColonLHS lhs = this.bindingContext.get(BindingContext.DOUBLE_COLON_LHS, receiverExpression);
        assert (lhs != null) : "Class literal expression should have LHS resolved";
        return this.generateClassLiteralReference(lhs, receiverExpression, true);
    }

    @Override
    public StackValue visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2, StackValue data2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(219);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2.getCallableReference(), this.bindingContext);
        StackValue receiver = this.generateCallableReferenceReceiver(resolvedCall2);
        FunctionDescriptor functionDescriptor = this.bindingContext.get(BindingContext.FUNCTION, expression2);
        if (functionDescriptor != null) {
            FunctionReferenceGenerationStrategy strategy = new FunctionReferenceGenerationStrategy(this.state, functionDescriptor, resolvedCall2, receiver != null ? new JvmKotlinType(receiver.type, receiver.kotlinType) : null, null, false);
            return this.genClosure(expression2, functionDescriptor, strategy, null, resolvedCall2, receiver);
        }
        return this.generatePropertyReference(expression2, this.getVariableDescriptorNotNull(expression2), (VariableDescriptor)resolvedCall2.getResultingDescriptor(), receiver);
    }

    @Nullable
    public StackValue generateCallableReferenceReceiver(@NotNull ResolvedCall<?> resolvedCall2) {
        ReceiverValue receiver;
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(220);
        }
        if ((receiver = JvmCodegenUtil.getBoundCallableReferenceReceiver(resolvedCall2)) == null) {
            return null;
        }
        KotlinType receiverType = receiver.getType();
        return StackValue.coercion(this.generateReceiverValue(receiver, false), this.asmType(receiverType), receiverType);
    }

    @NotNull
    private StackValue generatePropertyReference(@NotNull KtElement element, @NotNull VariableDescriptor variableDescriptor, @NotNull VariableDescriptor target, @Nullable StackValue receiverValue) {
        ClassDescriptor classDescriptor;
        if (element == null) {
            ExpressionCodegen.$$$reportNull$$$0(221);
        }
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(222);
        }
        if (target == null) {
            ExpressionCodegen.$$$reportNull$$$0(223);
        }
        if ((classDescriptor = this.bindingContext.get(CodegenBinding.CLASS_FOR_CALLABLE, variableDescriptor)) == null) {
            throw new IllegalStateException("Property reference class was not found: " + variableDescriptor + "\nTried to generate: " + element.getText());
        }
        ClassBuilder classBuilder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(element), this.typeMapper.mapClass(classDescriptor), element.getContainingFile());
        PropertyReferenceCodegen codegen2 = new PropertyReferenceCodegen(this.state, this.parentCodegen, this.context.intoAnonymousClass(classDescriptor, this, OwnerKind.IMPLEMENTATION), element, classBuilder2, variableDescriptor, target, receiverValue != null ? new JvmKotlinType(receiverValue.type, receiverValue.kotlinType) : null);
        codegen2.generate();
        StackValue stackValue = codegen2.putInstanceOnStack(receiverValue);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(224);
        }
        return stackValue;
    }

    @NotNull
    public StackValue generateClassLiteralReference(@NotNull DoubleColonLHS lhs, @Nullable KtExpression receiverExpression, boolean wrapIntoKClass) {
        if (lhs == null) {
            ExpressionCodegen.$$$reportNull$$$0(225);
        }
        StackValue stackValue = StackValue.operation(wrapIntoKClass ? AsmTypes.K_CLASS_TYPE : AsmTypes.JAVA_CLASS_TYPE, v -> {
            KotlinType type2 = lhs.getType();
            if (lhs instanceof DoubleColonLHS.Expression && !((DoubleColonLHS.Expression)lhs).isObjectQualifier()) {
                JavaClassProperty.INSTANCE.generateImpl((InstructionAdapter)v, this.gen(receiverExpression));
            } else {
                if (TypeUtils.isTypeParameter(type2)) {
                    assert (TypeUtils.isReifiedTypeParameter(type2)) : "Non-reified type parameter under ::class should be rejected by type checker: " + type2;
                    BaseExpressionCodegenKt.putReifiedOperationMarkerIfTypeIsReifiedParameter(this, type2, ReifiedTypeInliner.OperationKind.JAVA_CLASS);
                }
                DescriptorAsmUtil.putJavaLangClassInstance(v, this.typeMapper.mapType(type2), type2, this.typeMapper);
            }
            if (wrapIntoKClass) {
                AsmUtil.wrapJavaClassIntoKClass(v);
            }
            return Unit.INSTANCE;
        });
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(226);
        }
        return stackValue;
    }

    @Override
    public StackValue visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(227);
        }
        StackValue receiverValue = StackValue.none();
        return this.genQualified(receiverValue, expression2.getSelectorExpression());
    }

    private StackValue generateExpressionWithNullFallback(@NotNull KtExpression expression2, @NotNull Label ifnull) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(228);
        }
        if (ifnull == null) {
            ExpressionCodegen.$$$reportNull$$$0(229);
        }
        KtExpression deparenthesized = KtPsiUtil.deparenthesize(expression2);
        assert (deparenthesized != null) : "Unexpected empty expression";
        expression2 = deparenthesized;
        Type type2 = this.expressionType(expression2);
        KotlinType kotlinType = this.kotlinType(expression2);
        if (expression2 instanceof KtSafeQualifiedExpression && !AsmUtil.isPrimitive(type2)) {
            return StackValue.coercion(this.generateSafeQualifiedExpression((KtSafeQualifiedExpression)expression2, ifnull), type2, kotlinType);
        }
        return this.genLazy(expression2, type2, kotlinType);
    }

    private StackValue generateSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression2, @NotNull Label ifNull2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(230);
        }
        if (ifNull2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(231);
        }
        KtExpression receiver = expression2.getReceiverExpression();
        KtExpression selector = expression2.getSelectorExpression();
        Type receiverType = this.expressionType(receiver);
        KotlinType receiverKotlinType = this.kotlinType(receiver);
        StackValue receiverValue = this.generateExpressionWithNullFallback(receiver, ifNull2);
        StackValue.SafeCall newReceiver = new StackValue.SafeCall(receiverType, receiverKotlinType, receiverValue, AsmUtil.isPrimitive(receiverType) ? null : ifNull2);
        return this.genQualified(newReceiver, selector);
    }

    @Override
    public StackValue visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression2, StackValue unused2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(232);
        }
        Label ifnull = new Label();
        Type type2 = AsmUtil.boxType(this.expressionType(expression2));
        KotlinType kotlinType = this.kotlinType(expression2);
        StackValue value2 = this.generateSafeQualifiedExpression(expression2, ifnull);
        StackValue newReceiver = StackValue.coercion(value2, type2, kotlinType);
        StackValue result2 = !AsmUtil.isPrimitive(this.expressionType(expression2.getReceiverExpression())) ? new StackValue.SafeFallback(type2, kotlinType, ifnull, newReceiver) : newReceiver;
        return result2;
    }

    @Override
    public StackValue visitBinaryExpression(@NotNull KtBinaryExpression expression2, @NotNull StackValue receiver) {
        KtOperationReferenceExpression reference;
        IElementType opToken;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(233);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(234);
        }
        if ((opToken = (reference = expression2.getOperationReference()).getReferencedNameElementType()) == KtTokens.EQ) {
            return this.generateAssignmentExpression(expression2);
        }
        if (KtTokens.AUGMENTED_ASSIGNMENTS.contains(opToken)) {
            return this.generateAugmentedAssignment(expression2);
        }
        if (opToken == KtTokens.ANDAND) {
            return this.generateBooleanAnd(expression2);
        }
        if (opToken == KtTokens.OROR) {
            return this.generateBooleanOr(expression2);
        }
        if (opToken == KtTokens.EQEQ || opToken == KtTokens.EXCLEQ || opToken == KtTokens.EQEQEQ || opToken == KtTokens.EXCLEQEQEQ) {
            return this.generateEquals(expression2.getLeft(), expression2.getRight(), opToken, null, null, this.bindingContext.get(BindingContext.PRIMITIVE_NUMERIC_COMPARISON_INFO, expression2));
        }
        if (opToken == KtTokens.LT || opToken == KtTokens.LTEQ || opToken == KtTokens.GT || opToken == KtTokens.GTEQ) {
            return this.generateComparison(expression2, receiver);
        }
        if (opToken == KtTokens.ELVIS) {
            return this.generateElvis(expression2);
        }
        if (opToken == KtTokens.IN_KEYWORD || opToken == KtTokens.NOT_IN) {
            return this.generateIn(StackValue.expression(this.expressionType(expression2.getLeft()), expression2.getLeft(), this), expression2.getRight(), reference);
        }
        ConstantValue<?> compileTimeConstant = this.getPrimitiveOrStringCompileTimeConstant(expression2);
        if (compileTimeConstant != null) {
            return StackValue.constant(compileTimeConstant.getValue(), this.expressionType(expression2));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
        FunctionDescriptor descriptor2 = (FunctionDescriptor)resolvedCall2.getResultingDescriptor();
        if (descriptor2 instanceof ConstructorDescriptor) {
            return this.generateConstructorCall(resolvedCall2, this.expressionType(expression2));
        }
        return this.invokeFunction(resolvedCall2, receiver);
    }

    private StackValue generateIn(StackValue leftValue, KtExpression rangeExpression, KtSimpleNameExpression operationReference) {
        KtExpression deparenthesized = KtPsiUtil.deparenthesize(rangeExpression);
        assert (deparenthesized != null) : "For with empty range expression";
        RangeValue rangeValue = RangeValuesKt.createRangeValueForExpression(this, deparenthesized);
        return rangeValue.createInExpressionGenerator(this, operationReference).generate(leftValue);
    }

    private StackValue generateBooleanAnd(KtBinaryExpression expression2) {
        return StackValue.and(this.gen(expression2.getLeft()), this.gen(expression2.getRight()));
    }

    private StackValue generateBooleanOr(KtBinaryExpression expression2) {
        return StackValue.or(this.gen(expression2.getLeft()), this.gen(expression2.getRight()));
    }

    private StackValue genLazyUnlessProvided(@Nullable StackValue pregenerated, @NotNull KtExpression expr, @NotNull Type type2) {
        if (expr == null) {
            ExpressionCodegen.$$$reportNull$$$0(235);
        }
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(236);
        }
        return this.genLazyUnlessProvided(pregenerated, expr, type2, null);
    }

    private StackValue genLazyUnlessProvided(@Nullable StackValue pregenerated, @NotNull KtExpression expr, @NotNull Type type2, @Nullable KotlinType kotlinType) {
        if (expr == null) {
            ExpressionCodegen.$$$reportNull$$$0(237);
        }
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(238);
        }
        return pregenerated != null ? StackValue.coercion(pregenerated, type2, kotlinType) : this.genLazy(expr, type2, kotlinType);
    }

    private StackValue genUnlessProvided(@Nullable StackValue pregenerated, @NotNull KtExpression expr, @NotNull Type type2) {
        if (expr == null) {
            ExpressionCodegen.$$$reportNull$$$0(239);
        }
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(240);
        }
        if (pregenerated != null) {
            pregenerated.put(type2, null, this.v);
        } else {
            this.gen(expr, type2);
        }
        return StackValue.onStack(type2);
    }

    private StackValue generateEquals(@Nullable KtExpression left, @Nullable KtExpression right, @NotNull IElementType opToken, @Nullable StackValue pregeneratedSubject, @Nullable KotlinType subjectKotlinType, @Nullable PrimitiveNumericComparisonInfo primitiveNumericComparisonInfo) {
        boolean rightHasPrimitiveEquality;
        if (opToken == null) {
            ExpressionCodegen.$$$reportNull$$$0(241);
        }
        if (left == null || right == null) {
            return StackValue.operation(Type.VOID_TYPE, v -> {
                v.aconst(null);
                v.athrow();
                return Unit.INSTANCE;
            });
        }
        KotlinType leftKotlinType = subjectKotlinType != null ? subjectKotlinType : this.kotlinType(left);
        KotlinType rightKotlinType = this.kotlinType(right);
        boolean leftIsInlineClass = leftKotlinType != null && InlineClassesUtilsKt.isInlineClassType(leftKotlinType);
        boolean rightIsInlineClass = rightKotlinType != null && InlineClassesUtilsKt.isInlineClassType(rightKotlinType);
        Type leftType = pregeneratedSubject != null ? pregeneratedSubject.type : this.expressionType(left);
        Type rightType = this.expressionType(right);
        boolean leftHasPrimitiveEquality = AsmUtil.isPrimitive(leftType) && (!leftIsInlineClass || CodegenUtilKt.isInlineClassTypeWithPrimitiveEquality(leftKotlinType));
        boolean bl = rightHasPrimitiveEquality = AsmUtil.isPrimitive(rightType) && (!rightIsInlineClass || CodegenUtilKt.isInlineClassTypeWithPrimitiveEquality(rightKotlinType));
        if (KtPsiUtil.isNullConstant(left)) {
            return this.genCmpWithNull(right, opToken, null);
        }
        if (KtPsiUtil.isNullConstant(right)) {
            return this.genCmpWithNull(left, opToken, pregeneratedSubject);
        }
        if (leftIsInlineClass || rightIsInlineClass) {
            boolean rightIsUnboxed;
            boolean leftIsUnboxed = leftIsInlineClass && StackValue.isUnboxedInlineClass(leftKotlinType, leftType);
            boolean bl2 = rightIsUnboxed = rightIsInlineClass && StackValue.isUnboxedInlineClass(rightKotlinType, rightType);
            if (!(leftIsUnboxed && rightIsUnboxed && leftHasPrimitiveEquality && rightHasPrimitiveEquality)) {
                return this.genEqualsForInlineClasses(left, right, opToken, pregeneratedSubject, leftKotlinType, rightKotlinType, leftType, rightType, leftIsInlineClass, leftIsUnboxed, rightIsUnboxed);
            }
        }
        if (this.isIntZero(left, leftType) && rightHasPrimitiveEquality && AsmUtil.isIntPrimitive(rightType)) {
            return this.genCmpWithZero(right, opToken, null);
        }
        if (this.isIntZero(right, rightType) && leftHasPrimitiveEquality && AsmUtil.isIntPrimitive(leftType)) {
            return this.genCmpWithZero(left, opToken, pregeneratedSubject);
        }
        if (pregeneratedSubject == null && left instanceof KtSafeQualifiedExpression && this.isSelectorPureNonNullType((KtSafeQualifiedExpression)left) && AsmUtil.isPrimitive(rightType) && rightHasPrimitiveEquality) {
            return this.genCmpSafeCallToPrimitive((KtSafeQualifiedExpression)left, right, rightType, opToken);
        }
        if (AsmUtil.isPrimitive(leftType) && leftHasPrimitiveEquality && right instanceof KtSafeQualifiedExpression && this.isSelectorPureNonNullType((KtSafeQualifiedExpression)right)) {
            return this.genCmpPrimitiveToSafeCall(left, leftType, (KtSafeQualifiedExpression)right, opToken, pregeneratedSubject);
        }
        if (BoxedToPrimitiveEquality.isApplicable(opToken, leftType, rightType)) {
            return BoxedToPrimitiveEquality.create(opToken, this.genLazyUnlessProvided(pregeneratedSubject, left, leftType), leftType, this.genLazy(right, rightType), rightType, this.myFrameMap);
        }
        if (PrimitiveToBoxedEquality.isApplicable(opToken, leftType, rightType)) {
            return PrimitiveToBoxedEquality.create(opToken, this.genLazyUnlessProvided(pregeneratedSubject, left, leftType), leftType, this.genLazy(right, rightType), rightType);
        }
        if (PrimitiveToObjectEquality.isApplicable(opToken, leftType, rightType)) {
            return PrimitiveToObjectEquality.create(opToken, this.genLazyUnlessProvided(pregeneratedSubject, left, leftType), leftType, this.genLazy(right, rightType), rightType);
        }
        if (AsmUtil.isPrimitive(leftType) != AsmUtil.isPrimitive(rightType)) {
            leftType = AsmUtil.boxType(leftType);
            rightType = AsmUtil.boxType(rightType);
        }
        if (opToken == KtTokens.EQEQEQ || opToken == KtTokens.EXCLEQEQEQ) {
            Type operandType = AsmUtil.isPrimitive(leftType) ? leftType : AsmTypes.OBJECT_TYPE;
            return StackValue.cmp(opToken, operandType, this.genLazyUnlessProvided(pregeneratedSubject, left, leftType), this.genLazy(right, rightType));
        }
        if ((opToken == KtTokens.EQEQ || opToken == KtTokens.EXCLEQ) && (this.isEnumExpression(left) || this.isEnumExpression(right))) {
            return StackValue.cmp(opToken == KtTokens.EQEQ ? KtTokens.EQEQEQ : KtTokens.EXCLEQEQEQ, AsmTypes.OBJECT_TYPE, this.genLazyUnlessProvided(pregeneratedSubject, left, leftType), this.genLazy(right, rightType));
        }
        return this.genEqualsForExpressionsPreferIeee754Arithmetic(left, right, opToken, leftType, rightType, pregeneratedSubject, primitiveNumericComparisonInfo);
    }

    @NotNull
    private StackValue genEqualsForInlineClasses(@NotNull KtExpression left, @NotNull KtExpression right, @NotNull IElementType opToken, @Nullable StackValue pregeneratedSubject, @NotNull KotlinType leftKotlinType, @NotNull KotlinType rightKotlinType, @NotNull Type leftType, @NotNull Type rightType, boolean leftIsInlineClass, boolean leftIsUnboxed, boolean rightIsUnboxed) {
        if (left == null) {
            ExpressionCodegen.$$$reportNull$$$0(242);
        }
        if (right == null) {
            ExpressionCodegen.$$$reportNull$$$0(243);
        }
        if (opToken == null) {
            ExpressionCodegen.$$$reportNull$$$0(244);
        }
        if (leftKotlinType == null) {
            ExpressionCodegen.$$$reportNull$$$0(245);
        }
        if (rightKotlinType == null) {
            ExpressionCodegen.$$$reportNull$$$0(246);
        }
        if (leftType == null) {
            ExpressionCodegen.$$$reportNull$$$0(247);
        }
        if (rightType == null) {
            ExpressionCodegen.$$$reportNull$$$0(248);
        }
        StackValue leftValue = this.genLazyUnlessProvided(pregeneratedSubject, left, leftType, leftKotlinType);
        StackValue rightValue = this.genLazy(right, rightType, rightKotlinType);
        StackValue stackValue = StackValue.operation(Type.BOOLEAN_TYPE, v -> {
            SimpleType nullableAnyType = this.state.getModule().getBuiltIns().getNullableAnyType();
            Label endLabel = new Label();
            boolean flipComparison = opToken == KtTokens.EXCLEQ || opToken == KtTokens.EXCLEQEQEQ;
            boolean useUnboxedEquals = (leftIsUnboxed || leftIsInlineClass && rightIsUnboxed) && JvmCodegenUtil.typeHasSpecializedInlineClassEquality(leftKotlinType, this.state);
            leftValue.put(leftType, leftKotlinType, (InstructionAdapter)v);
            Type afterTopType = leftType;
            if (!useUnboxedEquals) {
                StackValue.coerce(leftType, leftKotlinType, AsmTypes.OBJECT_TYPE, nullableAnyType, v);
                afterTopType = AsmTypes.OBJECT_TYPE;
            }
            rightValue.put(rightType, rightKotlinType, (InstructionAdapter)v);
            Type topType = rightType;
            if (!useUnboxedEquals || !rightIsUnboxed) {
                StackValue.coerce(rightType, rightKotlinType, AsmTypes.OBJECT_TYPE, nullableAnyType, v);
                topType = AsmTypes.OBJECT_TYPE;
            }
            if (useUnboxedEquals) {
                String descriptor2;
                Label nonNullLabel;
                String className2 = this.typeMapper.mapTypeAsDeclaration(leftKotlinType).getInternalName();
                if (TypeUtils.isNullableType(leftKotlinType)) {
                    AsmUtil.dupSecond(v, topType, afterTopType);
                    nonNullLabel = new Label();
                    v.ifnonnull(nonNullLabel);
                    if (TypeUtils.isNullableType(rightKotlinType)) {
                        Label branchJumpLabel = new Label();
                        v.ifnonnull(branchJumpLabel);
                        AsmUtil.pop(v, afterTopType);
                        v.iconst(flipComparison ? 0 : 1);
                        v.goTo(endLabel);
                        v.visitLabel(branchJumpLabel);
                        AsmUtil.pop(v, afterTopType);
                    } else {
                        AsmUtil.pop2(v, topType, afterTopType);
                    }
                    v.iconst(flipComparison ? 1 : 0);
                    v.goTo(endLabel);
                    v.visitLabel(nonNullLabel);
                }
                if (rightIsUnboxed) {
                    if (TypeUtils.isNullableType(rightKotlinType)) {
                        AsmUtil.dup(v, topType);
                        nonNullLabel = new Label();
                        v.ifnonnull(nonNullLabel);
                        AsmUtil.pop2(v, topType, afterTopType);
                        v.iconst(flipComparison ? 1 : 0);
                        v.goTo(endLabel);
                        v.visitLabel(nonNullLabel);
                    }
                    if (!leftIsUnboxed) {
                        AsmUtil.swap(v, topType, afterTopType);
                        KotlinType nonNullableLeftKotlinType = TypeUtils.makeNotNullable(leftKotlinType);
                        Type nonNullableLeftType = this.typeMapper.mapType(nonNullableLeftKotlinType);
                        StackValue.coerce(leftType, leftKotlinType, nonNullableLeftType, nonNullableLeftKotlinType, v);
                        afterTopType = nonNullableLeftType;
                        AsmUtil.swap(v, afterTopType, topType);
                    }
                    descriptor2 = Type.getMethodDescriptor(Type.BOOLEAN_TYPE, afterTopType, afterTopType);
                    v.invokestatic(className2, InlineClassDescriptorResolver.SPECIALIZED_EQUALS_NAME.asString(), descriptor2, false);
                } else {
                    descriptor2 = Type.getMethodDescriptor(Type.BOOLEAN_TYPE, afterTopType, AsmTypes.OBJECT_TYPE);
                    v.invokestatic(className2, "equals-impl", descriptor2, false);
                }
            } else {
                DescriptorAsmUtil.genAreEqualCall(v);
            }
            if (flipComparison) {
                AsmUtil.genInvertBoolean(v);
            }
            v.visitLabel(endLabel);
            return Unit.INSTANCE;
        });
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(249);
        }
        return stackValue;
    }

    private boolean isEnumExpression(@Nullable KtExpression expression2) {
        KotlinType expressionType = this.bindingContext.getType(expression2);
        if (expressionType == null) {
            return false;
        }
        return DescriptorUtils.isEnumClass(expressionType.getConstructor().getDeclarationDescriptor());
    }

    private boolean isSelectorPureNonNullType(@NotNull KtSafeQualifiedExpression safeExpression) {
        KtExpression expression2;
        if (safeExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(250);
        }
        if ((expression2 = safeExpression.getSelectorExpression()) == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.bindingContext);
        if (resolvedCall2 == null) {
            return false;
        }
        KotlinType returnType2 = resolvedCall2.getResultingDescriptor().getReturnType();
        return returnType2 != null && !TypeUtils.isNullableType(returnType2);
    }

    private StackValue genCmpPrimitiveToSafeCall(@NotNull KtExpression left, @NotNull Type leftType, @NotNull KtSafeQualifiedExpression right, @NotNull IElementType opToken, @Nullable StackValue pregeneratedLeft) {
        if (left == null) {
            ExpressionCodegen.$$$reportNull$$$0(251);
        }
        if (leftType == null) {
            ExpressionCodegen.$$$reportNull$$$0(252);
        }
        if (right == null) {
            ExpressionCodegen.$$$reportNull$$$0(253);
        }
        if (opToken == null) {
            ExpressionCodegen.$$$reportNull$$$0(254);
        }
        Label rightIsNull = new Label();
        return new PrimitiveToSafeCallEquality(opToken, leftType, this.genLazyUnlessProvided(pregeneratedLeft, left, leftType), this.generateSafeQualifiedExpression(right, rightIsNull), this.expressionType(right.getReceiverExpression()), rightIsNull);
    }

    private StackValue genCmpSafeCallToPrimitive(@NotNull KtSafeQualifiedExpression left, @NotNull KtExpression right, @NotNull Type rightType, @NotNull IElementType opToken) {
        if (left == null) {
            ExpressionCodegen.$$$reportNull$$$0(255);
        }
        if (right == null) {
            ExpressionCodegen.$$$reportNull$$$0(256);
        }
        if (rightType == null) {
            ExpressionCodegen.$$$reportNull$$$0(257);
        }
        if (opToken == null) {
            ExpressionCodegen.$$$reportNull$$$0(258);
        }
        Label leftIsNull = new Label();
        return new SafeCallToPrimitiveEquality(opToken, rightType, this.generateSafeQualifiedExpression(left, leftIsNull), this.genLazy(right, rightType), this.expressionType(left.getReceiverExpression()), leftIsNull);
    }

    @Nullable
    private static KotlinType getLeftOperandType(@Nullable PrimitiveNumericComparisonInfo numericComparisonInfo) {
        if (numericComparisonInfo == null) {
            return null;
        }
        return numericComparisonInfo.getLeftPrimitiveType();
    }

    @Nullable
    private static KotlinType getRightOperandType(@Nullable PrimitiveNumericComparisonInfo numericComparisonInfo) {
        if (numericComparisonInfo == null) {
            return null;
        }
        return numericComparisonInfo.getRightPrimitiveType();
    }

    private StackValue genEqualsForExpressionsPreferIeee754Arithmetic(@NotNull KtExpression left, @NotNull KtExpression right, @NotNull IElementType opToken, @NotNull Type leftType, @NotNull Type rightType, @Nullable StackValue pregeneratedLeft, @Nullable PrimitiveNumericComparisonInfo primitiveNumericComparisonInfo) {
        Type comparisonType;
        if (left == null) {
            ExpressionCodegen.$$$reportNull$$$0(259);
        }
        if (right == null) {
            ExpressionCodegen.$$$reportNull$$$0(260);
        }
        if (opToken == null) {
            ExpressionCodegen.$$$reportNull$$$0(261);
        }
        if (leftType == null) {
            ExpressionCodegen.$$$reportNull$$$0(262);
        }
        if (rightType == null) {
            ExpressionCodegen.$$$reportNull$$$0(263);
        }
        assert (opToken == KtTokens.EQEQ || opToken == KtTokens.EXCLEQ) : "Optoken should be '==' or '!=', but: " + opToken;
        TypeAndNullability left754Type = this.calcTypeForIeee754ArithmeticIfNeeded(left, ExpressionCodegen.getLeftOperandType(primitiveNumericComparisonInfo));
        TypeAndNullability right754Type = this.calcTypeForIeee754ArithmeticIfNeeded(right, ExpressionCodegen.getRightOperandType(primitiveNumericComparisonInfo));
        if (left754Type != null && right754Type != null && ((comparisonType = AsmUtil.comparisonOperandType(left754Type.type, right754Type.type)) == Type.FLOAT_TYPE || comparisonType == Type.DOUBLE_TYPE)) {
            if (left754Type.type.equals(right754Type.type)) {
                if (left754Type.isNullable || right754Type.isNullable) {
                    if (this.state.getLanguageVersionSettings().getApiVersion().compareTo(ApiVersion.KOTLIN_1_1) >= 0) {
                        return StackValue.operation(Type.BOOLEAN_TYPE, v -> {
                            this.generate754EqualsForNullableTypesViaIntrinsic((InstructionAdapter)v, opToken, pregeneratedLeft, left, left754Type, right, right754Type);
                            return Unit.INSTANCE;
                        });
                    }
                    return StackValue.operation(Type.BOOLEAN_TYPE, v -> {
                        this.generate754EqualsForNullableTypes((InstructionAdapter)v, opToken, pregeneratedLeft, left, left754Type, right, right754Type);
                        return Unit.INSTANCE;
                    });
                }
                leftType = left754Type.type;
                rightType = right754Type.type;
            } else if (this.shouldUseProperIeee754Comparisons()) {
                return Ieee754Equality.create(this.myFrameMap, this.genLazy(left, ExpressionCodegen.boxIfNullable(left754Type)), this.genLazy(right, ExpressionCodegen.boxIfNullable(right754Type)), comparisonType, opToken);
            }
        }
        return DescriptorAsmUtil.genEqualsForExpressionsOnStack(opToken, this.genLazyUnlessProvided(pregeneratedLeft, left, leftType, this.kotlinType(left)), this.genLazy(right, rightType, this.kotlinType(right)));
    }

    @NotNull
    private static Type boxIfNullable(@NotNull TypeAndNullability ieee754Type) {
        if (ieee754Type == null) {
            ExpressionCodegen.$$$reportNull$$$0(264);
        }
        if (ieee754Type.isNullable) {
            Type type2 = AsmUtil.boxType(ieee754Type.type);
            if (type2 == null) {
                ExpressionCodegen.$$$reportNull$$$0(265);
            }
            return type2;
        }
        Type type3 = ieee754Type.type;
        if (type3 == null) {
            ExpressionCodegen.$$$reportNull$$$0(266);
        }
        return type3;
    }

    private void generate754EqualsForNullableTypesViaIntrinsic(@NotNull InstructionAdapter v, @NotNull IElementType opToken, @Nullable StackValue pregeneratedLeft, @Nullable KtExpression left, @NotNull TypeAndNullability left754Type, @Nullable KtExpression right, @NotNull TypeAndNullability right754Type) {
        if (v == null) {
            ExpressionCodegen.$$$reportNull$$$0(267);
        }
        if (opToken == null) {
            ExpressionCodegen.$$$reportNull$$$0(268);
        }
        if (left754Type == null) {
            ExpressionCodegen.$$$reportNull$$$0(269);
        }
        if (right754Type == null) {
            ExpressionCodegen.$$$reportNull$$$0(270);
        }
        Type leftType = left754Type.isNullable ? AsmUtil.boxType(left754Type.type) : left754Type.type;
        this.genUnlessProvided(pregeneratedLeft, left, leftType);
        Type rightType = right754Type.isNullable ? AsmUtil.boxType(right754Type.type) : right754Type.type;
        this.gen(right, rightType);
        DescriptorAsmUtil.genIEEE754EqualForNullableTypesCall(v, leftType, rightType);
        if (opToken == KtTokens.EXCLEQ) {
            AsmUtil.genInvertBoolean(v);
        }
    }

    private void generate754EqualsForNullableTypes(@NotNull InstructionAdapter v, @NotNull IElementType opToken, @Nullable StackValue pregeneratedLeft, @Nullable KtExpression left, @NotNull TypeAndNullability left754Type, @Nullable KtExpression right, @NotNull TypeAndNullability right754Type) {
        if (v == null) {
            ExpressionCodegen.$$$reportNull$$$0(271);
        }
        if (opToken == null) {
            ExpressionCodegen.$$$reportNull$$$0(272);
        }
        if (left754Type == null) {
            ExpressionCodegen.$$$reportNull$$$0(273);
        }
        if (right754Type == null) {
            ExpressionCodegen.$$$reportNull$$$0(274);
        }
        int equals = opToken == KtTokens.EQEQ ? 1 : 0;
        int notEquals = opToken != KtTokens.EQEQ ? 1 : 0;
        Label end = new Label();
        StackValue leftValue = pregeneratedLeft != null ? pregeneratedLeft : this.gen(left);
        leftValue.put(leftValue.type, leftValue.kotlinType, v);
        leftValue = StackValue.onStack(leftValue.type);
        Type leftType = left754Type.type;
        Type rightType = right754Type.type;
        if (left754Type.isNullable) {
            leftValue.dup(v, false);
            Label leftIsNull = new Label();
            v.ifnull(leftIsNull);
            StackValue.coercion(leftValue, leftType, null).put(leftType, null, v);
            StackValue nonNullLeftValue = StackValue.onStack(leftType);
            StackValue rightValue = this.gen(right);
            rightValue.put(rightValue.type, rightValue.kotlinType, v);
            rightValue = StackValue.onStack(rightValue.type);
            if (right754Type.isNullable) {
                rightValue.dup(v, false);
                Label rightIsNotNull = new Label();
                v.ifnonnull(rightIsNotNull);
                AsmUtil.pop(v, rightValue.type);
                AsmUtil.pop(v, nonNullLeftValue.type);
                v.iconst(notEquals);
                v.goTo(end);
                v.mark(rightIsNotNull);
            }
            StackValue.coercion(rightValue, rightType, null).put(rightType, null, v);
            StackValue nonNullRightValue = StackValue.onStack(rightType);
            StackValue.cmp(opToken, leftType, nonNullLeftValue, nonNullRightValue).put(Type.BOOLEAN_TYPE, null, v);
            v.goTo(end);
            v.mark(leftIsNull);
            AsmUtil.pop(v, leftValue.type);
            rightValue = this.gen(right);
            rightValue.put(rightValue.type, rightValue.kotlinType, v);
            rightValue = StackValue.onStack(rightValue.type);
            if (right754Type.isNullable) {
                Label rightIsNotNull = new Label();
                v.ifnonnull(rightIsNotNull);
                v.iconst(equals);
                v.goTo(end);
                v.mark(rightIsNotNull);
                v.iconst(notEquals);
            } else {
                AsmUtil.pop(v, rightValue.type);
                v.iconst(notEquals);
            }
            v.mark(end);
            return;
        }
        StackValue.coercion(leftValue, leftType, null).put(leftType, null, v);
        leftValue = StackValue.onStack(leftType);
        StackValue rightValue = this.gen(right);
        rightValue.put(rightValue.type, rightValue.kotlinType, v);
        rightValue = StackValue.onStack(rightValue.type);
        rightValue.dup(v, false);
        Label rightIsNotNull = new Label();
        v.ifnonnull(rightIsNotNull);
        AsmUtil.pop(v, rightValue.type);
        AsmUtil.pop(v, leftValue.type);
        v.iconst(notEquals);
        v.goTo(end);
        v.mark(rightIsNotNull);
        StackValue.coercion(rightValue, rightType, null).put(rightType, null, v);
        StackValue nonNullRightValue = StackValue.onStack(rightType);
        StackValue.cmp(opToken, leftType, leftValue, nonNullRightValue).put(Type.BOOLEAN_TYPE, null, v);
        v.mark(end);
    }

    private boolean isIntZero(KtExpression expr, Type exprType) {
        ConstantValue<?> exprValue = this.getPrimitiveOrStringCompileTimeConstant(expr);
        return AsmUtil.isIntPrimitive(exprType) && exprValue != null && Integer.valueOf(0).equals(exprValue.getValue());
    }

    private StackValue genCmpWithZero(KtExpression exp, IElementType opToken, @Nullable StackValue pregeneratedExpr) {
        StackValue argument2;
        if (pregeneratedExpr == null) {
            KotlinType kotlinType = this.kotlinType(exp);
            assert (kotlinType != null) : "No KotlinType for expression " + exp.getText();
            argument2 = this.genLazy(exp, this.asmType(kotlinType), kotlinType);
        } else {
            argument2 = pregeneratedExpr;
        }
        return StackValue.compareIntWithZero(argument2, KtTokens.EQEQ == opToken || KtTokens.EQEQEQ == opToken ? 154 : 153);
    }

    private StackValue genCmpWithNull(KtExpression exp, IElementType opToken, @Nullable StackValue pregeneratedExpr) {
        StackValue argument2;
        KotlinType kotlinType = this.kotlinType(exp);
        Type type2 = this.expressionType(exp);
        StackValue stackValue = argument2 = pregeneratedExpr != null ? pregeneratedExpr : this.gen(exp);
        if (kotlinType == null || TypeUtils.isNullableType(kotlinType) || !InlineClassesUtilsKt.isInlineClassType(kotlinType)) {
            return StackValue.compareWithNull(argument2, KtTokens.EQEQ == opToken || KtTokens.EQEQEQ == opToken ? 199 : 198);
        }
        return StackValue.operation(Type.BOOLEAN_TYPE, v -> {
            argument2.put(type2, kotlinType, (InstructionAdapter)v);
            AsmUtil.pop(v, type2);
            v.iconst(opToken == KtTokens.EXCLEQ || opToken == KtTokens.EXCLEQEQEQ ? 1 : 0);
            return Unit.INSTANCE;
        });
    }

    private StackValue generateElvis(@NotNull KtBinaryExpression expression2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(275);
        }
        KtExpression left = expression2.getLeft();
        Type exprType = this.expressionType(expression2);
        KotlinType exprKotlinType = this.kotlinType(expression2);
        Type leftType = this.expressionType(left);
        KotlinType leftKotlinType = this.kotlinType(left);
        Label ifNull2 = new Label();
        assert (left != null) : "left expression in elvis should be not null: " + expression2.getText();
        StackValue value2 = this.generateExpressionWithNullFallback(left, ifNull2);
        if (AsmUtil.isPrimitive(leftType)) {
            return value2;
        }
        return StackValue.operation(exprType, exprKotlinType, v -> {
            value2.put(value2.type, value2.kotlinType, (InstructionAdapter)v);
            v.dup();
            v.ifnull(ifNull2);
            StackValue.onStack(leftType, leftKotlinType).put(exprType, exprKotlinType, (InstructionAdapter)v);
            Label end = new Label();
            v.goTo(end);
            v.mark(ifNull2);
            Integer leftLineNumber = CodegenUtil.getLineNumberForElement(left, false);
            Integer rightLineNumber = CodegenUtil.getLineNumberForElement(expression2.getRight(), false);
            if (rightLineNumber != null && rightLineNumber.equals(leftLineNumber)) {
                v.visitLineNumber(rightLineNumber, ifNull2);
            }
            v.pop();
            this.gen(expression2.getRight(), exprType, exprKotlinType);
            v.mark(end);
            return null;
        });
    }

    private StackValue generateComparison(KtBinaryExpression expression2, StackValue receiver) {
        StackValue rightValue;
        StackValue leftValue;
        Type type2;
        boolean isStandardCompareTo;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
        PrimitiveNumericComparisonInfo primitiveNumericComparisonInfo = this.bindingContext.get(BindingContext.PRIMITIVE_NUMERIC_COMPARISON_INFO, expression2);
        KtExpression left = expression2.getLeft();
        KtExpression right = expression2.getRight();
        Type leftType = this.expressionType(left);
        Type rightType = this.expressionType(right);
        TypeAndNullability left754Type = this.calcTypeForIeee754ArithmeticIfNeeded(left, ExpressionCodegen.getLeftOperandType(primitiveNumericComparisonInfo));
        TypeAndNullability right754Type = this.calcTypeForIeee754ArithmeticIfNeeded(right, ExpressionCodegen.getRightOperandType(primitiveNumericComparisonInfo));
        boolean isSame754ArithmeticTypes = left754Type != null && right754Type != null && left754Type.type.equals(right754Type.type);
        boolean properIeee754Comparisons = this.shouldUseProperIeee754Comparisons();
        boolean bl = isStandardCompareTo = primitiveNumericComparisonInfo != null;
        if (properIeee754Comparisons && isStandardCompareTo && left754Type != null && right754Type != null) {
            type2 = AsmUtil.comparisonOperandType(left754Type.type, right754Type.type);
            leftValue = this.gen(left);
            rightValue = this.gen(right);
        } else if (!properIeee754Comparisons && isStandardCompareTo && (AsmUtil.isPrimitive(leftType) && AsmUtil.isPrimitive(rightType) || isSame754ArithmeticTypes)) {
            type2 = isSame754ArithmeticTypes ? left754Type.type : AsmUtil.comparisonOperandType(leftType, rightType);
            leftValue = this.gen(left);
            rightValue = this.gen(right);
        } else {
            type2 = Type.INT_TYPE;
            leftValue = this.invokeFunction(resolvedCall2, receiver);
            rightValue = StackValue.constant(0, type2);
        }
        return StackValue.cmp(expression2.getOperationToken(), type2, leftValue, rightValue);
    }

    @Nullable
    private TypeAndNullability calcTypeForIeee754ArithmeticIfNeeded(@Nullable KtExpression expression2, @Nullable KotlinType inferredPrimitiveType) {
        if (expression2 == null) {
            return null;
        }
        if (this.shouldUseProperIeee754Comparisons()) {
            return Ieee754Kt.calcProperTypeForIeee754ArithmeticIfNeeded(expression2, this.bindingContext, inferredPrimitiveType, this.typeMapper);
        }
        return Ieee754Kt.legacyCalcTypeForIeee754ArithmeticIfNeeded(expression2, this.bindingContext, this.context.getFunctionDescriptor(), this.state.getLanguageVersionSettings());
    }

    private boolean shouldUseProperIeee754Comparisons() {
        return this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperIeee754Comparisons);
    }

    private StackValue generateAssignmentExpression(KtBinaryExpression expression2) {
        return StackValue.operation(Type.VOID_TYPE, adapter -> {
            StackValue stackValue = this.gen(expression2.getLeft());
            KtExpression right = expression2.getRight();
            assert (right != null) : expression2.getText();
            stackValue.store(this.gen(right), this.v);
            return Unit.INSTANCE;
        });
    }

    private StackValue generateAugmentedAssignment(KtBinaryExpression expression2) {
        return StackValue.operation(Type.VOID_TYPE, adapter -> {
            ResolvedCall<CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
            ResolvedCallWithRealDescriptor callWithRealDescriptor = CoroutineCodegenUtilKt.replaceSuspensionFunctionWithRealDescriptor(resolvedCall2, this.state);
            if (callWithRealDescriptor != null) {
                this.prepareCoroutineArgumentForSuspendCall(resolvedCall2, callWithRealDescriptor.getFakeContinuationExpression());
                resolvedCall2 = callWithRealDescriptor.getResolvedCall();
            }
            FunctionDescriptor descriptor2 = this.accessibleFunctionDescriptor(resolvedCall2);
            Callable callable = this.resolveToCallable(descriptor2, false, resolvedCall2);
            KtExpression lhs = expression2.getLeft();
            JvmKotlinType jvmKotlinType = new JvmKotlinType(this.expressionType(lhs), this.kotlinType(lhs));
            boolean keepReturnValue = Boolean.TRUE.equals(this.bindingContext.get(BindingContext.VARIABLE_REASSIGNMENT, expression2)) || !KotlinBuiltIns.isUnit(descriptor2.getReturnType());
            this.putCallAugAssignMethod(expression2, resolvedCall2, callable, descriptor2.getReturnType(), jvmKotlinType, keepReturnValue);
            return Unit.INSTANCE;
        });
    }

    private void putCallAugAssignMethod(@NotNull KtBinaryExpression expression2, @NotNull ResolvedCall<?> resolvedCall2, @NotNull Callable callable, @Nullable KotlinType returnKotlinType, @NotNull JvmKotlinType jvmKotlinType, boolean keepReturnValue) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(276);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(277);
        }
        if (callable == null) {
            ExpressionCodegen.$$$reportNull$$$0(278);
        }
        if (jvmKotlinType == null) {
            ExpressionCodegen.$$$reportNull$$$0(279);
        }
        StackValue value2 = this.gen(expression2.getLeft());
        if (keepReturnValue) {
            value2 = StackValue.complexWriteReadReceiver(value2);
        }
        value2.put(jvmKotlinType.getType(), jvmKotlinType.getKotlinType(), this.v);
        StackValue receiver = StackValue.onStack(jvmKotlinType.getType(), jvmKotlinType.getKotlinType());
        callable.invokeMethodWithArguments(resolvedCall2, receiver, this).put(callable.getReturnType(), null, this.v);
        if (keepReturnValue) {
            value2.store(StackValue.onStack(callable.getReturnType(), returnKotlinType), this.v, true);
        }
    }

    public void invokeAppend(StringConcatGenerator generator2, KtExpression expr) {
        ConstantValue<?> compileTimeConstant = this.getPrimitiveOrStringCompileTimeConstant(expr = KtPsiUtil.safeDeparenthesize(expr));
        if (compileTimeConstant == null) {
            if (expr instanceof KtBinaryExpression) {
                KtBinaryExpression binaryExpression = (KtBinaryExpression)expr;
                if (binaryExpression.getOperationToken() == KtTokens.PLUS) {
                    KtExpression left = binaryExpression.getLeft();
                    KtExpression right = binaryExpression.getRight();
                    Type leftType = this.expressionType(left);
                    if (leftType.equals(AsmTypes.JAVA_STRING_TYPE)) {
                        this.invokeAppend(generator2, left);
                        this.invokeAppend(generator2, right);
                        return;
                    }
                }
            } else if (expr instanceof KtStringTemplateExpression) {
                List<StringTemplateEntry> entries2 = this.preprocessStringTemplate((KtStringTemplateExpression)expr);
                this.invokeAppendForEntries(generator2, entries2);
                return;
            }
        }
        Type exprType = this.expressionType(expr);
        KotlinType exprKotlinType = this.kotlinType(expr);
        if (exprKotlinType != null && InlineClassesUtilsKt.isInlineClassType(exprKotlinType) && FlexibleTypesKt.isNullabilityFlexible(exprKotlinType)) {
            exprKotlinType = TypeUtils.makeNullable(exprKotlinType);
        }
        StackValue value2 = compileTimeConstant != null ? StackValue.constant(compileTimeConstant.getValue(), exprType, exprKotlinType) : this.gen(expr);
        DescriptorAsmUtil.genInvokeAppendMethod(generator2, exprType, exprKotlinType, this.typeMapper, value2);
    }

    @Nullable
    private static KtSimpleNameExpression targetLabel(KtExpression expression2) {
        if (expression2.getParent() instanceof KtLabeledExpression) {
            return ((KtLabeledExpression)expression2.getParent()).getTargetLabel();
        }
        return null;
    }

    @Override
    public StackValue visitLabeledExpression(@NotNull KtLabeledExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(280);
        }
        return this.genQualified(receiver, expression2.getBaseExpression());
    }

    @Override
    public StackValue visitPrefixExpression(@NotNull KtPrefixExpression expression2, @NotNull StackValue receiver) {
        String operationName;
        ConstantValue<?> compileTimeConstant;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(281);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(282);
        }
        if ((compileTimeConstant = this.getPrimitiveOrStringCompileTimeConstant(expression2)) != null) {
            return StackValue.constant(compileTimeConstant.getValue(), this.expressionType(expression2));
        }
        DeclarationDescriptor originalOperation = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getOperationReference());
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
        CallableDescriptor op = resolvedCall2.getResultingDescriptor();
        assert (op instanceof FunctionDescriptor || originalOperation == null) : String.valueOf(op);
        String string2 = operationName = originalOperation == null ? "" : originalOperation.getName().asString();
        if (!operationName.equals("inc") && !operationName.equals("dec")) {
            return this.invokeFunction(resolvedCall2, receiver);
        }
        int increment = operationName.equals("inc") ? 1 : -1;
        Type type2 = this.expressionType(expression2.getBaseExpression());
        StackValue value2 = this.gen(expression2.getBaseExpression());
        return StackValue.preIncrement(type2, value2, increment, resolvedCall2, this);
    }

    @Override
    public StackValue visitPostfixExpression(@NotNull KtPostfixExpression expression2, StackValue receiver) {
        int index2;
        KtExpression operand;
        int increment;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(283);
        }
        if (expression2.getOperationReference().getReferencedNameElementType() == KtTokens.EXCLEXCL) {
            StackValue base2 = this.genQualified(receiver, expression2.getBaseExpression());
            if (AsmUtil.isPrimitive(base2.type)) {
                return base2;
            }
            return StackValue.operation(base2.type, base2.kotlinType, v -> {
                base2.put(base2.type, base2.kotlinType, (InstructionAdapter)v);
                v.dup();
                if (this.state.getUnifiedNullChecks()) {
                    v.invokestatic("kotlin/jvm/internal/Intrinsics", "checkNotNull", "(Ljava/lang/Object;)V", false);
                } else {
                    Label ok = new Label();
                    v.ifnonnull(ok);
                    v.invokestatic("kotlin/jvm/internal/Intrinsics", "throwNpe", "()V", false);
                    v.mark(ok);
                }
                return null;
            });
        }
        DeclarationDescriptor originalOperation = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getOperationReference());
        String originalOperationName = originalOperation != null ? originalOperation.getName().asString() : null;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
        CallableDescriptor op = resolvedCall2.getResultingDescriptor();
        if (!(op instanceof FunctionDescriptor) || originalOperation == null) {
            throw new UnsupportedOperationException("Don't know how to generate this postfix expression: " + originalOperationName + " " + op);
        }
        Type asmResultType = this.expressionType(expression2);
        Type asmBaseType = this.expressionType(expression2.getBaseExpression());
        KotlinType kotlinBaseType = this.kotlinType(expression2.getBaseExpression());
        DeclarationDescriptor cls = op.getContainingDeclaration();
        if (originalOperationName.equals("inc")) {
            increment = 1;
        } else if (originalOperationName.equals("dec")) {
            increment = -1;
        } else {
            throw new UnsupportedOperationException("Unsupported postfix operation: " + originalOperationName + " " + op);
        }
        boolean isPrimitiveNumberClassDescriptor = DescriptorAsmUtil.isPrimitiveNumberClassDescriptor(cls);
        if (isPrimitiveNumberClassDescriptor && AsmUtil.isPrimitive(asmBaseType) && (operand = expression2.getBaseExpression()) instanceof KtReferenceExpression && asmResultType == Type.INT_TYPE && this.bindingContext.get(BindingContext.SMARTCAST, operand) == null && (index2 = this.indexOfLocalNotDelegated((KtReferenceExpression)operand)) >= 0) {
            return StackValue.postIncrement(index2, increment);
        }
        return StackValue.operation(asmBaseType, kotlinBaseType, v -> {
            KotlinType storeKotlinType;
            Type storeType;
            StackValue value2 = StackValue.complexWriteReadReceiver(this.gen(expression2.getBaseExpression()));
            value2.put(asmBaseType, kotlinBaseType, (InstructionAdapter)v);
            AsmUtil.dup(v, asmBaseType);
            StackValue.Local previousValue = StackValue.local(this.myFrameMap.enterTemp(asmBaseType), asmBaseType, kotlinBaseType);
            previousValue.store(StackValue.onStack(asmBaseType, kotlinBaseType), (InstructionAdapter)v);
            if (isPrimitiveNumberClassDescriptor && AsmUtil.isPrimitive(asmBaseType)) {
                DescriptorAsmUtil.genIncrement(asmBaseType, increment, v);
                storeType = asmBaseType;
                storeKotlinType = kotlinBaseType;
            } else {
                StackValue result2 = this.invokeFunction(resolvedCall2, StackValue.onStack(asmBaseType, kotlinBaseType));
                result2.put(result2.type, result2.kotlinType, (InstructionAdapter)v);
                storeType = result2.type;
                storeKotlinType = result2.kotlinType;
            }
            value2.store(StackValue.onStack(storeType, storeKotlinType), (InstructionAdapter)v, true);
            previousValue.put(asmBaseType, kotlinBaseType, (InstructionAdapter)v);
            this.myFrameMap.leaveTemp(asmBaseType);
            return Unit.INSTANCE;
        });
    }

    @Override
    public StackValue visitProperty(@NotNull KtProperty property2, StackValue receiver) {
        if (property2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(284);
        }
        KtExpression initializer2 = property2.getInitializer();
        KtExpression delegateExpression2 = property2.getDelegateExpression();
        if (initializer2 != null) {
            assert (delegateExpression2 == null) : PsiUtilsKt.getElementTextWithContext(property2);
            this.initializeLocalVariable(property2, this.gen(initializer2));
        } else if (delegateExpression2 != null) {
            this.initializeLocalVariable(property2, this.gen(delegateExpression2));
        } else if (property2.hasModifier(KtTokens.LATEINIT_KEYWORD)) {
            this.initializeLocalVariable(property2, null);
        } else {
            this.initializeLocalVariableWithFakeDefaultValue(property2);
        }
        return StackValue.none();
    }

    @Override
    public StackValue visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, StackValue receiver) {
        if (multiDeclaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(285);
        }
        return this.initializeDestructuringDeclaration(multiDeclaration, false);
    }

    public StackValue initializeDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, boolean asProperty) {
        KtExpression initializer2;
        if (multiDeclaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(286);
        }
        if ((initializer2 = multiDeclaration.getInitializer()) == null) {
            return StackValue.none();
        }
        KotlinType initializerType = this.bindingContext.getType(initializer2);
        assert (initializerType != null);
        Type initializerAsmType = this.asmType(initializerType);
        TransientReceiver initializerAsReceiver = new TransientReceiver(initializerType);
        int tempVarIndex = this.myFrameMap.enterTemp(initializerAsmType);
        this.gen(initializer2, initializerAsmType, initializerType);
        this.v.store(tempVarIndex, initializerAsmType);
        StackValue.Local local = StackValue.local(tempVarIndex, initializerAsmType, initializerType);
        this.initializeDestructuringDeclarationVariables(multiDeclaration, initializerAsReceiver, local, asProperty);
        this.myFrameMap.leaveTemp(initializerAsmType);
        return StackValue.none();
    }

    public void initializeDestructuringDeclarationVariables(@NotNull KtDestructuringDeclaration destructuringDeclaration, @NotNull ReceiverValue receiver, @NotNull StackValue receiverStackValue) {
        if (destructuringDeclaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(287);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(288);
        }
        if (receiverStackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(289);
        }
        this.initializeDestructuringDeclarationVariables(destructuringDeclaration, receiver, receiverStackValue, false);
    }

    private void initializeDestructuringDeclarationVariables(@NotNull KtDestructuringDeclaration destructuringDeclaration, @NotNull ReceiverValue receiver, @NotNull StackValue receiverStackValue, boolean asProperty) {
        if (destructuringDeclaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(290);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(291);
        }
        if (receiverStackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(292);
        }
        for (KtDestructuringDeclarationEntry variableDeclaration : destructuringDeclaration.getEntries()) {
            ResolvedCall<FunctionDescriptor> resolvedCall2 = this.bindingContext.get(BindingContext.COMPONENT_RESOLVED_CALL, variableDeclaration);
            assert (resolvedCall2 != null) : "Resolved call is null for " + variableDeclaration.getText();
            Call call2 = this.makeFakeCall(receiver);
            VariableDescriptor variableDescriptor = this.getVariableDescriptorNotNull(variableDeclaration);
            if (UnderscoreUtilKt.isSingleUnderscore(variableDeclaration)) continue;
            if (asProperty && variableDescriptor instanceof PropertyDescriptor) {
                StackValue.Property propertyValue = this.intermediateValueForProperty((PropertyDescriptor)variableDescriptor, true, false, null, true, StackValue.LOCAL_0, null, false);
                propertyValue.store(this.invokeFunction(call2, resolvedCall2, receiverStackValue), this.v);
                continue;
            }
            this.initializeLocalVariable(variableDeclaration, this.invokeFunction(call2, resolvedCall2, receiverStackValue));
        }
    }

    @NotNull
    private StackValue getVariableMetadataValue(@NotNull VariableDescriptorWithAccessors variableDescriptor) {
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(293);
        }
        StackValue value2 = this.findLocalOrCapturedValue(CodegenBinding.getDelegatedLocalVariableMetadata(variableDescriptor, this.bindingContext));
        assert (value2 != null) : "Can't find stack value for local delegated variable metadata: " + variableDescriptor;
        StackValue stackValue = value2;
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(294);
        }
        return stackValue;
    }

    @NotNull
    private StackValue adjustVariableValue(@NotNull StackValue varValue, DeclarationDescriptor descriptor2) {
        if (varValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(295);
        }
        if (!JvmCodegenUtil.isDelegatedLocalVariable(descriptor2)) {
            StackValue stackValue = varValue;
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(296);
            }
            return stackValue;
        }
        VariableDescriptorWithAccessors variableDescriptor = (VariableDescriptorWithAccessors)descriptor2;
        StackValue metadataValue = this.getVariableMetadataValue(variableDescriptor);
        return this.delegatedVariableValue(varValue, metadataValue, variableDescriptor, this.typeMapper);
    }

    private void initializeLocalVariable(@NotNull KtVariableDeclaration variableDeclaration, @Nullable StackValue initializer2) {
        if (variableDeclaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(297);
        }
        LocalVariableDescriptor variableDescriptor = (LocalVariableDescriptor)this.getVariableDescriptorNotNull(variableDeclaration);
        if (KtPsiUtil.isScriptDeclaration(variableDeclaration)) {
            return;
        }
        int index2 = this.lookupLocalIndex(variableDescriptor);
        if (index2 < 0) {
            throw new IllegalStateException("Local variable not found for " + variableDescriptor);
        }
        Type sharedVarType = this.typeMapper.getSharedVarType(variableDescriptor);
        Type varType = this.getVariableTypeNoSharing(variableDescriptor);
        KotlinType delegateKotlinType = JvmCodegenUtil.getPropertyDelegateType(variableDescriptor, this.bindingContext);
        StackValue storeTo = sharedVarType == null ? StackValue.local(index2, varType, variableDescriptor, delegateKotlinType) : StackValue.shared(index2, varType, variableDescriptor, delegateKotlinType);
        storeTo.putReceiver(this.v, false);
        if (variableDescriptor.isLateInit()) {
            assert (initializer2 == null) : "Initializer should be null for lateinit var " + variableDescriptor + ": " + initializer2;
            this.v.aconst(null);
            storeTo.storeSelector(storeTo.type, storeTo.kotlinType, this.v);
            return;
        }
        assert (initializer2 != null) : "Initializer should be not null for " + variableDescriptor;
        initializer2.put(initializer2.type, initializer2.kotlinType, this.v);
        this.markLineNumber(variableDeclaration, false);
        Type resultType = initializer2.type;
        KotlinType resultKotlinType = initializer2.kotlinType;
        if (JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor)) {
            StackValue metadataValue = this.getVariableMetadataValue(variableDescriptor);
            this.initializePropertyMetadata((KtProperty)variableDeclaration, variableDescriptor, metadataValue);
            ResolvedCall<FunctionDescriptor> provideDelegateCall = this.bindingContext.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, variableDescriptor);
            if (provideDelegateCall != null) {
                StackValue provideDelegateValue = this.generateProvideDelegateCallForLocalVariable(initializer2, metadataValue, provideDelegateCall);
                resultType = provideDelegateValue.type;
                resultKotlinType = provideDelegateValue.kotlinType;
            }
        }
        storeTo.storeSelector(resultType, resultKotlinType, this.v);
    }

    private void initializeLocalVariableWithFakeDefaultValue(@NotNull KtProperty variableDeclaration) {
        LocalVariableDescriptor variableDescriptor;
        if (variableDeclaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(298);
        }
        if (BindingContextUtils.isBoxedLocalCapturedInClosure(this.bindingContext, variableDescriptor = (LocalVariableDescriptor)this.getVariableDescriptorNotNull(variableDeclaration))) {
            return;
        }
        assert (!variableDeclaration.hasDelegateExpressionOrInitializer() && !variableDescriptor.isLateInit()) : variableDeclaration.getText() + " in not variable declaration without initializer";
        KotlinType kotlinType = variableDescriptor.getType();
        Type type2 = this.typeMapper.mapType(kotlinType);
        if (type2 == Type.VOID_TYPE) {
            return;
        }
        int index2 = this.lookupLocalIndex(variableDescriptor);
        assert (index2 >= 0) : variableDescriptor + " is not in frame map";
        switch (type2.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.v.iconst(0);
                break;
            }
            case 6: {
                this.v.fconst(0.0f);
                break;
            }
            case 7: {
                this.v.lconst(0L);
                break;
            }
            case 8: {
                this.v.dconst(0.0);
                break;
            }
            default: {
                this.v.aconst(null);
            }
        }
        this.v.store(index2, type2);
    }

    @NotNull
    private StackValue generateProvideDelegateCallForLocalVariable(@NotNull StackValue initializer2, final StackValue metadataValue, ResolvedCall<FunctionDescriptor> provideDelegateResolvedCall) {
        if (initializer2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(299);
        }
        StackValue provideDelegateReceiver = StackValue.onStack(initializer2.type, initializer2.kotlinType);
        List<? extends ValueArgument> arguments2 = provideDelegateResolvedCall.getCall().getValueArguments();
        assert (arguments2.size() == 2) : "Resolved call for '" + OperatorNameConventions.PROVIDE_DELEGATE.asString() + "' should have exactly 2 value parameters";
        this.tempVariables.put(arguments2.get(0).asElement(), StackValue.constant(null, AsmTypes.OBJECT_TYPE));
        this.tempVariables.put(arguments2.get(1).asElement(), new StackValue(AsmTypes.K_PROPERTY_TYPE){

            @Override
            public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
                if (type2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (v == null) {
                    3.$$$reportNull$$$0(1);
                }
                metadataValue.put(type2, kotlinType, v);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "v";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$3";
                objectArray[2] = "putSelector";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        StackValue result2 = this.invokeFunction(provideDelegateResolvedCall, provideDelegateReceiver);
        result2.put(result2.type, result2.kotlinType, this.v);
        this.tempVariables.remove(arguments2.get(0).asElement());
        this.tempVariables.remove(arguments2.get(1).asElement());
        StackValue stackValue = result2;
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(300);
        }
        return stackValue;
    }

    @NotNull
    public VariableDescriptor getVariableDescriptorNotNull(@NotNull KtElement declaration2) {
        if (declaration2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(301);
        }
        VariableDescriptor descriptor2 = this.bindingContext.get(BindingContext.VARIABLE, declaration2);
        assert (descriptor2 != null) : "Couldn't find variable declaration in binding context " + declaration2.getText();
        VariableDescriptor variableDescriptor = descriptor2;
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(302);
        }
        return variableDescriptor;
    }

    private void initializePropertyMetadata(@NotNull KtProperty variable2, @NotNull LocalVariableDescriptor variableDescriptor, @NotNull StackValue metadataVar) {
        if (variable2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(303);
        }
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(304);
        }
        if (metadataVar == null) {
            ExpressionCodegen.$$$reportNull$$$0(305);
        }
        StackValue value2 = PropertyCodegen.isDelegatedPropertyWithOptimizedMetadata(variableDescriptor, this.bindingContext) ? PropertyCodegen.getOptimizedDelegatedPropertyMetadataValue() : (this.context.getFunctionDescriptor().isInline() ? this.generatePropertyReference(variable2.getDelegate(), variableDescriptor, variableDescriptor, null) : PropertyCodegen.getDelegatedPropertyMetadata(variableDescriptor, this.bindingContext));
        value2.put(AsmTypes.K_PROPERTY_TYPE, null, this.v);
        metadataVar.storeSelector(AsmTypes.K_PROPERTY_TYPE, null, this.v);
    }

    @NotNull
    private StackValue generateNewCall(@NotNull KtCallExpression expression2, @NotNull ResolvedCall<?> resolvedCall2) {
        Type type2;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(306);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(307);
        }
        if ((type2 = this.expressionType(expression2)).getSort() == 9) {
            KotlinType kotlinType = this.kotlinType(expression2);
            assert (kotlinType != null) : "No kotlinType for expression of type " + type2 + ": " + expression2.getText();
            if (KotlinBuiltIns.isArrayOrPrimitiveArray(kotlinType)) {
                StackValue stackValue = this.generateNewArray(expression2, this.bindingContext.getType(expression2), resolvedCall2);
                if (stackValue == null) {
                    ExpressionCodegen.$$$reportNull$$$0(308);
                }
                return stackValue;
            }
        }
        StackValue stackValue = this.generateConstructorCall(resolvedCall2, type2);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(309);
        }
        return stackValue;
    }

    @NotNull
    public ClassConstructorDescriptor getConstructorDescriptor(@NotNull ResolvedCall<?> resolvedCall2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(310);
        }
        FunctionDescriptor accessibleDescriptor = this.accessibleFunctionDescriptor(resolvedCall2);
        assert (accessibleDescriptor instanceof ClassConstructorDescriptor) : "getConstructorDescriptor must be called only for constructors: " + accessibleDescriptor;
        ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)accessibleDescriptor;
        if (classConstructorDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(311);
        }
        return classConstructorDescriptor;
    }

    @Nullable
    private static ReceiverValue getConstructorReceiver(@NotNull ResolvedCall<?> resolvedCall2) {
        Object constructor2;
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(312);
        }
        if ((constructor2 = resolvedCall2.getResultingDescriptor()).getExtensionReceiverParameter() != null) {
            assert (constructor2 instanceof TypeAliasConstructorDescriptor) : "Only type alias constructor can have an extension receiver: " + constructor2;
            return resolvedCall2.getExtensionReceiver();
        }
        if (constructor2.getDispatchReceiverParameter() != null) {
            return resolvedCall2.getDispatchReceiver();
        }
        return null;
    }

    @NotNull
    public StackValue generateConstructorCall(@NotNull ResolvedCall<?> resolvedCall2, @NotNull Type objectType) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(313);
        }
        if (objectType == null) {
            ExpressionCodegen.$$$reportNull$$$0(314);
        }
        StackValue stackValue = StackValue.functionCall(objectType, resolvedCall2.getResultingDescriptor().getReturnType(), v -> {
            ClassConstructorDescriptor constructor2 = this.getConstructorDescriptor(resolvedCall2);
            ReceiverParameterDescriptor dispatchReceiver = constructor2.getDispatchReceiverParameter();
            ClassDescriptor containingDeclaration = constructor2.getContainingDeclaration();
            if (!InlineClassesUtilsKt.isInlineClass(containingDeclaration)) {
                v.anew(objectType);
                v.dup();
            }
            if (dispatchReceiver != null) {
                KotlinType kotlinType = dispatchReceiver.getType();
                Type receiverType = this.typeMapper.mapType(kotlinType);
                ReceiverValue receiver = ExpressionCodegen.getConstructorReceiver(resolvedCall2);
                boolean callSuper = containingDeclaration.isInner() && receiver instanceof ImplicitClassReceiver;
                this.generateReceiverValue(receiver, callSuper).put(receiverType, kotlinType, (InstructionAdapter)v);
            }
            this.pushClosureOnStack(containingDeclaration, dispatchReceiver == null, this.defaultCallGenerator, null);
            constructor2 = SamCodegenUtil.resolveSamAdapter(constructor2);
            OwnerKind inlineClassKindOrNull = InlineClassesUtilsKt.isInlineClass(constructor2.getContainingDeclaration()) ? OwnerKind.ERASED_INLINE_CLASS : null;
            CallableMethod method = this.typeMapper.mapToCallableMethod(constructor2, false, inlineClassKindOrNull);
            this.invokeMethodWithArguments(method, resolvedCall2, StackValue.none());
            return Unit.INSTANCE;
        });
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(315);
        }
        return stackValue;
    }

    public StackValue generateNewArray(@NotNull KtCallExpression expression2, @NotNull KotlinType arrayType, @NotNull ResolvedCall<?> resolvedCall2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(316);
        }
        if (arrayType == null) {
            ExpressionCodegen.$$$reportNull$$$0(317);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(318);
        }
        List<KtValueArgument> args2 = expression2.getValueArguments();
        assert (args2.size() == 1 || args2.size() == 2) : "Unknown constructor called: " + args2.size() + " arguments";
        if (args2.size() == 1) {
            KtExpression sizeExpression = args2.get(0).getArgumentExpression();
            return StackValue.operation(this.typeMapper.mapType(arrayType), v -> {
                this.gen(sizeExpression, Type.INT_TYPE);
                this.newArrayInstruction(arrayType);
                return Unit.INSTANCE;
            });
        }
        return this.invokeFunction(resolvedCall2, StackValue.none());
    }

    public void newArrayInstruction(@NotNull KotlinType arrayType) {
        if (arrayType == null) {
            ExpressionCodegen.$$$reportNull$$$0(319);
        }
        if (KotlinBuiltIns.isArray(arrayType)) {
            KotlinType elementJetType = arrayType.getArguments().get(0).getType();
            BaseExpressionCodegenKt.putReifiedOperationMarkerIfTypeIsReifiedParameter(this, elementJetType, ReifiedTypeInliner.OperationKind.NEW_ARRAY);
            this.v.newarray(AsmUtil.boxType(this.typeMapper.mapTypeAsDeclaration(elementJetType)));
        } else {
            Type type2 = this.typeMapper.mapType(arrayType);
            this.v.newarray(AsmUtil.correctElementType(type2));
        }
    }

    @Override
    public StackValue visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2, StackValue receiver) {
        ResolvedCall<FunctionDescriptor> resolvedCall2;
        boolean isInlineClassType;
        KtExpression array2;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(320);
        }
        KotlinType arrayKotlinType = (array2 = expression2.getArrayExpression()) != null ? this.bindingContext.getType(array2) : null;
        Type arrayType = this.expressionType(array2);
        List<KtExpression> indices = expression2.getIndexExpressions();
        FunctionDescriptor operationDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        assert (operationDescriptor != null);
        boolean bl = isInlineClassType = arrayKotlinType != null && InlineClassesUtilsKt.isInlineClassType(arrayKotlinType);
        if (arrayType.getSort() == 9 && indices.size() == 1 && KotlinBuiltIns.isInt(operationDescriptor.getValueParameters().get(0).getType()) && !isInlineClassType) {
            assert (arrayKotlinType != null);
            KotlinType elementKotlinType = this.state.getModule().getBuiltIns().getArrayElementType(arrayKotlinType);
            Type elementType = KotlinBuiltIns.isArray(arrayKotlinType) ? DescriptorAsmUtil.boxType(this.asmType(elementKotlinType), elementKotlinType, this.typeMapper) : AsmUtil.correctElementType(arrayType);
            StackValue arrayValue = this.genLazy(array2, arrayType);
            StackValue index2 = this.genLazy(indices.get(0), Type.INT_TYPE);
            return StackValue.arrayElement(elementType, elementKotlinType, arrayValue, index2);
        }
        ResolvedCall<FunctionDescriptor> resolvedSetCall = this.bindingContext.get(BindingContext.INDEXED_LVALUE_SET, expression2);
        ResolvedCall<FunctionDescriptor> resolvedGetCall = this.bindingContext.get(BindingContext.INDEXED_LVALUE_GET, expression2);
        boolean isGetter = OperatorNameConventions.GET.equals(operationDescriptor.getName());
        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2 = isGetter ? resolvedGetCall : resolvedSetCall;
        assert (resolvedCall2 != null) : "No resolved call for " + operationDescriptor;
        Callable callable = this.resolveToCallable(this.accessibleFunctionDescriptor(resolvedCall2), false, resolvedCall2);
        CallableMethod callableMethod = this.typeMapper.mapToCallableMethod(SamCodegenUtil.resolveSamAdapter(operationDescriptor), false);
        Type[] argumentTypes2 = callableMethod.getParameterTypes();
        StackValue.CollectionElementReceiver collectionElementReceiver = this.createCollectionElementReceiver(expression2, receiver, operationDescriptor, isGetter, resolvedGetCall, resolvedSetCall, callable);
        Type elementType = isGetter ? callableMethod.getReturnType() : ArrayUtil.getLastElement(argumentTypes2);
        KotlinType elementKotlinType = isGetter ? operationDescriptor.getOriginal().getReturnType() : CollectionsKt.last(operationDescriptor.getOriginal().getValueParameters()).getType();
        return StackValue.collectionElement(collectionElementReceiver, elementType, elementKotlinType, resolvedGetCall, resolvedSetCall, this);
    }

    @NotNull
    private StackValue.CollectionElementReceiver createCollectionElementReceiver(@NotNull KtArrayAccessExpression expression2, @NotNull StackValue receiver, @NotNull FunctionDescriptor operationDescriptor, boolean isGetter, ResolvedCall<FunctionDescriptor> resolvedGetCall, ResolvedCall<FunctionDescriptor> resolvedSetCall, @NotNull Callable callable) {
        ResolvedCall<FunctionDescriptor> resolvedCall2;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(321);
        }
        if (receiver == null) {
            ExpressionCodegen.$$$reportNull$$$0(322);
        }
        if (operationDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(323);
        }
        if (callable == null) {
            ExpressionCodegen.$$$reportNull$$$0(324);
        }
        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2 = isGetter ? resolvedGetCall : resolvedSetCall;
        assert (resolvedCall2 != null) : "couldn't find resolved call: " + expression2.getText();
        List<ResolvedValueArgument> valueArguments = resolvedCall2.getValueArgumentsByIndex();
        assert (valueArguments != null) : "Failed to arrange value arguments by index: " + operationDescriptor;
        if (!isGetter) {
            assert (valueArguments.size() >= 2) : "Setter call should have at least 2 arguments: " + operationDescriptor;
            valueArguments.remove(valueArguments.size() - 1);
        }
        return new StackValue.CollectionElementReceiver(callable, receiver, resolvedGetCall, resolvedSetCall, isGetter, this, valueArguments);
    }

    @Override
    public StackValue visitThrowExpression(@NotNull KtThrowExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(325);
        }
        return StackValue.operation(Type.VOID_TYPE, this.getNothingType(), adapter -> {
            this.gen(expression2.getThrownExpression(), AsmTypes.JAVA_THROWABLE_TYPE);
            this.v.athrow();
            return Unit.INSTANCE;
        });
    }

    @Override
    public StackValue visitThisExpression(@NotNull KtThisExpression expression2, StackValue receiver) {
        DeclarationDescriptor descriptor2;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(326);
        }
        if ((descriptor2 = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference())) instanceof ClassDescriptor) {
            return this.generateInstanceReceiver((ClassDescriptor)descriptor2, false, true);
        }
        if (descriptor2 instanceof CallableDescriptor) {
            return this.generateExtensionReceiver((CallableDescriptor)descriptor2);
        }
        throw new UnsupportedOperationException("Neither this nor receiver: " + descriptor2 + expression2.getParent().getContainingFile().getText());
    }

    @Override
    public StackValue visitTryExpression(@NotNull KtTryExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(327);
        }
        return this.generateTryExpression(expression2, false);
    }

    public StackValue generateTryExpression(KtTryExpression expression2, boolean isStatement) {
        Type expectedAsmType = isStatement ? Type.VOID_TYPE : this.expressionType(expression2);
        KotlinType expectedKotlinType = isStatement ? null : this.kotlinType(expression2);
        return StackValue.operation(expectedAsmType, expectedKotlinType, v -> {
            TryBlockStackElement element;
            KtFinallySection finallyBlock = expression2.getFinallyBlock();
            TryWithFinallyBlockStackElement tryWithFinallyBlockStackElement = null;
            if (finallyBlock != null) {
                tryWithFinallyBlockStackElement = new TryWithFinallyBlockStackElement(expression2);
                element = tryWithFinallyBlockStackElement;
                this.blockStackElements.push(tryWithFinallyBlockStackElement);
            } else {
                element = new TryBlockStackElement();
                this.blockStackElements.push(element);
            }
            Label tryStart = new Label();
            v.mark(tryStart);
            v.nop();
            this.gen(expression2.getTryBlock(), expectedAsmType, expectedKotlinType);
            int savedValue = -1;
            if (!isStatement) {
                savedValue = this.myFrameMap.enterTemp(expectedAsmType);
                v.store(savedValue, expectedAsmType);
            }
            Label tryEnd = new Label();
            v.mark(tryEnd);
            List<Label> tryBlockRegions = ExpressionCodegen.getCurrentCatchIntervals(element, tryStart, tryEnd);
            Label end = new Label();
            this.genFinallyBlockOrGoto(tryWithFinallyBlockStackElement, end, null, new ArrayList<TryBlockStackElement>());
            List<KtCatchClause> clauses = expression2.getCatchClauses();
            int size = clauses.size();
            for (int i = 0; i < size; ++i) {
                KtCatchClause clause = clauses.get(i);
                Label clauseStart = new Label();
                v.mark(clauseStart);
                KtExpression catchBody2 = clause.getCatchBody();
                if (catchBody2 != null) {
                    this.markLineNumber(catchBody2, false);
                }
                VariableDescriptor descriptor2 = this.bindingContext.get(BindingContext.VALUE_PARAMETER, clause.getCatchParameter());
                assert (descriptor2 != null);
                Type descriptorType = this.asmType(descriptor2.getType());
                this.myFrameMap.enter(descriptor2, descriptorType);
                int index2 = this.lookupLocalIndex(descriptor2);
                v.store(index2, descriptorType);
                Label catchVariableStart = new Label();
                v.mark(catchVariableStart);
                this.gen(catchBody2, expectedAsmType, expectedKotlinType);
                if (!isStatement) {
                    v.store(savedValue, expectedAsmType);
                }
                this.myFrameMap.leave(descriptor2);
                Label clauseEnd = new Label();
                v.mark(clauseEnd);
                v.visitLocalVariable(descriptor2.getName().asString(), descriptorType.getDescriptor(), null, catchVariableStart, clauseEnd, index2);
                this.genFinallyBlockOrGoto(tryWithFinallyBlockStackElement, i != size - 1 || finallyBlock != null ? end : null, null, new ArrayList<TryBlockStackElement>());
                this.generateExceptionTable(clauseStart, tryBlockRegions, descriptorType.getInternalName());
            }
            if (finallyBlock != null) {
                Label defaultCatchStart = new Label();
                v.mark(defaultCatchStart);
                int savedException = this.myFrameMap.enterTemp(AsmTypes.JAVA_THROWABLE_TYPE);
                v.store(savedException, AsmTypes.JAVA_THROWABLE_TYPE);
                Label defaultCatchEnd = new Label();
                v.mark(defaultCatchEnd);
                List<Label> defaultCatchRegions = ExpressionCodegen.getCurrentCatchIntervals(tryWithFinallyBlockStackElement, tryStart, defaultCatchEnd);
                this.genFinallyBlockOrGoto(tryWithFinallyBlockStackElement, null, null, new ArrayList<TryBlockStackElement>());
                v.load(savedException, AsmTypes.JAVA_THROWABLE_TYPE);
                this.myFrameMap.leaveTemp(AsmTypes.JAVA_THROWABLE_TYPE);
                v.athrow();
                this.generateExceptionTable(defaultCatchStart, defaultCatchRegions, null);
            }
            this.markLineNumber(expression2, isStatement);
            v.mark(end);
            if (!isStatement) {
                v.load(savedValue, expectedAsmType);
                this.myFrameMap.leaveTemp(expectedAsmType);
            }
            this.blockStackElements.pop();
            return Unit.INSTANCE;
        });
    }

    private void generateExceptionTable(@NotNull Label catchStart, @NotNull List<Label> catchedRegions, @Nullable String exception) {
        if (catchStart == null) {
            ExpressionCodegen.$$$reportNull$$$0(328);
        }
        if (catchedRegions == null) {
            ExpressionCodegen.$$$reportNull$$$0(329);
        }
        for (int i = 0; i < catchedRegions.size(); i += 2) {
            Label startRegion = catchedRegions.get(i);
            Label endRegion = catchedRegions.get(i + 1);
            if (startRegion.info == null || endRegion.info == null || catchStart.info == null) {
                throw new IllegalStateException("All labels should have nodes added to instruction list");
            }
            this.v.visitTryCatchBlock(startRegion, endRegion, catchStart, exception);
        }
    }

    @NotNull
    private static List<Label> getCurrentCatchIntervals(@Nullable TryBlockStackElement finallyBlockStackElement, @NotNull Label blockStart, @NotNull Label blockEnd) {
        ArrayList<Label> gapsInBlock;
        if (blockStart == null) {
            ExpressionCodegen.$$$reportNull$$$0(330);
        }
        if (blockEnd == null) {
            ExpressionCodegen.$$$reportNull$$$0(331);
        }
        ArrayList<Label> arrayList = gapsInBlock = finallyBlockStackElement != null ? new ArrayList<Label>(finallyBlockStackElement.gaps) : Collections.emptyList();
        assert (gapsInBlock.size() % 2 == 0);
        ArrayList<Label> blockRegions = new ArrayList<Label>(gapsInBlock.size() + 2);
        blockRegions.add(blockStart);
        blockRegions.addAll(gapsInBlock);
        blockRegions.add(blockEnd);
        ArrayList<Label> arrayList2 = blockRegions;
        if (arrayList2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(332);
        }
        return arrayList2;
    }

    @Override
    public StackValue visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(333);
        }
        KtExpression left = expression2.getLeft();
        IElementType opToken = expression2.getOperationReference().getReferencedNameElementType();
        KotlinType rightKotlinType = this.bindingContext.get(BindingContext.TYPE, expression2.getRight());
        assert (rightKotlinType != null);
        StackValue value2 = this.genQualified(receiver, left);
        KotlinType leftKotlinType = value2.kotlinType;
        Type boxedLeftType = leftKotlinType != null && InlineClassesUtilsKt.isInlineClassType(leftKotlinType) ? this.typeMapper.mapTypeAsDeclaration(leftKotlinType) : AsmUtil.boxType(value2.type);
        Type boxedRightType = AsmUtil.boxType(this.typeMapper.mapTypeAsDeclaration(rightKotlinType));
        return StackValue.operation(boxedRightType, rightKotlinType, v -> {
            boolean safeAs;
            value2.put(boxedLeftType, value2.kotlinType, (InstructionAdapter)v);
            if (value2.type == Type.VOID_TYPE) {
                StackValue.putUnitInstance(v);
            }
            boolean bl = safeAs = opToken == KtTokens.AS_SAFE;
            if (TypeUtils.isReifiedTypeParameter(rightKotlinType)) {
                BaseExpressionCodegenKt.putReifiedOperationMarkerIfTypeIsReifiedParameter(this, rightKotlinType, safeAs ? ReifiedTypeInliner.OperationKind.SAFE_AS : ReifiedTypeInliner.OperationKind.AS);
                v.checkcast(boxedRightType);
                return Unit.INSTANCE;
            }
            CodegenUtilKt.generateAsCast(v, rightKotlinType, boxedRightType, safeAs, this.state.getUnifiedNullChecks());
            return Unit.INSTANCE;
        });
    }

    @Override
    public StackValue visitIsExpression(@NotNull KtIsExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(334);
        }
        StackValue match2 = StackValue.expression(AsmTypes.OBJECT_TYPE, expression2.getLeftHandSide(), this);
        return this.generateIsCheck(match2, expression2.getTypeReference(), expression2.isNegated());
    }

    private StackValue generateExpressionMatch(StackValue expressionToMatch, KtExpression subjectExpression, KotlinType subjectKotlinType, KtExpression patternExpression) {
        if (expressionToMatch != null) {
            return this.generateEquals(subjectExpression, patternExpression, KtTokens.EQEQ, expressionToMatch, subjectKotlinType, this.bindingContext.get(BindingContext.PRIMITIVE_NUMERIC_COMPARISON_INFO, patternExpression));
        }
        return this.gen(patternExpression);
    }

    private StackValue generateIsCheck(StackValue expressionToMatch, KtTypeReference typeReference, boolean negated) {
        KotlinType kotlinType = this.bindingContext.get(BindingContext.TYPE, typeReference);
        this.markStartLineNumber(typeReference);
        StackValue value2 = this.generateIsCheck(expressionToMatch, kotlinType, false);
        return negated ? StackValue.not(value2) : value2;
    }

    private StackValue generateIsCheck(StackValue expressionToGen, KotlinType rhsKotlinType, boolean leaveExpressionOnStack) {
        KotlinType lhsKotlinType = expressionToGen.kotlinType;
        Type lhsBoxedType = lhsKotlinType != null && InlineClassesUtilsKt.isInlineClassType(lhsKotlinType) ? this.typeMapper.mapTypeAsDeclaration(lhsKotlinType) : AsmTypes.OBJECT_TYPE;
        return StackValue.operation(Type.BOOLEAN_TYPE, v -> {
            expressionToGen.put(lhsBoxedType, expressionToGen.kotlinType, (InstructionAdapter)v);
            if (leaveExpressionOnStack) {
                v.dup();
            }
            Type type2 = AsmUtil.boxType(this.typeMapper.mapTypeAsDeclaration(rhsKotlinType));
            if (TypeUtils.isReifiedTypeParameter(rhsKotlinType)) {
                BaseExpressionCodegenKt.putReifiedOperationMarkerIfTypeIsReifiedParameter(this, rhsKotlinType, ReifiedTypeInliner.OperationKind.IS);
                v.instanceOf(type2);
                return null;
            }
            CodegenUtilKt.generateIsCheck(v, rhsKotlinType, type2);
            return null;
        });
    }

    @Override
    public void propagateChildReifiedTypeParametersUsages(@NotNull ReifiedTypeParametersUsages usages) {
        if (usages == null) {
            ExpressionCodegen.$$$reportNull$$$0(335);
        }
        this.parentCodegen.getReifiedTypeParametersUsages().propagateChildUsagesWithinContext(usages, () -> ((CallableMemberDescriptor)this.context.getContextDescriptor()).getTypeParameters().stream().filter(TypeParameterDescriptor::isReified).map(it -> it.getName().asString()).collect(Collectors.toSet()));
    }

    @Override
    public StackValue visitWhenExpression(@NotNull KtWhenExpression expression2, StackValue receiver) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(336);
        }
        return this.generateWhenExpression(expression2, false);
    }

    public StackValue generateWhenExpression(KtWhenExpression expression2, boolean isStatement) {
        Type resultType = isStatement ? Type.VOID_TYPE : this.expressionType(expression2);
        KotlinType resultKotlinType = isStatement ? null : this.kotlinType(expression2);
        return StackValue.operation(resultType, resultKotlinType, v -> {
            int subjectLocal;
            Type subjectType;
            KotlinType subjectKotlinType;
            SwitchCodegen switchCodegen;
            KtProperty subjectVariable = expression2.getSubjectVariable();
            KtExpression subjectExpression = expression2.getSubjectExpression();
            if (subjectVariable == null && subjectExpression == null) {
                v.nop();
            }
            if ((switchCodegen = this.switchCodegenProvider.buildAppropriateSwitchCodegenIfPossible(expression2, isStatement, CodegenUtil.isExhaustive(this.bindingContext, expression2, isStatement))) != null) {
                switchCodegen.generate();
                return null;
            }
            VariableDescriptor subjectVariableDescriptor = null;
            if (subjectVariable != null) {
                subjectVariableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, subjectVariable);
                assert (subjectVariableDescriptor != null) : "Unresolved subject variable: " + subjectVariable.getName();
                subjectKotlinType = subjectVariableDescriptor.getType();
                subjectType = this.asmType(subjectVariableDescriptor.getType());
                subjectLocal = this.myFrameMap.enter(subjectVariableDescriptor, subjectType);
                this.visitProperty(subjectVariable, null);
                this.tempVariables.put(subjectExpression, StackValue.local(subjectLocal, subjectType, subjectKotlinType));
            } else if (subjectExpression != null) {
                subjectKotlinType = this.kotlinType(subjectExpression);
                subjectType = this.expressionType(subjectExpression);
                subjectLocal = this.myFrameMap.enterTemp(subjectType);
                this.gen(subjectExpression, subjectType, subjectKotlinType);
                this.tempVariables.put(subjectExpression, StackValue.local(subjectLocal, subjectType, subjectKotlinType));
                v.store(subjectLocal, subjectType);
            } else {
                subjectLocal = -1;
                subjectType = Type.VOID_TYPE;
                subjectKotlinType = null;
            }
            Label begin = new Label();
            v.mark(begin);
            Label end = new Label();
            boolean hasElse = KtPsiUtil.checkWhenExpressionHasSingleElse(expression2);
            Label nextCondition = null;
            for (KtWhenEntry whenEntry : expression2.getEntries()) {
                if (nextCondition != null) {
                    v.mark(nextCondition);
                }
                nextCondition = new Label();
                FrameMapBase.Mark mark = this.myFrameMap.mark();
                Label thisEntry = new Label();
                if (!whenEntry.isElse()) {
                    KtWhenCondition[] conditions2 = whenEntry.getConditions();
                    for (int i = 0; i < conditions2.length; ++i) {
                        StackValue conditionValue = this.generateWhenCondition(subjectExpression, subjectType, subjectKotlinType, subjectLocal, conditions2[i]);
                        BranchedValue.Companion.condJump(conditionValue, nextCondition, true, (InstructionAdapter)v);
                        if (i >= conditions2.length - 1) continue;
                        v.goTo(thisEntry);
                        v.mark(nextCondition);
                        nextCondition = new Label();
                    }
                }
                v.visitLabel(thisEntry);
                this.gen(whenEntry.getExpression(), resultType, resultKotlinType);
                mark.dropTo();
                if (whenEntry.isElse()) continue;
                v.goTo(end);
            }
            if (!hasElse && nextCondition != null) {
                v.mark(nextCondition);
                this.putUnitInstanceOntoStackForNonExhaustiveWhen(expression2, isStatement);
            }
            this.markLineNumber(expression2, isStatement);
            v.mark(end);
            if (subjectVariableDescriptor != null) {
                this.myFrameMap.leave(subjectVariableDescriptor);
                v.visitLocalVariable(subjectVariableDescriptor.getName().asString(), subjectType.getDescriptor(), null, begin, end, subjectLocal);
            } else {
                this.myFrameMap.leaveTemp(subjectType);
            }
            this.tempVariables.remove(subjectExpression);
            return null;
        });
    }

    public void putUnitInstanceOntoStackForNonExhaustiveWhen(@NotNull KtWhenExpression whenExpression, boolean isStatement) {
        if (whenExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(337);
        }
        if (CodegenUtil.isExhaustive(this.bindingContext, whenExpression, isStatement)) {
            AsmUtil.genThrow(this.v, "kotlin/NoWhenBranchMatchedException", null);
        } else if (!isStatement) {
            StackValue.putUnitInstance(this.v);
        }
    }

    private StackValue generateWhenCondition(KtExpression subjectExpression, Type subjectType, KotlinType subjectKotlinType, int subjectLocal, KtWhenCondition condition) {
        StackValue.Local match2;
        if (condition instanceof KtWhenConditionInRange) {
            KtWhenConditionInRange conditionInRange = (KtWhenConditionInRange)condition;
            return this.generateIn(StackValue.local(subjectLocal, subjectType, subjectKotlinType), conditionInRange.getRangeExpression(), conditionInRange.getOperationReference());
        }
        StackValue.Local local = match2 = subjectLocal == -1 ? null : StackValue.local(subjectLocal, subjectType, subjectKotlinType);
        if (condition instanceof KtWhenConditionIsPattern) {
            KtWhenConditionIsPattern patternCondition = (KtWhenConditionIsPattern)condition;
            return this.generateIsCheck((StackValue)match2, patternCondition.getTypeReference(), patternCondition.isNegated());
        }
        if (condition instanceof KtWhenConditionWithExpression) {
            KtExpression patternExpression = ((KtWhenConditionWithExpression)condition).getExpression();
            return this.generateExpressionMatch(match2, subjectExpression, subjectKotlinType, patternExpression);
        }
        throw new UnsupportedOperationException("unsupported kind of when condition");
    }

    public Call makeFakeCall(ReceiverValue initializerAsReceiver) {
        KtSimpleNameExpression fake = KtPsiFactoryKt.KtPsiFactory(this.state.getProject(), false).createSimpleName("fake");
        return CallMaker.makeCall(fake, initializerAsReceiver);
    }

    public String toString() {
        return ((CallableMemberDescriptor)this.context.getContextDescriptor()).toString();
    }

    @NotNull
    public FrameMap getFrameMap() {
        FrameMap frameMap = this.myFrameMap;
        if (frameMap == null) {
            ExpressionCodegen.$$$reportNull$$$0(338);
        }
        return frameMap;
    }

    @NotNull
    public MethodContext getContext() {
        MethodContext methodContext2 = this.context;
        if (methodContext2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(339);
        }
        return methodContext2;
    }

    @Override
    @NotNull
    public NameGenerator getInlineNameGenerator() {
        NameGenerator nameGenerator2 = this.getParentCodegen().getInlineNameGenerator();
        Name name2 = ((CallableMemberDescriptor)this.context.getContextDescriptor()).getName();
        String inlinedName = name2.isSpecial() ? "$special" : name2.asString();
        NameGenerator nameGenerator3 = nameGenerator2.subGenerator(inlinedName + "$$inlined");
        if (nameGenerator3 == null) {
            ExpressionCodegen.$$$reportNull$$$0(340);
        }
        return nameGenerator3;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Stack<BlockStackElement> getBlockStackElements() {
        return new Stack<BlockStackElement>((Collection<BlockStackElement>)this.blockStackElements);
    }

    public void addBlockStackElementsForNonLocalReturns(@NotNull Stack<BlockStackElement> elements, int finallyDepth) {
        if (elements == null) {
            ExpressionCodegen.$$$reportNull$$$0(341);
        }
        this.blockStackElements.addAll(elements);
        this.finallyDepth = finallyDepth;
    }

    @NotNull
    private StackValue.Delegate delegatedVariableValue(@NotNull StackValue delegateValue2, @NotNull StackValue metadataValue, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KotlinTypeMapper typeMapper2) {
        if (delegateValue2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(342);
        }
        if (metadataValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(343);
        }
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(344);
        }
        if (typeMapper2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(345);
        }
        StackValue.Delegate delegate2 = StackValue.localDelegate(typeMapper2.mapType(variableDescriptor.getType()), delegateValue2, metadataValue, variableDescriptor, this);
        if (delegate2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(346);
        }
        return delegate2;
    }

    @Override
    @NotNull
    public InstructionAdapter getVisitor() {
        InstructionAdapter instructionAdapter = this.v;
        if (instructionAdapter == null) {
            ExpressionCodegen.$$$reportNull$$$0(347);
        }
        return instructionAdapter;
    }

    @Override
    @NotNull
    public TypeSystemCommonBackendContext getTypeSystem() {
        TypeSystemCommonBackendContext typeSystemCommonBackendContext = this.typeSystem;
        if (typeSystemCommonBackendContext == null) {
            ExpressionCodegen.$$$reportNull$$$0(348);
        }
        return typeSystemCommonBackendContext;
    }

    @Override
    public void consumeReifiedOperationMarker(@NotNull TypeParameterMarker typeParameter) {
        if (typeParameter == null) {
            ExpressionCodegen.$$$reportNull$$$0(349);
        }
        assert (typeParameter instanceof TypeParameterDescriptor) : "Type parameter should be a descriptor: " + typeParameter;
        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)typeParameter;
        if (typeParameterDescriptor.getContainingDeclaration() != this.context.getContextDescriptor()) {
            this.parentCodegen.getReifiedTypeParametersUsages().addUsedReifiedParameter(typeParameterDescriptor.getName().asString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 44: 
            case 51: 
            case 52: 
            case 64: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 90: 
            case 91: 
            case 131: 
            case 138: 
            case 144: 
            case 145: 
            case 149: 
            case 153: 
            case 154: 
            case 155: 
            case 163: 
            case 164: 
            case 177: 
            case 178: 
            case 184: 
            case 185: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 197: 
            case 198: 
            case 200: 
            case 201: 
            case 203: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 212: 
            case 215: 
            case 216: 
            case 217: 
            case 224: 
            case 226: 
            case 249: 
            case 265: 
            case 266: 
            case 294: 
            case 296: 
            case 300: 
            case 302: 
            case 308: 
            case 309: 
            case 311: 
            case 315: 
            case 332: 
            case 338: 
            case 339: 
            case 340: 
            case 346: 
            case 347: 
            case 348: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 44: 
            case 51: 
            case 52: 
            case 64: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 90: 
            case 91: 
            case 131: 
            case 138: 
            case 144: 
            case 145: 
            case 149: 
            case 153: 
            case 154: 
            case 155: 
            case 163: 
            case 164: 
            case 177: 
            case 178: 
            case 184: 
            case 185: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 197: 
            case 198: 
            case 200: 
            case 201: 
            case 203: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 212: 
            case 215: 
            case 216: 
            case 217: 
            case 224: 
            case 226: 
            case 249: 
            case 265: 
            case 266: 
            case 294: 
            case 296: 
            case 300: 
            case 302: 
            case 308: 
            case 309: 
            case 311: 
            case 315: 
            case 332: 
            case 338: 
            case 339: 
            case 340: 
            case 346: 
            case 347: 
            case 348: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mv";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameMap";
                break;
            }
            case 2: 
            case 110: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 3: 
            case 25: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentCodegen";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 44: 
            case 51: 
            case 52: 
            case 64: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 90: 
            case 91: 
            case 131: 
            case 138: 
            case 144: 
            case 145: 
            case 149: 
            case 153: 
            case 154: 
            case 155: 
            case 163: 
            case 164: 
            case 177: 
            case 178: 
            case 184: 
            case 185: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 197: 
            case 198: 
            case 200: 
            case 201: 
            case 203: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 212: 
            case 215: 
            case 216: 
            case 217: 
            case 224: 
            case 226: 
            case 249: 
            case 265: 
            case 266: 
            case 294: 
            case 296: 
            case 300: 
            case 302: 
            case 308: 
            case 309: 
            case 311: 
            case 315: 
            case 332: 
            case 338: 
            case 339: 
            case 340: 
            case 346: 
            case 347: 
            case 348: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/ExpressionCodegen";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 12: 
            case 71: 
            case 112: 
            case 123: 
            case 126: 
            case 127: 
            case 128: 
            case 176: 
            case 179: 
            case 182: 
            case 187: 
            case 196: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provided";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "required";
                break;
            }
            case 18: 
            case 28: 
            case 30: 
            case 183: 
            case 236: 
            case 238: 
            case 240: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAlias";
                break;
            }
            case 22: 
            case 70: 
            case 301: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 23: 
            case 24: 
            case 26: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 46: 
            case 47: 
            case 48: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 66: 
            case 69: 
            case 75: 
            case 82: 
            case 109: 
            case 113: 
            case 119: 
            case 121: 
            case 139: 
            case 140: 
            case 218: 
            case 219: 
            case 227: 
            case 228: 
            case 230: 
            case 232: 
            case 233: 
            case 275: 
            case 276: 
            case 280: 
            case 281: 
            case 283: 
            case 306: 
            case 316: 
            case 320: 
            case 321: 
            case 325: 
            case 326: 
            case 327: 
            case 333: 
            case 334: 
            case 336: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forExpression";
                break;
            }
            case 43: 
            case 45: 
            case 86: 
            case 143: 
            case 146: 
            case 147: 
            case 151: 
            case 156: 
            case 159: 
            case 162: 
            case 166: 
            case 169: 
            case 174: 
            case 180: 
            case 181: 
            case 186: 
            case 220: 
            case 277: 
            case 307: 
            case 310: 
            case 312: 
            case 313: 
            case 318: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterBreakContinueLabel";
                break;
            }
            case 50: 
            case 104: 
            case 105: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestedTryBlocksWithoutFinally";
                break;
            }
            case 57: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closureCodegen";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 77: 
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callGenerator";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendFunction";
                break;
            }
            case 88: 
            case 89: 
            case 222: 
            case 293: 
            case 304: 
            case 344: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDescriptor";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 97: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 95: 
            case 331: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockEnd";
                break;
            }
            case 96: 
            case 98: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaveTasks";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFunction";
                break;
            }
            case 101: 
            case 221: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 103: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterReturnLabel";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 114: 
            case 235: 
            case 237: 
            case 239: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 115: 
            case 116: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyExpression";
                break;
            }
            case 120: 
            case 122: 
            case 124: 
            case 130: 
            case 135: 
            case 137: 
            case 148: 
            case 152: 
            case 167: 
            case 170: 
            case 175: 
            case 199: 
            case 234: 
            case 282: 
            case 288: 
            case 291: 
            case 322: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 125: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 129: 
            case 134: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorKind";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDeclaration";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "probablyParenthesizedExpression";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "continuationExpression";
                break;
            }
            case 158: 
            case 267: 
            case 271: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingSuspendFunctionJvmView";
                break;
            }
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fd";
                break;
            }
            case 165: 
            case 168: 
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableMethod";
                break;
            }
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentGenerator";
                break;
            }
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverDescriptor";
                break;
            }
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "companionObjectDescriptor";
                break;
            }
            case 195: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextBeforeInline";
                break;
            }
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calleeContainingClass";
                break;
            }
            case 204: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singletonClassDescriptor";
                break;
            }
            case 205: 
            case 211: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisOrOuterClass";
                break;
            }
            case 213: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueArgument";
                break;
            }
            case 214: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outType";
                break;
            }
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 225: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lhs";
                break;
            }
            case 229: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifnull";
                break;
            }
            case 231: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifNull";
                break;
            }
            case 241: 
            case 244: 
            case 254: 
            case 258: 
            case 261: 
            case 268: 
            case 272: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opToken";
                break;
            }
            case 242: 
            case 251: 
            case 255: 
            case 259: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 243: 
            case 253: 
            case 256: 
            case 260: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 245: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftKotlinType";
                break;
            }
            case 246: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightKotlinType";
                break;
            }
            case 247: 
            case 252: 
            case 262: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftType";
                break;
            }
            case 248: 
            case 257: 
            case 263: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightType";
                break;
            }
            case 250: {
                objectArray2 = objectArray3;
                objectArray3[0] = "safeExpression";
                break;
            }
            case 264: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ieee754Type";
                break;
            }
            case 269: 
            case 273: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left754Type";
                break;
            }
            case 270: 
            case 274: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right754Type";
                break;
            }
            case 278: 
            case 324: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 279: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmKotlinType";
                break;
            }
            case 284: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 285: 
            case 286: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiDeclaration";
                break;
            }
            case 287: 
            case 290: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringDeclaration";
                break;
            }
            case 289: 
            case 292: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverStackValue";
                break;
            }
            case 295: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varValue";
                break;
            }
            case 297: 
            case 298: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDeclaration";
                break;
            }
            case 299: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 303: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 305: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadataVar";
                break;
            }
            case 314: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectType";
                break;
            }
            case 317: 
            case 319: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 323: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationDescriptor";
                break;
            }
            case 328: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchStart";
                break;
            }
            case 329: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchedRegions";
                break;
            }
            case 330: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStart";
                break;
            }
            case 335: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 337: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whenExpression";
                break;
            }
            case 341: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 342: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateValue";
                break;
            }
            case 343: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadataValue";
                break;
            }
            case 345: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 349: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentCodegen";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeMapper";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "castToRequiredTypeOfInterfaceIfNeeded";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperCallLabelTarget";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "asmType";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "mapTypeAsDeclaration";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "expressionType";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedReceiverType";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "generateBreakOrContinueExpression";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessStringTemplate";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "putClosureInstanceOnStack";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapOriginalReceiverOwnerForSuspendLambda";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupOuterValue";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableTypeNoSharing";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "intermediateValueForProperty";
                break;
            }
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "intermediateValueForSyntheticExtensionProperty";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "accessibleFunctionDescriptor";
                break;
            }
            case 149: 
            case 153: 
            case 154: 
            case 155: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeFunction";
                break;
            }
            case 163: 
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToCallable";
                break;
            }
            case 177: 
            case 178: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateCallGenerator";
                break;
            }
            case 184: 
            case 185: {
                objectArray = objectArray2;
                objectArray2[1] = "approximateCapturedType";
                break;
            }
            case 188: 
            case 189: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentsForResolvedCall";
                break;
            }
            case 190: 
            case 191: 
            case 192: {
                objectArray = objectArray2;
                objectArray2[1] = "generateReceiverValue";
                break;
            }
            case 197: 
            case 198: {
                objectArray = objectArray2;
                objectArray2[1] = "generateExtensionReceiver";
                break;
            }
            case 200: 
            case 201: {
                objectArray = objectArray2;
                objectArray2[1] = "generateScriptReceiver";
                break;
            }
            case 203: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: {
                objectArray = objectArray2;
                objectArray2[1] = "generateThisOrOuter";
                break;
            }
            case 212: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullParentContextForMethod";
                break;
            }
            case 215: 
            case 216: 
            case 217: {
                objectArray = objectArray2;
                objectArray2[1] = "genVarargs";
                break;
            }
            case 224: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePropertyReference";
                break;
            }
            case 226: {
                objectArray = objectArray2;
                objectArray2[1] = "generateClassLiteralReference";
                break;
            }
            case 249: {
                objectArray = objectArray2;
                objectArray2[1] = "genEqualsForInlineClasses";
                break;
            }
            case 265: 
            case 266: {
                objectArray = objectArray2;
                objectArray2[1] = "boxIfNullable";
                break;
            }
            case 294: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableMetadataValue";
                break;
            }
            case 296: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustVariableValue";
                break;
            }
            case 300: {
                objectArray = objectArray2;
                objectArray2[1] = "generateProvideDelegateCallForLocalVariable";
                break;
            }
            case 302: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableDescriptorNotNull";
                break;
            }
            case 308: 
            case 309: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNewCall";
                break;
            }
            case 311: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorDescriptor";
                break;
            }
            case 315: {
                objectArray = objectArray2;
                objectArray2[1] = "generateConstructorCall";
                break;
            }
            case 332: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCatchIntervals";
                break;
            }
            case 338: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameMap";
                break;
            }
            case 339: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 340: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineNameGenerator";
                break;
            }
            case 346: {
                objectArray = objectArray2;
                objectArray2[1] = "delegatedVariableValue";
                break;
            }
            case 347: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisitor";
                break;
            }
            case 348: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 44: 
            case 51: 
            case 52: 
            case 64: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 90: 
            case 91: 
            case 131: 
            case 138: 
            case 144: 
            case 145: 
            case 149: 
            case 153: 
            case 154: 
            case 155: 
            case 163: 
            case 164: 
            case 177: 
            case 178: 
            case 184: 
            case 185: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 197: 
            case 198: 
            case 200: 
            case 201: 
            case 203: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 212: 
            case 215: 
            case 216: 
            case 217: 
            case 224: 
            case 226: 
            case 249: 
            case 265: 
            case 266: 
            case 294: 
            case 296: 
            case 300: 
            case 302: 
            case 308: 
            case 309: 
            case 311: 
            case 315: 
            case 332: 
            case 338: 
            case 339: 
            case 340: 
            case 346: 
            case 347: 
            case 348: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generateObjectLiteral";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addReifiedParametersFromSignature";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processTypeArguments";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "castToRequiredTypeOfInterfaceIfNeeded";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "putStackValue";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitClass";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeAlias";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitObjectDeclaration";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitExpression";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitSuperExpression";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSuperCallLabelTarget";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "asmType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "mapTypeAsDeclaration";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitParenthesizedExpression";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotatedExpression";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitIfExpression";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "generateIfExpression";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "visitWhileExpression";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "generateWhile";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visitDoWhileExpression";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "generateDoWhile";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "visitForExpression";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "generateFor";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedReceiverType";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getSingleArgumentExpression";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "visitBreakExpression";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "visitContinueExpression";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "generateBreakOrContinueExpression";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "visitConstantExpression";
                break;
            }
            case 54: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getCompileTimeConstant";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveOrStringCompileTimeConstant";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "visitStringTemplateExpression";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "preprocessStringTemplate";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isConstantValueInlinableInStringTemplate";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "visitBlockExpression";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "visitNamedFunction";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "visitLambdaExpression";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "genClosure";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "putClosureInstanceOnStack";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "visitObjectLiteralExpression";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "pushClosureOnStack";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "unwrapOriginalReceiverOwnerForSuspendLambda";
                break;
            }
            case 82: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "generateBlock";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getCoroutineInstanceValueForSuspensionPoint";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "genCoroutineInstanceForSuspendLambda";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getVariableType";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getVariableTypeNoSharing";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "putDescriptorIntoFrameMap";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "putLocalVariableIntoFrameMap";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "addLeaveTaskToRemoveDescriptorFromFrameMap";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "addLeaveTaskToRemoveLocalVariableFromFrameMap";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "addLeaveTaskToRemoveNamedFunctionFromFrameMap";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "markStartLineNumber";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "markLineNumber";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "doFinallyOnReturn";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "genFinallyBlockOrGoto";
                break;
            }
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "addGapLabelsForNestedTryCatchWithoutFinally";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnExpression";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "generateFinallyBlocksIfNeeded";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "getNonLocalReturnInfo";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "returnExpression";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "endsWithReturn";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "isLambdaVoidBody";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "isLambdaBody";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "visitSimpleNameExpression";
                break;
            }
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "generateNonIntrinsicSimpleNameExpression";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "applyIntrinsic";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "getSuperCallTarget";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "findLocalOrCapturedValue";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "findCapturedValue";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "lookupCapturedValueInConstructorParameters";
                break;
            }
            case 129: 
            case 130: 
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "intermediateValueForProperty";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "getBackingFieldContext";
                break;
            }
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "intermediateValueForSyntheticExtensionProperty";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "visitCallExpression";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "visitCollectionLiteralExpression";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "genSamInterfaceValue";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "accessibleFunctionDescriptor";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "createAccessorForHiddenConstructor";
                break;
            }
            case 147: 
            case 148: 
            case 150: 
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "invokeFunction";
                break;
            }
            case 156: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "prepareCoroutineArgumentForSuspendCall";
                break;
            }
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "invokeCoroutineMigrationMethod";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "getContinuationParameterFromEnclosingSuspendFunction";
                break;
            }
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "getContinuationParameterFromEnclosingSuspendFunctionDescriptor";
                break;
            }
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "resolveToCallable";
                break;
            }
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "invokeMethodWithArguments";
                break;
            }
            case 173: 
            case 174: 
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "putReceiverAndInlineMarkerIfNeeded";
                break;
            }
            case 176: 
            case 180: 
            case 181: 
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCallGenerator";
                break;
            }
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCallGeneratorForDefaultImplBody";
                break;
            }
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "approximateCapturedType";
                break;
            }
            case 186: 
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentsForResolvedCall";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "generateInstanceReceiver";
                break;
            }
            case 194: 
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "getContextForCompanionObjectAccessorIfRequiredOrNull";
                break;
            }
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "generateExtensionReceiver";
                break;
            }
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "generateScriptReceiver";
                break;
            }
            case 202: 
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "generateThisOrOuter";
                break;
            }
            case 204: {
                objectArray = objectArray;
                objectArray[2] = "isInsideSingleton";
                break;
            }
            case 211: {
                objectArray = objectArray;
                objectArray[2] = "generateThisOrOuterFromContext";
                break;
            }
            case 213: 
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "genVarargs";
                break;
            }
            case 218: {
                objectArray = objectArray;
                objectArray[2] = "visitClassLiteralExpression";
                break;
            }
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "visitCallableReferenceExpression";
                break;
            }
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "generateCallableReferenceReceiver";
                break;
            }
            case 221: 
            case 222: 
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "generatePropertyReference";
                break;
            }
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "generateClassLiteralReference";
                break;
            }
            case 227: {
                objectArray = objectArray;
                objectArray[2] = "visitDotQualifiedExpression";
                break;
            }
            case 228: 
            case 229: {
                objectArray = objectArray;
                objectArray[2] = "generateExpressionWithNullFallback";
                break;
            }
            case 230: 
            case 231: {
                objectArray = objectArray;
                objectArray[2] = "generateSafeQualifiedExpression";
                break;
            }
            case 232: {
                objectArray = objectArray;
                objectArray[2] = "visitSafeQualifiedExpression";
                break;
            }
            case 233: 
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryExpression";
                break;
            }
            case 235: 
            case 236: 
            case 237: 
            case 238: {
                objectArray = objectArray;
                objectArray[2] = "genLazyUnlessProvided";
                break;
            }
            case 239: 
            case 240: {
                objectArray = objectArray;
                objectArray[2] = "genUnlessProvided";
                break;
            }
            case 241: {
                objectArray = objectArray;
                objectArray[2] = "generateEquals";
                break;
            }
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: {
                objectArray = objectArray;
                objectArray[2] = "genEqualsForInlineClasses";
                break;
            }
            case 250: {
                objectArray = objectArray;
                objectArray[2] = "isSelectorPureNonNullType";
                break;
            }
            case 251: 
            case 252: 
            case 253: 
            case 254: {
                objectArray = objectArray;
                objectArray[2] = "genCmpPrimitiveToSafeCall";
                break;
            }
            case 255: 
            case 256: 
            case 257: 
            case 258: {
                objectArray = objectArray;
                objectArray[2] = "genCmpSafeCallToPrimitive";
                break;
            }
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 263: {
                objectArray = objectArray;
                objectArray[2] = "genEqualsForExpressionsPreferIeee754Arithmetic";
                break;
            }
            case 264: {
                objectArray = objectArray;
                objectArray[2] = "boxIfNullable";
                break;
            }
            case 267: 
            case 268: 
            case 269: 
            case 270: {
                objectArray = objectArray;
                objectArray[2] = "generate754EqualsForNullableTypesViaIntrinsic";
                break;
            }
            case 271: 
            case 272: 
            case 273: 
            case 274: {
                objectArray = objectArray;
                objectArray[2] = "generate754EqualsForNullableTypes";
                break;
            }
            case 275: {
                objectArray = objectArray;
                objectArray[2] = "generateElvis";
                break;
            }
            case 276: 
            case 277: 
            case 278: 
            case 279: {
                objectArray = objectArray;
                objectArray[2] = "putCallAugAssignMethod";
                break;
            }
            case 280: {
                objectArray = objectArray;
                objectArray[2] = "visitLabeledExpression";
                break;
            }
            case 281: 
            case 282: {
                objectArray = objectArray;
                objectArray[2] = "visitPrefixExpression";
                break;
            }
            case 283: {
                objectArray = objectArray;
                objectArray[2] = "visitPostfixExpression";
                break;
            }
            case 284: {
                objectArray = objectArray;
                objectArray[2] = "visitProperty";
                break;
            }
            case 285: {
                objectArray = objectArray;
                objectArray[2] = "visitDestructuringDeclaration";
                break;
            }
            case 286: {
                objectArray = objectArray;
                objectArray[2] = "initializeDestructuringDeclaration";
                break;
            }
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: {
                objectArray = objectArray;
                objectArray[2] = "initializeDestructuringDeclarationVariables";
                break;
            }
            case 293: {
                objectArray = objectArray;
                objectArray[2] = "getVariableMetadataValue";
                break;
            }
            case 295: {
                objectArray = objectArray;
                objectArray[2] = "adjustVariableValue";
                break;
            }
            case 297: {
                objectArray = objectArray;
                objectArray[2] = "initializeLocalVariable";
                break;
            }
            case 298: {
                objectArray = objectArray;
                objectArray[2] = "initializeLocalVariableWithFakeDefaultValue";
                break;
            }
            case 299: {
                objectArray = objectArray;
                objectArray[2] = "generateProvideDelegateCallForLocalVariable";
                break;
            }
            case 301: {
                objectArray = objectArray;
                objectArray[2] = "getVariableDescriptorNotNull";
                break;
            }
            case 303: 
            case 304: 
            case 305: {
                objectArray = objectArray;
                objectArray[2] = "initializePropertyMetadata";
                break;
            }
            case 306: 
            case 307: {
                objectArray = objectArray;
                objectArray[2] = "generateNewCall";
                break;
            }
            case 310: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorDescriptor";
                break;
            }
            case 312: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorReceiver";
                break;
            }
            case 313: 
            case 314: {
                objectArray = objectArray;
                objectArray[2] = "generateConstructorCall";
                break;
            }
            case 316: 
            case 317: 
            case 318: {
                objectArray = objectArray;
                objectArray[2] = "generateNewArray";
                break;
            }
            case 319: {
                objectArray = objectArray;
                objectArray[2] = "newArrayInstruction";
                break;
            }
            case 320: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayAccessExpression";
                break;
            }
            case 321: 
            case 322: 
            case 323: 
            case 324: {
                objectArray = objectArray;
                objectArray[2] = "createCollectionElementReceiver";
                break;
            }
            case 325: {
                objectArray = objectArray;
                objectArray[2] = "visitThrowExpression";
                break;
            }
            case 326: {
                objectArray = objectArray;
                objectArray[2] = "visitThisExpression";
                break;
            }
            case 327: {
                objectArray = objectArray;
                objectArray[2] = "visitTryExpression";
                break;
            }
            case 328: 
            case 329: {
                objectArray = objectArray;
                objectArray[2] = "generateExceptionTable";
                break;
            }
            case 330: 
            case 331: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentCatchIntervals";
                break;
            }
            case 333: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryWithTypeRHSExpression";
                break;
            }
            case 334: {
                objectArray = objectArray;
                objectArray[2] = "visitIsExpression";
                break;
            }
            case 335: {
                objectArray = objectArray;
                objectArray[2] = "propagateChildReifiedTypeParametersUsages";
                break;
            }
            case 336: {
                objectArray = objectArray;
                objectArray[2] = "visitWhenExpression";
                break;
            }
            case 337: {
                objectArray = objectArray;
                objectArray[2] = "putUnitInstanceOntoStackForNonExhaustiveWhen";
                break;
            }
            case 341: {
                objectArray = objectArray;
                objectArray[2] = "addBlockStackElementsForNonLocalReturns";
                break;
            }
            case 342: 
            case 343: 
            case 344: 
            case 345: {
                objectArray = objectArray;
                objectArray[2] = "delegatedVariableValue";
                break;
            }
            case 349: {
                objectArray = objectArray;
                objectArray[2] = "consumeReifiedOperationMarker";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 44: 
            case 51: 
            case 52: 
            case 64: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 90: 
            case 91: 
            case 131: 
            case 138: 
            case 144: 
            case 145: 
            case 149: 
            case 153: 
            case 154: 
            case 155: 
            case 163: 
            case 164: 
            case 177: 
            case 178: 
            case 184: 
            case 185: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 197: 
            case 198: 
            case 200: 
            case 201: 
            case 203: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 212: 
            case 215: 
            case 216: 
            case 217: 
            case 224: 
            case 226: 
            case 249: 
            case 265: 
            case 266: 
            case 294: 
            case 296: 
            case 300: 
            case 302: 
            case 308: 
            case 309: 
            case 311: 
            case 315: 
            case 332: 
            case 338: 
            case 339: 
            case 340: 
            case 346: 
            case 347: 
            case 348: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NonLocalReturnInfo {
        private final CallableDescriptor descriptor;
        private final String labelName;

        private NonLocalReturnInfo(@NotNull CallableDescriptor descriptor2, @NotNull String name2) {
            if (descriptor2 == null) {
                NonLocalReturnInfo.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                NonLocalReturnInfo.$$$reportNull$$$0(1);
            }
            this.descriptor = descriptor2;
            this.labelName = name2;
        }

        private JvmKotlinType getJvmKotlinType(@NotNull KotlinTypeMapper typeMapper2) {
            if (typeMapper2 == null) {
                NonLocalReturnInfo.$$$reportNull$$$0(2);
            }
            return new JvmKotlinType(typeMapper2.mapReturnType(this.descriptor), this.descriptor.getReturnType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeMapper";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$NonLocalReturnInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getJvmKotlinType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class StringTemplateEntry {
        private StringTemplateEntry() {
        }

        static class Expression
        extends StringTemplateEntry {
            final KtExpression expression;

            Expression(KtExpression expression2) {
                this.expression = expression2;
            }
        }

        static class Constant
        extends StringTemplateEntry {
            final String value;

            Constant(String value2) {
                this.value = value2;
            }
        }
    }

    private static class ObjectLiteralResult {
        private final boolean wereReifiedMarkers;
        private final ClassDescriptor classDescriptor;

        public ObjectLiteralResult(boolean wereReifiedMarkers, @NotNull ClassDescriptor classDescriptor) {
            if (classDescriptor == null) {
                ObjectLiteralResult.$$$reportNull$$$0(0);
            }
            this.wereReifiedMarkers = wereReifiedMarkers;
            this.classDescriptor = classDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen$ObjectLiteralResult", "<init>"));
        }
    }

    static class TryWithFinallyBlockStackElement
    extends TryBlockStackElement {
        final KtTryExpression expression;

        TryWithFinallyBlockStackElement(KtTryExpression expression2) {
            this.expression = expression2;
        }
    }

    static class TryBlockStackElement
    extends BlockStackElement {
        List<Label> gaps = new ArrayList<Label>();

        TryBlockStackElement() {
        }

        void addGapLabel(Label label) {
            this.gaps.add(label);
        }
    }

    static class LoopBlockStackElement
    extends BlockStackElement {
        final Label continueLabel;
        final Label breakLabel;
        public final KtSimpleNameExpression targetLabel;

        LoopBlockStackElement(Label breakLabel, Label continueLabel, KtSimpleNameExpression targetLabel) {
            this.breakLabel = breakLabel;
            this.continueLabel = continueLabel;
            this.targetLabel = targetLabel;
        }
    }

    public static class BlockStackElement {
    }
}

