/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.lower.FieldAccessTransformer;
import org.jetbrains.kotlin.backend.jvm.lower.FieldCollector;
import org.jetbrains.kotlin.backend.jvm.lower.FieldRenamer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/RenameFieldsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.jvm.lower"})
final class RenameFieldsLowering
implements FileLoweringPass {
    @NotNull
    private final CommonBackendContext context;

    public RenameFieldsLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        List fields2 = new ArrayList();
        irFile.accept(FieldCollector.INSTANCE, fields2);
        List $this$sortBy$iv = fields2;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    IrField it = (IrField)a;
                    boolean bl = false;
                    int n = it.getVisibility().isPublicAPI() ? 0 : (it.isStatic() ? 1 : 2);
                    it = (IrField)b;
                    Comparable comparable = Integer.valueOf(n);
                    bl = false;
                    Integer n2 = it.getVisibility().isPublicAPI() ? 0 : (it.isStatic() ? 1 : 2);
                    return ComparisonsKt.compareValues(comparable, (Comparable)n2);
                }
            });
        }
        Map newNames = new LinkedHashMap();
        HashMap count2 = new HashMap();
        for (IrField field2 : fields2) {
            Pair<IrDeclarationParent, Name> key = TuplesKt.to(field2.getParent(), field2.getName());
            Comparable<Integer> comparable = (Integer)count2.get(key);
            Object object = comparable == null ? Integer.valueOf(0) : comparable;
            int index2 = ((Number)object).intValue();
            if (index2 != 0 && !field2.getVisibility().isPublicAPI()) {
                object = newNames;
                comparable = Name.identifier("" + field2.getName() + '$' + index2);
                Intrinsics.checkNotNullExpressionValue(comparable, "identifier(\"${field.name}$$index\")");
                object.put(field2, comparable);
            }
            object = count2;
            comparable = index2 + 1;
            object.put(key, comparable);
        }
        FieldRenamer renamer = new FieldRenamer(newNames);
        irFile.transform((IrElementTransformer)renamer, (Object)null);
        irFile.transform((IrElementTransformer)new FieldAccessTransformer(renamer.getNewSymbols()), (Object)null);
    }
}

