/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import org.jetbrains.kotlin.backend.common.serialization.IdSignatureDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.library.IrLibrary;
import org.jetbrains.kotlin.library.KotlinAbiVersion;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0011\u0010&\u001a\u00020\f2\u0006\u0010$\u001a\u00020%H\u00a6\u0002J\u0010\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020)2\u0006\u0010$\u001a\u00020%2\u0006\u0010+\u001a\u00020,H&J\b\u0010-\u001a\u00020#H\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u0015H\u0016J\b\u00100\u001a\u00020#H\u0016J\u0010\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020\u0000H\u0016J\b\u00102\u001a\u00020#H\u0016J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020%H\u0016J\u0018\u00108\u001a\u0002092\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020%H\u0016J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u00020\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "libraryAbiVersion", "Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/library/KotlinAbiVersion;)V", "compatibilityMode", "Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;", "getCompatibilityMode", "()Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;", "isCurrent", "", "()Z", "klib", "Lorg/jetbrains/kotlin/library/IrLibrary;", "getKlib", "()Lorg/jetbrains/kotlin/library/IrLibrary;", "getLibraryAbiVersion", "()Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "moduleDependencies", "", "getModuleDependencies", "()Ljava/util/Collection;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getModuleFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "strategy", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "getStrategy", "()Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "addModuleReachableTopLevel", "", "idSig", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "contains", "declareIrSymbol", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "deserializeIrSymbol", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "deserializeReachableDeclarations", "fileDeserializers", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "init", "delegate", "postProcess", "referencePropertyByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "idSignature", "referenceSimpleFunctionByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "signatureDeserializerForFile", "Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer;", "fileName", "", "ir.serialization.common"})
public abstract class IrModuleDeserializer {
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final KotlinAbiVersion libraryAbiVersion;
    @NotNull
    private final DeserializationStrategy strategy;
    private final boolean isCurrent;

    public IrModuleDeserializer(@NotNull ModuleDescriptor moduleDescriptor, @NotNull KotlinAbiVersion libraryAbiVersion) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(libraryAbiVersion, "libraryAbiVersion");
        this.moduleDescriptor = moduleDescriptor;
        this.libraryAbiVersion = libraryAbiVersion;
        this.strategy = DeserializationStrategy.ONLY_DECLARATION_HEADERS;
    }

    @NotNull
    public final ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @NotNull
    public final KotlinAbiVersion getLibraryAbiVersion() {
        return this.libraryAbiVersion;
    }

    public abstract boolean contains(@NotNull IdSignature var1);

    @NotNull
    public abstract IrSymbol deserializeIrSymbol(@NotNull IdSignature var1, @NotNull BinarySymbolData.SymbolKind var2);

    @NotNull
    public IrSimpleFunctionSymbol referenceSimpleFunctionByLocalSignature(@NotNull IrFile file2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        throw new IllegalStateException("Unsupported operation".toString());
    }

    @NotNull
    public IrPropertySymbol referencePropertyByLocalSignature(@NotNull IrFile file2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        throw new IllegalStateException("Unsupported operation".toString());
    }

    public void declareIrSymbol(@NotNull IrSymbol symbol2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        IdSignature signature2 = symbol2.getSignature();
        boolean bl2 = bl = signature2 != null;
        if (!bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus("Symbol is not public API: ", symbol2.getDescriptor());
            throw new IllegalArgumentException(string2.toString());
        }
        bl = symbol2.getHasDescriptor();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        this.deserializeIrSymbol(signature2, IrModuleDeserializerKt.kind(symbol2));
    }

    @NotNull
    public IrLibrary getKlib() {
        throw new IllegalStateException("Unsupported operation".toString());
    }

    public void init() {
        this.init(this);
    }

    public void postProcess() {
    }

    public void init(@NotNull IrModuleDeserializer delegate2) {
        Intrinsics.checkNotNullParameter(delegate2, "delegate");
    }

    public void addModuleReachableTopLevel(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        throw new IllegalStateException(Intrinsics.stringPlus("Unsupported Operation (sig: ", idSig).toString());
    }

    public void deserializeReachableDeclarations() {
        throw new IllegalStateException("Unsupported Operation".toString());
    }

    @NotNull
    public abstract IrModuleFragment getModuleFragment();

    @NotNull
    public abstract Collection<IrModuleDeserializer> getModuleDependencies();

    @NotNull
    public DeserializationStrategy getStrategy() {
        return this.strategy;
    }

    public boolean isCurrent() {
        return this.isCurrent;
    }

    @NotNull
    public Collection<IrFileDeserializer> fileDeserializers() {
        throw new IllegalStateException("Unsupported".toString());
    }

    @NotNull
    public final CompatibilityMode getCompatibilityMode() {
        return new CompatibilityMode(this.libraryAbiVersion);
    }

    @NotNull
    public IdSignatureDeserializer signatureDeserializerForFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        throw new IllegalStateException("Unsupported".toString());
    }
}

