/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.CollectionUtilKt;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000 Q*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0007PQRSTUVB\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J,\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\b2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'H$J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\bH$J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001e\u0010.\u001a\u00020\u001a2\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u000203H$J\u0010\u00104\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u00105\u001a\u00020\u001a2\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\bH$J\u0018\u00109\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020\u001a2\u0006\u00106\u001a\u000207H\u0002J\"\u0010=\u001a\n\u0012\u0004\u0012\u00020>\u0018\u0001002\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0016H\u0002J\u0018\u0010?\u001a\n\u0012\u0004\u0012\u00020>\u0018\u0001002\u0006\u0010@\u001a\u000207H\u0002J\"\u0010A\u001a\u00020)*\u00020\u001e2\u0006\u0010B\u001a\u00020\u00122\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FJ\u001c\u0010G\u001a\u00020\u001a*\u00020H2\u0006\u0010I\u001a\u00020\b2\u0006\u0010J\u001a\u00020KH$J\u001c\u0010L\u001a\u00020K*\u00020M2\u0006\u0010N\u001a\u00020D2\u0006\u0010:\u001a\u00020KH\u0014J\f\u0010O\u001a\u00020F*\u00020;H\u0004R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00160\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering;", "C", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "builtCoroutines", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$BuiltCoroutine;", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "continuationClassSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getContinuationSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "stateMachineMethodName", "Lorg/jetbrains/kotlin/name/Name;", "getStateMachineMethodName", "()Lorg/jetbrains/kotlin/name/Name;", "suspendLambdas", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "addMissingSupertypesToSuspendFunctionImplementingClasses", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "buildCoroutine", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "functionReference", "buildCoroutines", "buildStateMachine", "stateMachineFunction", "transformingFunction", "argumentToPropertiesMap", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getCoroutineBaseClass", "function", "getSuspendFunctionKind", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$SuspendFunctionKind;", "initializeStateMachine", "coroutineConstructors", "", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "coroutineClassThis", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "lower", "markSuspendLambdas", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "nameForCoroutineClass", "removeReturnIfSuspendedCallAndSimplifyDelegatingCall", "delegatingCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "transformCallableReferencesToSuspendLambdas", "transformSuspendFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "tryTransformSuspendFunction", "element", "addField", "name", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isMutable", "", "generateCoroutineStart", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "invokeSuspendFunction", "receiver", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "generateDelegatedCall", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "expectedType", "isReturnIfSuspendedCall", "BuiltCoroutine", "Companion", "CoroutineBuilder", "DECLARATION_ORIGIN_COROUTINE_IMPL", "STATEMENT_ORIGIN_COROUTINE_IMPL", "SuspendFunctionKind", "VariablesScopeTracker", "ir.backend.common"})
public abstract class AbstractSuspendFunctionsLowering<C extends CommonBackendContext>
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final C context;
    @NotNull
    private final Map<IrFunction, BuiltCoroutine> builtCoroutines;
    @NotNull
    private final Map<IrFunction, IrFunctionReference> suspendLambdas;
    @NotNull
    private final Symbols<CommonBackendContext> symbols;
    @NotNull
    private final IrSimpleFunctionSymbol getContinuationSymbol;
    @NotNull
    private final IrClassSymbol continuationClassSymbol;
    @NotNull
    private static final Name CREATE_IDENTIFIER;

    public AbstractSuspendFunctionsLowering(@NotNull C context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.builtCoroutines = new LinkedHashMap();
        this.suspendLambdas = new LinkedHashMap();
        this.symbols = this.context.getIr().getSymbols();
        this.getContinuationSymbol = this.symbols.getGetContinuation();
        this.continuationClassSymbol = (IrClassSymbol)IrTypesKt.getClassifierOrFail(((IrSimpleFunction)this.getContinuationSymbol.getOwner()).getReturnType());
    }

    @NotNull
    public final C getContext() {
        return this.context;
    }

    @NotNull
    protected abstract Name getStateMachineMethodName();

    @NotNull
    protected abstract IrClassSymbol getCoroutineBaseClass(@NotNull IrFunction var1);

    @NotNull
    protected abstract Name nameForCoroutineClass(@NotNull IrFunction var1);

    protected abstract void buildStateMachine(@NotNull IrFunction var1, @NotNull IrFunction var2, @NotNull Map<IrValueParameter, ? extends IrField> var3);

    protected abstract void generateCoroutineStart(@NotNull IrBlockBodyBuilder var1, @NotNull IrFunction var2, @NotNull IrExpression var3);

    protected abstract void initializeStateMachine(@NotNull List<? extends IrConstructor> var1, @NotNull IrValueDeclaration var2);

    @NotNull
    protected IrExpression generateDelegatedCall(@NotNull IrBuilderWithScope $this$generateDelegatedCall, @NotNull IrType expectedType2, @NotNull IrExpression delegatingCall) {
        Intrinsics.checkNotNullParameter($this$generateDelegatedCall, "<this>");
        Intrinsics.checkNotNullParameter(expectedType2, "expectedType");
        Intrinsics.checkNotNullParameter(delegatingCall, "delegatingCall");
        return delegatingCall;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        this.markSuspendLambdas(irFile);
        this.buildCoroutines(irFile);
        this.transformCallableReferencesToSuspendLambdas(irFile);
        this.addMissingSupertypesToSuspendFunctionImplementingClasses(irFile);
    }

    private final void addMissingSupertypesToSuspendFunctionImplementingClasses(IrFile irFile) {
        IrElementVisitorVoidKt.acceptChildrenVoid(irFile, new IrElementVisitorVoid(this){
            final /* synthetic */ AbstractSuspendFunctionsLowering<C> this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(@NotNull IrElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
            }

            public void visitClass(@NotNull IrClass declaration2) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                this.addMissingSupertypes(declaration2);
                IrElementVisitorVoidKt.acceptChildrenVoid(declaration2, this);
            }

            /*
             * WARNING - void declaration
             */
            private final void addMissingSupertypes(IrClass clazz) {
                Set suspendFunctionTypes = new LinkedHashSet<E>();
                for (IrSimpleType superType2 : IrTypeUtilsKt.getAllSubstitutedSupertypes(clazz)) {
                    if (IrTypeUtilsKt.isFunctionMarker(superType2)) continue;
                    if (IrTypeUtilsKt.isFunction(superType2)) {
                        return;
                    }
                    if (!IrTypeUtilsKt.isSuspendFunction(superType2)) continue;
                    Collection collection = suspendFunctionTypes;
                    collection.add(superType2);
                }
                for (IrSimpleType suspendFunctionType : suspendFunctionTypes) {
                    void $this$mapIndexedTo$iv$iv;
                    void $this$mapIndexed$iv;
                    Object element$iv2;
                    IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(suspendFunctionType);
                    if (irClassSymbol == null) continue;
                    IrClassSymbol suspendFunctionClassSymbol = irClassSymbol;
                    Iterable $this$single$iv = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.simpleFunctions((IrDeclarationContainer)suspendFunctionClassSymbol.getOwner());
                    boolean $i$f$single = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv2 : $this$single$iv) {
                        IrSimpleFunction it = (IrSimpleFunction)element$iv2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getName(), OperatorNameConventions.INVOKE)) continue;
                        if (found$iv) {
                            throw new IllegalArgumentException("Collection contains more than one matching element.");
                        }
                        single$iv = element$iv2;
                        found$iv = true;
                    }
                    if (!found$iv) {
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    IrSimpleFunctionSymbol suspendFunctionSymbol = ((IrSimpleFunction)single$iv).getSymbol();
                    Iterable $this$single$iv2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.simpleFunctions(clazz);
                    boolean $i$f$single2 = false;
                    Object single$iv2 = null;
                    boolean found$iv2 = false;
                    element$iv2 = $this$single$iv2.iterator();
                    while (element$iv2.hasNext()) {
                        E element$iv3 = element$iv2.next();
                        IrSimpleFunction it = (IrSimpleFunction)element$iv3;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual(it.getName(), OperatorNameConventions.INVOKE) && it.getOverriddenSymbols().contains(suspendFunctionSymbol))) continue;
                        if (found$iv2) {
                            throw new IllegalArgumentException("Collection contains more than one matching element.");
                        }
                        single$iv2 = element$iv3;
                        found$iv2 = true;
                    }
                    if (!found$iv2) {
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    IrSimpleFunction invokeFunction = single$iv2;
                    int suspendFunctionArity = ((IrSimpleFunction)suspendFunctionSymbol.getOwner()).getValueParameters().size();
                    IrClassSymbol functionClassSymbol = AbstractSuspendFunctionsLowering.access$getSymbols$p(this.this$0).functionN(suspendFunctionArity + 1);
                    Object $this$single$iv3 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.simpleFunctions((IrDeclarationContainer)functionClassSymbol.getOwner());
                    boolean $i$f$single222 = false;
                    Object single$iv3 = null;
                    boolean found$iv3 = false;
                    Iterator<T> bl = $this$single$iv3.iterator();
                    while (bl.hasNext()) {
                        T element$iv4 = bl.next();
                        IrSimpleFunction it = (IrSimpleFunction)element$iv4;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getName(), OperatorNameConventions.INVOKE)) continue;
                        if (found$iv3) {
                            throw new IllegalArgumentException("Collection contains more than one matching element.");
                        }
                        single$iv3 = element$iv4;
                        found$iv3 = true;
                    }
                    if (!found$iv3) {
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    IrSimpleFunctionSymbol functionSymbol = ((IrSimpleFunction)single$iv3).getSymbol();
                    $this$single$iv3 = invokeFunction;
                    $this$single$iv3.setOverriddenSymbols(CollectionsKt.plus((Collection)$this$single$iv3.getOverriddenSymbols(), functionSymbol));
                    Iterable $i$f$single222 = suspendFunctionType.getArguments();
                    Object object = this.this$0;
                    boolean $i$f$mapIndexed = false;
                    bl = $this$mapIndexed$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
                    boolean $i$f$mapIndexedTo = false;
                    int index$iv$iv = 0;
                    for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                        IrType irType;
                        void index2;
                        void argument2;
                        int n = index$iv$iv;
                        index$iv$iv = n + 1;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                        int n2 = n;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        IrType type2 = ((IrTypeProjection)argument2).getType();
                        if (index2 == suspendFunctionArity) {
                            IrType[] irTypeArray = new IrType[]{type2};
                            irType = IrTypesKt.typeWith((IrClassifierSymbol)AbstractSuspendFunctionsLowering.access$getContinuationClassSymbol$p((AbstractSuspendFunctionsLowering)object), irTypeArray);
                        } else {
                            irType = type2;
                        }
                        IrType irType2 = irType;
                        collection.add(irType2);
                    }
                    List<IrType> functionClassTypeArguments = CollectionsKt.plus((Collection)((List)destination$iv$iv), this.this$0.getContext().getIrBuiltIns().getAnyNType());
                    IrSimpleType functionType = IrTypesKt.typeWith((IrClassifierSymbol)functionClassSymbol, functionClassTypeArguments);
                    object = clazz;
                    ((IrClass)object).setSuperTypes(CollectionsKt.plus((Collection)((IrClass)object).getSuperTypes(), functionType));
                }
            }

            public <T> void visitConst(@NotNull IrConst<T> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data2);
            }

            public void visitBlock(@NotNull IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
            }

            public void visitBody(@NotNull IrBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
            }

            public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
            }

            public void visitBranch(@NotNull IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
            }

            public void visitBreak(@NotNull IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
            }

            public void visitCall(@NotNull IrCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            }

            public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
            }

            public void visitCatch(@NotNull IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
            }

            public void visitClass(@NotNull IrClass declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
            }

            public void visitComposite(@NotNull IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
            }

            public void visitContinue(@NotNull IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
            }

            public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
            }

            public void visitExpression(@NotNull IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data2);
            }

            public void visitField(@NotNull IrField declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
            }

            public void visitField(@NotNull IrField declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
            }

            public void visitFile(@NotNull IrFile declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
            }

            public void visitFile(@NotNull IrFile declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data2);
            }

            public void visitFunction(@NotNull IrFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
            }

            public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
            }

            public void visitGetField(@NotNull IrGetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
            }

            public void visitLoop(@NotNull IrLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
            }

            public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data2);
            }

            public void visitProperty(@NotNull IrProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
            }

            public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
            }

            public void visitReturn(@NotNull IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
            }

            public void visitScript(@NotNull IrScript declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
            }

            public void visitScript(@NotNull IrScript declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data2);
            }

            public void visitSetField(@NotNull IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
            }

            public void visitThrow(@NotNull IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
            }

            public void visitTry(@NotNull IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data2);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data2);
            }

            public void visitVararg(@NotNull IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
            }

            public void visitVariable(@NotNull IrVariable declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
            }

            public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data2);
            }

            public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
            }
        });
    }

    private final void buildCoroutines(IrFile irFile) {
        TransformKt.transformDeclarationsFlat(irFile, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)new Function1<IrElement, List<? extends IrDeclaration>>((Object)this){

            @Nullable
            public final List<IrDeclaration> invoke(@NotNull IrElement p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return AbstractSuspendFunctionsLowering.access$tryTransformSuspendFunction((AbstractSuspendFunctionsLowering)this.receiver, p0);
            }

            @NotNull
            public final String getSignature() {
                return "tryTransformSuspendFunction(Lorg/jetbrains/kotlin/ir/IrElement;)Ljava/util/List;";
            }

            @NotNull
            public final String getName() {
                return "tryTransformSuspendFunction";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(AbstractSuspendFunctionsLowering.class);
            }
        });
        IrElementVisitorVoidKt.acceptVoid(irFile, new IrElementVisitorVoid(this){
            final /* synthetic */ AbstractSuspendFunctionsLowering<C> this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(@NotNull IrElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
            }

            public void visitClass(@NotNull IrClass declaration2) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                IrElementVisitorVoidKt.acceptChildrenVoid(declaration2, this);
                TransformKt.transformDeclarationsFlat(declaration2, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)new Function1<IrElement, List<? extends IrDeclaration>>(this.this$0){

                    @Nullable
                    public final List<IrDeclaration> invoke(@NotNull IrElement p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return AbstractSuspendFunctionsLowering.access$tryTransformSuspendFunction((AbstractSuspendFunctionsLowering)this.receiver, p0);
                    }

                    @NotNull
                    public final String getSignature() {
                        return "tryTransformSuspendFunction(Lorg/jetbrains/kotlin/ir/IrElement;)Ljava/util/List;";
                    }

                    @NotNull
                    public final String getName() {
                        return "tryTransformSuspendFunction";
                    }

                    @NotNull
                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(AbstractSuspendFunctionsLowering.class);
                    }
                });
            }

            public <T> void visitConst(@NotNull IrConst<T> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data2);
            }

            public void visitBlock(@NotNull IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
            }

            public void visitBody(@NotNull IrBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
            }

            public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
            }

            public void visitBranch(@NotNull IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
            }

            public void visitBreak(@NotNull IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
            }

            public void visitCall(@NotNull IrCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            }

            public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
            }

            public void visitCatch(@NotNull IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
            }

            public void visitClass(@NotNull IrClass declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
            }

            public void visitComposite(@NotNull IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
            }

            public void visitContinue(@NotNull IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
            }

            public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
            }

            public void visitExpression(@NotNull IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data2);
            }

            public void visitField(@NotNull IrField declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
            }

            public void visitField(@NotNull IrField declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
            }

            public void visitFile(@NotNull IrFile declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
            }

            public void visitFile(@NotNull IrFile declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data2);
            }

            public void visitFunction(@NotNull IrFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
            }

            public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
            }

            public void visitGetField(@NotNull IrGetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
            }

            public void visitLoop(@NotNull IrLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
            }

            public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data2);
            }

            public void visitProperty(@NotNull IrProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
            }

            public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
            }

            public void visitReturn(@NotNull IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
            }

            public void visitScript(@NotNull IrScript declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
            }

            public void visitScript(@NotNull IrScript declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data2);
            }

            public void visitSetField(@NotNull IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
            }

            public void visitThrow(@NotNull IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
            }

            public void visitTry(@NotNull IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data2);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data2);
            }

            public void visitVararg(@NotNull IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
            }

            public void visitVariable(@NotNull IrVariable declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
            }

            public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data2);
            }

            public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
            }
        });
    }

    protected final boolean isReturnIfSuspendedCall(@NotNull IrCall $this$isReturnIfSuspendedCall) {
        Intrinsics.checkNotNullParameter($this$isReturnIfSuspendedCall, "<this>");
        return Intrinsics.areEqual($this$isReturnIfSuspendedCall.getSymbol().getSignature(), this.context.getIr().getSymbols().getReturnIfSuspended().getSignature());
    }

    private final List<IrDeclaration> tryTransformSuspendFunction(IrElement element) {
        return element instanceof IrSimpleFunction && ((IrSimpleFunction)element).isSuspend() && ((IrSimpleFunction)element).getModality() != Modality.ABSTRACT ? this.transformSuspendFunction((IrSimpleFunction)element, this.suspendLambdas.get(element)) : null;
    }

    private final void markSuspendLambdas(IrElement irElement) {
        IrElementVisitorVoidKt.acceptChildrenVoid(irElement, new IrElementVisitorVoid(this){
            final /* synthetic */ AbstractSuspendFunctionsLowering<C> this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(@NotNull IrElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementVisitorVoidKt.acceptChildrenVoid(expression2, this);
                if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isSuspend(expression2)) {
                    Map map2 = AbstractSuspendFunctionsLowering.access$getSuspendLambdas$p(this.this$0);
                    IrFunction irFunction2 = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
                    map2.put(irFunction2, expression2);
                }
            }

            public <T> void visitConst(@NotNull IrConst<T> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data2);
            }

            public void visitBlock(@NotNull IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
            }

            public void visitBody(@NotNull IrBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
            }

            public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
            }

            public void visitBranch(@NotNull IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
            }

            public void visitBreak(@NotNull IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
            }

            public void visitCall(@NotNull IrCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            }

            public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
            }

            public void visitCatch(@NotNull IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
            }

            public void visitClass(@NotNull IrClass declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
            }

            public void visitClass(@NotNull IrClass declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
            }

            public void visitComposite(@NotNull IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
            }

            public void visitContinue(@NotNull IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
            }

            public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
            }

            public void visitExpression(@NotNull IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data2);
            }

            public void visitField(@NotNull IrField declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
            }

            public void visitField(@NotNull IrField declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
            }

            public void visitFile(@NotNull IrFile declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
            }

            public void visitFile(@NotNull IrFile declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data2);
            }

            public void visitFunction(@NotNull IrFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
            }

            public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
            }

            public void visitGetField(@NotNull IrGetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
            }

            public void visitLoop(@NotNull IrLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
            }

            public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data2);
            }

            public void visitProperty(@NotNull IrProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
            }

            public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
            }

            public void visitReturn(@NotNull IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
            }

            public void visitScript(@NotNull IrScript declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
            }

            public void visitScript(@NotNull IrScript declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data2);
            }

            public void visitSetField(@NotNull IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
            }

            public void visitThrow(@NotNull IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
            }

            public void visitTry(@NotNull IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data2);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data2);
            }

            public void visitVararg(@NotNull IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
            }

            public void visitVariable(@NotNull IrVariable declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
            }

            public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data2);
            }

            public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
            }
        });
    }

    private final void transformCallableReferencesToSuspendLambdas(IrElement irElement) {
        IrElementTransformerVoidKt.transformChildrenVoid(irElement, new IrElementTransformerVoid(this){
            final /* synthetic */ AbstractSuspendFunctionsLowering<C> this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
                IrConstructorCall irConstructorCall;
                DeclarationIrBuilder irBuilder;
                DeclarationIrBuilder declarationIrBuilder;
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                if (!org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isSuspend(expression2)) {
                    return expression2;
                }
                BuiltCoroutine builtCoroutine = (BuiltCoroutine)AbstractSuspendFunctionsLowering.access$getBuiltCoroutines$p(this.this$0).get(((IrFunctionSymbol)expression2.getSymbol()).getOwner());
                if (builtCoroutine == null) {
                    throw new Error(Intrinsics.stringPlus("Non-local callable reference to suspend lambda: ", expression2));
                }
                BuiltCoroutine coroutine = builtCoroutine;
                List<IrValueParameter> constructorParameters = coroutine.getCoroutineConstructor().getValueParameters();
                Iterable $this$map$iv = IrUtilsKt.getArgumentsWithIr(expression2);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    IrExpression irExpression = (IrExpression)it.getSecond();
                    collection.add(irExpression);
                }
                List expressionArguments = (List)destination$iv$iv;
                boolean bl = $this$map$iv = constructorParameters.size() == expressionArguments.size();
                if (_Assertions.ENABLED && !$this$map$iv) {
                    boolean bl2 = false;
                    String string2 = "Inconsistency between callable reference to suspend lambda and the corresponding coroutine";
                    throw new AssertionError((Object)string2);
                }
                DeclarationIrBuilder $this$visitFunctionReference_u24lambda_u2d4 = declarationIrBuilder = (irBuilder = LowerUtilsKt.createIrBuilder((BackendContext)this.this$0.getContext(), expression2.getSymbol(), expression2.getStartOffset(), expression2.getEndOffset()));
                boolean bl3 = false;
                IrConstructorCall $this$visitFunctionReference_u24lambda_u2d4_u24lambda_u2d3 = irConstructorCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$visitFunctionReference_u24lambda_u2d4, coroutine.getCoroutineConstructor().getSymbol());
                boolean bl4 = false;
                Iterable $this$forEachIndexed$iv = expressionArguments;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    void argument2;
                    int n = index$iv;
                    index$iv = n + 1;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    IrExpression irExpression = (IrExpression)item$iv;
                    int index2 = n;
                    boolean bl5 = false;
                    $this$visitFunctionReference_u24lambda_u2d4_u24lambda_u2d3.putValueArgument(index2, (IrExpression)argument2);
                }
                return irConstructorCall;
            }
        });
    }

    private final List<IrDeclaration> transformSuspendFunction(IrSimpleFunction irFunction2, IrFunctionReference functionReference2) {
        List<IrDeclaration> list2;
        SuspendFunctionKind suspendFunctionKind = this.getSuspendFunctionKind(irFunction2);
        if (suspendFunctionKind instanceof SuspendFunctionKind.NO_SUSPEND_CALLS) {
            list2 = null;
        } else if (suspendFunctionKind instanceof SuspendFunctionKind.DELEGATING) {
            this.removeReturnIfSuspendedCallAndSimplifyDelegatingCall(irFunction2, ((SuspendFunctionKind.DELEGATING)suspendFunctionKind).getDelegatingCall());
            list2 = null;
        } else if (suspendFunctionKind instanceof SuspendFunctionKind.NEEDS_STATE_MACHINE) {
            IrClass coroutine = this.buildCoroutine(irFunction2, functionReference2);
            IrDeclaration[] irDeclarationArray = this.suspendLambdas;
            IrDeclaration[] irDeclarationArray2 = irDeclarationArray;
            if (irDeclarationArray2.containsKey(irFunction2)) {
                list2 = CollectionsKt.listOf(coroutine);
            } else {
                irDeclarationArray = new IrDeclaration[]{coroutine, irFunction2};
                list2 = CollectionsKt.listOf(irDeclarationArray);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list2;
    }

    private final SuspendFunctionKind getSuspendFunctionKind(IrSimpleFunction irFunction2) {
        SuspendFunctionKind suspendFunctionKind;
        IrCall irCall;
        Map<IrFunction, IrFunctionReference> map2 = this.suspendLambdas;
        Object object = map2;
        if (object.containsKey(irFunction2)) {
            return SuspendFunctionKind.NEEDS_STATE_MACHINE.INSTANCE;
        }
        object = irFunction2.getBody();
        if (object == null) {
            return SuspendFunctionKind.NO_SUSPEND_CALLS.INSTANCE;
        }
        Map<IrFunction, IrFunctionReference> body2 = object;
        Ref.IntRef numberOfSuspendCalls = new Ref.IntRef();
        IrElementVisitorVoidKt.acceptVoid((IrElement)((Object)body2), new IrElementVisitorVoid(numberOfSuspendCalls){
            final /* synthetic */ Ref.IntRef $numberOfSuspendCalls;
            {
                this.$numberOfSuspendCalls = $numberOfSuspendCalls;
            }

            public void visitElement(@NotNull IrElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
            }

            public void visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementVisitorVoidKt.acceptChildrenVoid(expression2, this);
                if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isSuspend(expression2)) {
                    ++this.$numberOfSuspendCalls.element;
                    int cfr_ignored_0 = this.$numberOfSuspendCalls.element;
                }
            }

            public <T> void visitConst(@NotNull IrConst<T> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data2);
            }

            public void visitBlock(@NotNull IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
            }

            public void visitBody(@NotNull IrBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
            }

            public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
            }

            public void visitBranch(@NotNull IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
            }

            public void visitBreak(@NotNull IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
            }

            public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
            }

            public void visitCatch(@NotNull IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
            }

            public void visitClass(@NotNull IrClass declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
            }

            public void visitClass(@NotNull IrClass declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
            }

            public void visitComposite(@NotNull IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
            }

            public void visitContinue(@NotNull IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
            }

            public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
            }

            public void visitExpression(@NotNull IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data2);
            }

            public void visitField(@NotNull IrField declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
            }

            public void visitField(@NotNull IrField declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
            }

            public void visitFile(@NotNull IrFile declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
            }

            public void visitFile(@NotNull IrFile declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data2);
            }

            public void visitFunction(@NotNull IrFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
            }

            public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
            }

            public void visitGetField(@NotNull IrGetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
            }

            public void visitLoop(@NotNull IrLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
            }

            public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data2);
            }

            public void visitProperty(@NotNull IrProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
            }

            public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
            }

            public void visitReturn(@NotNull IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
            }

            public void visitScript(@NotNull IrScript declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
            }

            public void visitScript(@NotNull IrScript declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data2);
            }

            public void visitSetField(@NotNull IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
            }

            public void visitThrow(@NotNull IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
            }

            public void visitTry(@NotNull IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data2);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data2);
            }

            public void visitVararg(@NotNull IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
            }

            public void visitVariable(@NotNull IrVariable declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
            }

            public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data2);
            }

            public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
            }
        });
        IrStatement lastStatement = CollectionsKt.lastOrNull(((IrBlockBody)((Object)body2)).getStatements());
        if (lastStatement instanceof IrCall) {
            irCall = (IrCall)lastStatement;
        } else if (lastStatement instanceof IrReturn) {
            IrElement value2 = lastStatement;
            while (true) {
                IrElement irElement;
                if (value2 instanceof IrBlock && ((IrBlock)value2).getStatements().size() == 1) {
                    irElement = CollectionsKt.first(((IrBlock)value2).getStatements());
                } else {
                    if (!(value2 instanceof IrReturn)) break;
                    irElement = ((IrReturn)value2).getValue();
                }
                value2 = irElement;
            }
            IrElement irElement = value2;
            irCall = irElement instanceof IrCall ? (IrCall)irElement : null;
        } else {
            irCall = null;
        }
        IrCall lastCall = irCall;
        boolean suspendCallAtEnd = lastCall != null && org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isSuspend(lastCall);
        if (numberOfSuspendCalls.element == 0) {
            suspendFunctionKind = SuspendFunctionKind.NO_SUSPEND_CALLS.INSTANCE;
        } else if (numberOfSuspendCalls.element == 1 && suspendCallAtEnd) {
            IrCall irCall2 = lastCall;
            Intrinsics.checkNotNull(irCall2);
            suspendFunctionKind = new SuspendFunctionKind.DELEGATING(irCall2);
        } else {
            suspendFunctionKind = SuspendFunctionKind.NEEDS_STATE_MACHINE.INSTANCE;
        }
        return suspendFunctionKind;
    }

    private final void removeReturnIfSuspendedCallAndSimplifyDelegatingCall(IrFunction irFunction2, IrCall delegatingCall) {
        boolean bl;
        DeclarationIrBuilder declarationIrBuilder;
        IrExpression irExpression;
        if (this.isReturnIfSuspendedCall(delegatingCall)) {
            IrExpression irExpression2 = delegatingCall.getValueArgument(0);
            irExpression = irExpression2;
            Intrinsics.checkNotNull(irExpression2);
        } else {
            irExpression = delegatingCall;
        }
        IrExpression returnValue = irExpression;
        DeclarationIrBuilder $this$removeReturnIfSuspendedCallAndSimplifyDelegatingCall_u24lambda_u2d1 = declarationIrBuilder = LowerUtilsKt.createIrBuilder$default((BackendContext)this.context, (IrSymbol)irFunction2.getSymbol(), 0, 0, 6, null);
        boolean bl2 = false;
        IrBody irBody = irFunction2.getBody();
        if (irBody == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
        }
        List<IrStatement> statements2 = ((IrBlockBody)irBody).getStatements();
        IrStatement lastStatement = CollectionsKt.last(statements2);
        boolean bl3 = bl = Intrinsics.areEqual(lastStatement, delegatingCall) || lastStatement instanceof IrReturn;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = Intrinsics.stringPlus("Unexpected statement ", lastStatement);
            throw new AssertionError((Object)string2);
        }
        statements2.set(CollectionsKt.getLastIndex(statements2), ExpressionHelpersKt.irReturn($this$removeReturnIfSuspendedCallAndSimplifyDelegatingCall_u24lambda_u2d1, this.generateDelegatedCall($this$removeReturnIfSuspendedCallAndSimplifyDelegatingCall_u24lambda_u2d1, irFunction2.getReturnType(), returnValue)));
    }

    /*
     * WARNING - void declaration
     */
    private final IrClass buildCoroutine(IrSimpleFunction irFunction2, IrFunctionReference functionReference2) {
        BuiltCoroutine coroutine = new CoroutineBuilder(irFunction2, functionReference2).build();
        Map<IrFunction, BuiltCoroutine> map2 = this.builtCoroutines;
        map2.put(irFunction2, coroutine);
        if (functionReference2 == null) {
            void $this$buildCoroutine_u24lambda_u2d5_u24lambda_u2d4;
            Collection<IrSimpleTypeImpl> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$buildCoroutine_u24lambda_u2d5;
            void this_$iv$iv$iv;
            void startOffset$iv$iv;
            void $this$irBlockBody$iv$iv;
            DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder((BackendContext)this.context, (IrSymbol)irFunction2.getSymbol(), irFunction2.getStartOffset(), irFunction2.getEndOffset());
            IrGeneratorWithScope $this$irBlockBody$iv = irBuilder;
            boolean $i$f$irBlockBody = false;
            IrGeneratorWithScope irGeneratorWithScope = $this$irBlockBody$iv;
            int n = ((IrElement)irFunction2).getStartOffset();
            int endOffset$iv$iv = ((IrElement)irFunction2).getEndOffset();
            boolean $i$f$irBlockBody2 = false;
            IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
            boolean $i$f$blockBody = false;
            void var13_13 = this_$iv$iv$iv;
            IrSimpleFunction irSimpleFunction = irFunction2;
            boolean bl = false;
            IrConstructor constructor2 = coroutine.getCoroutineConstructor();
            Object object = irFunction2.getTypeParameters();
            IrConstructorSymbol irConstructorSymbol = constructor2.getSymbol();
            Object object2 = (IrBuilderWithScope)$this$buildCoroutine_u24lambda_u2d5;
            IrFunction irFunction3 = coroutine.getStateMachineFunction();
            void var20_21 = $this$buildCoroutine_u24lambda_u2d5;
            AbstractSuspendFunctionsLowering abstractSuspendFunctionsLowering = this;
            boolean $i$f$map22 = false;
            void var23_25 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                IrSimpleTypeImpl irSimpleTypeImpl = new IrSimpleTypeImpl(it.getSymbol(), true, CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, 16, null);
                collection.add(irSimpleTypeImpl);
            }
            collection = (List)destination$iv$iv;
            Object $i$f$map22 = object = ExpressionHelpersKt.irCallConstructor((IrBuilderWithScope)object2, irConstructorSymbol, (List<? extends IrType>)collection);
            boolean bl3 = false;
            List<IrValueParameter> functionParameters = IrUtilsKt.getExplicitParameters(irFunction2);
            Iterable $this$forEachIndexed$iv = functionParameters;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void argument2;
                int n2 = index$iv;
                index$iv = n2 + 1;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrValueParameter irValueParameter = (IrValueParameter)item$iv;
                int index2 = n2;
                boolean bl4 = false;
                $this$buildCoroutine_u24lambda_u2d5_u24lambda_u2d4.putValueArgument(index2, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildCoroutine_u24lambda_u2d5, (IrValueDeclaration)argument2));
            }
            $this$buildCoroutine_u24lambda_u2d5_u24lambda_u2d4.putValueArgument(functionParameters.size(), ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildCoroutine_u24lambda_u2d5, this.getContinuationSymbol, ((IrSimpleFunction)this.getContinuationSymbol.getOwner()).getReturnType(), CollectionsKt.listOf(irFunction2.getReturnType())));
            object2 = Unit.INSTANCE;
            abstractSuspendFunctionsLowering.generateCoroutineStart((IrBlockBodyBuilder)var20_21, irFunction3, (IrExpression)object);
            Unit unit2 = Unit.INSTANCE;
            irSimpleFunction.setBody(this_$iv$iv$iv.doBuild());
        }
        return coroutine.getCoroutineClass();
    }

    @NotNull
    public final IrField addField(@NotNull IrClass $this$addField, @NotNull Name name2, @NotNull IrType type2, boolean isMutable) {
        IrField irField;
        IrFieldBuilder irFieldBuilder;
        Intrinsics.checkNotNullParameter($this$addField, "<this>");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(type2, "type");
        IrClass klass = $this$addField;
        IrFactory $this$buildField$iv = $this$addField.getFactory();
        boolean $i$f$buildField = false;
        IrFieldBuilder $this$buildField_u24lambda_u2d4$iv = irFieldBuilder = new IrFieldBuilder();
        boolean bl = false;
        IrFieldBuilder $this$addField_u24lambda_u2d6 = $this$buildField_u24lambda_u2d4$iv;
        boolean bl2 = false;
        $this$addField_u24lambda_u2d6.setStartOffset(klass.getStartOffset());
        $this$addField_u24lambda_u2d6.setEndOffset(klass.getEndOffset());
        $this$addField_u24lambda_u2d6.setOrigin(DECLARATION_ORIGIN_COROUTINE_IMPL.INSTANCE);
        $this$addField_u24lambda_u2d6.setName(name2);
        $this$addField_u24lambda_u2d6.setType(type2);
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PRIVATE");
        $this$addField_u24lambda_u2d6.setVisibility(descriptorVisibility);
        $this$addField_u24lambda_u2d6.setFinal(!isMutable);
        IrField it = irField = DeclarationBuildersKt.buildField($this$buildField$iv, $this$buildField_u24lambda_u2d4$iv);
        boolean bl3 = false;
        it.setParent($this$addField);
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.addChild($this$addField, it);
        return irField;
    }

    public static final /* synthetic */ Symbols access$getSymbols$p(AbstractSuspendFunctionsLowering $this) {
        return $this.symbols;
    }

    public static final /* synthetic */ List access$tryTransformSuspendFunction(AbstractSuspendFunctionsLowering $this, IrElement element) {
        return $this.tryTransformSuspendFunction(element);
    }

    public static final /* synthetic */ Map access$getSuspendLambdas$p(AbstractSuspendFunctionsLowering $this) {
        return $this.suspendLambdas;
    }

    public static final /* synthetic */ Map access$getBuiltCoroutines$p(AbstractSuspendFunctionsLowering $this) {
        return $this.builtCoroutines;
    }

    static {
        Name name2 = Name.identifier("create");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"create\")");
        CREATE_IDENTIFIER = name2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c4\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$STATEMENT_ORIGIN_COROUTINE_IMPL;", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "()V", "ir.backend.common"})
    protected static final class STATEMENT_ORIGIN_COROUTINE_IMPL
    extends IrStatementOriginImpl {
        @NotNull
        public static final STATEMENT_ORIGIN_COROUTINE_IMPL INSTANCE = new STATEMENT_ORIGIN_COROUTINE_IMPL();

        private STATEMENT_ORIGIN_COROUTINE_IMPL() {
            super("COROUTINE_IMPL");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c4\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$DECLARATION_ORIGIN_COROUTINE_IMPL;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "ir.backend.common"})
    protected static final class DECLARATION_ORIGIN_COROUTINE_IMPL
    extends IrDeclarationOriginImpl {
        @NotNull
        public static final DECLARATION_ORIGIN_COROUTINE_IMPL INSTANCE = new DECLARATION_ORIGIN_COROUTINE_IMPL();

        private DECLARATION_ORIGIN_COROUTINE_IMPL() {
            super("COROUTINE_IMPL", false, 2, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$SuspendFunctionKind;", "", "()V", "DELEGATING", "NEEDS_STATE_MACHINE", "NO_SUSPEND_CALLS", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$SuspendFunctionKind$NO_SUSPEND_CALLS;", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$SuspendFunctionKind$DELEGATING;", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$SuspendFunctionKind$NEEDS_STATE_MACHINE;", "ir.backend.common"})
    private static abstract class SuspendFunctionKind {
        private SuspendFunctionKind() {
        }

        public /* synthetic */ SuspendFunctionKind(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$SuspendFunctionKind$NO_SUSPEND_CALLS;", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$SuspendFunctionKind;", "()V", "ir.backend.common"})
        public static final class NO_SUSPEND_CALLS
        extends SuspendFunctionKind {
            @NotNull
            public static final NO_SUSPEND_CALLS INSTANCE = new NO_SUSPEND_CALLS();

            private NO_SUSPEND_CALLS() {
                super(null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$SuspendFunctionKind$DELEGATING;", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$SuspendFunctionKind;", "delegatingCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)V", "getDelegatingCall", "()Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "ir.backend.common"})
        public static final class DELEGATING
        extends SuspendFunctionKind {
            @NotNull
            private final IrCall delegatingCall;

            public DELEGATING(@NotNull IrCall delegatingCall) {
                Intrinsics.checkNotNullParameter(delegatingCall, "delegatingCall");
                super(null);
                this.delegatingCall = delegatingCall;
            }

            @NotNull
            public final IrCall getDelegatingCall() {
                return this.delegatingCall;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$SuspendFunctionKind$NEEDS_STATE_MACHINE;", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$SuspendFunctionKind;", "()V", "ir.backend.common"})
        public static final class NEEDS_STATE_MACHINE
        extends SuspendFunctionKind {
            @NotNull
            public static final NEEDS_STATE_MACHINE INSTANCE = new NEEDS_STATE_MACHINE();

            private NEEDS_STATE_MACHINE() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$BuiltCoroutine;", "", "coroutineClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "coroutineConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "stateMachineFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)V", "getCoroutineClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getCoroutineConstructor", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getStateMachineFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "ir.backend.common"})
    private static final class BuiltCoroutine {
        @NotNull
        private final IrClass coroutineClass;
        @NotNull
        private final IrConstructor coroutineConstructor;
        @NotNull
        private final IrFunction stateMachineFunction;

        public BuiltCoroutine(@NotNull IrClass coroutineClass, @NotNull IrConstructor coroutineConstructor, @NotNull IrFunction stateMachineFunction) {
            Intrinsics.checkNotNullParameter(coroutineClass, "coroutineClass");
            Intrinsics.checkNotNullParameter(coroutineConstructor, "coroutineConstructor");
            Intrinsics.checkNotNullParameter(stateMachineFunction, "stateMachineFunction");
            this.coroutineClass = coroutineClass;
            this.coroutineConstructor = coroutineConstructor;
            this.stateMachineFunction = stateMachineFunction;
        }

        @NotNull
        public final IrClass getCoroutineClass() {
            return this.coroutineClass;
        }

        @NotNull
        public final IrConstructor getCoroutineConstructor() {
            return this.coroutineConstructor;
        }

        @NotNull
        public final IrFunction getStateMachineFunction() {
            return this.stateMachineFunction;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u0012J(\u0010$\u001a\u00020\u001a2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0\f2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u0012H\u0002J\u0016\u0010)\u001a\u00020\u00122\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0002J(\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003H\u0002J\u0018\u00100\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$CoroutineBuilder;", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "functionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "(Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;)V", "argumentToPropertiesMap", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "boundFunctionParameters", "", "continuationType", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "coroutineBaseClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "coroutineBaseClassConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "coroutineClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "coroutineClassThis", "coroutineConstructors", "", "create1CompletionParameter", "create1Function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "functionParameters", "getFunctionReference", "()Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "getIrFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "unboundFunctionParameters", "build", "Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$BuiltCoroutine;", "buildConstructor", "buildCreateMethod", "unboundArgs", "superFunctionSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "coroutineConstructor", "buildFactoryConstructor", "boundParams", "buildInvokeMethod", "suspendFunctionInvokeFunctionSymbol", "functionInvokeFunctionSymbol", "createFunction", "stateMachineFunction", "buildInvokeSuspendMethod", "ir.backend.common"})
    private final class CoroutineBuilder {
        @NotNull
        private final IrFunction irFunction;
        @Nullable
        private final IrFunctionReference functionReference;
        @NotNull
        private final List<IrValueParameter> functionParameters;
        @Nullable
        private final List<IrValueParameter> boundFunctionParameters;
        @Nullable
        private final List<IrValueParameter> unboundFunctionParameters;
        @NotNull
        private final IrClass coroutineClass;
        @NotNull
        private final IrValueParameter coroutineClassThis;
        @NotNull
        private final IrSimpleType continuationType;
        @NotNull
        private final Map<IrValueParameter, IrField> argumentToPropertiesMap;
        @NotNull
        private final IrClassSymbol coroutineBaseClass;
        @NotNull
        private final IrConstructor coroutineBaseClassConstructor;
        @NotNull
        private final IrSimpleFunction create1Function;
        @NotNull
        private final IrValueParameter create1CompletionParameter;
        @NotNull
        private final List<IrConstructor> coroutineConstructors;

        /*
         * WARNING - void declaration
         */
        public CoroutineBuilder(@Nullable IrFunction irFunction2, IrFunctionReference functionReference2) {
            IrFunction it;
            Iterable $this$single$iv;
            Sequence<IrConstructor> $this$associateWith$iv;
            Collection<IrTypeParameter> collection;
            Iterator $this$mapTo$iv$iv;
            void $this$map$iv;
            AbstractSuspendFunctionsLowering $this$coroutineClass_u24lambda_u2d5;
            Object $this$buildClass$iv;
            void $this$coroutineClass_u24lambda_u2d2;
            List list2;
            IrValueParameter irValueParameter;
            Iterator it2;
            Object object;
            AbstractSuspendFunctionsLowering $this$map$iv2;
            CoroutineBuilder coroutineBuilder;
            Object object2;
            List list3;
            Intrinsics.checkNotNullParameter(AbstractSuspendFunctionsLowering.this, "this$0");
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            this.irFunction = irFunction2;
            this.functionReference = functionReference2;
            this.functionParameters = IrUtilsKt.getExplicitParameters(this.irFunction);
            CoroutineBuilder coroutineBuilder2 = this;
            Object object3 = this.functionReference;
            if (object3 == null) {
                list3 = null;
            } else {
                void $this$mapTo$iv$iv2;
                object2 = IrUtilsKt.getArgumentsWithIr((IrMemberAccessExpression)object3);
                Iterable iterable = (Iterable)object2;
                coroutineBuilder = coroutineBuilder2;
                boolean $i$f$map = false;
                Iterator iterator2 = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    Pair pair = (Pair)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    irValueParameter = (IrValueParameter)((Pair)((Object)it2)).getFirst();
                    object.add(irValueParameter);
                }
                object = (List)destination$iv$iv;
                coroutineBuilder2 = coroutineBuilder;
                list3 = object;
            }
            coroutineBuilder2.boundFunctionParameters = list3;
            CoroutineBuilder coroutineBuilder3 = this;
            object3 = this.boundFunctionParameters;
            if (object3 == null) {
                list2 = null;
            } else {
                void it3;
                object2 = object3;
                $this$map$iv2 = object2;
                coroutineBuilder = coroutineBuilder3;
                boolean bl = false;
                object = CollectionsKt.minus((Iterable)this.functionParameters, (Iterable)it3);
                coroutineBuilder3 = coroutineBuilder;
                list2 = object;
            }
            coroutineBuilder3.unboundFunctionParameters = list2;
            object3 = AbstractSuspendFunctionsLowering.this.getContext().getIrFactory();
            object2 = AbstractSuspendFunctionsLowering.this;
            boolean $i$f$buildClass = false;
            Object bl = new IrClassBuilder();
            IrClassBuilder $this$buildClass_u24lambda_u2d1$iv = bl;
            boolean bl2 = false;
            IrClassBuilder $i$f$mapTo = $this$buildClass_u24lambda_u2d1$iv;
            coroutineBuilder = this;
            boolean bl3 = false;
            $this$coroutineClass_u24lambda_u2d2.setStartOffset(this.getIrFunction().getStartOffset());
            $this$coroutineClass_u24lambda_u2d2.setEndOffset(this.getIrFunction().getEndOffset());
            $this$coroutineClass_u24lambda_u2d2.setOrigin(DECLARATION_ORIGIN_COROUTINE_IMPL.INSTANCE);
            $this$coroutineClass_u24lambda_u2d2.setName(((AbstractSuspendFunctionsLowering)object2).nameForCoroutineClass(this.getIrFunction()));
            $this$coroutineClass_u24lambda_u2d2.setVisibility(this.getIrFunction().getVisibility());
            object = Unit.INSTANCE;
            $this$buildClass$iv = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, $this$buildClass_u24lambda_u2d1$iv);
            object2 = $this$buildClass$iv;
            boolean bl4 = false;
            $this$coroutineClass_u24lambda_u2d5.setParent(this.getIrFunction().getParent());
            org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createParameterDeclarations((IrClass)((Object)$this$coroutineClass_u24lambda_u2d5));
            bl = this.getIrFunction().getTypeParameters();
            $this$buildClass_u24lambda_u2d1$iv = $this$coroutineClass_u24lambda_u2d5;
            boolean $i$f$map = false;
            $this$coroutineClass_u24lambda_u2d2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo22 = false;
            it2 = $this$mapTo$iv$iv.iterator();
            while (it2.hasNext()) {
                void typeParam;
                IrTypeParameter irTypeParameter2;
                Object item$iv$iv = it2.next();
                IrTypeParameter irTypeParameter3 = (IrTypeParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                IrTypeParameter $this$coroutineClass_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3 = irTypeParameter2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyToWithoutSuperTypes$default((IrTypeParameter)typeParam, (IrTypeParametersContainer)((Object)$this$coroutineClass_u24lambda_u2d5), 0, null, 6, null);
                boolean bl6 = false;
                IrTypeParameter irTypeParameter4 = $this$coroutineClass_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3;
                irTypeParameter4.setSuperTypes(CollectionsKt.plus((Collection)irTypeParameter4.getSuperTypes(), (Iterable)typeParam.getSuperTypes()));
                IrTypeParameter irTypeParameter5 = irTypeParameter2;
                collection.add(irTypeParameter5);
            }
            collection = (List)destination$iv$iv;
            $this$buildClass_u24lambda_u2d1$iv.setTypeParameters((List<? extends IrTypeParameter>)collection);
            object = Unit.INSTANCE;
            coroutineBuilder.coroutineClass = $this$buildClass$iv;
            IrValueParameter irValueParameter2 = this.coroutineClass.getThisReceiver();
            Intrinsics.checkNotNull(irValueParameter2);
            this.coroutineClassThis = irValueParameter2;
            $this$buildClass$iv = new IrType[]{this.irFunction.getReturnType()};
            this.continuationType = IrTypesKt.typeWith((IrClassifierSymbol)AbstractSuspendFunctionsLowering.this.continuationClassSymbol, $this$buildClass$iv);
            $this$buildClass$iv = this.functionParameters;
            $this$coroutineClass_u24lambda_u2d5 = AbstractSuspendFunctionsLowering.this;
            coroutineBuilder = this;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it4;
                IrValueParameter $i$f$mapTo22 = (IrValueParameter)element$iv$iv;
                irValueParameter = element$iv$iv;
                object = result$iv;
                boolean bl7 = false;
                IrField irField = $this$coroutineClass_u24lambda_u2d5.addField(this.coroutineClass, it4.getName(), it4.getType(), false);
                object.put(irValueParameter, irField);
            }
            coroutineBuilder.argumentToPropertiesMap = object = (Map)result$iv;
            this.coroutineBaseClass = AbstractSuspendFunctionsLowering.this.getCoroutineBaseClass(this.irFunction);
            $this$associateWith$iv = IrUtilsKt.getConstructors((IrClass)this.coroutineBaseClass.getOwner());
            coroutineBuilder = this;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                it = (IrConstructor)element$iv;
                boolean bl8 = false;
                if (!(it.getValueParameters().size() == 1)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            object = single$iv;
            coroutineBuilder.coroutineBaseClassConstructor = (IrConstructor)object;
            $this$single$iv = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.simpleFunctions((IrDeclarationContainer)this.coroutineBaseClass.getOwner());
            coroutineBuilder = this;
            $i$f$single = false;
            single$iv = null;
            found$iv = false;
            for (Object element$iv : $this$single$iv) {
                it = (IrSimpleFunction)element$iv;
                boolean bl9 = false;
                if (!(Intrinsics.areEqual(it.getName(), CREATE_IDENTIFIER) && it.getValueParameters().size() == 1)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            object = single$iv;
            coroutineBuilder.create1Function = (IrSimpleFunction)object;
            this.create1CompletionParameter = this.create1Function.getValueParameters().get(0);
            this.coroutineConstructors = new ArrayList();
        }

        @NotNull
        public final IrFunction getIrFunction() {
            return this.irFunction;
        }

        @Nullable
        public final IrFunctionReference getFunctionReference() {
            return this.functionReference;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @NotNull
        public final BuiltCoroutine build() {
            block14: {
                var2_1 = new IrType[]{IrTypesKt.getDefaultType(this.coroutineBaseClass)};
                superTypes = CollectionsKt.mutableListOf(var2_1);
                suspendFunctionClass = null;
                functionClass = null;
                suspendFunctionClassTypeArguments = null;
                functionClassTypeArguments = null;
                if (this.unboundFunctionParameters != null) {
                    numberOfParameters = this.unboundFunctionParameters.size();
                    suspendFunctionClass = (IrClass)AbstractSuspendFunctionsLowering.access$getSymbols$p(AbstractSuspendFunctionsLowering.this).suspendFunctionN(numberOfParameters).getOwner();
                    $this$map$iv = this.unboundFunctionParameters;
                    $i$f$map = false;
                    var10_11 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var15_21 = (IrValueParameter)item$iv$iv;
                        var24_25 = destination$iv$iv;
                        $i$a$-map-AbstractSuspendFunctionsLowering$CoroutineBuilder$build$unboundParameterTypes$1 = false;
                        var25_26 = it.getType();
                        var24_25.add(var25_26);
                    }
                    unboundParameterTypes = (List)destination$iv$iv;
                    suspendFunctionClassTypeArguments = CollectionsKt.plus((Collection)unboundParameterTypes, this.irFunction.getReturnType());
                    ((Collection)superTypes).add(IrTypesKt.typeWith(suspendFunctionClass, suspendFunctionClassTypeArguments));
                    functionClass = (IrClass)AbstractSuspendFunctionsLowering.access$getSymbols$p(AbstractSuspendFunctionsLowering.this).functionN(numberOfParameters + 1).getOwner();
                    functionClassTypeArguments = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)unboundParameterTypes, this.continuationType), AbstractSuspendFunctionsLowering.this.getContext().getIrBuiltIns().getAnyNType());
                    ((Collection)superTypes).add(IrTypesKt.typeWith(functionClass, functionClassTypeArguments));
                }
                coroutineConstructor = this.buildConstructor();
                $this$map$iv = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.simpleFunctions((IrDeclarationContainer)this.coroutineBaseClass.getOwner());
                $i$f$map = AbstractSuspendFunctionsLowering.this;
                $i$f$single = false;
                single$iv = null;
                found$iv = false;
                for (T element$iv : $this$single$iv) {
                    it = (IrSimpleFunction)element$iv;
                    $i$a$-single-AbstractSuspendFunctionsLowering$CoroutineBuilder$build$superInvokeSuspendFunction$1 = false;
                    if (!Intrinsics.areEqual(it.getName(), $i$f$map.getStateMachineMethodName())) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                superInvokeSuspendFunction = single$iv;
                invokeSuspendMethod = this.buildInvokeSuspendMethod(superInvokeSuspendFunction, this.coroutineClass);
                coroutineFactoryConstructor = null;
                createMethod = null;
                if (this.functionReference == null) break block14;
                v0 = this.boundFunctionParameters;
                Intrinsics.checkNotNull(v0);
                coroutineFactoryConstructor = this.buildFactoryConstructor(v0);
                var13_17 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.simpleFunctions((IrDeclarationContainer)this.coroutineBaseClass.getOwner());
                $i$f$atMostOne = false;
                $this$filter$iv$iv = $this$atMostOne$iv;
                $i$f$filter = false;
                var17_28 = $this$filter$iv$iv;
                destination$iv$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                var20_34 = $this$filterTo$iv$iv$iv.iterator();
                while (var20_34.hasNext()) {
                    element$iv$iv$iv = var20_34.next();
                    it = (IrSimpleFunction)element$iv$iv$iv;
                    $i$a$-atMostOne-AbstractSuspendFunctionsLowering$CoroutineBuilder$build$createFunctionSymbol$1 = false;
                    if (!Intrinsics.areEqual(it.getName(), AbstractSuspendFunctionsLowering.access$getCREATE_IDENTIFIER$cp())) ** GOTO lbl-1000
                    v1 = it.getValueParameters().size();
                    v2 = this.unboundFunctionParameters;
                    Intrinsics.checkNotNull(v2);
                    if (v1 == v2.size() + 1) {
                        v3 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = false;
                    }
                    if (!v3) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv);
                }
                found$iv = (IrSimpleFunction)CollectionUtilKt.atMostOne((List)destination$iv$iv$iv);
                createFunctionSymbol = found$iv == null ? null : found$iv.getSymbol();
                v4 = this.unboundFunctionParameters;
                Intrinsics.checkNotNull(v4);
                createMethod = this.buildCreateMethod(v4, createFunctionSymbol, coroutineConstructor);
                v5 = functionClass;
                Intrinsics.checkNotNull(v5);
                $this$single$iv = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.simpleFunctions(v5);
                $i$f$single = false;
                single$iv = null;
                found$iv = false;
                for (T element$iv : $this$single$iv) {
                    it = (IrSimpleFunction)element$iv;
                    $i$a$-single-AbstractSuspendFunctionsLowering$CoroutineBuilder$build$invokeFunctionSymbol$1 = false;
                    if (!Intrinsics.areEqual(it.getName(), OperatorNameConventions.INVOKE)) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                invokeFunctionSymbol = ((IrSimpleFunction)single$iv).getSymbol();
                v6 = suspendFunctionClass;
                Intrinsics.checkNotNull(v6);
                $this$single$iv = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.simpleFunctions(v6);
                $i$f$single = false;
                single$iv = null;
                found$iv = false;
                for (T element$iv : $this$single$iv) {
                    it = (IrSimpleFunction)element$iv;
                    $i$a$-single-AbstractSuspendFunctionsLowering$CoroutineBuilder$build$suspendInvokeFunctionSymbol$1 = false;
                    if (!Intrinsics.areEqual(it.getName(), OperatorNameConventions.INVOKE)) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                suspendInvokeFunctionSymbol = ((IrSimpleFunction)single$iv).getSymbol();
                this.buildInvokeMethod(suspendInvokeFunctionSymbol, invokeFunctionSymbol, createMethod, invokeSuspendMethod);
            }
            var11_14 /* !! */  = this.coroutineClass;
            var11_14 /* !! */ .setSuperTypes(CollectionsKt.plus((Collection)var11_14 /* !! */ .getSuperTypes(), (Iterable)superTypes));
            org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.addFakeOverrides$default(this.coroutineClass, AbstractSuspendFunctionsLowering.this.getContext().getTypeSystem(), null, 2, null);
            AbstractSuspendFunctionsLowering.this.initializeStateMachine(this.coroutineConstructors, this.coroutineClassThis);
            var11_14 /* !! */  = coroutineFactoryConstructor;
            return new BuiltCoroutine(this.coroutineClass, (IrConstructor)(var11_14 /* !! */  == null ? coroutineConstructor : var11_14 /* !! */ ), invokeSuspendMethod);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IrConstructor buildConstructor() {
            void $this$buildConstructor_u24lambda_u2d19_u24lambda_u2d18_u24lambda_u2d16;
            void $this$buildConstructor_u24lambda_u2d19_u24lambda_u2d18;
            IrDelegatingConstructorCall irDelegatingConstructorCall2;
            void this_$iv$iv;
            Object object;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            IrFunctionBuilder irFunctionBuilder;
            IrFactory $this$buildConstructor$iv = AbstractSuspendFunctionsLowering.this.getContext().getIrFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u2d20$iv = irFunctionBuilder = new IrFunctionBuilder();
            boolean $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22 = false;
            Object $this$buildConstructor_u24lambda_u2d14 = $this$buildConstructor_u24lambda_u2d20$iv;
            boolean bl = false;
            ((IrElementBuilder)$this$buildConstructor_u24lambda_u2d14).setStartOffset(this.getIrFunction().getStartOffset());
            ((IrElementBuilder)$this$buildConstructor_u24lambda_u2d14).setEndOffset(this.getIrFunction().getEndOffset());
            ((IrDeclarationBuilder)$this$buildConstructor_u24lambda_u2d14).setOrigin(DECLARATION_ORIGIN_COROUTINE_IMPL.INSTANCE);
            ((IrDeclarationBuilder)$this$buildConstructor_u24lambda_u2d14).setVisibility(this.getIrFunction().getVisibility());
            ((IrFunctionBuilder)$this$buildConstructor_u24lambda_u2d14).setReturnType(IrUtilsKt.getDefaultType(this.coroutineClass));
            ((IrFunctionBuilder)$this$buildConstructor_u24lambda_u2d14).setPrimary(true);
            IrConstructor irConstructor2 = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv, $this$buildConstructor_u24lambda_u2d20$iv);
            AbstractSuspendFunctionsLowering abstractSuspendFunctionsLowering = AbstractSuspendFunctionsLowering.this;
            IrConstructor $this$buildConstructor_u24lambda_u2d19 = irConstructor2;
            boolean bl2 = false;
            $this$buildConstructor_u24lambda_u2d19.setParent(this.coroutineClass);
            Object $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22 = this.coroutineClass;
            $this$buildConstructor_u24lambda_u2d14 = $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22.getDeclarations();
            $this$buildConstructor_u24lambda_u2d14.add($this$buildConstructor_u24lambda_u2d19);
            $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22 = this;
            $this$buildConstructor_u24lambda_u2d14 = ((CoroutineBuilder)$i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22).coroutineConstructors;
            $this$buildConstructor_u24lambda_u2d14.add($this$buildConstructor_u24lambda_u2d19);
            $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22 = this.functionParameters;
            IrConstructor irConstructor3 = $this$buildConstructor_u24lambda_u2d19;
            boolean $i$f$mapIndexed22 = false;
            void var8_14 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index2;
                void parameter;
                int n = index$iv$iv;
                index$iv$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                int n2 = n;
                object = destination$iv$iv;
                boolean irDelegatingConstructorCall2 = false;
                IrValueParameter irValueParameter2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)parameter, $this$buildConstructor_u24lambda_u2d19, DECLARATION_ORIGIN_COROUTINE_IMPL.INSTANCE, (int)index2, 0, 0, null, null, null, null, null, false, false, false, 8184, null);
                object.add(irValueParameter2);
            }
            object = (List)destination$iv$iv;
            irConstructor3.setValueParameters((List<? extends IrValueParameter>)object);
            IrValueParameter continuationParameter = this.coroutineBaseClassConstructor.getValueParameters().get(0);
            IrConstructor $i$f$mapIndexed22 = $this$buildConstructor_u24lambda_u2d19;
            $i$f$mapIndexed22.setValueParameters(CollectionsKt.plus((Collection)$i$f$mapIndexed22.getValueParameters(), org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(continuationParameter, $this$buildConstructor_u24lambda_u2d19, DECLARATION_ORIGIN_COROUTINE_IMPL.INSTANCE, $this$buildConstructor_u24lambda_u2d19.getValueParameters().size(), 0, 0, null, null, this.continuationType, null, null, false, false, false, 8056, null)));
            DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder((BackendContext)abstractSuspendFunctionsLowering.getContext(), (IrSymbol)$this$buildConstructor_u24lambda_u2d19.getSymbol(), $this$buildConstructor_u24lambda_u2d19.getStartOffset(), $this$buildConstructor_u24lambda_u2d19.getEndOffset());
            IrBuilderWithScope $this$irBlockBody_u24default$iv = irBuilder;
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void var14_23 = this_$iv$iv;
            irConstructor3 = $this$buildConstructor_u24lambda_u2d19;
            boolean bl3 = false;
            IrValueParameter completionParameter = CollectionsKt.last($this$buildConstructor_u24lambda_u2d19.getValueParameters());
            IrDelegatingConstructorCall irDelegatingConstructorCall3 = irDelegatingConstructorCall2 = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$buildConstructor_u24lambda_u2d19_u24lambda_u2d18, this.coroutineBaseClassConstructor);
            void var21_34 = $this$buildConstructor_u24lambda_u2d19_u24lambda_u2d18;
            boolean bl4 = false;
            $this$buildConstructor_u24lambda_u2d19_u24lambda_u2d18_u24lambda_u2d16.putValueArgument(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildConstructor_u24lambda_u2d19_u24lambda_u2d18, completionParameter));
            Unit unit2 = Unit.INSTANCE;
            var21_34.unaryPlus(irDelegatingConstructorCall2);
            $this$buildConstructor_u24lambda_u2d19_u24lambda_u2d18.unaryPlus(new IrInstanceInitializerCallImpl($this$buildConstructor_u24lambda_u2d19_u24lambda_u2d18.getStartOffset(), $this$buildConstructor_u24lambda_u2d19_u24lambda_u2d18.getEndOffset(), this.coroutineClass.getSymbol(), $this$buildConstructor_u24lambda_u2d19_u24lambda_u2d18.getContext().getIrBuiltIns().getUnitType()));
            Iterable $this$forEachIndexed$iv = this.functionParameters;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void parameter;
                int n = index$iv;
                index$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrValueParameter irValueParameter = (IrValueParameter)item$iv;
                int index3 = n;
                boolean bl5 = false;
                $this$buildConstructor_u24lambda_u2d19_u24lambda_u2d18.unaryPlus(ExpressionHelpersKt.irSetField((IrBuilderWithScope)$this$buildConstructor_u24lambda_u2d19_u24lambda_u2d18, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildConstructor_u24lambda_u2d19_u24lambda_u2d18, this.coroutineClassThis), MapsKt.getValue(this.argumentToPropertiesMap, parameter), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildConstructor_u24lambda_u2d19_u24lambda_u2d18, $this$buildConstructor_u24lambda_u2d19.getValueParameters().get(index3))));
            }
            object = Unit.INSTANCE;
            irConstructor3.setBody(this_$iv$iv.doBuild());
            return irConstructor2;
        }

        /*
         * WARNING - void declaration
         */
        private final IrConstructor buildFactoryConstructor(List<? extends IrValueParameter> boundParams) {
            void $this$buildFactoryConstructor_u24lambda_u2d25_u24lambda_u2d24_u24lambda_u2d22;
            void $this$buildFactoryConstructor_u24lambda_u2d25_u24lambda_u2d24;
            void this_$iv$iv;
            IrDelegatingConstructorCall parameter;
            Object object;
            Object item$iv$iv2;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            IrFunctionBuilder irFunctionBuilder;
            IrFactory $this$buildConstructor$iv = AbstractSuspendFunctionsLowering.this.getContext().getIrFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u2d20$iv = irFunctionBuilder = new IrFunctionBuilder();
            boolean $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22 = false;
            Object $this$buildFactoryConstructor_u24lambda_u2d20 = $this$buildConstructor_u24lambda_u2d20$iv;
            boolean bl = false;
            ((IrElementBuilder)$this$buildFactoryConstructor_u24lambda_u2d20).setStartOffset(this.getIrFunction().getStartOffset());
            ((IrElementBuilder)$this$buildFactoryConstructor_u24lambda_u2d20).setEndOffset(this.getIrFunction().getEndOffset());
            ((IrDeclarationBuilder)$this$buildFactoryConstructor_u24lambda_u2d20).setOrigin(DECLARATION_ORIGIN_COROUTINE_IMPL.INSTANCE);
            ((IrDeclarationBuilder)$this$buildFactoryConstructor_u24lambda_u2d20).setVisibility(this.getIrFunction().getVisibility());
            ((IrFunctionBuilder)$this$buildFactoryConstructor_u24lambda_u2d20).setReturnType(IrUtilsKt.getDefaultType(this.coroutineClass));
            IrConstructor irConstructor2 = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv, $this$buildConstructor_u24lambda_u2d20$iv);
            AbstractSuspendFunctionsLowering abstractSuspendFunctionsLowering = AbstractSuspendFunctionsLowering.this;
            IrConstructor $this$buildFactoryConstructor_u24lambda_u2d25 = irConstructor2;
            boolean bl2 = false;
            $this$buildFactoryConstructor_u24lambda_u2d25.setParent(this.coroutineClass);
            Object $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22 = this.coroutineClass;
            $this$buildFactoryConstructor_u24lambda_u2d20 = $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22.getDeclarations();
            $this$buildFactoryConstructor_u24lambda_u2d20.add($this$buildFactoryConstructor_u24lambda_u2d25);
            $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22 = this;
            $this$buildFactoryConstructor_u24lambda_u2d20 = ((CoroutineBuilder)$i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22).coroutineConstructors;
            $this$buildFactoryConstructor_u24lambda_u2d20.add($this$buildFactoryConstructor_u24lambda_u2d25);
            $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22 = boundParams;
            IrConstructor irConstructor3 = $this$buildFactoryConstructor_u24lambda_u2d25;
            boolean $i$f$mapIndexed = false;
            void var9_15 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv22 = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
                void index2;
                int n = index$iv$iv22;
                index$iv$iv22 = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv2;
                int n2 = n;
                object = destination$iv$iv;
                boolean bl3 = false;
                IrValueParameter irValueParameter2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)((Object)parameter), $this$buildFactoryConstructor_u24lambda_u2d25, DECLARATION_ORIGIN_COROUTINE_IMPL.INSTANCE, (int)index2, 0, 0, null, null, null, null, null, false, false, false, 8184, null);
                object.add(irValueParameter2);
            }
            object = (List)destination$iv$iv;
            irConstructor3.setValueParameters((List<? extends IrValueParameter>)object);
            DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder((BackendContext)abstractSuspendFunctionsLowering.getContext(), (IrSymbol)$this$buildFactoryConstructor_u24lambda_u2d25.getSymbol(), $this$buildFactoryConstructor_u24lambda_u2d25.getStartOffset(), $this$buildFactoryConstructor_u24lambda_u2d25.getEndOffset());
            IrBuilderWithScope $this$irBlockBody_u24default$iv = irBuilder;
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder index$iv$iv22 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            item$iv$iv2 = this_$iv$iv;
            irConstructor3 = $this$buildFactoryConstructor_u24lambda_u2d25;
            boolean bl4 = false;
            IrDelegatingConstructorCall index2 = parameter = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$buildFactoryConstructor_u24lambda_u2d25_u24lambda_u2d24, this.coroutineBaseClassConstructor);
            void var19_32 = $this$buildFactoryConstructor_u24lambda_u2d25_u24lambda_u2d24;
            boolean bl5 = false;
            $this$buildFactoryConstructor_u24lambda_u2d25_u24lambda_u2d24_u24lambda_u2d22.putValueArgument(0, ExpressionHelpersKt.irNull((IrBuilderWithScope)$this$buildFactoryConstructor_u24lambda_u2d25_u24lambda_u2d24));
            Unit unit2 = Unit.INSTANCE;
            var19_32.unaryPlus(parameter);
            $this$buildFactoryConstructor_u24lambda_u2d25_u24lambda_u2d24.unaryPlus(new IrInstanceInitializerCallImpl($this$buildFactoryConstructor_u24lambda_u2d25_u24lambda_u2d24.getStartOffset(), $this$buildFactoryConstructor_u24lambda_u2d25_u24lambda_u2d24.getEndOffset(), this.coroutineClass.getSymbol(), $this$buildFactoryConstructor_u24lambda_u2d25_u24lambda_u2d24.getContext().getIrBuiltIns().getUnitType()));
            Iterable $this$forEachIndexed$iv = boundParams;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void parameter2;
                int n = index$iv;
                index$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrValueParameter irValueParameter = (IrValueParameter)item$iv;
                int index3 = n;
                boolean bl6 = false;
                $this$buildFactoryConstructor_u24lambda_u2d25_u24lambda_u2d24.unaryPlus(ExpressionHelpersKt.irSetField((IrBuilderWithScope)$this$buildFactoryConstructor_u24lambda_u2d25_u24lambda_u2d24, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildFactoryConstructor_u24lambda_u2d25_u24lambda_u2d24, this.coroutineClassThis), MapsKt.getValue(this.argumentToPropertiesMap, parameter2), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildFactoryConstructor_u24lambda_u2d25_u24lambda_u2d24, $this$buildFactoryConstructor_u24lambda_u2d25.getValueParameters().get(index3))));
            }
            object = Unit.INSTANCE;
            irConstructor3.setBody(this_$iv$iv.doBuild());
            return irConstructor2;
        }

        /*
         * WARNING - void declaration
         */
        private final IrSimpleFunction buildCreateMethod(List<? extends IrValueParameter> unboundArgs, IrSimpleFunctionSymbol superFunctionSymbol, IrConstructor coroutineConstructor) {
            boolean bl;
            void $this$buildCreateMethod_u24lambda_u2d36_u24lambda_u2d35_u24lambda_u2d34;
            void $this$forEachIndexed$iv;
            void $this$mapTo$iv$iv;
            void $this$buildCreateMethod_u24lambda_u2d36_u24lambda_u2d35;
            IrFunctionAccessExpression irFunctionAccessExpression;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlockBody$iv;
            Object it;
            void $this$mapIndexedTo$iv$iv;
            IrSimpleFunctionSymbol $this$mapIndexed$iv;
            IrDeclarationBase irDeclarationBase;
            Object object;
            IrDeclarationBase irDeclarationBase2;
            int n2;
            Object object2;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv;
            IrFunctionBuilder irFunctionBuilder;
            IrFactory $this$buildFun$iv = AbstractSuspendFunctionsLowering.this.getContext().getIrFactory();
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv = irFunctionBuilder = new IrFunctionBuilder();
            boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = false;
            Object $this$buildCreateMethod_u24lambda_u2d26 = $this$buildFun_u24lambda_u2d16$iv;
            boolean bl2 = false;
            ((IrElementBuilder)$this$buildCreateMethod_u24lambda_u2d26).setStartOffset(this.getIrFunction().getStartOffset());
            ((IrElementBuilder)$this$buildCreateMethod_u24lambda_u2d26).setEndOffset(this.getIrFunction().getEndOffset());
            ((IrDeclarationBuilder)$this$buildCreateMethod_u24lambda_u2d26).setOrigin(DECLARATION_ORIGIN_COROUTINE_IMPL.INSTANCE);
            ((IrDeclarationBuilder)$this$buildCreateMethod_u24lambda_u2d26).setName(CREATE_IDENTIFIER);
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PROTECTED;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PROTECTED");
            ((IrDeclarationBuilder)$this$buildCreateMethod_u24lambda_u2d26).setVisibility(descriptorVisibility);
            ((IrFunctionBuilder)$this$buildCreateMethod_u24lambda_u2d26).setReturnType(IrUtilsKt.getDefaultType(this.coroutineClass));
            IrSimpleFunction irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2d16$iv);
            AbstractSuspendFunctionsLowering abstractSuspendFunctionsLowering = AbstractSuspendFunctionsLowering.this;
            IrSimpleFunction $this$buildCreateMethod_u24lambda_u2d36 = irSimpleFunction;
            boolean bl3 = false;
            $this$buildCreateMethod_u24lambda_u2d36.setParent(this.coroutineClass);
            Object $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = this.coroutineClass;
            $this$buildCreateMethod_u24lambda_u2d26 = $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22.getDeclarations();
            $this$buildCreateMethod_u24lambda_u2d26.add($this$buildCreateMethod_u24lambda_u2d36);
            $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = this.getIrFunction().getTypeParameters();
            IrSimpleFunction irSimpleFunction2 = $this$buildCreateMethod_u24lambda_u2d36;
            boolean $i$f$map = false;
            descriptorVisibility = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void parameter;
                IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv$iv2;
                object2 = destination$iv$iv;
                n2 = 0;
                IrTypeParameter $this$buildCreateMethod_u24lambda_u2d36_u24lambda_u2d28_u24lambda_u2d27 = irDeclarationBase2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyToWithoutSuperTypes$default((IrTypeParameter)parameter, $this$buildCreateMethod_u24lambda_u2d36, 0, DECLARATION_ORIGIN_COROUTINE_IMPL.INSTANCE, 2, null);
                boolean bl4 = false;
                object = $this$buildCreateMethod_u24lambda_u2d36_u24lambda_u2d28_u24lambda_u2d27;
                ((IrTypeParameter)object).setSuperTypes(CollectionsKt.plus((Collection)((IrTypeParameter)object).getSuperTypes(), (Iterable)parameter.getSuperTypes()));
                irDeclarationBase = irDeclarationBase2;
                object2.add(irDeclarationBase);
            }
            object2 = (List)destination$iv$iv;
            irSimpleFunction2.setTypeParameters((List<? extends IrTypeParameter>)object2);
            $this$map$iv = CollectionsKt.plus((Collection)unboundArgs, this.create1CompletionParameter);
            irSimpleFunction2 = $this$buildCreateMethod_u24lambda_u2d36;
            boolean $i$f$mapIndexed2 = false;
            $this$mapTo$iv$iv2 = $this$mapIndexed$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo2 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv3 : $this$mapIndexedTo$iv$iv) {
                void index2;
                void parameter;
                n2 = index$iv$iv;
                index$iv$iv = n2 + 1;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                irDeclarationBase2 = (IrValueParameter)item$iv$iv3;
                int $this$buildCreateMethod_u24lambda_u2d36_u24lambda_u2d28_u24lambda_u2d27 = n2;
                object2 = destination$iv$iv;
                boolean bl5 = false;
                irDeclarationBase = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)parameter, $this$buildCreateMethod_u24lambda_u2d36, DECLARATION_ORIGIN_COROUTINE_IMPL.INSTANCE, (int)index2, 0, 0, null, null, null, null, null, false, false, false, 8184, null);
                object2.add(irDeclarationBase);
            }
            object2 = (List)destination$iv$iv;
            irSimpleFunction2.setValueParameters((List<? extends IrValueParameter>)object2);
            org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createDispatchReceiverParameter$default($this$buildCreateMethod_u24lambda_u2d36, null, 1, null);
            $this$mapIndexed$iv = superFunctionSymbol;
            if ($this$mapIndexed$iv != null) {
                IrSimpleFunctionSymbol $i$f$mapIndexed2 = $this$mapIndexed$iv;
                it = $i$f$mapIndexed2;
                boolean bl6 = false;
                IrSimpleFunction $i$f$mapIndexedTo2 = $this$buildCreateMethod_u24lambda_u2d36;
                $i$f$mapIndexedTo2.setOverriddenSymbols(CollectionsKt.plus((Collection)$i$f$mapIndexedTo2.getOverriddenSymbols(), (Iterable)((IrSimpleFunction)it.getOwner()).getOverriddenSymbols()));
                $i$f$mapIndexedTo2 = $this$buildCreateMethod_u24lambda_u2d36;
                $i$f$mapIndexedTo2.setOverriddenSymbols(CollectionsKt.plus((Collection)$i$f$mapIndexedTo2.getOverriddenSymbols(), it));
            }
            IrValueParameter irValueParameter = $this$buildCreateMethod_u24lambda_u2d36.getDispatchReceiverParameter();
            Intrinsics.checkNotNull(irValueParameter);
            IrValueParameter thisReceiver2 = irValueParameter;
            DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder((BackendContext)abstractSuspendFunctionsLowering.getContext(), (IrSymbol)$this$buildCreateMethod_u24lambda_u2d36.getSymbol(), $this$buildCreateMethod_u24lambda_u2d36.getStartOffset(), $this$buildCreateMethod_u24lambda_u2d36.getEndOffset());
            it = irBuilder;
            int bl6 = $this$buildCreateMethod_u24lambda_u2d36.getStartOffset();
            int endOffset$iv = $this$buildCreateMethod_u24lambda_u2d36.getEndOffset();
            boolean $i$f$irBlockBody = false;
            item$iv$iv2 = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void n2 = this_$iv$iv;
            irSimpleFunction2 = $this$buildCreateMethod_u24lambda_u2d36;
            boolean bl7 = false;
            IrFunctionAccessExpression bl5 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildCreateMethod_u24lambda_u2d36_u24lambda_u2d35, coroutineConstructor);
            object = (IrBuilderWithScope)$this$buildCreateMethod_u24lambda_u2d36_u24lambda_u2d35;
            void var24_42 = $this$buildCreateMethod_u24lambda_u2d36_u24lambda_u2d35;
            boolean bl8 = false;
            int unboundIndex = 0;
            Set unboundArgsSet = CollectionsKt.toSet((Iterable)unboundArgs);
            Iterable $this$map$iv2 = this.functionParameters;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv4 : $this$mapTo$iv$iv) {
                IrDeclarationReference irDeclarationReference;
                void it2;
                IrValueParameter irValueParameter2 = (IrValueParameter)item$iv$iv4;
                Collection collection = destination$iv$iv2;
                boolean bl9 = false;
                if (unboundArgsSet.contains(it2)) {
                    int n3 = unboundIndex;
                    unboundIndex = n3 + 1;
                    irDeclarationReference = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildCreateMethod_u24lambda_u2d36_u24lambda_u2d35, $this$buildCreateMethod_u24lambda_u2d36.getValueParameters().get(n3));
                } else {
                    irDeclarationReference = ExpressionHelpersKt.irGetField((IrBuilderWithScope)$this$buildCreateMethod_u24lambda_u2d36_u24lambda_u2d35, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildCreateMethod_u24lambda_u2d36_u24lambda_u2d35, thisReceiver2), MapsKt.getValue(this.argumentToPropertiesMap, it2));
                }
                IrDeclarationReference irDeclarationReference2 = irDeclarationReference;
                collection.add(irDeclarationReference2);
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void argument2;
                Object item$iv$iv4;
                int n4 = index$iv;
                index$iv = n4 + 1;
                if (n4 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                item$iv$iv4 = (IrDeclarationReference)item$iv;
                int index3 = n4;
                boolean bl10 = false;
                $this$buildCreateMethod_u24lambda_u2d36_u24lambda_u2d35_u24lambda_u2d34.putValueArgument(index3, (IrExpression)argument2);
            }
            $this$buildCreateMethod_u24lambda_u2d36_u24lambda_u2d35_u24lambda_u2d34.putValueArgument(this.functionParameters.size(), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildCreateMethod_u24lambda_u2d36_u24lambda_u2d35, $this$buildCreateMethod_u24lambda_u2d36.getValueParameters().get(unboundIndex)));
            boolean bl11 = bl = unboundIndex == $this$buildCreateMethod_u24lambda_u2d36.getValueParameters().size() - 1;
            if (_Assertions.ENABLED && !bl) {
                boolean bl12 = false;
                String string2 = "Not all arguments of <create> are used";
                throw new AssertionError((Object)string2);
            }
            Unit unit2 = Unit.INSTANCE;
            var24_42.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)object, irFunctionAccessExpression));
            object2 = Unit.INSTANCE;
            irSimpleFunction2.setBody(this_$iv$iv.doBuild());
            return irSimpleFunction;
        }

        /*
         * WARNING - void declaration
         */
        private final IrSimpleFunction buildInvokeMethod(IrSimpleFunctionSymbol suspendFunctionInvokeFunctionSymbol, IrSimpleFunctionSymbol functionInvokeFunctionSymbol, IrFunction createFunction2, IrFunction stateMachineFunction) {
            void $this$buildInvokeMethod_u24lambda_u2d44_u24lambda_u2d43_u24lambda_u2d42;
            void $this$buildInvokeMethod_u24lambda_u2d44_u24lambda_u2d43;
            IrFunctionAccessExpression irFunctionAccessExpression;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlockBody$iv;
            IrBuilderWithScope $this$mapIndexedTo$iv$iv;
            Object $this$mapIndexed$iv;
            IrDeclarationBase irDeclarationBase;
            IrDeclarationBase irDeclarationBase2;
            IrDeclarationBase irDeclarationBase3;
            int n2;
            Object object;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$buildFun$iv;
            Object object2 = AbstractSuspendFunctionsLowering.this.getContext().getIrFactory();
            AbstractSuspendFunctionsLowering abstractSuspendFunctionsLowering = AbstractSuspendFunctionsLowering.this;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
            Object $this$buildFun_u24lambda_u2d16$iv = irFunctionBuilder;
            boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = false;
            IrFunctionBuilder $this$buildInvokeMethod_u24lambda_u2d37 = $this$buildFun_u24lambda_u2d16$iv;
            boolean $i$a$-buildFun-AbstractSuspendFunctionsLowering$CoroutineBuilder$buildInvokeMethod$22 = false;
            $this$buildInvokeMethod_u24lambda_u2d37.setStartOffset(this.getIrFunction().getStartOffset());
            $this$buildInvokeMethod_u24lambda_u2d37.setEndOffset(this.getIrFunction().getEndOffset());
            $this$buildInvokeMethod_u24lambda_u2d37.setOrigin(DECLARATION_ORIGIN_COROUTINE_IMPL.INSTANCE);
            $this$buildInvokeMethod_u24lambda_u2d37.setName(OperatorNameConventions.INVOKE);
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PROTECTED;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PROTECTED");
            $this$buildInvokeMethod_u24lambda_u2d37.setVisibility(descriptorVisibility);
            $this$buildInvokeMethod_u24lambda_u2d37.setReturnType(abstractSuspendFunctionsLowering.getContext().getIrBuiltIns().getAnyNType());
            $this$buildInvokeMethod_u24lambda_u2d37.setSuspend(true);
            object2 = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2d16$iv);
            abstractSuspendFunctionsLowering = AbstractSuspendFunctionsLowering.this;
            Object $this$buildInvokeMethod_u24lambda_u2d44 = object2;
            boolean bl = false;
            $this$buildInvokeMethod_u24lambda_u2d44.setParent(this.coroutineClass);
            $this$buildFun_u24lambda_u2d16$iv = this.coroutineClass;
            Collection $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = $this$buildFun_u24lambda_u2d16$iv.getDeclarations();
            $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22.add($this$buildInvokeMethod_u24lambda_u2d44);
            $this$buildFun_u24lambda_u2d16$iv = this.getIrFunction().getTypeParameters();
            Object object3 = $this$buildInvokeMethod_u24lambda_u2d44;
            boolean $i$f$map = false;
            void $i$a$-buildFun-AbstractSuspendFunctionsLowering$CoroutineBuilder$buildInvokeMethod$22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void parameter;
                IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv$iv2;
                object = destination$iv$iv;
                n2 = 0;
                IrTypeParameter $this$buildInvokeMethod_u24lambda_u2d44_u24lambda_u2d39_u24lambda_u2d38 = irDeclarationBase3 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyToWithoutSuperTypes$default((IrTypeParameter)parameter, (IrTypeParametersContainer)$this$buildInvokeMethod_u24lambda_u2d44, 0, DECLARATION_ORIGIN_COROUTINE_IMPL.INSTANCE, 2, null);
                boolean bl2 = false;
                irDeclarationBase2 = $this$buildInvokeMethod_u24lambda_u2d44_u24lambda_u2d39_u24lambda_u2d38;
                irDeclarationBase2.setSuperTypes(CollectionsKt.plus((Collection)irDeclarationBase2.getSuperTypes(), (Iterable)parameter.getSuperTypes()));
                irDeclarationBase = irDeclarationBase3;
                object.add(irDeclarationBase);
            }
            object = (List)destination$iv$iv;
            object3.setTypeParameters((List<? extends IrTypeParameter>)object);
            $this$map$iv = CollectionsKt.take((Iterable)createFunction2.getValueParameters(), createFunction2.getValueParameters().size() - 1);
            object3 = $this$buildInvokeMethod_u24lambda_u2d44;
            boolean $i$f$mapIndexed = false;
            $this$mapTo$iv$iv = $this$mapIndexed$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            item$iv$iv2 = $this$mapIndexedTo$iv$iv.iterator();
            while (item$iv$iv2.hasNext()) {
                void index2;
                void parameter;
                Object item$iv$iv3 = item$iv$iv2.next();
                n2 = index$iv$iv;
                index$iv$iv = n2 + 1;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                irDeclarationBase3 = (IrValueParameter)item$iv$iv3;
                int $this$buildInvokeMethod_u24lambda_u2d44_u24lambda_u2d39_u24lambda_u2d38 = n2;
                object = destination$iv$iv;
                boolean bl3 = false;
                irDeclarationBase = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)parameter, (IrFunction)$this$buildInvokeMethod_u24lambda_u2d44, DECLARATION_ORIGIN_COROUTINE_IMPL.INSTANCE, (int)index2, 0, 0, null, null, null, null, null, false, false, false, 8184, null);
                object.add(irDeclarationBase);
            }
            object = (List)destination$iv$iv;
            ((IrFunction)object3).setValueParameters((List<? extends IrValueParameter>)object);
            org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createDispatchReceiverParameter$default((IrFunction)$this$buildInvokeMethod_u24lambda_u2d44, null, 1, null);
            $this$mapIndexed$iv = $this$buildInvokeMethod_u24lambda_u2d44;
            $this$mapIndexed$iv.setOverriddenSymbols(CollectionsKt.plus((Collection)$this$mapIndexed$iv.getOverriddenSymbols(), functionInvokeFunctionSymbol));
            $this$mapIndexed$iv = $this$buildInvokeMethod_u24lambda_u2d44;
            $this$mapIndexed$iv.setOverriddenSymbols(CollectionsKt.plus((Collection)$this$mapIndexed$iv.getOverriddenSymbols(), suspendFunctionInvokeFunctionSymbol));
            IrValueParameter irValueParameter = ((IrFunction)$this$buildInvokeMethod_u24lambda_u2d44).getDispatchReceiverParameter();
            Intrinsics.checkNotNull(irValueParameter);
            IrValueParameter thisReceiver2 = irValueParameter;
            DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder((BackendContext)abstractSuspendFunctionsLowering.getContext(), (IrSymbol)((IrSimpleFunction)$this$buildInvokeMethod_u24lambda_u2d44).getSymbol(), $this$buildInvokeMethod_u24lambda_u2d44.getStartOffset(), $this$buildInvokeMethod_u24lambda_u2d44.getEndOffset());
            $this$mapIndexedTo$iv$iv = irBuilder;
            int destination$iv$iv2 = $this$buildInvokeMethod_u24lambda_u2d44.getStartOffset();
            int endOffset$iv = $this$buildInvokeMethod_u24lambda_u2d44.getEndOffset();
            boolean $i$f$irBlockBody = false;
            item$iv$iv2 = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void n2 = this_$iv$iv;
            object3 = $this$buildInvokeMethod_u24lambda_u2d44;
            boolean bl4 = false;
            IrFunctionAccessExpression bl3 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildInvokeMethod_u24lambda_u2d44_u24lambda_u2d43, createFunction2);
            irDeclarationBase2 = stateMachineFunction;
            void var25_39 = $this$buildInvokeMethod_u24lambda_u2d44_u24lambda_u2d43;
            AbstractSuspendFunctionsLowering abstractSuspendFunctionsLowering2 = abstractSuspendFunctionsLowering;
            boolean bl5 = false;
            $this$buildInvokeMethod_u24lambda_u2d44_u24lambda_u2d43_u24lambda_u2d42.setDispatchReceiver(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildInvokeMethod_u24lambda_u2d44_u24lambda_u2d43, thisReceiver2));
            Iterable $this$forEachIndexed$iv = ((IrFunction)$this$buildInvokeMethod_u24lambda_u2d44).getValueParameters();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void parameter;
                int n3 = index$iv;
                index$iv = n3 + 1;
                if (n3 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrValueParameter irValueParameter2 = (IrValueParameter)item$iv;
                int index3 = n3;
                boolean bl6 = false;
                $this$buildInvokeMethod_u24lambda_u2d44_u24lambda_u2d43_u24lambda_u2d42.putValueArgument(index3, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildInvokeMethod_u24lambda_u2d44_u24lambda_u2d43, (IrValueDeclaration)parameter));
            }
            $this$buildInvokeMethod_u24lambda_u2d44_u24lambda_u2d43_u24lambda_u2d42.putValueArgument(((IrFunction)$this$buildInvokeMethod_u24lambda_u2d44).getValueParameters().size(), ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildInvokeMethod_u24lambda_u2d44_u24lambda_u2d43, abstractSuspendFunctionsLowering.getContinuationSymbol, ((IrSimpleFunction)abstractSuspendFunctionsLowering.getContinuationSymbol.getOwner()).getReturnType(), CollectionsKt.listOf(((IrFunction)$this$buildInvokeMethod_u24lambda_u2d44).getReturnType())));
            Unit unit2 = Unit.INSTANCE;
            abstractSuspendFunctionsLowering2.generateCoroutineStart((IrBlockBodyBuilder)var25_39, (IrFunction)irDeclarationBase2, irFunctionAccessExpression);
            object = Unit.INSTANCE;
            ((IrFunction)object3).setBody(this_$iv$iv.doBuild());
            return object2;
        }

        /*
         * WARNING - void declaration
         */
        private final IrSimpleFunction buildInvokeSuspendMethod(IrSimpleFunction stateMachineFunction, IrClass coroutineClass) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            IrDeclarationBase irDeclarationBase;
            IrDeclarationBase irDeclarationBase2;
            Collection<IrTypeParameter> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$buildFun$iv;
            Object object;
            Object object2 = AbstractSuspendFunctionsLowering.this.getContext().getIrFactory();
            AbstractSuspendFunctionsLowering abstractSuspendFunctionsLowering = AbstractSuspendFunctionsLowering.this;
            boolean $i$f$buildFun = false;
            Object $this$buildFun_u24lambda_u2d16$iv = object = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$buildInvokeSuspendMethod_u24lambda_u2d45 = $this$buildFun_u24lambda_u2d16$iv;
            boolean bl2 = false;
            $this$buildInvokeSuspendMethod_u24lambda_u2d45.setStartOffset(this.getIrFunction().getStartOffset());
            $this$buildInvokeSuspendMethod_u24lambda_u2d45.setEndOffset(this.getIrFunction().getEndOffset());
            $this$buildInvokeSuspendMethod_u24lambda_u2d45.setOrigin(DECLARATION_ORIGIN_COROUTINE_IMPL.INSTANCE);
            $this$buildInvokeSuspendMethod_u24lambda_u2d45.setName(stateMachineFunction.getName());
            $this$buildInvokeSuspendMethod_u24lambda_u2d45.setVisibility(stateMachineFunction.getVisibility());
            $this$buildInvokeSuspendMethod_u24lambda_u2d45.setReturnType(abstractSuspendFunctionsLowering.getContext().getIrBuiltIns().getAnyNType());
            $this$buildInvokeSuspendMethod_u24lambda_u2d45.setInline(stateMachineFunction.isInline());
            $this$buildInvokeSuspendMethod_u24lambda_u2d45.setExternal(stateMachineFunction.isExternal());
            $this$buildInvokeSuspendMethod_u24lambda_u2d45.setTailrec(stateMachineFunction.isTailrec());
            $this$buildInvokeSuspendMethod_u24lambda_u2d45.setSuspend(stateMachineFunction.isSuspend());
            $this$buildInvokeSuspendMethod_u24lambda_u2d45.setOperator(false);
            $this$buildInvokeSuspendMethod_u24lambda_u2d45.setExpect(stateMachineFunction.isExpect());
            $this$buildInvokeSuspendMethod_u24lambda_u2d45.setFakeOverride(false);
            Object $this$buildInvokeSuspendMethod_u24lambda_u2d49 = object2 = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2d16$iv);
            boolean bl3 = false;
            $this$buildInvokeSuspendMethod_u24lambda_u2d49.setParent(coroutineClass);
            object = coroutineClass;
            $this$buildFun_u24lambda_u2d16$iv = object.getDeclarations();
            $this$buildFun_u24lambda_u2d16$iv.add($this$buildInvokeSuspendMethod_u24lambda_u2d49);
            object = stateMachineFunction.getTypeParameters();
            Object object3 = $this$buildInvokeSuspendMethod_u24lambda_u2d49;
            boolean $i$f$map = false;
            $this$buildInvokeSuspendMethod_u24lambda_u2d45 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void parameter;
                IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                IrTypeParameter $this$buildInvokeSuspendMethod_u24lambda_u2d49_u24lambda_u2d47_u24lambda_u2d46 = irDeclarationBase2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyToWithoutSuperTypes$default((IrTypeParameter)parameter, (IrTypeParametersContainer)$this$buildInvokeSuspendMethod_u24lambda_u2d49, 0, DECLARATION_ORIGIN_COROUTINE_IMPL.INSTANCE, 2, null);
                boolean bl5 = false;
                IrTypeParameter irTypeParameter3 = $this$buildInvokeSuspendMethod_u24lambda_u2d49_u24lambda_u2d47_u24lambda_u2d46;
                irTypeParameter3.setSuperTypes(CollectionsKt.plus((Collection)irTypeParameter3.getSuperTypes(), (Iterable)parameter.getSuperTypes()));
                irDeclarationBase = irDeclarationBase2;
                collection.add((IrTypeParameter)irDeclarationBase);
            }
            collection = (List)destination$iv$iv;
            object3.setTypeParameters((List<? extends IrTypeParameter>)collection);
            $this$map$iv = stateMachineFunction.getValueParameters();
            object3 = $this$buildInvokeSuspendMethod_u24lambda_u2d49;
            boolean $i$f$mapIndexed = false;
            $this$mapTo$iv$iv = $this$mapIndexed$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index2;
                void parameter;
                int n = index$iv$iv;
                index$iv$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                irDeclarationBase2 = (IrValueParameter)item$iv$iv;
                int $this$buildInvokeSuspendMethod_u24lambda_u2d49_u24lambda_u2d47_u24lambda_u2d46 = n;
                collection = destination$iv$iv;
                boolean bl6 = false;
                irDeclarationBase = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)parameter, (IrFunction)$this$buildInvokeSuspendMethod_u24lambda_u2d49, DECLARATION_ORIGIN_COROUTINE_IMPL.INSTANCE, (int)index2, 0, 0, null, null, null, null, null, false, false, false, 8184, null);
                collection.add((IrTypeParameter)irDeclarationBase);
            }
            collection = (List)destination$iv$iv;
            ((IrFunction)object3).setValueParameters((List<? extends IrValueParameter>)collection);
            org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createDispatchReceiverParameter$default((IrFunction)$this$buildInvokeSuspendMethod_u24lambda_u2d49, null, 1, null);
            object = $this$buildInvokeSuspendMethod_u24lambda_u2d49;
            object.setOverriddenSymbols(CollectionsKt.plus((Collection)object.getOverriddenSymbols(), stateMachineFunction.getSymbol()));
            Object function2 = object2;
            AbstractSuspendFunctionsLowering.this.buildStateMachine((IrFunction)function2, this.irFunction, this.argumentToPropertiesMap);
            return function2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0014\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016R \u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$VariablesScopeTracker;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "()V", "scopeStack", "", "", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getScopeStack", "()Ljava/util/List;", "visitCatch", "", "aCatch", "Lorg/jetbrains/kotlin/ir/expressions/IrCatch;", "visitContainerExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitVariable", "declaration", "ir.backend.common"})
    protected static class VariablesScopeTracker
    implements IrElementVisitorVoid {
        @NotNull
        private final List<Set<IrVariable>> scopeStack;

        public VariablesScopeTracker() {
            Set[] setArray = new Set[]{new LinkedHashSet()};
            this.scopeStack = CollectionsKt.mutableListOf(setArray);
        }

        @NotNull
        protected final List<Set<IrVariable>> getScopeStack() {
            return this.scopeStack;
        }

        @Override
        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkNotNullParameter(element, "element");
            IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            if (!expression2.isTransparentScope()) {
                UtilsKt.push(this.scopeStack, (Set)new LinkedHashSet());
            }
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            if (!expression2.isTransparentScope()) {
                UtilsKt.pop(this.scopeStack);
            }
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch) {
            Intrinsics.checkNotNullParameter(aCatch, "aCatch");
            UtilsKt.push(this.scopeStack, (Set)new LinkedHashSet());
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            UtilsKt.pop(this.scopeStack);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
            Set<IrVariable> set = UtilsKt.peek(this.scopeStack);
            Intrinsics.checkNotNull(set);
            set.add(declaration2);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2) {
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data2);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2) {
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data2);
        }

        @Override
        public void visitBody(@NotNull IrBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
        }

        @Override
        public void visitBody(@NotNull IrBody body2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data2);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch) {
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump) {
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump) {
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data2);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2) {
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data2);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data2);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump) {
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data2);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data2);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
        }

        @Override
        public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch) {
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data2);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data2);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data2);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data2);
        }

        @Override
        public void visitField(@NotNull IrField declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
        }

        @Override
        public void visitField(@NotNull IrField declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data2);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data2);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data2);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data2);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data2);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2) {
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data2);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data2);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data2);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data2);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
            IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2) {
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data2);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
        }

        @Override
        public void visitSetValue(@NotNull IrSetValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
        }

        @Override
        public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data2);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data2);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread) {
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data2);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2) {
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry) {
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data2);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data2);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration2) {
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data2);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2) {
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data2);
        }

        @Override
        public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
            IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2) {
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data2) {
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AbstractSuspendFunctionsLowering$Companion;", "", "()V", "CREATE_IDENTIFIER", "Lorg/jetbrains/kotlin/name/Name;", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

