/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import junit.framework.AssertionFailedError;
import junit.framework.ComparisonFailure;

public class Assert {
    protected Assert() {
    }

    public static void assertTrue(String message2, boolean condition) {
        if (!condition) {
            Assert.fail(message2);
        }
    }

    public static void assertTrue(boolean condition) {
        Assert.assertTrue(null, condition);
    }

    public static void assertFalse(String message2, boolean condition) {
        Assert.assertTrue(message2, !condition);
    }

    public static void assertFalse(boolean condition) {
        Assert.assertFalse(null, condition);
    }

    public static void fail(String message2) {
        throw new AssertionFailedError(message2);
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void assertEquals(String message2, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        Assert.failNotEquals(message2, expected, actual);
    }

    public static void assertEquals(Object expected, Object actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message2, String expected, String actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        throw new ComparisonFailure(message2, expected, actual);
    }

    public static void assertEquals(String expected, String actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message2, double expected, double actual, double delta) {
        if (Double.compare(expected, actual) == 0) {
            return;
        }
        if (!(Math.abs(expected - actual) <= delta)) {
            Assert.failNotEquals(message2, new Double(expected), new Double(actual));
        }
    }

    public static void assertEquals(double expected, double actual, double delta) {
        Assert.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(String message2, float expected, float actual, float delta) {
        if (Float.compare(expected, actual) == 0) {
            return;
        }
        if (!(Math.abs(expected - actual) <= delta)) {
            Assert.failNotEquals(message2, new Float(expected), new Float(actual));
        }
    }

    public static void assertEquals(float expected, float actual, float delta) {
        Assert.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(String message2, long expected, long actual) {
        Assert.assertEquals(message2, new Long(expected), new Long(actual));
    }

    public static void assertEquals(long expected, long actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message2, boolean expected, boolean actual) {
        Assert.assertEquals(message2, (Object)expected, (Object)actual);
    }

    public static void assertEquals(boolean expected, boolean actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message2, byte expected, byte actual) {
        Assert.assertEquals(message2, new Byte(expected), new Byte(actual));
    }

    public static void assertEquals(byte expected, byte actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message2, char expected, char actual) {
        Assert.assertEquals(message2, new Character(expected), new Character(actual));
    }

    public static void assertEquals(char expected, char actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message2, short expected, short actual) {
        Assert.assertEquals(message2, new Short(expected), new Short(actual));
    }

    public static void assertEquals(short expected, short actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message2, int expected, int actual) {
        Assert.assertEquals(message2, new Integer(expected), new Integer(actual));
    }

    public static void assertEquals(int expected, int actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(null, object);
    }

    public static void assertNotNull(String message2, Object object) {
        Assert.assertTrue(message2, object != null);
    }

    public static void assertNull(Object object) {
        Assert.assertNull(null, object);
    }

    public static void assertNull(String message2, Object object) {
        Assert.assertTrue(message2, object == null);
    }

    public static void assertSame(String message2, Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        Assert.failNotSame(message2, expected, actual);
    }

    public static void assertSame(Object expected, Object actual) {
        Assert.assertSame(null, expected, actual);
    }

    public static void assertNotSame(String message2, Object expected, Object actual) {
        if (expected == actual) {
            Assert.failSame(message2);
        }
    }

    public static void assertNotSame(Object expected, Object actual) {
        Assert.assertNotSame(null, expected, actual);
    }

    public static void failSame(String message2) {
        String formatted = "";
        if (message2 != null) {
            formatted = String.valueOf(message2) + " ";
        }
        Assert.fail(String.valueOf(formatted) + "expected not same");
    }

    public static void failNotSame(String message2, Object expected, Object actual) {
        String formatted = "";
        if (message2 != null) {
            formatted = String.valueOf(message2) + " ";
        }
        Assert.fail(String.valueOf(formatted) + "expected same:<" + expected + "> was not:<" + actual + ">");
    }

    public static void failNotEquals(String message2, Object expected, Object actual) {
        Assert.fail(Assert.format(message2, expected, actual));
    }

    public static String format(String message2, Object expected, Object actual) {
        String formatted = "";
        if (message2 != null) {
            formatted = String.valueOf(message2) + " ";
        }
        return String.valueOf(formatted) + "expected:<" + expected + "> but was:<" + actual + ">";
    }
}

