/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.mattermost;

import java.util.LinkedHashMap;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.mattermost.Message;
import org.jreleaser.util.StringUtils;

public class MattermostAnnouncer
implements Announcer<org.jreleaser.model.api.announce.MattermostAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.MattermostAnnouncer mattermost;

    public MattermostAnnouncer(JReleaserContext context) {
        this.context = context;
        this.mattermost = context.getModel().getAnnounce().getMattermost();
    }

    public org.jreleaser.model.api.announce.MattermostAnnouncer getAnnouncer() {
        return this.mattermost.asImmutable();
    }

    public String getName() {
        return "mattermost";
    }

    public boolean isEnabled() {
        return this.mattermost.isEnabled();
    }

    public void announce() throws AnnounceException {
        String message = "";
        if (StringUtils.isNotBlank((String)this.mattermost.getMessage())) {
            message = this.mattermost.getResolvedMessage(this.context);
        } else {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
            message = this.mattermost.getResolvedMessageTemplate(this.context, props);
        }
        this.context.getLogger().info("message: {}", new Object[]{message});
        if (!this.context.isDryrun()) {
            ClientUtils.webhook((JReleaserLogger)this.context.getLogger(), (String)this.mattermost.getResolvedWebhook(), (int)this.mattermost.getConnectTimeout(), (int)this.mattermost.getReadTimeout(), (Object)Message.of(message));
        }
    }
}

