/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.extensions.api;

import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jreleaser.bundle.RB;
import org.jreleaser.extensions.api.ExtensionManager;

public final class ExtensionManagerHolder {
    private static final ThreadLocal<ExtensionManager> EXTENSION_MANAGER_THREAD_LOCAL = ThreadLocal.withInitial(new Supplier<ExtensionManager>(){

        @Override
        public ExtensionManager get() {
            List extensionManagers = StreamSupport.stream(ExtensionManagerHolder.resolveServiceLoader().spliterator(), false).collect(Collectors.toList());
            if (extensionManagers.size() == 0) {
                throw new IllegalStateException(RB.$((String)"ERROR_extension_manager_load", (Object[])new Object[0]));
            }
            if (extensionManagers.size() > 1) {
                throw new IllegalStateException(RB.$((String)"ERROR_extension_manager_multiple_instances", (Object[])new Object[]{extensionManagers.size()}));
            }
            return (ExtensionManager)extensionManagers.get(0);
        }
    });

    public static ExtensionManager get() {
        return EXTENSION_MANAGER_THREAD_LOCAL.get();
    }

    private static ServiceLoader<ExtensionManager> resolveServiceLoader() {
        ServiceLoader<ExtensionManager> handlers = ServiceLoader.load(ExtensionManager.class, ExtensionManager.class.getClassLoader());
        if (handlers.iterator().hasNext()) {
            return handlers;
        }
        return ServiceLoader.load(ExtensionManager.class);
    }
}

