/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Scanner;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.TemplatePackager;
import org.jreleaser.model.packager.spi.PackagerProcessingException;
import org.jreleaser.packagers.AbstractPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.MustacheUtils;

abstract class AbstractTemplatePackagerProcessor<T extends TemplatePackager>
extends AbstractPackagerProcessor<T> {
    protected AbstractTemplatePackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPrepareDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        try {
            this.doPrepareDistribution(distribution, props, distribution.getName(), this.getPrepareDirectory(props), ((TemplatePackager)this.getPackager()).getTemplateDirectory(), this.getPackagerName(), true);
        }
        catch (IOException e) {
            throw new PackagerProcessingException((Throwable)e);
        }
    }

    protected void doPrepareDistribution(Distribution distribution, Map<String, Object> props, String distributionName, Path prepareDirectory, String templateDirectory, String packagerName, boolean copyLicense) throws IOException, PackagerProcessingException {
        FileUtils.deleteFiles((Path)prepareDirectory);
        Files.createDirectories(prepareDirectory, new FileAttribute[0]);
        this.context.getLogger().debug(RB.$((String)"packager.resolve.templates", (Object[])new Object[0]), new Object[]{distributionName, packagerName});
        Map templates = TemplateUtils.resolveAndMergeTemplates((JReleaserLogger)this.context.getLogger(), (String)distribution.getType().name(), (String)this.getPackagerName(), (boolean)this.context.getModel().getProject().isSnapshot(), (Path)this.context.getBasedir().resolve(templateDirectory));
        for (Map.Entry entry : templates.entrySet()) {
            String filename = (String)entry.getKey();
            if (filename.endsWith(".tpl")) {
                this.context.getLogger().debug(RB.$((String)"packager.evaluate.template", (Object[])new Object[0]), new Object[]{filename, distributionName, packagerName});
                String content = MustacheUtils.applyTemplate((Reader)((Reader)entry.getValue()), props);
                if (!content.endsWith(System.lineSeparator())) {
                    content = content + System.lineSeparator();
                }
                this.context.getLogger().debug(RB.$((String)"packager.write.template", (Object[])new Object[0]), new Object[]{filename, distributionName, packagerName});
                this.writeFile(this.context.getModel().getProject(), distribution, content, props, prepareDirectory, filename);
                continue;
            }
            this.context.getLogger().debug(RB.$((String)"packager.write.file", (Object[])new Object[0]), new Object[]{filename, distributionName, packagerName});
            this.writeFile((Reader)entry.getValue(), prepareDirectory.resolve(filename));
        }
        if (copyLicense) {
            this.context.getLogger().debug(RB.$((String)"packager.copy.license", (Object[])new Object[0]));
            FileUtils.copyFiles((JReleaserLogger)this.context.getLogger(), (Path)this.context.getBasedir(), (Path)prepareDirectory, path -> path.getFileName().startsWith("LICENSE"));
        }
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        this.doPackageDistribution(distribution, props, this.getPackageDirectory(props));
    }

    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws PackagerProcessingException {
        try {
            FileUtils.deleteFiles((Path)packageDirectory);
            Files.createDirectories(packageDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new PackagerProcessingException((Throwable)e);
        }
    }

    protected abstract void writeFile(Project var1, Distribution var2, String var3, Map<String, Object> var4, Path var5, String var6) throws PackagerProcessingException;

    protected void writeFile(Reader reader, Path outputFile) throws PackagerProcessingException {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Scanner scanner = new Scanner(reader);
            scanner.useDelimiter("\\Z");
            Files.write(outputFile, scanner.next().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            scanner.close();
            FileUtils.grantFullAccess((Path)outputFile);
        }
        catch (IOException e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error_writing_file", (Object[])new Object[]{outputFile.toAbsolutePath()}), (Throwable)e);
        }
    }

    protected void writeFile(String content, Path outputFile) throws PackagerProcessingException {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Files.write(outputFile, content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            FileUtils.grantFullAccess((Path)outputFile);
        }
        catch (IOException e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error_writing_file", (Object[])new Object[]{outputFile.toAbsolutePath()}), (Throwable)e);
        }
    }
}

