/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.sdkman;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserCommand;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Sdkman;
import org.jreleaser.model.announcer.spi.AnnounceException;
import org.jreleaser.model.announcer.spi.Announcer;
import org.jreleaser.model.util.SdkmanHelper;
import org.jreleaser.sdk.sdkman.AnnounceSdkmanCommand;
import org.jreleaser.sdk.sdkman.MajorReleaseSdkmanCommand;
import org.jreleaser.sdk.sdkman.MinorReleaseSdkmanCommand;
import org.jreleaser.sdk.sdkman.SdkmanException;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class SdkmanAnnouncer
implements Announcer {
    private final JReleaserContext context;

    SdkmanAnnouncer(JReleaserContext context) {
        this.context = context;
    }

    public String getName() {
        return "sdkman";
    }

    public boolean isEnabled() {
        return this.context.getModel().getAnnounce().getSdkman().isEnabled();
    }

    public void announce() throws AnnounceException {
        Map<String, Distribution> distributions = this.context.getModel().getActiveDistributions().stream().filter(d -> d.getSdkman().isEnabled()).filter(d -> !JReleaserCommand.supportsPublish((JReleaserCommand)this.context.getCommand()) || d.getSdkman().isPublished()).collect(Collectors.toMap(distribution -> {
            Sdkman sdkman = distribution.getSdkman();
            return StringUtils.isNotBlank((String)sdkman.getCandidate()) ? sdkman.getCandidate().trim() : this.context.getModel().getProject().getName();
        }, distribution -> distribution));
        Boolean set = (Boolean)this.context.getModel().getAnnounce().getSdkman().getExtraProperties().remove("__MAGIC_SET__");
        if (distributions.isEmpty()) {
            if (set == null || !set.booleanValue()) {
                this.announceProject();
            } else {
                this.context.getLogger().debug(RB.$((String)"announcers.announcer.disabled", (Object[])new Object[0]));
            }
            return;
        }
        boolean failures = false;
        for (Map.Entry<String, Distribution> e : distributions.entrySet()) {
            String candidate = e.getKey();
            Distribution distribution2 = e.getValue();
            Sdkman sdkman = distribution2.getSdkman();
            Map props = this.context.props();
            props.putAll(distribution2.props());
            String releaseNotesUrl = Templates.resolveTemplate((String)sdkman.getReleaseNotesUrl(), (Map)props);
            String command = sdkman.getCommand().name().toLowerCase();
            this.context.getLogger().info(RB.$((String)"sdkman.release.announce", (Object[])new Object[0]), new Object[]{command, candidate});
            try {
                ((AnnounceSdkmanCommand.Builder)((AnnounceSdkmanCommand.Builder)((AnnounceSdkmanCommand.Builder)((AnnounceSdkmanCommand.Builder)((AnnounceSdkmanCommand.Builder)((AnnounceSdkmanCommand.Builder)((AnnounceSdkmanCommand.Builder)AnnounceSdkmanCommand.builder(this.context.getLogger()).connectTimeout(sdkman.getConnectTimeout())).readTimeout(sdkman.getReadTimeout())).consumerKey(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getResolvedConsumerKey())).consumerToken(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getResolvedConsumerToken())).candidate(candidate)).version(this.context.getModel().getProject().getVersion())).releaseNotesUrl(releaseNotesUrl).dryrun(this.context.isDryrun())).build().execute();
            }
            catch (SdkmanException x) {
                this.context.getLogger().warn(x.getMessage().trim());
                failures = true;
            }
        }
        if (failures) {
            throw new AnnounceException(RB.$((String)"ERROR_sdkman_announce", (Object[])new Object[0]));
        }
    }

    private void announceProject() throws AnnounceException {
        org.jreleaser.model.SdkmanAnnouncer sdkman = this.context.getModel().getAnnounce().getSdkman();
        LinkedHashMap<String, String> platforms = new LinkedHashMap<String, String>();
        for (Distribution distribution : this.context.getModel().getActiveDistributions()) {
            if (!this.isDistributionSupported(distribution)) continue;
            SdkmanHelper.collectArtifacts((JReleaserContext)this.context, (Distribution)distribution, platforms);
        }
        if (platforms.isEmpty()) {
            this.context.getLogger().warn(RB.$((String)"sdkman.no.suitable.artifacts", (Object[])new Object[0]));
            return;
        }
        try {
            String candidate = StringUtils.isNotBlank((String)sdkman.getCandidate()) ? sdkman.getCandidate().trim() : this.context.getModel().getProject().getName();
            String releaseNotesUrl = Templates.resolveTemplate((String)sdkman.getReleaseNotesUrl(), (Map)this.context.props());
            if (sdkman.isMajor()) {
                this.context.getLogger().info(RB.$((String)"sdkman.release.announce.major", (Object[])new Object[0]), new Object[]{candidate});
                ((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)((MajorReleaseSdkmanCommand.Builder)MajorReleaseSdkmanCommand.builder(this.context.getLogger()).connectTimeout(sdkman.getConnectTimeout())).readTimeout(sdkman.getReadTimeout())).consumerKey(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getResolvedConsumerKey())).consumerToken(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getResolvedConsumerToken())).candidate(candidate)).version(this.context.getModel().getProject().getVersion())).platforms(platforms).releaseNotesUrl(releaseNotesUrl).dryrun(this.context.isDryrun())).build().execute();
            } else {
                this.context.getLogger().info(RB.$((String)"sdkman.release.announce.minor", (Object[])new Object[0]), new Object[]{candidate});
                ((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)((MinorReleaseSdkmanCommand.Builder)MinorReleaseSdkmanCommand.builder(this.context.getLogger()).connectTimeout(sdkman.getConnectTimeout())).readTimeout(sdkman.getReadTimeout())).consumerKey(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getResolvedConsumerKey())).consumerToken(this.context.isDryrun() ? "**UNDEFINED**" : sdkman.getResolvedConsumerToken())).candidate(candidate)).version(this.context.getModel().getProject().getVersion())).platforms(platforms).releaseNotesUrl(releaseNotesUrl).dryrun(this.context.isDryrun())).build().execute();
            }
        }
        catch (SdkmanException e) {
            throw new AnnounceException((Throwable)e);
        }
    }

    private boolean isDistributionSupported(Distribution distribution) {
        return (distribution.getType() == Distribution.DistributionType.JAVA_BINARY || distribution.getType() == Distribution.DistributionType.JLINK || distribution.getType() == Distribution.DistributionType.NATIVE_IMAGE) && !StringUtils.isTrue(distribution.getExtraProperties().get("skipSdkman"));
    }
}

