/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.condition;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.CachedEnvironment;
import java.util.Locale;

public final class OperatingSystem {
    private static OperatingSystem instance;
    private final Requires.Family family;

    private OperatingSystem(Requires.Family family) {
        this.family = family;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OperatingSystem getCurrent() {
        if (instance != null) return instance;
        Class<OperatingSystem> clazz = OperatingSystem.class;
        synchronized (OperatingSystem.class) {
            if (instance != null) return instance;
            String osName = CachedEnvironment.getProperty("os.name").toLowerCase(Locale.ENGLISH);
            Requires.Family osFamily = osName.contains("linux") ? Requires.Family.LINUX : (osName.startsWith("mac") || osName.startsWith("darwin") ? Requires.Family.MAC_OS : (osName.contains("windows") ? Requires.Family.WINDOWS : (osName.contains("sunos") ? Requires.Family.SOLARIS : Requires.Family.OTHER)));
            instance = new OperatingSystem(osFamily);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isLinux() {
        return this.family == Requires.Family.LINUX;
    }

    public boolean isWindows() {
        return this.family == Requires.Family.WINDOWS;
    }

    public boolean isMacOs() {
        return this.family == Requires.Family.MAC_OS;
    }

    public boolean isSolaris() {
        return this.family == Requires.Family.SOLARIS;
    }

    public Requires.Family getFamily() {
        return this.family;
    }
}

