/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.Label;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.Opcodes;
import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.asm.commons.Method;
import io.micronaut.asm.commons.TableSwitchGenerator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.writer.AbstractClassFileWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.validation.constraints.NotNull;

public class DispatchWriter
extends AbstractClassFileWriter
implements Opcodes {
    private static final Method DISPATCH_METHOD = new Method("dispatch", DispatchWriter.getMethodDescriptor(Object.class, Arrays.asList(Integer.TYPE, Object.class, Object[].class)));
    private static final Method DISPATCH_ONE_METHOD = new Method("dispatchOne", DispatchWriter.getMethodDescriptor(Object.class, Arrays.asList(Integer.TYPE, Object.class, Object.class)));
    private static final Method GET_TARGET_METHOD = new Method("getTargetMethodByIndex", DispatchWriter.getMethodDescriptor(java.lang.reflect.Method.class, Collections.singletonList(Integer.TYPE)));
    private static final Method UNKNOWN_DISPATCH_AT_INDEX = new Method("unknownDispatchAtIndexException", DispatchWriter.getMethodDescriptor(RuntimeException.class, Collections.singletonList(Integer.TYPE)));
    private static final String FIELD_INTERCEPTABLE = "$interceptable";
    private static final Type TYPE_REFLECTION_UTILS = Type.getType(ReflectionUtils.class);
    private static final Method METHOD_GET_REQUIRED_METHOD = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(ReflectionUtils.class, (String)"getRequiredMethod", (Class[])new Class[]{Class.class, String.class, Class[].class}));
    private final List<DispatchTarget> dispatchTargets = new ArrayList<DispatchTarget>();
    private final Type thisType;
    private boolean hasInterceptedMethod;

    public DispatchWriter(Type thisType) {
        super(new Element[0]);
        this.thisType = thisType;
    }

    public int addSetField(FieldElement beanField) {
        return this.addDispatchTarget(new FieldSetDispatchTarget(beanField));
    }

    public int addGetField(FieldElement beanField) {
        return this.addDispatchTarget(new FieldGetDispatchTarget(beanField));
    }

    public int addMethod(TypedElement declaringType, MethodElement methodElement) {
        return this.addMethod(declaringType, methodElement, false);
    }

    public int addMethod(TypedElement declaringType, MethodElement methodElement, boolean useOneDispatch) {
        return this.addDispatchTarget(new MethodDispatchTarget(declaringType, methodElement, useOneDispatch, !useOneDispatch));
    }

    public int addInterceptedMethod(TypedElement declaringType, MethodElement methodElement, String interceptedProxyClassName, String interceptedProxyBridgeMethodName) {
        this.hasInterceptedMethod = true;
        return this.addDispatchTarget(new InterceptableMethodDispatchTarget(declaringType, methodElement, interceptedProxyClassName, interceptedProxyBridgeMethodName, this.thisType));
    }

    public int addDispatchTarget(DispatchTarget dispatchTarget) {
        this.dispatchTargets.add(dispatchTarget);
        return this.dispatchTargets.size() - 1;
    }

    public void buildDispatchMethod(ClassWriter classWriter) {
        int[] cases = this.dispatchTargets.stream().filter(DispatchTarget::supportsDispatchMulti).mapToInt(this.dispatchTargets::indexOf).toArray();
        if (cases.length == 0) {
            return;
        }
        final GeneratorAdapter dispatchMethod = new GeneratorAdapter(classWriter.visitMethod(20, DISPATCH_METHOD.getName(), DISPATCH_METHOD.getDescriptor(), null, null), 20, DISPATCH_METHOD.getName(), DISPATCH_METHOD.getDescriptor());
        dispatchMethod.loadArg(0);
        dispatchMethod.tableSwitch(cases, new TableSwitchGenerator(){

            public void generateCase(int key, Label end) {
                DispatchTarget method = (DispatchTarget)DispatchWriter.this.dispatchTargets.get(key);
                method.writeDispatchMulti(dispatchMethod);
                dispatchMethod.returnValue();
            }

            public void generateDefault() {
                dispatchMethod.loadThis();
                dispatchMethod.loadArg(0);
                dispatchMethod.invokeVirtual(DispatchWriter.this.thisType, UNKNOWN_DISPATCH_AT_INDEX);
                dispatchMethod.throwException();
            }
        }, true);
        dispatchMethod.visitMaxs(13, 1);
        dispatchMethod.visitEnd();
    }

    public void buildDispatchOneMethod(ClassWriter classWriter) {
        int[] cases = this.dispatchTargets.stream().filter(DispatchTarget::supportsDispatchOne).mapToInt(this.dispatchTargets::indexOf).toArray();
        if (cases.length == 0) {
            return;
        }
        final GeneratorAdapter dispatchMethod = new GeneratorAdapter(classWriter.visitMethod(20, DISPATCH_ONE_METHOD.getName(), DISPATCH_ONE_METHOD.getDescriptor(), null, null), 20, DISPATCH_ONE_METHOD.getName(), DISPATCH_ONE_METHOD.getDescriptor());
        dispatchMethod.loadArg(0);
        dispatchMethod.tableSwitch(cases, new TableSwitchGenerator(){

            public void generateCase(int key, Label end) {
                DispatchTarget method = (DispatchTarget)DispatchWriter.this.dispatchTargets.get(key);
                method.writeDispatchOne(dispatchMethod);
                dispatchMethod.returnValue();
            }

            public void generateDefault() {
                dispatchMethod.loadThis();
                dispatchMethod.loadArg(0);
                dispatchMethod.invokeVirtual(DispatchWriter.this.thisType, UNKNOWN_DISPATCH_AT_INDEX);
                dispatchMethod.throwException();
            }
        }, true);
        dispatchMethod.visitMaxs(13, 1);
        dispatchMethod.visitEnd();
    }

    public void buildGetTargetMethodByIndex(ClassWriter classWriter) {
        final GeneratorAdapter getTargetMethodByIndex = new GeneratorAdapter(classWriter.visitMethod(20, GET_TARGET_METHOD.getName(), GET_TARGET_METHOD.getDescriptor(), null, null), 20, GET_TARGET_METHOD.getName(), GET_TARGET_METHOD.getDescriptor());
        getTargetMethodByIndex.loadArg(0);
        int[] cases = this.dispatchTargets.stream().filter(dispatchTarget -> dispatchTarget instanceof MethodDispatchTarget).mapToInt(this.dispatchTargets::indexOf).toArray();
        getTargetMethodByIndex.tableSwitch(cases, new TableSwitchGenerator(){

            public void generateCase(int key, Label end) {
                MethodDispatchTarget method = (MethodDispatchTarget)DispatchWriter.this.dispatchTargets.get(key);
                Type declaringTypeObject = JavaModelUtils.getTypeReference(method.declaringType);
                List<ParameterElement> argumentTypes = Arrays.asList(method.methodElement.getSuspendParameters());
                getTargetMethodByIndex.push(declaringTypeObject);
                getTargetMethodByIndex.push(method.methodElement.getName());
                if (!argumentTypes.isEmpty()) {
                    int len = argumentTypes.size();
                    Iterator<ParameterElement> iter = argumentTypes.iterator();
                    AbstractClassFileWriter.pushNewArray(getTargetMethodByIndex, Class.class, len);
                    for (int i = 0; i < len; ++i) {
                        ParameterElement type = iter.next();
                        AbstractClassFileWriter.pushStoreInArray(getTargetMethodByIndex, i, len, () -> getTargetMethodByIndex.push(JavaModelUtils.getTypeReference(type)));
                    }
                } else {
                    getTargetMethodByIndex.getStatic(TYPE_REFLECTION_UTILS, "EMPTY_CLASS_ARRAY", Type.getType(Class[].class));
                }
                getTargetMethodByIndex.invokeStatic(TYPE_REFLECTION_UTILS, METHOD_GET_REQUIRED_METHOD);
                getTargetMethodByIndex.returnValue();
            }

            public void generateDefault() {
                getTargetMethodByIndex.loadThis();
                getTargetMethodByIndex.loadArg(0);
                getTargetMethodByIndex.invokeVirtual(DispatchWriter.this.thisType, UNKNOWN_DISPATCH_AT_INDEX);
                getTargetMethodByIndex.throwException();
            }
        }, true);
        getTargetMethodByIndex.visitMaxs(13, 1);
        getTargetMethodByIndex.visitEnd();
    }

    @Override
    public void accept(ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        throw new IllegalStateException();
    }

    public List<DispatchTarget> getDispatchTargets() {
        return this.dispatchTargets;
    }

    public boolean isHasInterceptedMethod() {
        return this.hasInterceptedMethod;
    }

    @Internal
    public static final class InterceptableMethodDispatchTarget
    extends MethodDispatchTarget {
        final String interceptedProxyClassName;
        final String interceptedProxyBridgeMethodName;
        final Type thisType;

        private InterceptableMethodDispatchTarget(TypedElement declaringType, MethodElement methodElement, String interceptedProxyClassName, String interceptedProxyBridgeMethodName, Type thisType) {
            super(declaringType, methodElement, false, true);
            this.interceptedProxyClassName = interceptedProxyClassName;
            this.interceptedProxyBridgeMethodName = interceptedProxyBridgeMethodName;
            this.thisType = thisType;
        }

        @Override
        public void writeDispatchMulti(GeneratorAdapter writer) {
            boolean hasArgs;
            String methodName = this.methodElement.getName();
            List<ParameterElement> argumentTypes = Arrays.asList(this.methodElement.getSuspendParameters());
            Type declaringTypeObject = JavaModelUtils.getTypeReference(this.declaringType);
            ClassElement returnType = this.methodElement.isSuspend() ? ClassElement.of(Object.class) : this.methodElement.getReturnType();
            boolean isInterface = this.declaringType.getType().isInterface();
            Type returnTypeObject = JavaModelUtils.getTypeReference(returnType);
            writer.loadArg(1);
            writer.dup();
            String methodDescriptor = AbstractClassFileWriter.getMethodDescriptor(returnType, argumentTypes);
            Label invokeTargetBlock = new Label();
            Type interceptedProxyType = AbstractClassFileWriter.getObjectType(this.interceptedProxyClassName);
            writer.loadThis();
            writer.getField(this.thisType, DispatchWriter.FIELD_INTERCEPTABLE, Type.getType(Boolean.TYPE));
            writer.push(true);
            writer.ifCmp(Type.BOOLEAN_TYPE, 154, invokeTargetBlock);
            writer.loadArg(1);
            writer.instanceOf(interceptedProxyType);
            writer.push(true);
            writer.ifCmp(Type.BOOLEAN_TYPE, 154, invokeTargetBlock);
            AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, interceptedProxyType);
            Iterator<ParameterElement> iterator = argumentTypes.iterator();
            for (int i = 0; i < argumentTypes.size(); ++i) {
                writer.loadArg(2);
                writer.push(i);
                writer.visitInsn(50);
                AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, iterator.next());
            }
            writer.visitMethodInsn(182, interceptedProxyType.getInternalName(), this.interceptedProxyBridgeMethodName, methodDescriptor, false);
            if (returnTypeObject.equals((Object)Type.VOID_TYPE)) {
                writer.visitInsn(1);
            } else {
                AbstractClassFileWriter.pushBoxPrimitiveIfNecessary(returnType, (MethodVisitor)writer);
            }
            writer.returnValue();
            writer.visitLabel(invokeTargetBlock);
            writer.pop();
            AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, declaringTypeObject);
            boolean bl = hasArgs = !argumentTypes.isEmpty();
            if (hasArgs) {
                int argCount = argumentTypes.size();
                Iterator<ParameterElement> argIterator = argumentTypes.iterator();
                for (int i = 0; i < argCount; ++i) {
                    writer.loadArg(2);
                    writer.push(i);
                    writer.visitInsn(50);
                    AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, argIterator.next());
                }
            }
            writer.visitMethodInsn(isInterface ? 185 : 182, declaringTypeObject.getInternalName(), methodName, methodDescriptor, isInterface);
            if (returnTypeObject.equals((Object)Type.VOID_TYPE)) {
                writer.visitInsn(1);
            } else {
                AbstractClassFileWriter.pushBoxPrimitiveIfNecessary(returnType, (MethodVisitor)writer);
            }
        }
    }

    @Internal
    public static class MethodDispatchTarget
    implements DispatchTarget {
        final TypedElement declaringType;
        final MethodElement methodElement;
        final boolean oneDispatch;
        final boolean multiDispatch;

        private MethodDispatchTarget(TypedElement declaringType, MethodElement methodElement, boolean oneDispatch, boolean multiDispatch) {
            this.declaringType = declaringType;
            this.methodElement = methodElement;
            this.oneDispatch = oneDispatch;
            this.multiDispatch = multiDispatch;
        }

        public MethodElement getMethodElement() {
            return this.methodElement;
        }

        @Override
        public boolean supportsDispatchOne() {
            return this.oneDispatch;
        }

        @Override
        public boolean supportsDispatchMulti() {
            return this.multiDispatch;
        }

        @Override
        public void writeDispatchMulti(GeneratorAdapter writer) {
            boolean hasArgs;
            String methodName = this.methodElement.getName();
            List<ParameterElement> argumentTypes = Arrays.asList(this.methodElement.getSuspendParameters());
            Type declaringTypeObject = JavaModelUtils.getTypeReference(this.declaringType);
            ClassElement returnType = this.methodElement.isSuspend() ? ClassElement.of(Object.class) : this.methodElement.getReturnType();
            boolean isInterface = this.declaringType.getType().isInterface();
            Type returnTypeObject = JavaModelUtils.getTypeReference(returnType);
            writer.loadArg(1);
            writer.dup();
            String methodDescriptor = AbstractClassFileWriter.getMethodDescriptor(returnType, argumentTypes);
            AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, declaringTypeObject);
            boolean bl = hasArgs = !argumentTypes.isEmpty();
            if (hasArgs) {
                int argCount = argumentTypes.size();
                Iterator<ParameterElement> argIterator = argumentTypes.iterator();
                for (int i = 0; i < argCount; ++i) {
                    writer.loadArg(2);
                    writer.push(i);
                    writer.visitInsn(50);
                    AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, argIterator.next());
                }
            }
            writer.visitMethodInsn(isInterface ? 185 : 182, declaringTypeObject.getInternalName(), methodName, methodDescriptor, isInterface);
            if (returnTypeObject.equals((Object)Type.VOID_TYPE)) {
                writer.visitInsn(1);
            } else {
                AbstractClassFileWriter.pushBoxPrimitiveIfNecessary(returnType, (MethodVisitor)writer);
            }
        }

        @Override
        public void writeDispatchOne(GeneratorAdapter writer) {
            boolean hasArgs;
            String methodName = this.methodElement.getName();
            List<ParameterElement> argumentTypes = Arrays.asList(this.methodElement.getSuspendParameters());
            Type declaringTypeObject = JavaModelUtils.getTypeReference(this.declaringType);
            ClassElement returnType = this.methodElement.isSuspend() ? ClassElement.of(Object.class) : this.methodElement.getReturnType();
            boolean isInterface = this.declaringType.getType().isInterface();
            Type returnTypeObject = JavaModelUtils.getTypeReference(returnType);
            writer.loadArg(1);
            AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, this.declaringType);
            boolean bl = hasArgs = !argumentTypes.isEmpty();
            if (hasArgs) {
                writer.loadArg(2);
                AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, argumentTypes.get(0));
            }
            writer.visitMethodInsn(isInterface ? 185 : 182, declaringTypeObject.getInternalName(), methodName, AbstractClassFileWriter.getMethodDescriptor(returnType, argumentTypes), isInterface);
            if (returnTypeObject.equals((Object)Type.VOID_TYPE)) {
                writer.visitInsn(1);
            } else {
                AbstractClassFileWriter.pushBoxPrimitiveIfNecessary(returnType, (MethodVisitor)writer);
            }
        }
    }

    @Internal
    public static final class FieldSetDispatchTarget
    implements DispatchTarget {
        @NotNull
        final FieldElement beanField;

        public FieldSetDispatchTarget(FieldElement beanField) {
            this.beanField = beanField;
        }

        @Override
        public boolean supportsDispatchOne() {
            return true;
        }

        @Override
        public boolean supportsDispatchMulti() {
            return false;
        }

        @Override
        public void writeDispatchOne(GeneratorAdapter writer) {
            Type propertyType = JavaModelUtils.getTypeReference(this.beanField.getType());
            Type beanType = JavaModelUtils.getTypeReference(this.beanField.getOwningType());
            writer.loadArg(1);
            AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, beanType);
            writer.loadArg(2);
            AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, propertyType);
            writer.putField(beanType, this.beanField.getName(), propertyType);
            writer.push((String)null);
        }
    }

    @Internal
    public static final class FieldGetDispatchTarget
    implements DispatchTarget {
        @NotNull
        final FieldElement beanField;

        public FieldGetDispatchTarget(FieldElement beanField) {
            this.beanField = beanField;
        }

        @Override
        public boolean supportsDispatchOne() {
            return true;
        }

        @Override
        public boolean supportsDispatchMulti() {
            return false;
        }

        @Override
        public void writeDispatchOne(GeneratorAdapter writer) {
            Type propertyType = JavaModelUtils.getTypeReference(this.beanField.getType());
            Type beanType = JavaModelUtils.getTypeReference(this.beanField.getOwningType());
            writer.loadArg(1);
            AbstractClassFileWriter.pushCastToType((MethodVisitor)writer, beanType);
            writer.getField(JavaModelUtils.getTypeReference(this.beanField.getOwningType()), this.beanField.getName(), propertyType);
            AbstractClassFileWriter.pushBoxPrimitiveIfNecessary(propertyType, (MethodVisitor)writer);
        }
    }

    public static interface DispatchTarget {
        default public boolean supportsDispatchOne() {
            return false;
        }

        default public void writeDispatchOne(GeneratorAdapter writer) {
            throw new IllegalStateException("Not supported");
        }

        default public boolean supportsDispatchMulti() {
            return false;
        }

        default public void writeDispatchMulti(GeneratorAdapter writer) {
            throw new IllegalStateException("Not supported");
        }
    }
}

