/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.context.event;

import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.context.event.ShutdownEvent;
import io.micronaut.context.event.StartupEvent;
import io.micronaut.spring.context.MicronautApplicationContext;
import jakarta.inject.Singleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextStartedEvent;

@Singleton
class ContextEventAdapter
implements ApplicationEventListener<Object> {
    private final ApplicationEventPublisher eventPublisher;
    private final MicronautApplicationContext applicationContext;

    ContextEventAdapter(MicronautApplicationContext applicationContext, ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(Object event) {
        if (event instanceof StartupEvent) {
            this.eventPublisher.publishEvent((Object)new ContextStartedEvent((ApplicationContext)this.applicationContext));
        } else if (event instanceof ShutdownEvent) {
            this.eventPublisher.publishEvent((Object)new ContextClosedEvent((ApplicationContext)this.applicationContext));
        }
    }
}

