/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.convert.value;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleMultiValuesMap;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.type.Argument;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public interface ConvertibleMultiValues<V>
extends ConvertibleValues<List<V>> {
    public List<V> getAll(CharSequence var1);

    @Nullable
    public V get(CharSequence var1);

    @Override
    default public boolean isEmpty() {
        return this == ConvertibleMultiValuesMap.EMPTY || this.names().isEmpty();
    }

    default public void forEachValue(BiConsumer<String, V> action) {
        Objects.requireNonNull(action, "Consumer cannot be null");
        Set<String> names = this.names();
        for (String headerName : names) {
            List<V> values = this.getAll(headerName);
            for (Object value : values) {
                action.accept(headerName, value);
            }
        }
    }

    @Override
    default public void forEach(BiConsumer<String, List<V>> action) {
        Objects.requireNonNull(action, "Consumer cannot be null");
        Set<String> names = this.names();
        for (String headerName : names) {
            List<V> values = this.getAll(headerName);
            action.accept(headerName, values);
        }
    }

    @Override
    default public Iterator<Map.Entry<String, List<V>>> iterator() {
        final Iterator<String> headerNames = this.names().iterator();
        return new Iterator<Map.Entry<String, List<V>>>(){

            @Override
            public boolean hasNext() {
                return headerNames.hasNext();
            }

            @Override
            public Map.Entry<String, List<V>> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                final String name = (String)headerNames.next();
                return new Map.Entry<String, List<V>>(){

                    @Override
                    public String getKey() {
                        return name;
                    }

                    @Override
                    public List<V> getValue() {
                        return ConvertibleMultiValues.this.getAll(name);
                    }

                    @Override
                    public List<V> setValue(List<V> value) {
                        throw new UnsupportedOperationException("Not mutable");
                    }
                };
            }
        };
    }

    default public Optional<V> getFirst(CharSequence name) {
        Optional<Class> type = GenericTypeUtils.resolveInterfaceTypeArgument(this.getClass(), ConvertibleMultiValues.class);
        return this.getFirst(name, type.orElse(Object.class));
    }

    default public <T> Optional<T> getFirst(CharSequence name, Class<T> requiredType) {
        return this.getFirst(name, Argument.of(requiredType));
    }

    default public <T> Optional<T> getFirst(CharSequence name, Argument<T> requiredType) {
        V v = this.get(name);
        if (v != null) {
            return ConversionService.SHARED.convert(v, ConversionContext.of(requiredType));
        }
        return Optional.empty();
    }

    default public <T> Optional<T> getFirst(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        V v = this.get(name);
        if (v != null) {
            return ConversionService.SHARED.convert(v, conversionContext);
        }
        return Optional.empty();
    }

    default public <T> T getFirst(CharSequence name, Class<T> requiredType, T defaultValue) {
        return this.getFirst(name, requiredType).orElse(defaultValue);
    }

    public static <T> ConvertibleMultiValues<T> of(Map<CharSequence, List<T>> values) {
        return new ConvertibleMultiValuesMap(values);
    }

    public static <V> ConvertibleMultiValues<V> empty() {
        return ConvertibleMultiValuesMap.EMPTY;
    }
}

