/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckable;
import org.grails.datastore.mapping.proxy.EntityProxyMethodHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.util.ReflectionUtils;

public class SessionEntityProxyMethodHandler
extends EntityProxyMethodHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SessionEntityProxyMethodHandler.class);
    private final Session session;
    private final Class cls;
    private final Serializable id;
    protected Object target;

    public SessionEntityProxyMethodHandler(Class proxyClass, Session session, Class cls, Serializable id) {
        super(proxyClass);
        this.session = session;
        this.cls = cls;
        this.id = id;
    }

    @Override
    protected Object resolveDelegate(Object self) {
        if (this.target == null) {
            this.initializeTarget(self);
            if (this.target == null) {
                throw new DataIntegrityViolationException("Proxy for [" + this.cls.getName() + ":" + this.id + "] could not be initialized");
            }
        }
        return this.target;
    }

    protected void initializeTarget() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Lazy loading proxy for class {} with id {}", (Object)this.cls.getName(), (Object)this.id);
        }
        this.target = this.session.retrieve(this.cls, this.id);
    }

    protected void initializeTarget(Object self) {
        this.initializeTarget();
        if (this.target instanceof DirtyCheckable) {
            ((DirtyCheckable)this.target).syncChangedProperties(self);
        }
    }

    @Override
    protected Object isProxyInitiated(Object self) {
        return this.target != null;
    }

    @Override
    protected Object getProxyKey(Object self) {
        return this.id;
    }

    @Override
    protected Object handleInvocationFallback(Object self, Method thisMethod, Object[] args) {
        Object actualTarget = this.getProxyTarget(self);
        if (!thisMethod.getDeclaringClass().isInstance(actualTarget)) {
            if (Modifier.isPublic(thisMethod.getModifiers())) {
                Method method = ReflectionUtils.findMethod(actualTarget.getClass(), (String)thisMethod.getName(), (Class[])thisMethod.getParameterTypes());
                if (method != null) {
                    ReflectionUtils.makeAccessible((Method)method);
                    thisMethod = method;
                }
            } else {
                Method method = ReflectionUtils.findMethod(actualTarget.getClass(), (String)thisMethod.getName(), (Class[])thisMethod.getParameterTypes());
                if (method != null) {
                    thisMethod = method;
                }
            }
        }
        return ReflectionUtils.invokeMethod((Method)thisMethod, (Object)actualTarget, (Object[])args);
    }
}

