/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.annotation;

import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.util.ArgumentUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface AnnotationSource {
    public static final AnnotationSource EMPTY = new AnnotationSource(){};

    @Nullable
    default public <T extends Annotation> T synthesize(@Nonnull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return null;
    }

    @Nullable
    default public <T extends Annotation> T synthesizeDeclared(@Nonnull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return null;
    }

    @Nonnull
    default public Annotation[] synthesizeAll() {
        return AnnotationUtil.ZERO_ANNOTATIONS;
    }

    @Nonnull
    default public Annotation[] synthesizeDeclared() {
        return AnnotationUtil.ZERO_ANNOTATIONS;
    }

    @Nonnull
    default public <T extends Annotation> T[] synthesizeAnnotationsByType(@Nonnull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return (Annotation[])Array.newInstance(annotationClass, 0);
    }

    @Nonnull
    default public <T extends Annotation> T[] synthesizeDeclaredAnnotationsByType(@Nonnull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return (Annotation[])Array.newInstance(annotationClass, 0);
    }

    @Nonnull
    default public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(@Nonnull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return Optional.empty();
    }

    @Nonnull
    default public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(@Nonnull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return Optional.empty();
    }

    @Nonnull
    default public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(@Nonnull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return Optional.empty();
    }

    @Nonnull
    default public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(@Nonnull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return Optional.empty();
    }

    @Nullable
    default public <T extends Annotation> AnnotationValue<T> getAnnotation(@Nonnull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.findAnnotation(annotation).orElse(null);
    }

    @Nullable
    default public <T extends Annotation> AnnotationValue<T> getAnnotation(@Nonnull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return this.findAnnotation(annotationClass).orElse(null);
    }

    @Nullable
    default public <T extends Annotation> AnnotationValue<T> getDeclaredAnnotation(@Nonnull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.findDeclaredAnnotation(annotation).orElse(null);
    }

    @Nullable
    default public <T extends Annotation> AnnotationValue<T> getDeclaredAnnotation(@Nonnull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return this.findDeclaredAnnotation(annotationClass).orElse(null);
    }

    default public boolean isAnnotationPresent(@Nonnull Class<? extends Annotation> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return false;
    }

    default public boolean isDeclaredAnnotationPresent(@Nonnull Class<? extends Annotation> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return false;
    }
}

