package org.springframework.uaa.client.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * Simple methods dealing with {@link InputStream}s.
 * 
 * @author Christian Dupuis
 * @since 1.0.1
 */
public abstract class StreamUtils {
	
	/**
	 * Copies the {@link InputStream} into the {@link OutputStream}.
	 */
	public static int copy(InputStream in, OutputStream out) throws IOException {
		try {
			int byteCount = 0;
			byte[] buffer = new byte[4096];
			int bytesRead = -1;
			while ((bytesRead = in.read(buffer)) != -1) {
				out.write(buffer, 0, bytesRead);
				byteCount += bytesRead;
			}
			out.flush();
			return byteCount;
		}
		finally {
			try { in.close(); }
			catch (IOException ex) {}
		}
	}

	/**
	 * Creates a {@link InputStream} from the given <code>is</code> that guarantees to understand 
	 * {@link InputStream#reset()}. 
	 */
	public static InputStream copyIntoResettableStream(InputStream is) throws IOException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		copy(is, baos);
		return new ByteArrayInputStream(baos.toByteArray());
	}
	
}
