package org.springframework.uaa.client;

/**
 * Extension to {@link UaaService} that allows UAA clients to request an transmission of UAA
 * usage data.
 * 
 * <p>
 * It is up to the implementation to decide if the upload will happen immediately or at a later time.
 * Also this method can be try a synchronous or asynchronous transmission.
 * 
 * @author Christian Dupuis
 * @since 1.0.1
 */
public interface TransmissionAwareUaaService extends UaaService {
	
	/**
	 * Request a UAA usage data transmission.
	 * 
	 * <p>
	 * Note: this is not to demand an upload. It is to the implementation to decide when and if the
	 * transmission will happen.
	 */
	void requestTransmission();
	
}
