/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.converters;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.converters.TwoWayConverter;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.JdkVersion;

public class ArrayToCollection
implements TwoWayConverter {
    private ConversionService conversionService;
    private ConversionExecutor elementConverter;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public ArrayToCollection(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ArrayToCollection(ConversionExecutor elementConverter) {
        this.elementConverter = elementConverter;
    }

    public Class getSourceClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ljava.lang.Object;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Class getTargetClass() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Collection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Object convertSourceToTargetClass(Object source, Class targetClass) throws Exception {
        if (source == null) {
            return null;
        }
        Class collectionImplClass = this.getCollectionImplClass(targetClass);
        Constructor constructor = collectionImplClass.getConstructor(null);
        Collection collection = (Collection)constructor.newInstance(null);
        ConversionExecutor converter = this.getArrayElementConverter(source, targetClass);
        int length = Array.getLength(source);
        int i = 0;
        while (i < length) {
            Object value = Array.get(source, i);
            if (converter != null) {
                value = converter.execute(value);
            }
            collection.add(value);
            ++i;
        }
        return collection;
    }

    public Object convertTargetToSourceClass(Object target, Class sourceClass) throws Exception {
        if (target == null) {
            return null;
        }
        Collection collection = (Collection)target;
        Object array = Array.newInstance(sourceClass.getComponentType(), collection.size());
        int i = 0;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Object value = it.next();
            if (value != null) {
                ConversionExecutor converter = this.elementConverter != null ? this.elementConverter : this.conversionService.getConversionExecutor(value.getClass(), sourceClass.getComponentType());
                value = converter.execute(value);
            }
            Array.set(array, i, value);
            ++i;
        }
        return array;
    }

    private Class getCollectionImplClass(Class targetClass) {
        if (targetClass.isInterface()) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.util.List");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(targetClass)) {
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$3 = Class.forName("java.util.ArrayList");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz2;
            }
            Class<?> clazz3 = class$4;
            if (clazz3 == null) {
                try {
                    clazz3 = class$4 = Class.forName("java.util.Set");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz3.equals(targetClass)) {
                Class<?> clazz4 = class$5;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$5 = Class.forName("java.util.LinkedHashSet");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz4;
            }
            Class<?> clazz5 = class$6;
            if (clazz5 == null) {
                try {
                    clazz5 = class$6 = Class.forName("java.util.SortedSet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz5.equals(targetClass)) {
                Class<?> clazz6 = class$7;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$7 = Class.forName("java.util.TreeSet");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz6;
            }
            throw new IllegalArgumentException("Unsupported collection interface [" + targetClass.getName() + "]");
        }
        return targetClass;
    }

    private ConversionExecutor getArrayElementConverter(Object source, Class targetClass) {
        Class elementType;
        if (this.elementConverter != null) {
            return this.elementConverter;
        }
        if (JdkVersion.isAtLeastJava15() && (elementType = GenericCollectionTypeResolver.getCollectionType((Class)targetClass)) != null) {
            Class<?> componentType = source.getClass().getComponentType();
            return this.conversionService.getConversionExecutor(componentType, elementType);
        }
        return null;
    }
}

