/*
 * Decompiled with CFR 0.152.
 */
package liquibase.statement.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.database.structure.type.DataType;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.ForeignKeyConstraint;
import liquibase.statement.NotNullConstraint;
import liquibase.statement.PrimaryKeyConstraint;
import liquibase.statement.UniqueConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTableStatement
extends AbstractSqlStatement {
    private String schemaName;
    private String tableName;
    private String tablespace;
    private List<String> columns = new ArrayList<String>();
    private Set<AutoIncrementConstraint> autoIncrementConstraints = new HashSet<AutoIncrementConstraint>();
    private Map<String, DataType> columnTypes = new HashMap<String, DataType>();
    private Map<String, Object> defaultValues = new HashMap<String, Object>();
    private PrimaryKeyConstraint primaryKeyConstraint;
    private Set<String> notNullColumns = new HashSet<String>();
    private Set<ForeignKeyConstraint> foreignKeyConstraints = new HashSet<ForeignKeyConstraint>();
    private Set<UniqueConstraint> uniqueConstraints = new HashSet<UniqueConstraint>();

    public CreateTableStatement(String schemaName, String tableName) {
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public CreateTableStatement setTablespace(String tablespace) {
        this.tablespace = tablespace;
        return this;
    }

    public PrimaryKeyConstraint getPrimaryKeyConstraint() {
        return this.primaryKeyConstraint;
    }

    public Set<ForeignKeyConstraint> getForeignKeyConstraints() {
        return this.foreignKeyConstraints;
    }

    public Set<UniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public Set<String> getNotNullColumns() {
        return this.notNullColumns;
    }

    public CreateTableStatement addPrimaryKeyColumn(String columnName, DataType columnType, Object defaultValue, String keyName, String tablespace, ColumnConstraint ... constraints) {
        PrimaryKeyConstraint pkConstraint = new PrimaryKeyConstraint(keyName);
        pkConstraint.addColumns(columnName);
        pkConstraint.setTablespace(tablespace);
        ArrayList<ColumnConstraint> allConstraints = new ArrayList<ColumnConstraint>();
        allConstraints.addAll(Arrays.asList(constraints));
        allConstraints.add(new NotNullConstraint(columnName));
        allConstraints.add(pkConstraint);
        this.addColumn(columnName, columnType, defaultValue, allConstraints.toArray(new ColumnConstraint[allConstraints.size()]));
        return this;
    }

    public CreateTableStatement addColumn(String columnName, DataType columnType) {
        return this.addColumn(columnName, columnType, (Object)null, new ColumnConstraint[0]);
    }

    public CreateTableStatement addColumn(String columnName, DataType columnType, Object defaultValue) {
        if (defaultValue instanceof ColumnConstraint) {
            return this.addColumn(columnName, columnType, null, (ColumnConstraint)defaultValue);
        }
        return this.addColumn(columnName, columnType, defaultValue, new ColumnConstraint[0]);
    }

    public CreateTableStatement addColumn(String columnName, DataType columnType, ColumnConstraint ... constraints) {
        return this.addColumn(columnName, columnType, (Object)null, constraints);
    }

    public CreateTableStatement addColumn(String columnName, DataType columnType, Object defaultValue, ColumnConstraint ... constraints) {
        this.getColumns().add(columnName);
        this.columnTypes.put(columnName, columnType);
        if (defaultValue != null) {
            this.defaultValues.put(columnName, defaultValue);
        }
        if (constraints != null) {
            for (ColumnConstraint constraint : constraints) {
                if (constraint == null) continue;
                if (constraint instanceof PrimaryKeyConstraint) {
                    if (this.getPrimaryKeyConstraint() == null) {
                        this.primaryKeyConstraint = (PrimaryKeyConstraint)constraint;
                        continue;
                    }
                    for (String column : ((PrimaryKeyConstraint)constraint).getColumns()) {
                        this.getPrimaryKeyConstraint().addColumns(column);
                    }
                    continue;
                }
                if (constraint instanceof NotNullConstraint) {
                    ((NotNullConstraint)constraint).setColumnName(columnName);
                    this.getNotNullColumns().add(columnName);
                    continue;
                }
                if (constraint instanceof ForeignKeyConstraint) {
                    ((ForeignKeyConstraint)constraint).setColumn(columnName);
                    this.getForeignKeyConstraints().add((ForeignKeyConstraint)constraint);
                    continue;
                }
                if (constraint instanceof UniqueConstraint) {
                    ((UniqueConstraint)constraint).addColumns(columnName);
                    this.getUniqueConstraints().add((UniqueConstraint)constraint);
                    continue;
                }
                if (constraint instanceof AutoIncrementConstraint) {
                    this.autoIncrementConstraints.add((AutoIncrementConstraint)constraint);
                    continue;
                }
                throw new RuntimeException("Unknown constraint type: " + constraint.getClass().getName());
            }
        }
        return this;
    }

    public Object getDefaultValue(String column) {
        return this.defaultValues.get(column);
    }

    public CreateTableStatement addColumnConstraint(NotNullConstraint notNullConstraint) {
        this.getNotNullColumns().add(notNullConstraint.getColumnName());
        return this;
    }

    public CreateTableStatement addColumnConstraint(ForeignKeyConstraint fkConstraint) {
        this.getForeignKeyConstraints().add(fkConstraint);
        return this;
    }

    public CreateTableStatement addColumnConstraint(UniqueConstraint uniqueConstraint) {
        this.getUniqueConstraints().add(uniqueConstraint);
        return this;
    }

    public CreateTableStatement addColumnConstraint(AutoIncrementConstraint autoIncrementConstraint) {
        this.getAutoIncrementConstraints().add(autoIncrementConstraint);
        return this;
    }

    public Set<AutoIncrementConstraint> getAutoIncrementConstraints() {
        return this.autoIncrementConstraints;
    }

    public Map<String, DataType> getColumnTypes() {
        return this.columnTypes;
    }

    public Map<String, Object> getDefaultValues() {
        return this.defaultValues;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }
}

