/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.sitemesh;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.ContentProcessor;
import com.opensymphony.sitemesh.Decorator;
import com.opensymphony.sitemesh.SiteMeshContext;
import com.opensymphony.sitemesh.compatability.OldDecorator2NewDecorator;
import com.opensymphony.sitemesh.compatability.PageParser2ContentProcessor;
import com.opensymphony.sitemesh.webapp.ContainerTweaks;
import com.opensymphony.sitemesh.webapp.SiteMeshFilter;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import grails.util.GrailsWebUtil;
import java.io.IOException;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.support.NullPersistentContextInterceptor;
import org.codehaus.groovy.grails.support.PersistenceContextInterceptor;
import org.codehaus.groovy.grails.web.sitemesh.FactoryHolder;
import org.codehaus.groovy.grails.web.sitemesh.GSPSitemeshPage;
import org.codehaus.groovy.grails.web.sitemesh.Grails5535Factory;
import org.codehaus.groovy.grails.web.sitemesh.GrailsContentBufferingResponse;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.util.UrlPathHelper;

public class GrailsPageFilter
extends SiteMeshFilter {
    public static final String ALREADY_APPLIED_KEY = "com.opensymphony.sitemesh.APPLIED_ONCE";
    public static final String FACTORY_SERVLET_CONTEXT_ATTRIBUTE = "sitemesh.factory";
    private static final String HTML_EXT = ".html";
    private static final String UTF_8_ENCODING = "UTF-8";
    private static final String CONFIG_OPTION_GSP_ENCODING = "grails.views.gsp.encoding";
    public static final String GSP_SITEMESH_PAGE = GrailsPageFilter.class.getName() + ".GSP_SITEMESH_PAGE";
    private FilterConfig filterConfig;
    private ContainerTweaks containerTweaks;
    private WebApplicationContext applicationContext;
    private PersistenceContextInterceptor persistenceInterceptor = new NullPersistentContextInterceptor();
    private String defaultEncoding = "UTF-8";
    protected ViewResolver layoutViewResolver;
    private ContentProcessor contentProcessor;
    private DecoratorMapper decoratorMapper;

    public void init(FilterConfig fc) {
        Map interceptors;
        super.init(fc);
        this.filterConfig = fc;
        this.containerTweaks = new ContainerTweaks();
        Config config = new Config(fc);
        Grails5535Factory defaultFactory = new Grails5535Factory(config);
        fc.getServletContext().setAttribute(FACTORY_SERVLET_CONTEXT_ATTRIBUTE, (Object)defaultFactory);
        defaultFactory.refresh();
        FactoryHolder.setFactory((Factory)defaultFactory);
        this.contentProcessor = new PageParser2ContentProcessor((Factory)defaultFactory);
        this.decoratorMapper = defaultFactory.getDecoratorMapper();
        this.applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)fc.getServletContext());
        this.layoutViewResolver = WebUtils.lookupViewResolver((ApplicationContext)this.applicationContext);
        GrailsApplication grailsApplication = GrailsWebUtil.lookupApplication(fc.getServletContext());
        String encoding = (String)grailsApplication.getFlatConfig().get(CONFIG_OPTION_GSP_ENCODING);
        if (encoding != null) {
            this.defaultEncoding = encoding;
        }
        if (!(interceptors = this.applicationContext.getBeansOfType(PersistenceContextInterceptor.class)).isEmpty()) {
            this.persistenceInterceptor = (PersistenceContextInterceptor)interceptors.values().iterator().next();
        }
    }

    public void destroy() {
        super.destroy();
        FactoryHolder.setFactory(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest rq, ServletResponse rs, FilterChain chain) throws IOException, ServletException {
        boolean dispatched;
        HttpServletRequest request;
        block17: {
            block15: {
                block16: {
                    request = (HttpServletRequest)rq;
                    HttpServletResponse response = (HttpServletResponse)rs;
                    ServletContext servletContext = this.filterConfig.getServletContext();
                    SiteMeshWebAppContext webAppContext = new SiteMeshWebAppContext(request, response, servletContext);
                    if (this.filterAlreadyAppliedForRequest(request)) {
                        chain.doFilter((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                    if (!this.contentProcessor.handles((SiteMeshContext)webAppContext)) {
                        chain.doFilter((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                    request.removeAttribute("__sitemesh__page");
                    if (this.containerTweaks.shouldAutoCreateSession()) {
                        request.getSession(true);
                    }
                    dispatched = false;
                    try {
                        try {
                            Content content;
                            block19: {
                                block18: {
                                    content = this.obtainContent(this.contentProcessor, webAppContext, request, response, chain);
                                    if (content == null) break block18;
                                    if (!response.isCommitted()) break block19;
                                }
                                Object var12_11 = null;
                                if (dispatched) break block15;
                                break block16;
                            }
                            this.detectContentTypeFromPage(content, response);
                            com.opensymphony.module.sitemesh.Decorator decorator = this.decoratorMapper.getDecorator(request, (Page)GSPSitemeshPage.content2htmlPage(content));
                            this.persistenceInterceptor.reconnect();
                            if (decorator instanceof Decorator) {
                                ((Decorator)decorator).render(content, (SiteMeshContext)webAppContext);
                            } else {
                                new OldDecorator2NewDecorator(decorator).render(content, (SiteMeshContext)webAppContext);
                            }
                            dispatched = true;
                            break block17;
                        }
                        catch (IllegalStateException e) {
                            if (!this.containerTweaks.shouldIgnoreIllegalStateExceptionOnErrorPage()) {
                                throw e;
                            }
                            Object var12_13 = null;
                            if (!dispatched) {
                                request.setAttribute(ALREADY_APPLIED_KEY, null);
                            }
                            if (!this.persistenceInterceptor.isOpen()) return;
                            this.persistenceInterceptor.destroy();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_14 = null;
                        if (!dispatched) {
                            request.setAttribute(ALREADY_APPLIED_KEY, null);
                        }
                        if (!this.persistenceInterceptor.isOpen()) throw throwable;
                        this.persistenceInterceptor.destroy();
                        throw throwable;
                    }
                }
                request.setAttribute(ALREADY_APPLIED_KEY, null);
            }
            if (!this.persistenceInterceptor.isOpen()) return;
            this.persistenceInterceptor.destroy();
            return;
        }
        Object var12_12 = null;
        if (!dispatched) {
            request.setAttribute(ALREADY_APPLIED_KEY, null);
        }
        if (!this.persistenceInterceptor.isOpen()) return;
        this.persistenceInterceptor.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Content obtainContent(ContentProcessor contentProcessor, SiteMeshWebAppContext webAppContext, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        Content content;
        block2: {
            Object oldGspSiteMeshPage = request.getAttribute(GSP_SITEMESH_PAGE);
            try {
                request.setAttribute(GSP_SITEMESH_PAGE, (Object)new GSPSitemeshPage());
                GrailsContentBufferingResponse contentBufferingResponse = new GrailsContentBufferingResponse(response, contentProcessor, webAppContext);
                this.setDefaultConfiguredEncoding(request, contentBufferingResponse);
                chain.doFilter((ServletRequest)request, (ServletResponse)contentBufferingResponse);
                webAppContext.setUsingStream(contentBufferingResponse.isUsingStream());
                content = contentBufferingResponse.getContent();
                Object var10_9 = null;
                if (oldGspSiteMeshPage == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var10_10 = null;
                    if (oldGspSiteMeshPage == null) break block3;
                    request.setAttribute(GSP_SITEMESH_PAGE, oldGspSiteMeshPage);
                }
                throw throwable;
            }
            request.setAttribute(GSP_SITEMESH_PAGE, oldGspSiteMeshPage);
        }
        return content;
    }

    private void setDefaultConfiguredEncoding(HttpServletRequest request, GrailsContentBufferingResponse contentBufferingResponse) {
        UrlPathHelper urlHelper = new UrlPathHelper();
        String requestURI = urlHelper.getOriginatingRequestUri(request);
        if (requestURI.endsWith(HTML_EXT)) {
            contentBufferingResponse.setContentType("text/html;charset=" + this.defaultEncoding);
        }
    }

    private boolean filterAlreadyAppliedForRequest(HttpServletRequest request) {
        if (request.getAttribute(ALREADY_APPLIED_KEY) == Boolean.TRUE) {
            return true;
        }
        request.setAttribute(ALREADY_APPLIED_KEY, (Object)Boolean.TRUE);
        return false;
    }

    private void detectContentTypeFromPage(Content page, HttpServletResponse response) {
        String contentType = page.getProperty("meta.http-equiv.Content-Type");
        if (contentType != null && "text/html".equals(response.getContentType())) {
            response.setContentType(contentType);
        }
    }
}

